/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.orm;

import org.eclipse.jpt.core.context.GeneratedValue;
import org.eclipse.jpt.core.context.GenerationType;
import org.eclipse.jpt.core.context.orm.OrmGeneratedValue;
import org.eclipse.jpt.core.context.orm.OrmJpaContextNode;
import org.eclipse.jpt.core.internal.context.orm.AbstractOrmJpaContextNode;
import org.eclipse.jpt.core.resource.orm.XmlGeneratedValue;
import org.eclipse.jpt.core.utility.TextRange;

public class GenericOrmGeneratedValue
extends AbstractOrmJpaContextNode
implements OrmGeneratedValue {
    protected GenerationType specifiedStrategy;
    protected String specifiedGenerator;
    protected String defaultGenerator;
    protected XmlGeneratedValue resourceGeneratedValue;

    public GenericOrmGeneratedValue(OrmJpaContextNode parent, XmlGeneratedValue resourceGeneratedValue) {
        super(parent);
        this.initialize(resourceGeneratedValue);
    }

    public OrmJpaContextNode getParent() {
        return (OrmJpaContextNode)super.getParent();
    }

    public GenerationType getStrategy() {
        return this.getSpecifiedStrategy() == null ? this.getDefaultStrategy() : this.getSpecifiedStrategy();
    }

    public GenerationType getDefaultStrategy() {
        return GeneratedValue.DEFAULT_STRATEGY;
    }

    public GenerationType getSpecifiedStrategy() {
        return this.specifiedStrategy;
    }

    public void setSpecifiedStrategy(GenerationType newSpecifiedStrategy) {
        GenerationType oldStrategy = this.specifiedStrategy;
        this.specifiedStrategy = newSpecifiedStrategy;
        this.resourceGeneratedValue.setStrategy(GenerationType.toOrmResourceModel(newSpecifiedStrategy));
        this.firePropertyChanged("specifiedStrategyProperty", (Object)oldStrategy, (Object)newSpecifiedStrategy);
    }

    protected void setSpecifiedStrategy_(GenerationType newSpecifiedStrategy) {
        GenerationType oldStrategy = this.specifiedStrategy;
        this.specifiedStrategy = newSpecifiedStrategy;
        this.firePropertyChanged("specifiedStrategyProperty", (Object)oldStrategy, (Object)newSpecifiedStrategy);
    }

    public String getGenerator() {
        return this.getSpecifiedGenerator() == null ? this.getDefaultGenerator() : this.getSpecifiedGenerator();
    }

    public String getDefaultGenerator() {
        return this.defaultGenerator;
    }

    protected void setDefaultGenerator(String newDefaultGenerator) {
        String oldGenerator = this.defaultGenerator;
        this.defaultGenerator = newDefaultGenerator;
        this.firePropertyChanged("defaultGeneratorProperty", oldGenerator, newDefaultGenerator);
    }

    public String getSpecifiedGenerator() {
        return this.specifiedGenerator;
    }

    public void setSpecifiedGenerator(String newSpecifiedGenerator) {
        String oldGenerator = this.specifiedGenerator;
        this.specifiedGenerator = newSpecifiedGenerator;
        this.resourceGeneratedValue.setGenerator(newSpecifiedGenerator);
        this.firePropertyChanged("specifiedGeneratorProperty", oldGenerator, newSpecifiedGenerator);
    }

    protected void setSpecifiedGenerator_(String newSpecifiedGenerator) {
        String oldGenerator = this.specifiedGenerator;
        this.specifiedGenerator = newSpecifiedGenerator;
        this.firePropertyChanged("specifiedGeneratorProperty", oldGenerator, newSpecifiedGenerator);
    }

    public TextRange getGeneratorTextRange() {
        TextRange textRange = this.resourceGeneratedValue.getGeneratorTextRange();
        return textRange != null ? textRange : this.getValidationTextRange();
    }

    protected void initialize(XmlGeneratedValue resourceGeneratedValue) {
        this.resourceGeneratedValue = resourceGeneratedValue;
        this.specifiedStrategy = this.strategy(resourceGeneratedValue);
        this.specifiedGenerator = this.generator(resourceGeneratedValue);
        this.defaultGenerator = null;
    }

    public void update(XmlGeneratedValue resourceGeneratedValue) {
        this.resourceGeneratedValue = resourceGeneratedValue;
        this.setSpecifiedStrategy_(this.strategy(resourceGeneratedValue));
        this.setSpecifiedGenerator_(this.generator(resourceGeneratedValue));
        this.setDefaultGenerator(null);
    }

    protected GenerationType strategy(XmlGeneratedValue resourceGeneratedValue) {
        return GenerationType.fromOrmResourceModel(resourceGeneratedValue.getStrategy());
    }

    protected String generator(XmlGeneratedValue resourceGeneratedValue) {
        return resourceGeneratedValue.getGenerator();
    }

    public TextRange getValidationTextRange() {
        TextRange validationTextRange = this.resourceGeneratedValue.getValidationTextRange();
        return validationTextRange != null ? validationTextRange : this.getParent().getValidationTextRange();
    }
}

