/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.orm;

import java.util.List;
import org.eclipse.jpt.core.context.JoinColumn;
import org.eclipse.jpt.core.context.RelationshipMapping;
import org.eclipse.jpt.core.context.orm.OrmJoinColumn;
import org.eclipse.jpt.core.context.orm.OrmJpaContextNode;
import org.eclipse.jpt.core.context.orm.OrmRelationshipMapping;
import org.eclipse.jpt.core.internal.context.MappingTools;
import org.eclipse.jpt.core.internal.context.orm.AbstractOrmBaseColumn;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.resource.orm.XmlJoinColumn;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.db.Column;
import org.eclipse.jpt.db.Table;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericOrmJoinColumn
extends AbstractOrmBaseColumn<XmlJoinColumn>
implements OrmJoinColumn {
    protected String specifiedReferencedColumnName;
    protected String defaultReferencedColumnName;
    protected XmlJoinColumn resourceJoinColumn;

    public GenericOrmJoinColumn(OrmJpaContextNode parent, OrmJoinColumn.Owner owner, XmlJoinColumn resourceJoinColumn) {
        super(parent, owner);
        this.initialize(resourceJoinColumn);
    }

    @Override
    public void initializeFrom(JoinColumn oldColumn) {
        super.initializeFrom(oldColumn);
        this.setSpecifiedReferencedColumnName(oldColumn.getSpecifiedReferencedColumnName());
    }

    @Override
    public String getReferencedColumnName() {
        return this.getSpecifiedReferencedColumnName() == null ? this.getDefaultReferencedColumnName() : this.getSpecifiedReferencedColumnName();
    }

    @Override
    public String getSpecifiedReferencedColumnName() {
        return this.specifiedReferencedColumnName;
    }

    @Override
    public void setSpecifiedReferencedColumnName(String newSpecifiedReferencedColumnName) {
        String oldSpecifiedReferencedColumnName = this.specifiedReferencedColumnName;
        this.specifiedReferencedColumnName = newSpecifiedReferencedColumnName;
        this.getResourceColumn().setReferencedColumnName(newSpecifiedReferencedColumnName);
        this.firePropertyChanged("specifiedReferencedColumnName", oldSpecifiedReferencedColumnName, newSpecifiedReferencedColumnName);
    }

    protected void setSpecifiedReferencedColumnName_(String newSpecifiedReferencedColumnName) {
        String oldSpecifiedReferencedColumnName = this.specifiedReferencedColumnName;
        this.specifiedReferencedColumnName = newSpecifiedReferencedColumnName;
        this.firePropertyChanged("specifiedReferencedColumnName", oldSpecifiedReferencedColumnName, newSpecifiedReferencedColumnName);
    }

    @Override
    public String getDefaultReferencedColumnName() {
        return this.defaultReferencedColumnName;
    }

    protected void setDefaultReferencedColumnName(String newDefaultReferencedColumnName) {
        String oldDefaultReferencedColumnName = this.defaultReferencedColumnName;
        this.defaultReferencedColumnName = newDefaultReferencedColumnName;
        this.firePropertyChanged("defaultReferencedColumnName", oldDefaultReferencedColumnName, newDefaultReferencedColumnName);
    }

    @Override
    public boolean isVirtual() {
        return this.getOwner().isVirtual(this);
    }

    @Override
    public OrmJoinColumn.Owner getOwner() {
        return (OrmJoinColumn.Owner)this.owner;
    }

    protected Table getReferencedColumnDbTable() {
        return this.getOwner().getReferencedColumnDbTable();
    }

    @Override
    public Column getReferencedDbColumn() {
        Table table = this.getReferencedColumnDbTable();
        return table == null ? null : table.getColumnForIdentifier(this.getReferencedColumnName());
    }

    @Override
    public boolean isReferencedColumnResolved() {
        return this.getReferencedDbColumn() != null;
    }

    @Override
    public TextRange getReferencedColumnNameTextRange() {
        TextRange textRange;
        if (this.getResourceColumn() != null && (textRange = this.getResourceColumn().getReferencedColumnNameTextRange()) != null) {
            return textRange;
        }
        return this.getOwner().getValidationTextRange();
    }

    @Override
    protected XmlJoinColumn getResourceColumn() {
        return this.resourceJoinColumn;
    }

    @Override
    protected void addResourceColumn() {
    }

    @Override
    protected void removeResourceColumn() {
    }

    @Override
    protected void initialize(XmlJoinColumn xjc) {
        this.resourceJoinColumn = xjc;
        super.initialize(xjc);
        this.specifiedReferencedColumnName = this.buildSpecifiedReferencedColumnName(xjc);
        this.defaultReferencedColumnName = this.buildDefaultReferencedColumnName();
    }

    @Override
    public void update(XmlJoinColumn xjc) {
        this.resourceJoinColumn = xjc;
        super.update(xjc);
        this.setSpecifiedReferencedColumnName_(this.buildSpecifiedReferencedColumnName(xjc));
        this.setDefaultReferencedColumnName(this.buildDefaultReferencedColumnName());
    }

    protected String buildSpecifiedReferencedColumnName(XmlJoinColumn xjc) {
        return xjc == null ? null : xjc.getReferencedColumnName();
    }

    @Override
    protected String buildDefaultName() {
        return MappingTools.buildJoinColumnDefaultName(this);
    }

    protected String buildDefaultReferencedColumnName() {
        return MappingTools.buildJoinColumnDefaultReferencedColumnName(this.getOwner());
    }

    @Override
    protected String defaultTable() {
        RelationshipMapping relationshipMapping = this.getOwner().getRelationshipMapping();
        if (relationshipMapping == null) {
            return null;
        }
        if (!relationshipMapping.isRelationshipOwner()) {
            return null;
        }
        return super.defaultTable();
    }

    @Override
    public void validate(List<IMessage> messages) {
        super.validate(messages);
        if (!this.isResolved()) {
            messages.add(this.buildUnresolvedMessage());
        }
    }

    protected IMessage buildUnresolvedMessage() {
        OrmRelationshipMapping mapping = (OrmRelationshipMapping)this.getOwner().getRelationshipMapping();
        return mapping.getPersistentAttribute().isVirtual() ? this.buildVirtualUnresolvedMessage(mapping) : this.buildNonVirtualUnresolvedMessage();
    }

    protected IMessage buildVirtualUnresolvedMessage(OrmRelationshipMapping mapping) {
        return this.buildMessage("VIRTUAL_ATTRIBUTE_COLUMN_UNRESOLVED_NAME", new String[]{mapping.getName(), this.getName()});
    }

    protected IMessage buildNonVirtualUnresolvedMessage() {
        return this.buildMessage("COLUMN_UNRESOLVED_NAME", new String[]{this.getName()});
    }

    protected IMessage buildMessage(String msgID, String[] parms) {
        return DefaultJpaValidationMessages.buildMessage(1, msgID, parms, this, this.getNameTextRange());
    }
}

