/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.orm;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jpt.core.context.AttributeMapping;
import org.eclipse.jpt.core.context.BaseJoinColumn;
import org.eclipse.jpt.core.context.Entity;
import org.eclipse.jpt.core.context.JoinColumn;
import org.eclipse.jpt.core.context.JoinTable;
import org.eclipse.jpt.core.context.NonOwningMapping;
import org.eclipse.jpt.core.context.PersistentAttribute;
import org.eclipse.jpt.core.context.RelationshipMapping;
import org.eclipse.jpt.core.context.TypeMapping;
import org.eclipse.jpt.core.context.orm.OrmJoinColumn;
import org.eclipse.jpt.core.context.orm.OrmJoinTable;
import org.eclipse.jpt.core.context.orm.OrmRelationshipMapping;
import org.eclipse.jpt.core.internal.context.orm.AbstractOrmTable;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.resource.orm.OrmFactory;
import org.eclipse.jpt.core.resource.orm.XmlJoinColumn;
import org.eclipse.jpt.core.resource.orm.XmlJoinColumnImpl;
import org.eclipse.jpt.core.resource.orm.XmlJoinTable;
import org.eclipse.jpt.core.resource.orm.XmlJoinTableImpl;
import org.eclipse.jpt.core.resource.orm.XmlRelationshipMapping;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.db.Table;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;
import org.eclipse.jpt.utility.internal.iterators.EmptyListIterator;
import org.eclipse.jpt.utility.internal.iterators.SingleElementListIterator;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericOrmJoinTable
extends AbstractOrmTable
implements OrmJoinTable {
    protected final List<OrmJoinColumn> specifiedJoinColumns = new ArrayList<OrmJoinColumn>();
    protected OrmJoinColumn defaultJoinColumn;
    protected final List<OrmJoinColumn> specifiedInverseJoinColumns = new ArrayList<OrmJoinColumn>();
    protected OrmJoinColumn defaultInverseJoinColumn;
    protected XmlRelationshipMapping relationshipMappingResource;

    public GenericOrmJoinTable(OrmRelationshipMapping parent) {
        super(parent);
    }

    @Override
    public OrmRelationshipMapping getParent() {
        return (OrmRelationshipMapping)super.getParent();
    }

    public OrmRelationshipMapping getRelationshipMapping() {
        return this.getParent();
    }

    @Override
    public void initializeFrom(JoinTable oldJoinTable) {
        OrmJoinColumn newJoinColumn;
        super.initializeFrom(oldJoinTable);
        int index = 0;
        for (JoinColumn joinColumn : CollectionTools.iterable((Iterator)oldJoinTable.specifiedJoinColumns())) {
            newJoinColumn = this.addSpecifiedJoinColumn(index++);
            newJoinColumn.initializeFrom(joinColumn);
        }
        index = 0;
        for (JoinColumn joinColumn : CollectionTools.iterable((Iterator)oldJoinTable.specifiedInverseJoinColumns())) {
            newJoinColumn = this.addSpecifiedInverseJoinColumn(index++);
            newJoinColumn.initializeFrom(joinColumn);
        }
    }

    @Override
    protected String buildDefaultName() {
        return this.getRelationshipMapping().getJoinTableDefaultName();
    }

    @Override
    protected String buildDefaultSchema() {
        return this.getRelationshipMapping().isRelationshipOwner() ? this.getContextDefaultSchema() : null;
    }

    @Override
    protected String buildDefaultCatalog() {
        return this.getRelationshipMapping().isRelationshipOwner() ? this.getContextDefaultCatalog() : null;
    }

    @Override
    protected XmlJoinTable getResourceTable() {
        return this.relationshipMappingResource.getJoinTable();
    }

    @Override
    protected XmlJoinTable addResourceTable() {
        XmlJoinTableImpl resourceTable = OrmFactory.eINSTANCE.createXmlJoinTableImpl();
        this.relationshipMappingResource.setJoinTable(resourceTable);
        return resourceTable;
    }

    @Override
    protected void removeResourceTable() {
        this.relationshipMappingResource.setJoinTable(null);
    }

    @Override
    public ListIterator<OrmJoinColumn> joinColumns() {
        return this.containsSpecifiedJoinColumns() ? this.specifiedJoinColumns() : this.defaultJoinColumns();
    }

    @Override
    public int joinColumnsSize() {
        return this.containsSpecifiedJoinColumns() ? this.specifiedJoinColumnsSize() : this.defaultJoinColumnsSize();
    }

    @Override
    public ListIterator<OrmJoinColumn> specifiedJoinColumns() {
        return new CloneListIterator(this.specifiedJoinColumns);
    }

    @Override
    public int specifiedJoinColumnsSize() {
        return this.specifiedJoinColumns.size();
    }

    protected ListIterator<OrmJoinColumn> defaultJoinColumns() {
        if (this.defaultJoinColumn != null) {
            return new SingleElementListIterator((Object)this.defaultJoinColumn);
        }
        return EmptyListIterator.instance();
    }

    protected int defaultJoinColumnsSize() {
        return this.defaultJoinColumn == null ? 0 : 1;
    }

    @Override
    public OrmJoinColumn getDefaultJoinColumn() {
        return this.defaultJoinColumn;
    }

    protected void setDefaultJoinColumn(OrmJoinColumn newJoinColumn) {
        OrmJoinColumn oldJoinColumn = this.defaultJoinColumn;
        this.defaultJoinColumn = newJoinColumn;
        this.firePropertyChanged("defaultJoinColumn", oldJoinColumn, newJoinColumn);
    }

    @Override
    public boolean containsSpecifiedJoinColumns() {
        return !this.specifiedJoinColumns.isEmpty();
    }

    @Override
    public OrmJoinColumn addSpecifiedJoinColumn(int index) {
        if (this.getResourceTable() == null) {
            this.addResourceTable();
        }
        XmlJoinColumnImpl resourceJoinColumn = OrmFactory.eINSTANCE.createXmlJoinColumnImpl();
        OrmJoinColumn contextJoinColumn = this.buildJoinColumn(resourceJoinColumn);
        this.specifiedJoinColumns.add(index, contextJoinColumn);
        this.getResourceTable().getJoinColumns().add(index, (Object)resourceJoinColumn);
        this.fireItemAdded("specifiedJoinColumnsList", index, contextJoinColumn);
        return contextJoinColumn;
    }

    protected void addSpecifiedJoinColumn(int index, OrmJoinColumn joinColumn) {
        this.addItemToList(index, joinColumn, this.specifiedJoinColumns, "specifiedJoinColumnsList");
    }

    protected void addSpecifiedJoinColumn(OrmJoinColumn joinColumn) {
        this.addSpecifiedJoinColumn(this.specifiedJoinColumns.size(), joinColumn);
    }

    @Override
    public void removeSpecifiedJoinColumn(JoinColumn joinColumn) {
        this.removeSpecifiedJoinColumn(this.specifiedJoinColumns.indexOf(joinColumn));
    }

    @Override
    public void removeSpecifiedJoinColumn(int index) {
        OrmJoinColumn removedJoinColumn = this.specifiedJoinColumns.remove(index);
        if (!this.containsSpecifiedJoinColumns()) {
            this.defaultJoinColumn = this.buildJoinColumn(null);
        }
        this.getResourceTable().getJoinColumns().remove(index);
        this.fireItemRemoved("specifiedJoinColumnsList", index, removedJoinColumn);
        if (this.defaultJoinColumn != null) {
            this.firePropertyChanged("defaultJoinColumn", null, this.defaultJoinColumn);
        }
    }

    protected void removeSpecifiedJoinColumn_(OrmJoinColumn joinColumn) {
        this.removeItemFromList(joinColumn, this.specifiedJoinColumns, "specifiedJoinColumnsList");
    }

    @Override
    public void moveSpecifiedJoinColumn(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.specifiedJoinColumns, (int)targetIndex, (int)sourceIndex);
        this.getResourceTable().getJoinColumns().move(targetIndex, sourceIndex);
        this.fireItemMoved("specifiedJoinColumnsList", targetIndex, sourceIndex);
    }

    @Override
    public ListIterator<OrmJoinColumn> inverseJoinColumns() {
        return this.containsSpecifiedInverseJoinColumns() ? this.specifiedInverseJoinColumns() : this.defaultInverseJoinColumns();
    }

    @Override
    public int inverseJoinColumnsSize() {
        return this.containsSpecifiedInverseJoinColumns() ? this.specifiedInverseJoinColumnsSize() : this.defaultInverseJoinColumnsSize();
    }

    @Override
    public ListIterator<OrmJoinColumn> specifiedInverseJoinColumns() {
        return new CloneListIterator(this.specifiedInverseJoinColumns);
    }

    @Override
    public int specifiedInverseJoinColumnsSize() {
        return this.specifiedInverseJoinColumns.size();
    }

    protected ListIterator<OrmJoinColumn> defaultInverseJoinColumns() {
        if (this.defaultInverseJoinColumn != null) {
            return new SingleElementListIterator((Object)this.defaultInverseJoinColumn);
        }
        return EmptyListIterator.instance();
    }

    protected int defaultInverseJoinColumnsSize() {
        return this.defaultInverseJoinColumn == null ? 0 : 1;
    }

    @Override
    public OrmJoinColumn getDefaultInverseJoinColumn() {
        return this.defaultInverseJoinColumn;
    }

    protected void setDefaultInverseJoinColumn(OrmJoinColumn newJoinColumn) {
        OrmJoinColumn oldJoinColumn = this.defaultInverseJoinColumn;
        this.defaultInverseJoinColumn = newJoinColumn;
        this.firePropertyChanged("defaultInverseJoinColumn", oldJoinColumn, newJoinColumn);
    }

    @Override
    public boolean containsSpecifiedInverseJoinColumns() {
        return !this.specifiedInverseJoinColumns.isEmpty();
    }

    @Override
    public OrmJoinColumn addSpecifiedInverseJoinColumn(int index) {
        if (this.getResourceTable() == null) {
            this.addResourceTable();
        }
        XmlJoinColumnImpl resourceJoinColumn = OrmFactory.eINSTANCE.createXmlJoinColumnImpl();
        OrmJoinColumn contextJoinColumn = this.buildInverseJoinColumn(resourceJoinColumn);
        this.specifiedInverseJoinColumns.add(index, contextJoinColumn);
        this.getResourceTable().getInverseJoinColumns().add(index, (Object)resourceJoinColumn);
        this.fireItemAdded("specifiedInverseJoinColumnsList", index, contextJoinColumn);
        return contextJoinColumn;
    }

    protected void addSpecifiedInverseJoinColumn(int index, OrmJoinColumn joinColumn) {
        this.addItemToList(index, joinColumn, this.specifiedInverseJoinColumns, "specifiedInverseJoinColumnsList");
    }

    protected void addSpecifiedInverseJoinColumn(OrmJoinColumn joinColumn) {
        this.addSpecifiedInverseJoinColumn(this.specifiedInverseJoinColumns.size(), joinColumn);
    }

    @Override
    public void removeSpecifiedInverseJoinColumn(JoinColumn joinColumn) {
        this.removeSpecifiedInverseJoinColumn(this.specifiedInverseJoinColumns.indexOf(joinColumn));
    }

    @Override
    public void removeSpecifiedInverseJoinColumn(int index) {
        OrmJoinColumn removedJoinColumn = this.specifiedInverseJoinColumns.remove(index);
        if (!this.containsSpecifiedInverseJoinColumns()) {
            this.defaultInverseJoinColumn = this.buildInverseJoinColumn(null);
        }
        this.getResourceTable().getInverseJoinColumns().remove(index);
        this.fireItemRemoved("specifiedInverseJoinColumnsList", index, removedJoinColumn);
        if (this.defaultInverseJoinColumn != null) {
            this.firePropertyChanged("defaultInverseJoinColumn", null, this.defaultInverseJoinColumn);
        }
    }

    protected void removeSpecifiedInverseJoinColumn_(OrmJoinColumn joinColumn) {
        this.removeItemFromList(joinColumn, this.specifiedInverseJoinColumns, "specifiedInverseJoinColumnsList");
    }

    @Override
    public void moveSpecifiedInverseJoinColumn(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.specifiedInverseJoinColumns, (int)targetIndex, (int)sourceIndex);
        this.getResourceTable().getInverseJoinColumns().move(targetIndex, sourceIndex);
        this.fireItemMoved("specifiedInverseJoinColumnsList", targetIndex, sourceIndex);
    }

    @Override
    public boolean isSpecified() {
        return this.getResourceTable() != null && this.getResourceTable().isSpecified();
    }

    @Override
    public void initialize(XmlRelationshipMapping relationshipMapping) {
        this.relationshipMappingResource = relationshipMapping;
        this.initialize(this.getResourceTable());
    }

    @Override
    public void update(XmlRelationshipMapping relationshipMapping) {
        this.relationshipMappingResource = relationshipMapping;
        this.update(this.getResourceTable());
    }

    protected void initialize(XmlJoinTable joinTable) {
        super.initialize(joinTable);
        this.initializeSpecifiedJoinColumns(joinTable);
        this.initializeDefaultJoinColumn();
        this.initializeSpecifiedInverseJoinColumns(joinTable);
        this.initializeDefaultInverseJoinColumn();
    }

    protected void initializeSpecifiedJoinColumns(XmlJoinTable joinTable) {
        if (joinTable == null) {
            return;
        }
        for (XmlJoinColumn joinColumn : joinTable.getJoinColumns()) {
            this.specifiedJoinColumns.add(this.buildJoinColumn(joinColumn));
        }
    }

    protected void initializeDefaultJoinColumn() {
        if (!this.shouldBuildDefaultJoinColumn()) {
            return;
        }
        this.defaultJoinColumn = this.buildJoinColumn(null);
    }

    protected void initializeSpecifiedInverseJoinColumns(XmlJoinTable joinTable) {
        if (joinTable == null) {
            return;
        }
        for (XmlJoinColumn joinColumn : joinTable.getInverseJoinColumns()) {
            this.specifiedInverseJoinColumns.add(this.buildInverseJoinColumn(joinColumn));
        }
    }

    protected void initializeDefaultInverseJoinColumn() {
        if (!this.shouldBuildDefaultInverseJoinColumn()) {
            return;
        }
        this.defaultInverseJoinColumn = this.buildInverseJoinColumn(null);
    }

    protected void update(XmlJoinTable joinTable) {
        super.update(joinTable);
        this.updateSpecifiedJoinColumns(joinTable);
        this.updateDefaultJoinColumn();
        this.updateSpecifiedInverseJoinColumns(joinTable);
        this.updateDefaultInverseJoinColumn();
    }

    protected void updateSpecifiedJoinColumns(XmlJoinTable joinTable) {
        ListIterator<OrmJoinColumn> contextJoinColumns = this.specifiedJoinColumns();
        ListIterator resourceJoinColumns = EmptyListIterator.instance();
        if (joinTable != null) {
            resourceJoinColumns = new CloneListIterator(joinTable.getJoinColumns());
        }
        while (contextJoinColumns.hasNext()) {
            OrmJoinColumn joinColumn = contextJoinColumns.next();
            if (resourceJoinColumns.hasNext()) {
                joinColumn.update((XmlJoinColumn)resourceJoinColumns.next());
                continue;
            }
            this.removeSpecifiedJoinColumn_(joinColumn);
        }
        while (resourceJoinColumns.hasNext()) {
            this.addSpecifiedJoinColumn(this.buildJoinColumn((XmlJoinColumn)resourceJoinColumns.next()));
        }
    }

    protected boolean shouldBuildDefaultJoinColumn() {
        return !this.containsSpecifiedJoinColumns();
    }

    protected void updateDefaultJoinColumn() {
        if (!this.shouldBuildDefaultJoinColumn()) {
            this.setDefaultJoinColumn(null);
            return;
        }
        if (this.getDefaultJoinColumn() == null) {
            this.setDefaultJoinColumn(this.buildJoinColumn(null));
        } else {
            this.defaultJoinColumn.update(null);
        }
    }

    protected void updateSpecifiedInverseJoinColumns(XmlJoinTable joinTable) {
        ListIterator<OrmJoinColumn> contextJoinColumns = this.specifiedInverseJoinColumns();
        ListIterator resourceJoinColumns = EmptyListIterator.instance();
        if (joinTable != null) {
            resourceJoinColumns = new CloneListIterator(joinTable.getInverseJoinColumns());
        }
        while (contextJoinColumns.hasNext()) {
            OrmJoinColumn joinColumn = contextJoinColumns.next();
            if (resourceJoinColumns.hasNext()) {
                joinColumn.update((XmlJoinColumn)resourceJoinColumns.next());
                continue;
            }
            this.removeSpecifiedInverseJoinColumn_(joinColumn);
        }
        while (resourceJoinColumns.hasNext()) {
            this.addSpecifiedInverseJoinColumn(this.buildInverseJoinColumn((XmlJoinColumn)resourceJoinColumns.next()));
        }
    }

    protected boolean shouldBuildDefaultInverseJoinColumn() {
        return !this.containsSpecifiedInverseJoinColumns();
    }

    protected void updateDefaultInverseJoinColumn() {
        if (!this.shouldBuildDefaultInverseJoinColumn()) {
            this.setDefaultInverseJoinColumn(null);
            return;
        }
        if (this.getDefaultInverseJoinColumn() == null) {
            this.setDefaultInverseJoinColumn(this.buildInverseJoinColumn(null));
        } else {
            this.defaultInverseJoinColumn.update(null);
        }
    }

    protected OrmJoinColumn buildJoinColumn(XmlJoinColumn resourceJoinColumn) {
        return this.getJpaFactory().buildOrmJoinColumn(this, new JoinColumnOwner(), resourceJoinColumn);
    }

    protected OrmJoinColumn buildInverseJoinColumn(XmlJoinColumn resourceJoinColumn) {
        return this.getJpaFactory().buildOrmJoinColumn(this, new InverseJoinColumnOwner(), resourceJoinColumn);
    }

    @Override
    public void validate(List<IMessage> messages) {
        super.validate(messages);
        if (this.connectionProfileIsActive()) {
            this.validateAgainstDatabase(messages);
        }
    }

    protected void validateAgainstDatabase(List<IMessage> messages) {
        OrmRelationshipMapping mapping = this.getRelationshipMapping();
        if (!this.hasResolvedCatalog()) {
            if (mapping.getPersistentAttribute().isVirtual()) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "VIRTUAL_ATTRIBUTE_JOIN_TABLE_UNRESOLVED_CATALOG", new String[]{mapping.getName(), this.getCatalog(), this.getName()}, this, this.getCatalogTextRange()));
            } else {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "JOIN_TABLE_UNRESOLVED_CATALOG", new String[]{this.getCatalog(), this.getName()}, this, this.getCatalogTextRange()));
            }
            return;
        }
        if (!this.hasResolvedSchema()) {
            if (mapping.getPersistentAttribute().isVirtual()) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "VIRTUAL_ATTRIBUTE_JOIN_TABLE_UNRESOLVED_SCHEMA", new String[]{mapping.getName(), this.getSchema(), this.getName()}, this, this.getSchemaTextRange()));
            } else {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "JOIN_TABLE_UNRESOLVED_SCHEMA", new String[]{this.getSchema(), this.getName()}, this, this.getSchemaTextRange()));
            }
            return;
        }
        if (!this.isResolved()) {
            if (mapping.getPersistentAttribute().isVirtual()) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "VIRTUAL_ATTRIBUTE_JOIN_TABLE_UNRESOLVED_NAME", new String[]{mapping.getName(), this.getName()}, this, this.getNameTextRange()));
            } else {
                String attributeName = mapping.getPersistentAttribute().getName();
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "JOIN_TABLE_CANNOT_BE_DETERMINED", new String[]{attributeName}, this, this.getNameTextRange()));
            }
            return;
        }
        this.validateJoinColumns(this.joinColumns(), messages);
        this.validateJoinColumns(this.inverseJoinColumns(), messages);
    }

    protected void validateJoinColumns(Iterator<OrmJoinColumn> joinColumns, List<IMessage> messages) {
        while (joinColumns.hasNext()) {
            joinColumns.next().validate(messages);
        }
    }

    abstract class AbstractJoinColumnOwner
    implements OrmJoinColumn.Owner {
        AbstractJoinColumnOwner() {
        }

        public TypeMapping getTypeMapping() {
            return this.getRelationshipMapping().getTypeMapping();
        }

        public RelationshipMapping getRelationshipMapping() {
            return GenericOrmJoinTable.this.getRelationshipMapping();
        }

        public boolean tableNameIsInvalid(String tableName) {
            return false;
        }

        public boolean tableIsAllowed() {
            return false;
        }

        public Table getDbTable(String tableName) {
            if (GenericOrmJoinTable.this.getName() == null) {
                return null;
            }
            return GenericOrmJoinTable.this.getName().equals(tableName) ? GenericOrmJoinTable.this.getDbTable() : null;
        }

        public String getDefaultTableName() {
            return GenericOrmJoinTable.this.getName();
        }

        public TextRange getValidationTextRange() {
            return GenericOrmJoinTable.this.getValidationTextRange();
        }
    }

    class InverseJoinColumnOwner
    extends AbstractJoinColumnOwner {
        public Entity getTargetEntity() {
            return GenericOrmJoinTable.this.getRelationshipMapping().getResolvedTargetEntity();
        }

        public String getAttributeName() {
            return GenericOrmJoinTable.this.getRelationshipMapping().getName();
        }

        public Table getDbTable(String tableName) {
            Table dbTable = super.getDbTable(tableName);
            if (dbTable != null) {
                return dbTable;
            }
            Entity targetEntity = this.getTargetEntity();
            return targetEntity == null ? null : targetEntity.getDbTable(tableName);
        }

        public Table getReferencedColumnDbTable() {
            Entity targetEntity = this.getTargetEntity();
            return targetEntity == null ? null : targetEntity.getPrimaryDbTable();
        }

        public boolean isVirtual(BaseJoinColumn joinColumn) {
            return GenericOrmJoinTable.this.defaultInverseJoinColumn == joinColumn;
        }

        public String getDefaultColumnName() {
            return null;
        }

        public int joinColumnsSize() {
            return GenericOrmJoinTable.this.inverseJoinColumnsSize();
        }
    }

    class JoinColumnOwner
    extends AbstractJoinColumnOwner {
        public Entity getTargetEntity() {
            return GenericOrmJoinTable.this.getRelationshipMapping().getEntity();
        }

        public String getAttributeName() {
            Entity targetEntity = GenericOrmJoinTable.this.getRelationshipMapping().getResolvedTargetEntity();
            if (targetEntity == null) {
                return null;
            }
            String attributeName = GenericOrmJoinTable.this.getRelationshipMapping().getName();
            Iterator<PersistentAttribute> stream = targetEntity.getPersistentType().allAttributes();
            while (stream.hasNext()) {
                String mappedBy;
                PersistentAttribute attribute = stream.next();
                AttributeMapping mapping = attribute.getMapping();
                if (!(mapping instanceof NonOwningMapping) || (mappedBy = ((NonOwningMapping)mapping).getMappedBy()) == null || !mappedBy.equals(attributeName)) continue;
                return attribute.getName();
            }
            return null;
        }

        public Table getDbTable(String tableName) {
            Table dbTable = super.getDbTable(tableName);
            return dbTable != null ? dbTable : this.getTypeMapping().getDbTable(tableName);
        }

        public Table getReferencedColumnDbTable() {
            return this.getTypeMapping().getPrimaryDbTable();
        }

        public boolean isVirtual(BaseJoinColumn joinColumn) {
            return GenericOrmJoinTable.this.defaultJoinColumn == joinColumn;
        }

        public String getDefaultColumnName() {
            return null;
        }

        public int joinColumnsSize() {
            return GenericOrmJoinTable.this.joinColumnsSize();
        }
    }
}

