/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.orm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jpt.core.JpaStructureNode;
import org.eclipse.jpt.core.JptCorePlugin;
import org.eclipse.jpt.core.MappingKeys;
import org.eclipse.jpt.core.context.AccessType;
import org.eclipse.jpt.core.context.PersistentAttribute;
import org.eclipse.jpt.core.context.PersistentType;
import org.eclipse.jpt.core.context.java.JavaAttributeMapping;
import org.eclipse.jpt.core.context.java.JavaBasicMapping;
import org.eclipse.jpt.core.context.java.JavaEmbeddedIdMapping;
import org.eclipse.jpt.core.context.java.JavaEmbeddedMapping;
import org.eclipse.jpt.core.context.java.JavaIdMapping;
import org.eclipse.jpt.core.context.java.JavaManyToManyMapping;
import org.eclipse.jpt.core.context.java.JavaManyToOneMapping;
import org.eclipse.jpt.core.context.java.JavaOneToManyMapping;
import org.eclipse.jpt.core.context.java.JavaOneToOneMapping;
import org.eclipse.jpt.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.core.context.java.JavaPersistentType;
import org.eclipse.jpt.core.context.java.JavaTransientMapping;
import org.eclipse.jpt.core.context.java.JavaVersionMapping;
import org.eclipse.jpt.core.context.orm.EntityMappings;
import org.eclipse.jpt.core.context.orm.OrmAttributeMapping;
import org.eclipse.jpt.core.context.orm.OrmEmbeddable;
import org.eclipse.jpt.core.context.orm.OrmEntity;
import org.eclipse.jpt.core.context.orm.OrmMappedSuperclass;
import org.eclipse.jpt.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.core.context.orm.OrmTypeMapping;
import org.eclipse.jpt.core.context.orm.OrmTypeMappingProvider;
import org.eclipse.jpt.core.internal.context.orm.AbstractOrmJpaContextNode;
import org.eclipse.jpt.core.internal.context.orm.OrmEmbeddableProvider;
import org.eclipse.jpt.core.internal.context.orm.OrmEntityProvider;
import org.eclipse.jpt.core.internal.context.orm.OrmMappedSuperclassProvider;
import org.eclipse.jpt.core.internal.context.orm.VirtualXmlBasic;
import org.eclipse.jpt.core.internal.context.orm.VirtualXmlEmbedded;
import org.eclipse.jpt.core.internal.context.orm.VirtualXmlEmbeddedId;
import org.eclipse.jpt.core.internal.context.orm.VirtualXmlId;
import org.eclipse.jpt.core.internal.context.orm.VirtualXmlManyToMany;
import org.eclipse.jpt.core.internal.context.orm.VirtualXmlManyToOne;
import org.eclipse.jpt.core.internal.context.orm.VirtualXmlNullAttributeMapping;
import org.eclipse.jpt.core.internal.context.orm.VirtualXmlOneToMany;
import org.eclipse.jpt.core.internal.context.orm.VirtualXmlOneToOne;
import org.eclipse.jpt.core.internal.context.orm.VirtualXmlTransient;
import org.eclipse.jpt.core.internal.context.orm.VirtualXmlVersion;
import org.eclipse.jpt.core.resource.orm.AbstractXmlTypeMapping;
import org.eclipse.jpt.core.resource.orm.Attributes;
import org.eclipse.jpt.core.resource.orm.OrmFactory;
import org.eclipse.jpt.core.resource.orm.XmlBasic;
import org.eclipse.jpt.core.resource.orm.XmlEmbeddable;
import org.eclipse.jpt.core.resource.orm.XmlEmbedded;
import org.eclipse.jpt.core.resource.orm.XmlEmbeddedId;
import org.eclipse.jpt.core.resource.orm.XmlEntity;
import org.eclipse.jpt.core.resource.orm.XmlId;
import org.eclipse.jpt.core.resource.orm.XmlManyToMany;
import org.eclipse.jpt.core.resource.orm.XmlManyToOne;
import org.eclipse.jpt.core.resource.orm.XmlMappedSuperclass;
import org.eclipse.jpt.core.resource.orm.XmlOneToMany;
import org.eclipse.jpt.core.resource.orm.XmlOneToOne;
import org.eclipse.jpt.core.resource.orm.XmlTransient;
import org.eclipse.jpt.core.resource.orm.XmlVersion;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.ChainIterator;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;
import org.eclipse.jpt.utility.internal.iterators.CompositeIterator;
import org.eclipse.jpt.utility.internal.iterators.CompositeListIterator;
import org.eclipse.jpt.utility.internal.iterators.EmptyListIterator;
import org.eclipse.jpt.utility.internal.iterators.FilteringIterator;
import org.eclipse.jpt.utility.internal.iterators.TransformationIterator;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericOrmPersistentType
extends AbstractOrmJpaContextNode
implements OrmPersistentType {
    protected final List<OrmPersistentAttribute> specifiedPersistentAttributes;
    protected final List<OrmPersistentAttribute> virtualPersistentAttributes;
    protected final Collection<OrmTypeMappingProvider> typeMappingProviders = this.buildTypeMappingProviders();
    protected OrmTypeMapping ormTypeMapping;
    protected PersistentType parentPersistentType;

    public GenericOrmPersistentType(EntityMappings parent, String mappingKey) {
        super(parent);
        this.ormTypeMapping = this.buildOrmTypeMapping(mappingKey);
        this.specifiedPersistentAttributes = new ArrayList<OrmPersistentAttribute>();
        this.virtualPersistentAttributes = new ArrayList<OrmPersistentAttribute>();
    }

    @Override
    public String getId() {
        return "org.eclipse.jpt.core.orm.persistentType";
    }

    @Override
    public boolean isFor(String fullyQualifiedTypeName) {
        String className = this.getMapping().getClass_();
        if (className == null) {
            return false;
        }
        if (className.equals(fullyQualifiedTypeName)) {
            return true;
        }
        return (String.valueOf(this.getEntityMappings().getPackage()) + '.' + className).equals(fullyQualifiedTypeName);
    }

    protected OrmTypeMapping buildOrmTypeMapping(String key) {
        return this.getTypeMappingProvider(key).buildTypeMapping(this.getJpaFactory(), this);
    }

    protected Collection<OrmTypeMappingProvider> buildTypeMappingProviders() {
        ArrayList<OrmTypeMappingProvider> collection = new ArrayList<OrmTypeMappingProvider>();
        collection.add(new OrmEntityProvider());
        collection.add(new OrmMappedSuperclassProvider());
        collection.add(new OrmEmbeddableProvider());
        return collection;
    }

    protected OrmTypeMappingProvider getTypeMappingProvider(String key) {
        for (OrmTypeMappingProvider provider : this.typeMappingProviders) {
            if (!provider.getKey().equals(key)) continue;
            return provider;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public OrmTypeMapping getMapping() {
        return this.ormTypeMapping;
    }

    @Override
    public void setMappingKey(String newMappingKey) {
        if (this.getMappingKey() == newMappingKey) {
            return;
        }
        OrmTypeMapping oldMapping = this.getMapping();
        this.ormTypeMapping = this.buildOrmTypeMapping(newMappingKey);
        this.getEntityMappings().changeMapping(this, oldMapping, this.ormTypeMapping);
        this.firePropertyChanged("mapping", oldMapping, this.ormTypeMapping);
    }

    protected void setMappingKey_(String newMappingKey) {
        if (this.getMappingKey() == newMappingKey) {
            return;
        }
        OrmTypeMapping oldMapping = this.getMapping();
        this.ormTypeMapping = this.buildOrmTypeMapping(newMappingKey);
        this.firePropertyChanged("mapping", oldMapping, this.ormTypeMapping);
    }

    @Override
    public Iterator<PersistentType> inheritanceHierarchy() {
        return new ChainIterator<PersistentType>((PersistentType)this){

            protected PersistentType nextLink(PersistentType pt) {
                return pt.getParentPersistentType();
            }
        };
    }

    @Override
    public Iterator<PersistentType> ancestors() {
        return new ChainIterator<PersistentType>(this.getParentPersistentType()){

            protected PersistentType nextLink(PersistentType pt) {
                return pt.getParentPersistentType();
            }
        };
    }

    @Override
    public PersistentType getParentPersistentType() {
        return this.parentPersistentType;
    }

    public void setParentPersistentType(PersistentType newParentPersistentType) {
        if (this.attributeValueHasNotChanged(this.parentPersistentType, newParentPersistentType)) {
            return;
        }
        PersistentType oldParentPersistentType = this.parentPersistentType;
        this.parentPersistentType = newParentPersistentType;
        this.firePropertyChanged("parentPersistentType", oldParentPersistentType, newParentPersistentType);
    }

    @Override
    public AccessType getAccess() {
        return this.getMapping().getAccess();
    }

    @Override
    public void changeMapping(OrmPersistentAttribute ormPersistentAttribute, OrmAttributeMapping oldMapping, OrmAttributeMapping newMapping) {
        int sourceIndex = this.specifiedPersistentAttributes.indexOf(ormPersistentAttribute);
        if (sourceIndex != -1) {
            this.specifiedPersistentAttributes.remove(sourceIndex);
            oldMapping.removeFromResourceModel(this.getMapping().getTypeMappingResource());
        }
        if (this.getMapping().getTypeMappingResource().getAttributes() == null) {
            this.getMapping().getTypeMappingResource().setAttributes(OrmFactory.eINSTANCE.createAttributes());
        }
        int targetIndex = this.insertionIndex(ormPersistentAttribute);
        this.specifiedPersistentAttributes.add(targetIndex, ormPersistentAttribute);
        newMapping.addToResourceModel(this.getMapping().getTypeMappingResource());
        oldMapping.initializeOn(newMapping);
        if (sourceIndex != -1) {
            this.fireItemMoved("specifiedAttributes", targetIndex, sourceIndex);
        }
    }

    @Override
    public void makePersistentAttributeVirtual(OrmPersistentAttribute ormPersistentAttribute) {
        if (ormPersistentAttribute.isVirtual()) {
            throw new IllegalStateException("Attribute is already virtual");
        }
        JavaPersistentAttribute javaPersistentAttribute = ormPersistentAttribute.getMapping().getJavaPersistentAttribute();
        OrmPersistentAttribute virtualPersistentAttribute = null;
        if (javaPersistentAttribute != null) {
            virtualPersistentAttribute = this.createVirtualPersistentAttribute(javaPersistentAttribute);
            this.virtualPersistentAttributes.add(virtualPersistentAttribute);
        }
        this.removeSpecifiedPersistentAttribute(ormPersistentAttribute);
        if (virtualPersistentAttribute != null) {
            this.fireItemAdded("virtualAttributes", this.virtualAttributesSize() - 1, virtualPersistentAttribute);
        }
    }

    @Override
    public void makePersistentAttributeSpecified(OrmPersistentAttribute ormPersistentAttribute) {
        this.makePersistentAttributeSpecified(ormPersistentAttribute, ormPersistentAttribute.getMappingKey());
    }

    @Override
    public void makePersistentAttributeSpecified(OrmPersistentAttribute ormPersistentAttribute, String mappingKey) {
        if (!ormPersistentAttribute.isVirtual()) {
            throw new IllegalStateException("Attribute is already specified");
        }
        if (mappingKey == MappingKeys.NULL_ATTRIBUTE_MAPPING_KEY) {
            throw new IllegalStateException("Use makePersistentAttributeSpecified(OrmPersistentAttribute, String) instead and specify a mapping type");
        }
        OrmPersistentAttribute newPersistentAttribute = this.getJpaFactory().buildOrmPersistentAttribute(this, mappingKey);
        if (this.getMapping().getTypeMappingResource().getAttributes() == null) {
            this.getMapping().getTypeMappingResource().setAttributes(OrmFactory.eINSTANCE.createAttributes());
        }
        int insertionIndex = this.insertionIndex(newPersistentAttribute);
        this.specifiedPersistentAttributes.add(insertionIndex, newPersistentAttribute);
        newPersistentAttribute.getMapping().addToResourceModel(this.getMapping().getTypeMappingResource());
        int removalIndex = this.virtualPersistentAttributes.indexOf(ormPersistentAttribute);
        this.virtualPersistentAttributes.remove(ormPersistentAttribute);
        newPersistentAttribute.getSpecifiedMapping().setName(ormPersistentAttribute.getName());
        this.fireItemAdded("specifiedAttributes", insertionIndex, newPersistentAttribute);
        this.fireItemRemoved("virtualAttributes", removalIndex, ormPersistentAttribute);
    }

    @Override
    public Iterator<String> allAttributeNames() {
        return this.attributeNames(this.allAttributes());
    }

    @Override
    public Iterator<PersistentAttribute> allAttributes() {
        return new CompositeIterator((Iterator)new TransformationIterator<PersistentType, Iterator<PersistentAttribute>>(this.inheritanceHierarchy()){

            protected Iterator<PersistentAttribute> transform(PersistentType pt) {
                return pt.attributes();
            }
        });
    }

    protected Iterator<OrmPersistentAttribute> attributesNamed(final String attributeName) {
        return new FilteringIterator<OrmPersistentAttribute, OrmPersistentAttribute>(this.attributes()){

            protected boolean accept(OrmPersistentAttribute o) {
                if (attributeName == null && o.getName() == null) {
                    return true;
                }
                return attributeName != null && attributeName.equals(o.getName());
            }
        };
    }

    @Override
    public OrmPersistentAttribute getAttributeNamed(String attributeName) {
        Iterator<OrmPersistentAttribute> stream = this.attributesNamed(attributeName);
        return stream.hasNext() ? stream.next() : null;
    }

    @Override
    public Iterator<String> attributeNames() {
        return this.attributeNames(this.attributes());
    }

    protected Iterator<String> attributeNames(Iterator<? extends PersistentAttribute> attrs) {
        return new TransformationIterator<PersistentAttribute, String>(attrs){

            protected String transform(PersistentAttribute attribute) {
                return attribute.getName();
            }
        };
    }

    protected OrmPersistentAttribute specifiedAttributeNamed(String attributeName) {
        Iterator<OrmPersistentAttribute> stream = this.specifiedAttributesNamed(attributeName);
        return stream.hasNext() ? stream.next() : null;
    }

    protected Iterator<OrmPersistentAttribute> specifiedAttributesNamed(final String attributeName) {
        return new FilteringIterator<OrmPersistentAttribute, OrmPersistentAttribute>(this.specifiedAttributes()){

            protected boolean accept(OrmPersistentAttribute ormPersistentAttribute) {
                return attributeName.equals(ormPersistentAttribute.getName());
            }
        };
    }

    @Override
    public ListIterator<OrmPersistentAttribute> attributes() {
        return new CompositeListIterator(new ListIterator[]{this.specifiedAttributes(), this.virtualAttributes()});
    }

    @Override
    public int attributesSize() {
        return this.specifiedAttributesSize() + this.virtualAttributesSize();
    }

    @Override
    public ListIterator<OrmPersistentAttribute> specifiedAttributes() {
        return new CloneListIterator(this.specifiedPersistentAttributes);
    }

    @Override
    public int specifiedAttributesSize() {
        return this.specifiedPersistentAttributes.size();
    }

    @Override
    public ListIterator<OrmPersistentAttribute> virtualAttributes() {
        return new CloneListIterator(this.virtualPersistentAttributes);
    }

    @Override
    public int virtualAttributesSize() {
        return this.virtualPersistentAttributes.size();
    }

    protected void addVirtualPersistentAttribute(OrmPersistentAttribute ormPersistentAttribute) {
        this.addItemToList(ormPersistentAttribute, this.virtualPersistentAttributes, "virtualAttributes");
    }

    protected void removeVirtualPersistentAttribute(OrmPersistentAttribute ormPersistentAttribute) {
        this.removeItemFromList(ormPersistentAttribute, this.virtualPersistentAttributes, "virtualAttributes");
    }

    @Override
    public boolean containsVirtualPersistentAttribute(OrmPersistentAttribute ormPersistentAttribute) {
        return this.virtualPersistentAttributes.contains(ormPersistentAttribute);
    }

    @Override
    public OrmPersistentAttribute addSpecifiedPersistentAttribute(String mappingKey, String attributeName) {
        OrmPersistentAttribute persistentAttribute = this.getJpaFactory().buildOrmPersistentAttribute(this, mappingKey);
        int index = this.insertionIndex(persistentAttribute);
        if (this.getMapping().getTypeMappingResource().getAttributes() == null) {
            this.getMapping().getTypeMappingResource().setAttributes(OrmFactory.eINSTANCE.createAttributes());
        }
        this.specifiedPersistentAttributes.add(index, persistentAttribute);
        persistentAttribute.getMapping().addToResourceModel(this.getMapping().getTypeMappingResource());
        persistentAttribute.getSpecifiedMapping().setName(attributeName);
        this.fireItemAdded("specifiedAttributes", index, persistentAttribute);
        return persistentAttribute;
    }

    protected int insertionIndex(OrmPersistentAttribute persistentAttribute) {
        return CollectionTools.insertionIndexOf(this.specifiedPersistentAttributes, (Object)persistentAttribute, this.buildMappingComparator());
    }

    protected Comparator<OrmPersistentAttribute> buildMappingComparator() {
        return new Comparator<OrmPersistentAttribute>(){

            @Override
            public int compare(OrmPersistentAttribute o1, OrmPersistentAttribute o2) {
                int o2Sequence;
                int o1Sequence = o1.getMapping().getXmlSequence();
                if (o1Sequence < (o2Sequence = o2.getMapping().getXmlSequence())) {
                    return -1;
                }
                if (o1Sequence == o2Sequence) {
                    return 0;
                }
                return 1;
            }
        };
    }

    protected void addSpecifiedPersistentAttribute_(OrmPersistentAttribute ormPersistentAttribute) {
        this.addItemToList(ormPersistentAttribute, this.specifiedPersistentAttributes, "specifiedAttributes");
    }

    protected void removeSpecifiedPersistentAttribute_(OrmPersistentAttribute ormPersistentAttribute) {
        this.removeItemFromList(ormPersistentAttribute, this.specifiedPersistentAttributes, "specifiedAttributes");
    }

    @Override
    public void removeSpecifiedPersistentAttribute(OrmPersistentAttribute ormPersistentAttribute) {
        int index = this.specifiedPersistentAttributes.indexOf(ormPersistentAttribute);
        this.specifiedPersistentAttributes.remove(ormPersistentAttribute);
        ormPersistentAttribute.getMapping().removeFromResourceModel(this.ormTypeMapping.getTypeMappingResource());
        this.fireItemRemoved("specifiedAttributes", index, ormPersistentAttribute);
    }

    @Override
    public String getName() {
        return this.getMapping().getClass_();
    }

    @Override
    public void classChanged(String oldClass, String newClass) {
        this.firePropertyChanged("name", oldClass, newClass);
    }

    @Override
    public boolean isMapped() {
        return true;
    }

    @Override
    public String getMappingKey() {
        return this.getMapping().getKey();
    }

    @Override
    public JavaPersistentType getJavaPersistentType() {
        return this.getMapping().getJavaPersistentType();
    }

    @Override
    public void initialize(XmlEntity entity) {
        ((OrmEntity)this.getMapping()).initialize(entity);
        this.initializeParentPersistentType();
        this.initializePersistentAttributes(entity);
    }

    @Override
    public void initialize(XmlMappedSuperclass mappedSuperclass) {
        ((OrmMappedSuperclass)this.getMapping()).initialize(mappedSuperclass);
        this.initializeParentPersistentType();
        this.initializePersistentAttributes(mappedSuperclass);
    }

    @Override
    public void initialize(XmlEmbeddable embeddable) {
        ((OrmEmbeddable)this.getMapping()).initialize(embeddable);
        this.initializeParentPersistentType();
        this.initializePersistentAttributes(embeddable);
    }

    protected void initializePersistentAttributes(AbstractXmlTypeMapping typeMapping) {
        Attributes attributes = typeMapping.getAttributes();
        if (attributes != null) {
            this.initializeSpecifiedPersistentAttributes(attributes);
        }
        this.initializeVirtualPersistentAttributes();
    }

    protected void initializeSpecifiedPersistentAttributes(Attributes attributes) {
        OrmPersistentAttribute ormPersistentAttribute;
        for (XmlId id : attributes.getIds()) {
            ormPersistentAttribute = this.getJpaFactory().buildOrmPersistentAttribute(this, "id");
            ormPersistentAttribute.initialize(id);
            this.specifiedPersistentAttributes.add(ormPersistentAttribute);
        }
        for (XmlEmbeddedId embeddedId : attributes.getEmbeddedIds()) {
            ormPersistentAttribute = this.getJpaFactory().buildOrmPersistentAttribute(this, "embeddedId");
            ormPersistentAttribute.initialize(embeddedId);
            this.specifiedPersistentAttributes.add(ormPersistentAttribute);
        }
        for (XmlBasic basic : attributes.getBasics()) {
            ormPersistentAttribute = this.getJpaFactory().buildOrmPersistentAttribute(this, "basic");
            ormPersistentAttribute.initialize(basic);
            this.specifiedPersistentAttributes.add(ormPersistentAttribute);
        }
        for (XmlVersion version : attributes.getVersions()) {
            ormPersistentAttribute = this.getJpaFactory().buildOrmPersistentAttribute(this, "version");
            ormPersistentAttribute.initialize(version);
            this.specifiedPersistentAttributes.add(ormPersistentAttribute);
        }
        for (XmlManyToOne manyToOne : attributes.getManyToOnes()) {
            ormPersistentAttribute = this.getJpaFactory().buildOrmPersistentAttribute(this, "manyToOne");
            ormPersistentAttribute.initialize(manyToOne);
            this.specifiedPersistentAttributes.add(ormPersistentAttribute);
        }
        for (XmlOneToMany oneToMany : attributes.getOneToManys()) {
            ormPersistentAttribute = this.getJpaFactory().buildOrmPersistentAttribute(this, "oneToMany");
            ormPersistentAttribute.initialize(oneToMany);
            this.specifiedPersistentAttributes.add(ormPersistentAttribute);
        }
        for (XmlOneToOne oneToOne : attributes.getOneToOnes()) {
            ormPersistentAttribute = this.getJpaFactory().buildOrmPersistentAttribute(this, "oneToOne");
            ormPersistentAttribute.initialize(oneToOne);
            this.specifiedPersistentAttributes.add(ormPersistentAttribute);
        }
        for (XmlManyToMany manyToMany : attributes.getManyToManys()) {
            ormPersistentAttribute = this.getJpaFactory().buildOrmPersistentAttribute(this, "manyToMany");
            ormPersistentAttribute.initialize(manyToMany);
            this.specifiedPersistentAttributes.add(ormPersistentAttribute);
        }
        for (XmlEmbedded embedded : attributes.getEmbeddeds()) {
            ormPersistentAttribute = this.getJpaFactory().buildOrmPersistentAttribute(this, "embedded");
            ormPersistentAttribute.initialize(embedded);
            this.specifiedPersistentAttributes.add(ormPersistentAttribute);
        }
        for (XmlTransient transientResource : attributes.getTransients()) {
            ormPersistentAttribute = this.getJpaFactory().buildOrmPersistentAttribute(this, "transient");
            ormPersistentAttribute.initialize(transientResource);
            this.specifiedPersistentAttributes.add(ormPersistentAttribute);
        }
    }

    protected void initializeVirtualPersistentAttributes() {
        ListIterator<JavaPersistentAttribute> javaAttributes = this.javaPersistentAttributes();
        while (javaAttributes.hasNext()) {
            JavaPersistentAttribute javaPersistentAttribute = javaAttributes.next();
            if (this.specifiedAttributeNamed(javaPersistentAttribute.getName()) != null) continue;
            OrmPersistentAttribute ormPersistentAttribute = this.createVirtualPersistentAttribute(javaPersistentAttribute);
            this.virtualPersistentAttributes.add(ormPersistentAttribute);
        }
    }

    protected ListIterator<JavaPersistentAttribute> javaPersistentAttributes() {
        JavaPersistentType javaPersistentType = this.getJavaPersistentType();
        if (javaPersistentType != null) {
            return javaPersistentType.attributes();
        }
        return EmptyListIterator.instance();
    }

    protected void initializeParentPersistentType() {
        JavaPersistentType javaPersistentType = this.getJavaPersistentType();
        if (javaPersistentType != null) {
            this.parentPersistentType = javaPersistentType.getParentPersistentType();
        }
    }

    @Override
    public void update(XmlEntity entity) {
        if (this.getMappingKey() != "entity") {
            this.setMappingKey_("entity");
        }
        ((OrmEntity)this.getMapping()).update(entity);
        this.updateParentPersistentType();
        this.updatePersistentAttributes(entity);
    }

    @Override
    public void update(XmlMappedSuperclass mappedSuperclass) {
        if (this.getMappingKey() != "mappedSuperclass") {
            this.setMappingKey_("mappedSuperclass");
        }
        ((OrmMappedSuperclass)this.getMapping()).update(mappedSuperclass);
        this.updateParentPersistentType();
        this.updatePersistentAttributes(mappedSuperclass);
    }

    @Override
    public void update(XmlEmbeddable embeddable) {
        if (this.getMappingKey() != "embeddable") {
            this.setMappingKey_("embeddable");
        }
        ((OrmEmbeddable)this.getMapping()).update(embeddable);
        this.updateParentPersistentType();
        this.updatePersistentAttributes(embeddable);
    }

    protected void updateParentPersistentType() {
        JavaPersistentType javaPersistentType = this.getJavaPersistentType();
        this.setParentPersistentType(javaPersistentType == null ? null : javaPersistentType.getParentPersistentType());
    }

    protected void updatePersistentAttributes(AbstractXmlTypeMapping typeMapping) {
        ListIterator<OrmPersistentAttribute> ormPersistentAttributes = this.specifiedAttributes();
        if (typeMapping.getAttributes() != null) {
            this.updateIds(typeMapping.getAttributes(), ormPersistentAttributes);
            this.updateEmbeddedIds(typeMapping.getAttributes(), ormPersistentAttributes);
            this.updateBasics(typeMapping.getAttributes(), ormPersistentAttributes);
            this.updateVersions(typeMapping.getAttributes(), ormPersistentAttributes);
            this.updateManyToOnes(typeMapping.getAttributes(), ormPersistentAttributes);
            this.updateOneToManys(typeMapping.getAttributes(), ormPersistentAttributes);
            this.updateOneToOnes(typeMapping.getAttributes(), ormPersistentAttributes);
            this.updateManyToManys(typeMapping.getAttributes(), ormPersistentAttributes);
            this.updateEmbeddeds(typeMapping.getAttributes(), ormPersistentAttributes);
            this.updateTransients(typeMapping.getAttributes(), ormPersistentAttributes);
        }
        while (ormPersistentAttributes.hasNext()) {
            this.removeSpecifiedPersistentAttribute_(ormPersistentAttributes.next());
        }
        this.updateVirtualPersistentAttributes();
    }

    protected void updateVirtualAttribute(OrmPersistentAttribute ormPersistentAttribute, JavaPersistentAttribute javaAttribute) {
        String javaMappingKey = javaAttribute.getMappingKey();
        JavaAttributeMapping javaAttributeMapping = javaAttribute.getMapping();
        if (this.getMapping().isMetadataComplete()) {
            javaMappingKey = javaAttribute.getDefaultMappingKey();
            javaAttributeMapping = javaAttribute.getDefaultMapping();
        }
        if (javaMappingKey == "basic") {
            ormPersistentAttribute.update(new VirtualXmlBasic(this.getMapping(), (JavaBasicMapping)javaAttributeMapping, this.getMapping().isMetadataComplete()));
        } else if (javaMappingKey == "embedded") {
            ormPersistentAttribute.update(new VirtualXmlEmbedded(this.getMapping(), (JavaEmbeddedMapping)javaAttributeMapping, this.getMapping().isMetadataComplete()));
        } else if (javaMappingKey == "embeddedId") {
            ormPersistentAttribute.update(new VirtualXmlEmbeddedId(this.getMapping(), (JavaEmbeddedIdMapping)javaAttributeMapping, this.getMapping().isMetadataComplete()));
        } else if (javaMappingKey == "id") {
            ormPersistentAttribute.update(new VirtualXmlId(this.getMapping(), (JavaIdMapping)javaAttributeMapping, this.getMapping().isMetadataComplete()));
        } else if (javaMappingKey == "manyToMany") {
            ormPersistentAttribute.update(new VirtualXmlManyToMany(ormPersistentAttribute, (JavaManyToManyMapping)javaAttributeMapping, this.getMapping().isMetadataComplete()));
        } else if (javaMappingKey == "manyToOne") {
            ormPersistentAttribute.update(new VirtualXmlManyToOne((JavaManyToOneMapping)javaAttributeMapping, this.getMapping().isMetadataComplete()));
        } else if (javaMappingKey == "oneToMany") {
            ormPersistentAttribute.update(new VirtualXmlOneToMany(ormPersistentAttribute, (JavaOneToManyMapping)javaAttributeMapping, this.getMapping().isMetadataComplete()));
        } else if (javaMappingKey == "oneToOne") {
            ormPersistentAttribute.update(new VirtualXmlOneToOne((JavaOneToOneMapping)javaAttributeMapping, this.getMapping().isMetadataComplete()));
        } else if (javaMappingKey == "transient") {
            ormPersistentAttribute.update(new VirtualXmlTransient((JavaTransientMapping)javaAttributeMapping, this.getMapping().isMetadataComplete()));
        } else if (javaMappingKey == "version") {
            ormPersistentAttribute.update(new VirtualXmlVersion(this.getMapping(), (JavaVersionMapping)javaAttributeMapping, this.getMapping().isMetadataComplete()));
        } else if (javaMappingKey == MappingKeys.NULL_ATTRIBUTE_MAPPING_KEY) {
            ormPersistentAttribute.update(new VirtualXmlNullAttributeMapping(this.getMapping(), javaAttributeMapping, this.getMapping().isMetadataComplete()));
        }
    }

    protected void updateVirtualPersistentAttributes() {
        ListIterator<JavaPersistentAttribute> javaAttributes = this.javaPersistentAttributes();
        ListIterator<OrmPersistentAttribute> xmlVirtualAttributes = this.virtualAttributes();
        for (JavaPersistentAttribute javaAttribute : CollectionTools.iterable(javaAttributes)) {
            if (this.specifiedAttributeNamed(javaAttribute.getName()) != null) continue;
            if (xmlVirtualAttributes.hasNext()) {
                this.updateVirtualAttribute(xmlVirtualAttributes.next(), javaAttribute);
                continue;
            }
            OrmPersistentAttribute ormPersistentAttribute = this.createVirtualPersistentAttribute(javaAttribute);
            this.addVirtualPersistentAttribute(ormPersistentAttribute);
        }
        while (xmlVirtualAttributes.hasNext()) {
            this.removeVirtualPersistentAttribute(xmlVirtualAttributes.next());
        }
    }

    protected void addVirtualPersistentAttribute(JavaPersistentAttribute javaAttribute) {
        this.addVirtualPersistentAttribute(this.createVirtualPersistentAttribute(javaAttribute));
    }

    protected OrmPersistentAttribute createVirtualPersistentAttribute(JavaPersistentAttribute javaAttribute) {
        String javaMappingKey = javaAttribute.getMappingKey();
        JavaAttributeMapping javaAttributeMapping = javaAttribute.getMapping();
        if (this.getMapping().isMetadataComplete()) {
            javaMappingKey = javaAttribute.getDefaultMappingKey();
            javaAttributeMapping = javaAttribute.getDefaultMapping();
        }
        OrmPersistentAttribute ormPersistentAttribute = this.getJpaFactory().buildOrmPersistentAttribute(this, javaMappingKey);
        if (javaMappingKey == "basic") {
            ormPersistentAttribute.initialize(new VirtualXmlBasic(this.getMapping(), (JavaBasicMapping)javaAttributeMapping, this.getMapping().isMetadataComplete()));
        } else if (javaMappingKey == "embeddedId") {
            ormPersistentAttribute.initialize(new VirtualXmlEmbeddedId(this.getMapping(), (JavaEmbeddedIdMapping)javaAttributeMapping, this.getMapping().isMetadataComplete()));
        } else if (javaMappingKey == "embedded") {
            ormPersistentAttribute.initialize(new VirtualXmlEmbedded(this.getMapping(), (JavaEmbeddedMapping)javaAttributeMapping, this.getMapping().isMetadataComplete()));
        } else if (javaMappingKey == "id") {
            ormPersistentAttribute.initialize(new VirtualXmlId(this.getMapping(), (JavaIdMapping)javaAttributeMapping, this.getMapping().isMetadataComplete()));
        } else if (javaMappingKey == "manyToMany") {
            ormPersistentAttribute.initialize(new VirtualXmlManyToMany(ormPersistentAttribute, (JavaManyToManyMapping)javaAttributeMapping, this.getMapping().isMetadataComplete()));
        } else if (javaMappingKey == "manyToOne") {
            ormPersistentAttribute.initialize(new VirtualXmlManyToOne((JavaManyToOneMapping)javaAttributeMapping, this.getMapping().isMetadataComplete()));
        } else if (javaMappingKey == "oneToMany") {
            ormPersistentAttribute.initialize(new VirtualXmlOneToMany(ormPersistentAttribute, (JavaOneToManyMapping)javaAttributeMapping, this.getMapping().isMetadataComplete()));
        } else if (javaMappingKey == "oneToOne") {
            ormPersistentAttribute.initialize(new VirtualXmlOneToOne((JavaOneToOneMapping)javaAttributeMapping, this.getMapping().isMetadataComplete()));
        } else if (javaMappingKey == "transient") {
            ormPersistentAttribute.initialize(new VirtualXmlTransient((JavaTransientMapping)javaAttributeMapping, this.getMapping().isMetadataComplete()));
        } else if (javaMappingKey == "version") {
            ormPersistentAttribute.initialize(new VirtualXmlVersion(this.getMapping(), (JavaVersionMapping)javaAttributeMapping, this.getMapping().isMetadataComplete()));
        } else if (javaMappingKey == MappingKeys.NULL_ATTRIBUTE_MAPPING_KEY) {
            ormPersistentAttribute.initialize(new VirtualXmlNullAttributeMapping(this.getMapping(), javaAttributeMapping, this.getMapping().isMetadataComplete()));
        }
        return ormPersistentAttribute;
    }

    protected void updateIds(Attributes attributes, ListIterator<OrmPersistentAttribute> ormPersistentAttributes) {
        CloneListIterator ids = new CloneListIterator(attributes.getIds());
        for (XmlId id : CollectionTools.iterable((Iterator)ids)) {
            if (ormPersistentAttributes.hasNext()) {
                ormPersistentAttributes.next().update(id);
                continue;
            }
            OrmPersistentAttribute ormPersistentAttribute = this.getJpaFactory().buildOrmPersistentAttribute(this, "id");
            ormPersistentAttribute.initialize(id);
            this.addSpecifiedPersistentAttribute_(ormPersistentAttribute);
        }
    }

    protected void updateEmbeddedIds(Attributes attributes, ListIterator<OrmPersistentAttribute> ormPersistentAttributes) {
        CloneListIterator embeddedIds = new CloneListIterator(attributes.getEmbeddedIds());
        for (XmlEmbeddedId embeddedId : CollectionTools.iterable((Iterator)embeddedIds)) {
            if (ormPersistentAttributes.hasNext()) {
                ormPersistentAttributes.next().update(embeddedId);
                continue;
            }
            OrmPersistentAttribute ormPersistentAttribute = this.getJpaFactory().buildOrmPersistentAttribute(this, "embeddedId");
            ormPersistentAttribute.initialize(embeddedId);
            this.addSpecifiedPersistentAttribute_(ormPersistentAttribute);
        }
    }

    protected void updateBasics(Attributes attributes, ListIterator<OrmPersistentAttribute> ormPersistentAttributes) {
        CloneListIterator basics = new CloneListIterator(attributes.getBasics());
        for (XmlBasic basic : CollectionTools.iterable((Iterator)basics)) {
            if (ormPersistentAttributes.hasNext()) {
                ormPersistentAttributes.next().update(basic);
                continue;
            }
            OrmPersistentAttribute ormPersistentAttribute = this.getJpaFactory().buildOrmPersistentAttribute(this, "basic");
            ormPersistentAttribute.initialize(basic);
            this.addSpecifiedPersistentAttribute_(ormPersistentAttribute);
        }
    }

    protected void updateVersions(Attributes attributes, ListIterator<OrmPersistentAttribute> ormPersistentAttributes) {
        CloneListIterator versions = new CloneListIterator(attributes.getVersions());
        for (XmlVersion version : CollectionTools.iterable((Iterator)versions)) {
            if (ormPersistentAttributes.hasNext()) {
                ormPersistentAttributes.next().update(version);
                continue;
            }
            OrmPersistentAttribute ormPersistentAttribute = this.getJpaFactory().buildOrmPersistentAttribute(this, "version");
            ormPersistentAttribute.initialize(version);
            this.addSpecifiedPersistentAttribute_(ormPersistentAttribute);
        }
    }

    protected void updateManyToOnes(Attributes attributes, ListIterator<OrmPersistentAttribute> ormPersistentAttributes) {
        CloneListIterator manyToOnes = new CloneListIterator(attributes.getManyToOnes());
        for (XmlManyToOne manyToOne : CollectionTools.iterable((Iterator)manyToOnes)) {
            if (ormPersistentAttributes.hasNext()) {
                ormPersistentAttributes.next().update(manyToOne);
                continue;
            }
            OrmPersistentAttribute ormPersistentAttribute = this.getJpaFactory().buildOrmPersistentAttribute(this, "manyToOne");
            ormPersistentAttribute.initialize(manyToOne);
            this.addSpecifiedPersistentAttribute_(ormPersistentAttribute);
        }
    }

    protected void updateOneToManys(Attributes attributes, ListIterator<OrmPersistentAttribute> ormPersistentAttributes) {
        CloneListIterator oneToManys = new CloneListIterator(attributes.getOneToManys());
        for (XmlOneToMany oneToMany : CollectionTools.iterable((Iterator)oneToManys)) {
            if (ormPersistentAttributes.hasNext()) {
                ormPersistentAttributes.next().update(oneToMany);
                continue;
            }
            OrmPersistentAttribute ormPersistentAttribute = this.getJpaFactory().buildOrmPersistentAttribute(this, "oneToMany");
            ormPersistentAttribute.initialize(oneToMany);
            this.addSpecifiedPersistentAttribute_(ormPersistentAttribute);
        }
    }

    protected void updateOneToOnes(Attributes attributes, ListIterator<OrmPersistentAttribute> ormPersistentAttributes) {
        CloneListIterator oneToOnes = new CloneListIterator(attributes.getOneToOnes());
        for (XmlOneToOne oneToOne : CollectionTools.iterable((Iterator)oneToOnes)) {
            if (ormPersistentAttributes.hasNext()) {
                ormPersistentAttributes.next().update(oneToOne);
                continue;
            }
            OrmPersistentAttribute ormPersistentAttribute = this.getJpaFactory().buildOrmPersistentAttribute(this, "oneToOne");
            ormPersistentAttribute.initialize(oneToOne);
            this.addSpecifiedPersistentAttribute_(ormPersistentAttribute);
        }
    }

    protected void updateManyToManys(Attributes attributes, ListIterator<OrmPersistentAttribute> ormPersistentAttributes) {
        CloneListIterator manyToManys = new CloneListIterator(attributes.getManyToManys());
        for (XmlManyToMany manyToMany : CollectionTools.iterable((Iterator)manyToManys)) {
            if (ormPersistentAttributes.hasNext()) {
                ormPersistentAttributes.next().update(manyToMany);
                continue;
            }
            OrmPersistentAttribute ormPersistentAttribute = this.getJpaFactory().buildOrmPersistentAttribute(this, "manyToMany");
            ormPersistentAttribute.initialize(manyToMany);
            this.addSpecifiedPersistentAttribute_(ormPersistentAttribute);
        }
    }

    protected void updateEmbeddeds(Attributes attributes, ListIterator<OrmPersistentAttribute> ormPersistentAttributes) {
        CloneListIterator embeddeds = new CloneListIterator(attributes.getEmbeddeds());
        for (XmlEmbedded embedded : CollectionTools.iterable((Iterator)embeddeds)) {
            if (ormPersistentAttributes.hasNext()) {
                ormPersistentAttributes.next().update(embedded);
                continue;
            }
            OrmPersistentAttribute ormPersistentAttribute = this.getJpaFactory().buildOrmPersistentAttribute(this, "embedded");
            ormPersistentAttribute.initialize(embedded);
            this.addSpecifiedPersistentAttribute_(ormPersistentAttribute);
        }
    }

    protected void updateTransients(Attributes attributes, ListIterator<OrmPersistentAttribute> ormPersistentAttributes) {
        CloneListIterator transients = new CloneListIterator(attributes.getTransients());
        for (XmlTransient transientResource : CollectionTools.iterable((Iterator)transients)) {
            if (ormPersistentAttributes.hasNext()) {
                ormPersistentAttributes.next().update(transientResource);
                continue;
            }
            OrmPersistentAttribute ormPersistentAttribute = this.getJpaFactory().buildOrmPersistentAttribute(this, "transient");
            ormPersistentAttribute.initialize(transientResource);
            this.addSpecifiedPersistentAttribute_(ormPersistentAttribute);
        }
    }

    @Override
    public PersistentAttribute resolveAttribute(String attributeName) {
        Iterator<OrmPersistentAttribute> attributes = this.attributesNamed(attributeName);
        if (attributes.hasNext()) {
            OrmPersistentAttribute attribute = attributes.next();
            return attributes.hasNext() ? null : attribute;
        }
        if (this.getParentPersistentType() != null) {
            return this.getParentPersistentType().resolveAttribute(attributeName);
        }
        return null;
    }

    @Override
    public OrmPersistentType getOrmPersistentType() {
        return this;
    }

    @Override
    public JpaStructureNode getStructureNode(int textOffset) {
        for (OrmPersistentAttribute attribute : CollectionTools.iterable(this.specifiedAttributes())) {
            if (!attribute.contains(textOffset)) continue;
            return attribute;
        }
        return this;
    }

    @Override
    public boolean contains(int textOffset) {
        return this.ormTypeMapping.containsOffset(textOffset);
    }

    @Override
    public TextRange getSelectionTextRange() {
        return this.ormTypeMapping.getSelectionTextRange();
    }

    @Override
    public void validate(List<IMessage> messages) {
        super.validate(messages);
        this.validateMapping(messages);
        this.validateAttributes(messages);
    }

    protected void validateMapping(List<IMessage> messages) {
        try {
            this.ormTypeMapping.validate(messages);
        }
        catch (Throwable t) {
            JptCorePlugin.log(t);
        }
    }

    protected void validateAttributes(List<IMessage> messages) {
        ListIterator<OrmPersistentAttribute> stream = this.attributes();
        while (stream.hasNext()) {
            this.validateAttribute((OrmPersistentAttribute)stream.next(), messages);
        }
    }

    protected void validateAttribute(OrmPersistentAttribute attribute, List<IMessage> messages) {
        try {
            attribute.validate(messages);
        }
        catch (Throwable t) {
            JptCorePlugin.log(t);
        }
    }

    @Override
    public TextRange getValidationTextRange() {
        return this.ormTypeMapping.getValidationTextRange();
    }

    @Override
    public void dispose() {
        if (this.getJavaPersistentType() != null) {
            this.getJavaPersistentType().dispose();
        }
    }

    public void toString(StringBuilder sb) {
        sb.append(this.getName());
    }
}

