/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.persistence;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jpt.core.JpaStructureNode;
import org.eclipse.jpt.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.core.context.orm.OrmXml;
import org.eclipse.jpt.core.context.orm.PersistenceUnitDefaults;
import org.eclipse.jpt.core.context.persistence.MappingFileRef;
import org.eclipse.jpt.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.core.internal.context.persistence.AbstractPersistenceJpaContextNode;
import org.eclipse.jpt.core.internal.resource.orm.OrmResourceModelProvider;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.resource.orm.OrmResource;
import org.eclipse.jpt.core.resource.persistence.XmlMappingFileRef;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericMappingFileRef
extends AbstractPersistenceJpaContextNode
implements MappingFileRef {
    protected XmlMappingFileRef xmlMappingFileRef;
    protected String fileName;
    protected OrmXml ormXml;

    public GenericMappingFileRef(PersistenceUnit parent, XmlMappingFileRef mappingFileRef) {
        super(parent);
        this.initialize(mappingFileRef);
    }

    @Override
    public String getId() {
        return "org.eclipse.jpt.core.persistence.mappingFileRef";
    }

    @Override
    public boolean isVirtual() {
        return this.xmlMappingFileRef == null;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public void setFileName(String newFileName) {
        this.xmlMappingFileRef.setFileName(newFileName);
        this.setFileName_(newFileName);
    }

    protected void setFileName_(String newFileName) {
        String oldFileName = this.fileName;
        this.fileName = newFileName;
        this.firePropertyChanged("fileName", oldFileName, newFileName);
    }

    @Override
    public OrmXml getOrmXml() {
        return this.ormXml;
    }

    protected void setOrmXml(OrmXml newOrmXml) {
        OrmXml oldOrmXml = this.ormXml;
        this.ormXml = newOrmXml;
        this.firePropertyChanged("ormXml", oldOrmXml, newOrmXml);
    }

    protected void initialize(XmlMappingFileRef mappingFileRef) {
        this.xmlMappingFileRef = mappingFileRef;
        this.initializeFileName();
        this.initializeOrmXml();
    }

    protected void initializeFileName() {
        this.fileName = this.isVirtual() ? "META-INF/orm.xml" : this.xmlMappingFileRef.getFileName();
    }

    protected void initializeOrmXml() {
        OrmResourceModelProvider modelProvider;
        OrmResource ormResource;
        if (this.fileName != null && (ormResource = (modelProvider = OrmResourceModelProvider.getModelProvider(this.getJpaProject().getProject(), this.fileName)).getResource()) != null && ormResource.exists()) {
            this.ormXml = this.buildOrmXml(ormResource);
        }
    }

    @Override
    public void update(XmlMappingFileRef mappingFileRef) {
        this.xmlMappingFileRef = mappingFileRef;
        this.updateFileName();
        this.updateOrmXml();
    }

    protected void updateFileName() {
        if (this.isVirtual()) {
            this.setFileName_("META-INF/orm.xml");
        } else {
            this.setFileName_(this.xmlMappingFileRef.getFileName());
        }
    }

    protected void updateOrmXml() {
        if (this.fileName != null) {
            IProject project = this.getJpaProject().getProject();
            OrmResourceModelProvider modelProvider = OrmResourceModelProvider.getModelProvider(project, this.fileName);
            OrmResource ormResource = modelProvider.getResource();
            if (ormResource != null && ormResource.exists()) {
                if (this.ormXml != null) {
                    this.ormXml.update(ormResource);
                } else {
                    this.setOrmXml(this.buildOrmXml(ormResource));
                }
            } else {
                if (this.getOrmXml() != null) {
                    this.getOrmXml().dispose();
                }
                this.setOrmXml(null);
            }
        } else {
            if (this.getOrmXml() != null) {
                this.getOrmXml().dispose();
            }
            this.setOrmXml(null);
        }
    }

    protected OrmXml buildOrmXml(OrmResource ormResource) {
        return this.getJpaFactory().buildOrmXml(this, ormResource);
    }

    @Override
    public PersistenceUnitDefaults getPersistenceUnitDefaults() {
        if (this.getOrmXml() != null) {
            return this.getOrmXml().getPersistenceUnitDefaults();
        }
        return null;
    }

    @Override
    public OrmPersistentType getPersistentType(String fullyQualifiedTypeName) {
        if (this.getOrmXml() != null) {
            return this.getOrmXml().getPersistentType(fullyQualifiedTypeName);
        }
        return null;
    }

    @Override
    public JpaStructureNode getStructureNode(int textOffset) {
        return this;
    }

    @Override
    public boolean containsOffset(int textOffset) {
        if (this.xmlMappingFileRef == null) {
            return false;
        }
        return this.xmlMappingFileRef.containsOffset(textOffset);
    }

    @Override
    public TextRange getSelectionTextRange() {
        if (this.isVirtual()) {
            return null;
        }
        return this.xmlMappingFileRef.getSelectionTextRange();
    }

    @Override
    public TextRange getValidationTextRange() {
        if (this.isVirtual()) {
            return this.getPersistenceUnit().getValidationTextRange();
        }
        return this.xmlMappingFileRef.getValidationTextRange();
    }

    public void toString(StringBuilder sb) {
        super.toString(sb);
        sb.append(this.getFileName());
    }

    @Override
    public void dispose() {
        if (this.getOrmXml() != null) {
            this.getOrmXml().dispose();
        }
    }

    @Override
    public void validate(List<IMessage> messages) {
        super.validate(messages);
        if (StringTools.stringIsEmpty((String)this.fileName)) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "PERSISTENCE_UNIT_UNSPECIFIED_MAPPING_FILE", this, this.getValidationTextRange()));
            return;
        }
        if (this.ormXml == null) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "PERSISTENCE_UNIT_NONEXISTENT_MAPPING_FILE", new String[]{this.fileName}, this, this.getValidationTextRange()));
            return;
        }
        if (this.ormXml.getEntityMappings() == null) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "PERSISTENCE_UNIT_INVALID_MAPPING_FILE", new String[]{this.fileName}, this, this.getValidationTextRange()));
        }
        this.ormXml.validate(messages);
    }
}

