/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.persistence;

import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.jpt.core.JpaStructureNode;
import org.eclipse.jpt.core.context.JpaRootContextNode;
import org.eclipse.jpt.core.context.persistence.Persistence;
import org.eclipse.jpt.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.core.context.persistence.PersistenceXml;
import org.eclipse.jpt.core.internal.context.persistence.AbstractPersistenceJpaContextNode;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.core.resource.persistence.PersistenceResource;
import org.eclipse.jpt.core.resource.persistence.XmlPersistence;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericPersistenceXml
extends AbstractPersistenceJpaContextNode
implements PersistenceXml {
    protected PersistenceResource persistenceResource;
    protected Persistence persistence;

    public GenericPersistenceXml(JpaRootContextNode parent, PersistenceResource persistenceResource) {
        super(parent);
        this.initialize(persistenceResource);
    }

    @Override
    public String getId() {
        return null;
    }

    @Override
    public JpaRootContextNode getParent() {
        return (JpaRootContextNode)super.getParent();
    }

    @Override
    public IResource getResource() {
        return this.persistenceResource.getFile();
    }

    @Override
    public Persistence getPersistence() {
        return this.persistence;
    }

    @Override
    public Persistence addPersistence() {
        if (this.persistence != null) {
            throw new IllegalStateException();
        }
        XmlPersistence xmlPersistence = PersistenceFactory.eINSTANCE.createXmlPersistence();
        this.persistence = this.buildPersistence(xmlPersistence);
        this.persistenceResource.getContents().add((Object)xmlPersistence);
        this.firePropertyChanged("persistence", null, this.persistence);
        return this.persistence;
    }

    @Override
    public void removePersistence() {
        if (this.persistence == null) {
            throw new IllegalStateException();
        }
        this.getJpaFile(this.persistenceResource.getResourceModel()).removeRootStructureNode((Object)this.persistenceResource);
        this.persistence.dispose();
        Persistence oldPersistence = this.persistence;
        this.persistence = null;
        XmlPersistence xmlPersistence = this.persistenceResource.getPersistence();
        this.persistenceResource.getContents().remove((Object)xmlPersistence);
        this.firePropertyChanged("persistence", oldPersistence, null);
    }

    protected void setPersistence_(Persistence newPersistence) {
        Persistence oldPersistence = this.persistence;
        this.persistence = newPersistence;
        this.firePropertyChanged("persistence", oldPersistence, newPersistence);
    }

    protected void initialize(PersistenceResource pr) {
        this.persistenceResource = pr;
        if (pr.getPersistence() != null) {
            this.persistence = this.buildPersistence(pr.getPersistence());
        }
    }

    @Override
    public void update(PersistenceResource pr) {
        this.persistenceResource = pr;
        if (pr.getPersistence() != null) {
            if (this.persistence != null) {
                this.getJpaFile(this.persistenceResource.getResourceModel()).addRootStructureNode((Object)this.persistenceResource, this.persistence);
                this.persistence.update(pr.getPersistence());
            } else {
                this.setPersistence_(this.buildPersistence(pr.getPersistence()));
            }
        } else {
            if (this.persistence != null) {
                this.getJpaFile(this.persistenceResource.getResourceModel()).removeRootStructureNode((Object)this.persistenceResource);
                this.persistence.dispose();
            }
            this.setPersistence_(null);
        }
    }

    protected Persistence buildPersistence(XmlPersistence xmlPersistence) {
        return this.getJpaFactory().buildPersistence(this, xmlPersistence);
    }

    @Override
    public PersistenceUnit getPersistenceUnit() {
        throw new UnsupportedOperationException("No Persistence Unit in this context");
    }

    @Override
    public JpaStructureNode getStructureNode(int textOffset) {
        if (this.persistence.containsOffset(textOffset)) {
            return this.persistence.getStructureNode(textOffset);
        }
        return this;
    }

    @Override
    public TextRange getSelectionTextRange() {
        return TextRange.Empty.instance();
    }

    @Override
    public TextRange getValidationTextRange() {
        return TextRange.Empty.instance();
    }

    @Override
    public void validate(List<IMessage> messages) {
        super.validate(messages);
        if (this.persistence == null) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "PERSISTENCE_XML_INVALID_CONTENT", this));
            return;
        }
        this.persistence.validate(messages);
    }

    @Override
    public void dispose() {
        this.persistence.dispose();
    }
}

