/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.facet;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jpt.core.JptCorePlugin;
import org.eclipse.jpt.core.internal.JptCoreMessages;
import org.eclipse.jpt.core.internal.facet.JpaFacetDataModelProperties;
import org.eclipse.jpt.core.internal.platform.JpaPlatformRegistry;
import org.eclipse.jpt.db.ConnectionProfile;
import org.eclipse.jpt.db.ConnectionProfileFactory;
import org.eclipse.jpt.db.Database;
import org.eclipse.jpt.db.JptDbPlugin;
import org.eclipse.jpt.db.Schema;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.iterators.CompositeIterator;
import org.eclipse.jpt.utility.internal.iterators.EmptyIterator;
import org.eclipse.jpt.utility.internal.iterators.TransformationIterator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.componentcore.datamodel.FacetInstallDataModelProvider;
import org.eclipse.wst.common.frameworks.datamodel.DataModelPropertyDescriptor;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpaFacetDataModelProvider
extends FacetInstallDataModelProvider
implements JpaFacetDataModelProperties {
    private static final String EJB_FACET_ID = "jst.ejb";
    private static final String RUNTIME_NONE = WTPCommonPlugin.getResourceString((String)"44", null);
    private static final IStatus PLATFORM_NOT_SPECIFIED_STATUS = JpaFacetDataModelProvider.buildErrorStatus(JptCoreMessages.VALIDATE_PLATFORM_NOT_SPECIFIED);
    private static final IStatus CONNECTION_NOT_CONNECTED_STATUS = JpaFacetDataModelProvider.buildInfoStatus(JptCoreMessages.VALIDATE_CONNECTION_NOT_CONNECTED);
    private static final IStatus USER_OVERRIDE_DEFAULT_SCHEMA_NOT_SPECIFIED_STATUS = JpaFacetDataModelProvider.buildErrorStatus(JptCoreMessages.VALIDATE_DEFAULT_SCHEMA_NOT_SPECIFIED);
    private static final IStatus RUNTIME_NOT_SPECIFIED_STATUS = JpaFacetDataModelProvider.buildWarningStatus(JptCoreMessages.VALIDATE_RUNTIME_NOT_SPECIFIED);
    private static final IStatus RUNTIME_DOES_NOT_SUPPORT_EJB_30_STATUS = JpaFacetDataModelProvider.buildWarningStatus(JptCoreMessages.VALIDATE_RUNTIME_DOES_NOT_SUPPORT_EJB_30);
    private static final IStatus LIBRARY_NOT_SPECIFIED_STATUS = JpaFacetDataModelProvider.buildWarningStatus(JptCoreMessages.VALIDATE_LIBRARY_NOT_SPECIFIED);
    private static final DataModelPropertyDescriptor[] EMPTY_DMPD_ARRAY = new DataModelPropertyDescriptor[0];

    public Set<String> getPropertyNames() {
        Set propertyNames = super.getPropertyNames();
        propertyNames.add("JpaFacetDataModelProperties.PLATFORM_ID");
        propertyNames.add("JpaFacetDataModelProperties.CONNECTION");
        propertyNames.add("JpaFacetDataModelProperties.CONNECTION_ACTIVE");
        propertyNames.add("JpaFacetDataModelProperties.USER_WANTS_TO_ADD_DB_DRIVER_JARS_TO_CLASSPATH");
        propertyNames.add("JpaFacetDataModelProperties.DB_DRIVER_NAME");
        propertyNames.add("JpaFacetDataModelProperties.DB_DRIVER_JARS");
        propertyNames.add("JpaFacetDataModelProperties.USER_WANTS_TO_OVERRIDE_DEFAULT_SCHEMA");
        propertyNames.add("JpaFacetDataModelProperties.USER_OVERRIDE_DEFAULT_SCHEMA");
        propertyNames.add("JpaFacetDataModelProperties.RUNTIME");
        propertyNames.add("JpaFacetDataModelProperties.USE_SERVER_JPA_IMPLEMENTATION");
        propertyNames.add("JpaFacetDataModelProperties.USE_USER_JPA_LIBRARY");
        propertyNames.add("JpaFacetDataModelProperties.JPA_LIBRARY");
        propertyNames.add("JpaFacetDataModelProperties.DISCOVER_ANNOTATED_CLASSES");
        propertyNames.add("JpaFacetDataModelProperties.LIST_ANNOTATED_CLASSES");
        propertyNames.add("JpaFacetDataModelProperties.CREATE_ORM_XML");
        return propertyNames;
    }

    public boolean isPropertyEnabled(String propertyName) {
        if (propertyName.equals("JpaFacetDataModelProperties.USER_OVERRIDE_DEFAULT_SCHEMA")) {
            return this.getBooleanProperty("JpaFacetDataModelProperties.USER_WANTS_TO_OVERRIDE_DEFAULT_SCHEMA");
        }
        if (propertyName.equals("JpaFacetDataModelProperties.USER_WANTS_TO_ADD_DB_DRIVER_JARS_TO_CLASSPATH")) {
            return this.getConnectionProfile() != null;
        }
        if (propertyName.equals("JpaFacetDataModelProperties.DB_DRIVER_NAME")) {
            return this.getBooleanProperty("JpaFacetDataModelProperties.USER_WANTS_TO_ADD_DB_DRIVER_JARS_TO_CLASSPATH");
        }
        if (propertyName.equals("JpaFacetDataModelProperties.JPA_LIBRARY")) {
            return this.getBooleanProperty("JpaFacetDataModelProperties.USE_USER_JPA_LIBRARY");
        }
        return super.isPropertyEnabled(propertyName);
    }

    public Object getDefaultProperty(String propertyName) {
        if (propertyName.equals("IFacetDataModelProperties.FACET_ID")) {
            return "jpt.jpa";
        }
        if (propertyName.equals("JpaFacetDataModelProperties.PLATFORM_ID")) {
            return JptCorePlugin.getDefaultJpaPlatformId();
        }
        if (propertyName.equals("JpaFacetDataModelProperties.CONNECTION")) {
            return null;
        }
        if (propertyName.equals("JpaFacetDataModelProperties.CONNECTION_ACTIVE")) {
            return this.connectionIsActive();
        }
        if (propertyName.equals("JpaFacetDataModelProperties.USER_WANTS_TO_ADD_DB_DRIVER_JARS_TO_CLASSPATH")) {
            return Boolean.FALSE;
        }
        if (propertyName.equals("JpaFacetDataModelProperties.DB_DRIVER_NAME")) {
            return this.getDefaultDriverName();
        }
        if (propertyName.equals("JpaFacetDataModelProperties.DB_DRIVER_JARS")) {
            return this.getDefaultDriverJars();
        }
        if (propertyName.equals("JpaFacetDataModelProperties.USER_WANTS_TO_OVERRIDE_DEFAULT_SCHEMA")) {
            return Boolean.FALSE;
        }
        if (propertyName.equals("JpaFacetDataModelProperties.USER_OVERRIDE_DEFAULT_SCHEMA")) {
            return this.getDefaultSchemaName();
        }
        if (propertyName.equals("JpaFacetDataModelProperties.RUNTIME")) {
            return null;
        }
        if (propertyName.equals("JpaFacetDataModelProperties.USE_SERVER_JPA_IMPLEMENTATION")) {
            return this.runtimeSupportsEjb30(this.runtime());
        }
        if (propertyName.equals("JpaFacetDataModelProperties.USE_USER_JPA_LIBRARY")) {
            return !this.getBooleanProperty("JpaFacetDataModelProperties.USE_SERVER_JPA_IMPLEMENTATION");
        }
        if (propertyName.equals("JpaFacetDataModelProperties.JPA_LIBRARY")) {
            return JptCorePlugin.getDefaultJpaLibrary();
        }
        if (propertyName.equals("JpaFacetDataModelProperties.DISCOVER_ANNOTATED_CLASSES")) {
            return this.runtimeSupportsEjb30(this.runtime());
        }
        if (propertyName.equals("JpaFacetDataModelProperties.LIST_ANNOTATED_CLASSES")) {
            return !this.getBooleanProperty("JpaFacetDataModelProperties.DISCOVER_ANNOTATED_CLASSES");
        }
        if (propertyName.equals("JpaFacetDataModelProperties.CREATE_ORM_XML")) {
            return Boolean.TRUE;
        }
        return super.getDefaultProperty(propertyName);
    }

    public boolean propertySet(String propertyName, Object propertyValue) {
        boolean ok = super.propertySet(propertyName, propertyValue);
        if (propertyName.equals("JpaFacetDataModelProperties.RUNTIME")) {
            this.model.notifyPropertyChange("JpaFacetDataModelProperties.USE_SERVER_JPA_IMPLEMENTATION", 2);
            this.model.notifyPropertyChange("JpaFacetDataModelProperties.USE_USER_JPA_LIBRARY", 2);
            this.model.notifyPropertyChange("JpaFacetDataModelProperties.JPA_LIBRARY", 3);
            this.model.notifyPropertyChange("JpaFacetDataModelProperties.DISCOVER_ANNOTATED_CLASSES", 2);
            this.model.notifyPropertyChange("JpaFacetDataModelProperties.LIST_ANNOTATED_CLASSES", 2);
        }
        if (propertyName.equals("JpaFacetDataModelProperties.CONNECTION")) {
            this.model.notifyPropertyChange("JpaFacetDataModelProperties.CONNECTION", 4);
            this.model.setBooleanProperty("JpaFacetDataModelProperties.CONNECTION_ACTIVE", this.connectionIsActive());
            this.model.notifyPropertyChange("JpaFacetDataModelProperties.DB_DRIVER_NAME", 2);
            this.model.notifyPropertyChange("JpaFacetDataModelProperties.DB_DRIVER_NAME", 4);
            this.model.notifyPropertyChange("JpaFacetDataModelProperties.DB_DRIVER_JARS", 2);
            this.model.notifyPropertyChange("JpaFacetDataModelProperties.DB_DRIVER_JARS", 4);
            this.model.notifyPropertyChange("JpaFacetDataModelProperties.USER_OVERRIDE_DEFAULT_SCHEMA", 2);
            this.model.notifyPropertyChange("JpaFacetDataModelProperties.USER_OVERRIDE_DEFAULT_SCHEMA", 4);
        }
        if (propertyName.equals("JpaFacetDataModelProperties.CONNECTION_ACTIVE")) {
            this.model.notifyPropertyChange("JpaFacetDataModelProperties.USER_OVERRIDE_DEFAULT_SCHEMA", 2);
            this.model.notifyPropertyChange("JpaFacetDataModelProperties.USER_OVERRIDE_DEFAULT_SCHEMA", 4);
        }
        if (propertyName.equals("JpaFacetDataModelProperties.USER_WANTS_TO_ADD_DB_DRIVER_JARS_TO_CLASSPATH")) {
            this.model.notifyPropertyChange("JpaFacetDataModelProperties.DB_DRIVER_NAME", 3);
            this.model.notifyPropertyChange("JpaFacetDataModelProperties.DB_DRIVER_JARS", 3);
            if (!((Boolean)propertyValue).booleanValue()) {
                this.model.setProperty("JpaFacetDataModelProperties.DB_DRIVER_NAME", null);
                this.model.setProperty("JpaFacetDataModelProperties.DB_DRIVER_JARS", null);
            }
        }
        if (propertyName.equals("JpaFacetDataModelProperties.USER_WANTS_TO_OVERRIDE_DEFAULT_SCHEMA")) {
            this.model.notifyPropertyChange("JpaFacetDataModelProperties.USER_OVERRIDE_DEFAULT_SCHEMA", 3);
            if (!((Boolean)propertyValue).booleanValue()) {
                this.model.setProperty("JpaFacetDataModelProperties.USER_OVERRIDE_DEFAULT_SCHEMA", null);
            }
        }
        if (propertyName.equals("JpaFacetDataModelProperties.USE_SERVER_JPA_IMPLEMENTATION")) {
            this.model.setBooleanProperty("JpaFacetDataModelProperties.USE_USER_JPA_LIBRARY", (Boolean)propertyValue == false);
        }
        if (propertyName.equals("JpaFacetDataModelProperties.USE_USER_JPA_LIBRARY")) {
            this.model.setBooleanProperty("JpaFacetDataModelProperties.USE_SERVER_JPA_IMPLEMENTATION", (Boolean)propertyValue == false);
            this.model.notifyPropertyChange("JpaFacetDataModelProperties.JPA_LIBRARY", 3);
        }
        if (propertyName.equals("JpaFacetDataModelProperties.DISCOVER_ANNOTATED_CLASSES")) {
            this.model.setBooleanProperty("JpaFacetDataModelProperties.LIST_ANNOTATED_CLASSES", (Boolean)propertyValue == false);
        }
        if (propertyName.equals("JpaFacetDataModelProperties.LIST_ANNOTATED_CLASSES")) {
            this.model.setBooleanProperty("JpaFacetDataModelProperties.DISCOVER_ANNOTATED_CLASSES", (Boolean)propertyValue == false);
        }
        return ok;
    }

    public DataModelPropertyDescriptor[] getValidPropertyDescriptors(String propertyName) {
        if (propertyName.equals("JpaFacetDataModelProperties.PLATFORM_ID")) {
            return (DataModelPropertyDescriptor[])CollectionTools.array((Iterator)new TransformationIterator<String, DataModelPropertyDescriptor>(JpaPlatformRegistry.instance().jpaPlatformIds()){

                protected DataModelPropertyDescriptor transform(String platformId) {
                    return JpaFacetDataModelProvider.this.platformIdPropertyDescriptor(platformId);
                }
            }, (Object[])EMPTY_DMPD_ARRAY);
        }
        if (propertyName.equals("JpaFacetDataModelProperties.CONNECTION")) {
            return (DataModelPropertyDescriptor[])CollectionTools.array((Iterator)new TransformationIterator<String, DataModelPropertyDescriptor>((Iterator)new CompositeIterator(null, this.connectionNames())){

                protected DataModelPropertyDescriptor transform(String next) {
                    return JpaFacetDataModelProvider.this.connectionPropertyDescriptor(next);
                }
            }, (Object[])EMPTY_DMPD_ARRAY);
        }
        if (propertyName.equals("JpaFacetDataModelProperties.DB_DRIVER_NAME")) {
            return (DataModelPropertyDescriptor[])CollectionTools.array((Iterator)new TransformationIterator<String, DataModelPropertyDescriptor>(this.driverNames()){

                protected DataModelPropertyDescriptor transform(String next) {
                    return new DataModelPropertyDescriptor((Object)next);
                }
            }, (Object[])EMPTY_DMPD_ARRAY);
        }
        if (propertyName.equals("JpaFacetDataModelProperties.USER_OVERRIDE_DEFAULT_SCHEMA")) {
            return (DataModelPropertyDescriptor[])CollectionTools.array((Iterator)new TransformationIterator<String, DataModelPropertyDescriptor>(this.schemaNames()){

                protected DataModelPropertyDescriptor transform(String next) {
                    return new DataModelPropertyDescriptor((Object)next);
                }
            }, (Object[])EMPTY_DMPD_ARRAY);
        }
        if (propertyName.equals("JpaFacetDataModelProperties.JPA_LIBRARY")) {
            String[] libraries = (String[])CollectionTools.sort((Object[])JavaCore.getUserLibraryNames());
            DataModelPropertyDescriptor[] descriptors = new DataModelPropertyDescriptor[libraries.length + 1];
            descriptors[0] = new DataModelPropertyDescriptor((Object)"", RUNTIME_NONE);
            int i = 1;
            String[] stringArray = libraries;
            int n = libraries.length;
            int n2 = 0;
            while (n2 < n) {
                String library = stringArray[n2];
                descriptors[i++] = new DataModelPropertyDescriptor((Object)library, library);
                ++n2;
            }
            return descriptors;
        }
        return super.getValidPropertyDescriptors(propertyName);
    }

    public DataModelPropertyDescriptor getPropertyDescriptor(String propertyName) {
        if (propertyName.equals("JpaFacetDataModelProperties.PLATFORM_ID")) {
            return this.platformIdPropertyDescriptor(this.getStringProperty("JpaFacetDataModelProperties.PLATFORM_ID"));
        }
        if (propertyName.equals("JpaFacetDataModelProperties.CONNECTION")) {
            return this.connectionPropertyDescriptor(this.getStringProperty("JpaFacetDataModelProperties.CONNECTION"));
        }
        return super.getPropertyDescriptor(propertyName);
    }

    DataModelPropertyDescriptor platformIdPropertyDescriptor(String platformId) {
        return new DataModelPropertyDescriptor((Object)platformId, JpaPlatformRegistry.instance().getJpaPlatformLabel(platformId));
    }

    DataModelPropertyDescriptor connectionPropertyDescriptor(String connection) {
        return StringTools.stringIsEmpty((String)connection) ? new DataModelPropertyDescriptor(null, JptCoreMessages.NONE) : new DataModelPropertyDescriptor((Object)connection);
    }

    public IStatus validate(String name) {
        if (name.equals("JpaFacetDataModelProperties.PLATFORM_ID")) {
            return this.validatePlatformId(this.getStringProperty(name));
        }
        if (name.equals("JpaFacetDataModelProperties.CONNECTION")) {
            return this.validateConnectionName(this.getStringProperty(name));
        }
        if (name.equals("JpaFacetDataModelProperties.USER_WANTS_TO_ADD_DB_DRIVER_JARS_TO_CLASSPATH") || name.equals("JpaFacetDataModelProperties.DB_DRIVER_NAME")) {
            return this.validateDbDriverName();
        }
        if (name.equals("JpaFacetDataModelProperties.USER_WANTS_TO_OVERRIDE_DEFAULT_SCHEMA") || name.equals("JpaFacetDataModelProperties.USER_OVERRIDE_DEFAULT_SCHEMA")) {
            return this.validateUserOverrideDefaultSchema();
        }
        if (name.equals("JpaFacetDataModelProperties.USE_SERVER_JPA_IMPLEMENTATION")) {
            return this.validateJpaLibrary(this.getBooleanProperty(name));
        }
        if (name.equals("JpaFacetDataModelProperties.DISCOVER_ANNOTATED_CLASSES")) {
            return this.validatePersistentClassManagement(this.getBooleanProperty(name));
        }
        return super.validate(name);
    }

    private IRuntime runtime() {
        return (IRuntime)this.getProperty("JpaFacetDataModelProperties.RUNTIME");
    }

    private boolean runtimeSupportsEjb30(IRuntime runtime) {
        IProjectFacetVersion ejb30 = ProjectFacetsManager.getProjectFacet((String)EJB_FACET_ID).getVersion("3.0");
        return runtime == null ? false : runtime.supports(ejb30);
    }

    private String getConnectionName() {
        return this.getStringProperty("JpaFacetDataModelProperties.CONNECTION");
    }

    private ConnectionProfile getConnectionProfile() {
        return this.buildConnectionProfile(this.getConnectionName());
    }

    private ConnectionProfileFactory getConnectionProfileFactory() {
        return JptDbPlugin.instance().getConnectionProfileFactory();
    }

    private ConnectionProfile buildConnectionProfile(String name) {
        return this.getConnectionProfileFactory().buildConnectionProfile(name);
    }

    private boolean connectionIsActive() {
        return this.connectionIsActive(this.getConnectionName());
    }

    private boolean connectionIsActive(String connectionName) {
        ConnectionProfile cp = this.buildConnectionProfile(connectionName);
        return cp != null && cp.isActive();
    }

    private String getDefaultDriverName() {
        ConnectionProfile cp = this.getConnectionProfile();
        if (cp == null) {
            return null;
        }
        return cp.getDriverName();
    }

    private String getDefaultDriverJars() {
        ConnectionProfile cp = this.getConnectionProfile();
        if (cp == null) {
            return null;
        }
        return cp.getDriverJarList();
    }

    private Iterator<String> connectionNames() {
        String setValue = this.getStringProperty("JpaFacetDataModelProperties.CONNECTION");
        List connectionNames = CollectionTools.sort((List)CollectionTools.list((Iterator)this.getConnectionProfileFactory().connectionProfileNames()));
        if (!StringTools.stringIsEmpty((String)setValue) && !connectionNames.contains(setValue)) {
            return new CompositeIterator((Object)setValue, connectionNames.iterator());
        }
        return connectionNames.iterator();
    }

    private String getDefaultSchemaName() {
        ConnectionProfile cp = this.getConnectionProfile();
        if (cp == null) {
            return null;
        }
        Database db = cp.getDatabase();
        if (db == null) {
            return null;
        }
        Schema schema = db.getDefaultSchema();
        return schema == null ? null : schema.getIdentifier();
    }

    private List<String> buildSortedSchemaNames() {
        ConnectionProfile cp = this.getConnectionProfile();
        if (cp == null) {
            return Collections.emptyList();
        }
        Database db = cp.getDatabase();
        if (db == null) {
            return Collections.emptyList();
        }
        return CollectionTools.list((Iterator)db.sortedSchemaIdentifiers());
    }

    private Iterator<String> schemaNames() {
        String setValue = this.getStringProperty("JpaFacetDataModelProperties.USER_OVERRIDE_DEFAULT_SCHEMA");
        List<String> schemaNames = this.buildSortedSchemaNames();
        if (StringTools.stringIsEmpty((String)setValue) || schemaNames.contains(setValue)) {
            return schemaNames.iterator();
        }
        return new CompositeIterator((Object)setValue, schemaNames.iterator());
    }

    private Iterator<String> driverNames() {
        String setValue = this.getStringProperty("JpaFacetDataModelProperties.DB_DRIVER_NAME");
        return new CompositeIterator((Object)setValue, EmptyIterator.instance());
    }

    private IStatus validatePlatformId(String platformId) {
        return StringTools.stringIsEmpty((String)platformId) ? PLATFORM_NOT_SPECIFIED_STATUS : OK_STATUS;
    }

    private IStatus validateConnectionName(String connectionName) {
        if (StringTools.stringIsEmpty((String)connectionName)) {
            return OK_STATUS;
        }
        ConnectionProfile connectionProfile = this.getConnectionProfile();
        if (connectionProfile == null) {
            return JpaFacetDataModelProvider.buildErrorStatus(NLS.bind((String)JptCoreMessages.VALIDATE_CONNECTION_INVALID, (Object)connectionName));
        }
        if (!connectionProfile.isActive()) {
            return CONNECTION_NOT_CONNECTED_STATUS;
        }
        return OK_STATUS;
    }

    private IStatus validateUserOverrideDefaultSchema() {
        if (this.getBooleanProperty("JpaFacetDataModelProperties.USER_WANTS_TO_OVERRIDE_DEFAULT_SCHEMA") && StringTools.stringIsEmpty((String)this.getStringProperty("JpaFacetDataModelProperties.USER_OVERRIDE_DEFAULT_SCHEMA"))) {
            return USER_OVERRIDE_DEFAULT_SCHEMA_NOT_SPECIFIED_STATUS;
        }
        return OK_STATUS;
    }

    private IStatus validateJpaLibrary(boolean useServerJpaImplementation) {
        if (useServerJpaImplementation) {
            IRuntime runtime = this.runtime();
            if (runtime == null) {
                return RUNTIME_NOT_SPECIFIED_STATUS;
            }
            if (!this.runtimeSupportsEjb30(runtime)) {
                return RUNTIME_DOES_NOT_SUPPORT_EJB_30_STATUS;
            }
        } else if (StringTools.stringIsEmpty((String)this.getStringProperty("JpaFacetDataModelProperties.JPA_LIBRARY"))) {
            return LIBRARY_NOT_SPECIFIED_STATUS;
        }
        return OK_STATUS;
    }

    private IStatus validatePersistentClassManagement(boolean discoverAnnotatedClasses) {
        return OK_STATUS;
    }

    private IStatus validateDbDriverName() {
        return OK_STATUS;
    }

    private static IStatus buildInfoStatus(String message) {
        return JpaFacetDataModelProvider.buildStatus(1, message);
    }

    private static IStatus buildWarningStatus(String message) {
        return JpaFacetDataModelProvider.buildStatus(2, message);
    }

    private static IStatus buildErrorStatus(String message) {
        return JpaFacetDataModelProvider.buildStatus(4, message);
    }

    private static IStatus buildStatus(int severity, String message) {
        return new Status(severity, "org.eclipse.jpt.core", message);
    }
}

