/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.operations;

import java.util.Iterator;
import java.util.ListIterator;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.core.JptCorePlugin;
import org.eclipse.jpt.core.context.persistence.Persistence;
import org.eclipse.jpt.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.core.context.persistence.PersistenceXml;
import org.eclipse.jpt.core.internal.JptCoreMessages;
import org.eclipse.jpt.core.internal.operations.OrmFileCreationDataModelProperties;
import org.eclipse.jpt.core.internal.operations.OrmFileCreationOperation;
import org.eclipse.jpt.core.resource.orm.AccessType;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.iterators.CompositeIterator;
import org.eclipse.jpt.utility.internal.iterators.EmptyIterator;
import org.eclipse.jpt.utility.internal.iterators.FilteringIterator;
import org.eclipse.jpt.utility.internal.iterators.TransformationIterator;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelProvider;
import org.eclipse.wst.common.frameworks.datamodel.DataModelPropertyDescriptor;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;
import org.eclipse.wst.common.project.facet.core.FacetedProjectFramework;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrmFileCreationDataModelProvider
extends AbstractDataModelProvider
implements OrmFileCreationDataModelProperties {
    public IDataModelOperation getDefaultOperation() {
        return new OrmFileCreationOperation(this.getDataModel());
    }

    public Set<String> getPropertyNames() {
        Set propertyNames = super.getPropertyNames();
        propertyNames.add("OrmFileCreationDataModelProperties.PROJECT_NAME");
        propertyNames.add("OrmFileCreationDataModelProperties.SOURCE_FOLDER");
        propertyNames.add("OrmFileCreationDataModelProperties.FILE_PATH");
        propertyNames.add("OrmFileCreationDataModelProperties.DEFAULT_ACCESS");
        propertyNames.add("OrmFileCreationDataModelProperties.ADD_TO_PERSISTENCE_UNIT");
        propertyNames.add("OrmFileCreationDataModelProperties.PERSISTENCE_UNIT");
        return propertyNames;
    }

    public boolean isPropertyEnabled(String propertyName) {
        if (propertyName.equals("OrmFileCreationDataModelProperties.PERSISTENCE_UNIT")) {
            return this.getBooleanProperty("OrmFileCreationDataModelProperties.ADD_TO_PERSISTENCE_UNIT");
        }
        return super.isPropertyEnabled(propertyName);
    }

    public Object getDefaultProperty(String propertyName) {
        if (propertyName.equals("OrmFileCreationDataModelProperties.SOURCE_FOLDER")) {
            IFolder sourceFolder = this.getDefaultSourceFolder();
            if (sourceFolder != null && sourceFolder.exists()) {
                return sourceFolder.getFullPath().toPortableString();
            }
        } else {
            PersistenceUnit pUnit;
            if (propertyName.equals("OrmFileCreationDataModelProperties.FILE_PATH")) {
                return new Path("META-INF/orm.xml").toPortableString();
            }
            if (propertyName.equals("OrmFileCreationDataModelProperties.DEFAULT_ACCESS")) {
                return null;
            }
            if (propertyName.equals("OrmFileCreationDataModelProperties.ADD_TO_PERSISTENCE_UNIT")) {
                return Boolean.FALSE;
            }
            if (propertyName.equals("OrmFileCreationDataModelProperties.PERSISTENCE_UNIT") && (pUnit = this.getDefaultPersistenceUnit()) != null) {
                return pUnit.getName();
            }
        }
        return super.getDefaultProperty(propertyName);
    }

    public boolean propertySet(String propertyName, Object propertyValue) {
        boolean ok = super.propertySet(propertyName, propertyValue);
        if (propertyName.equals("OrmFileCreationDataModelProperties.PROJECT_NAME")) {
            this.model.notifyPropertyChange("OrmFileCreationDataModelProperties.SOURCE_FOLDER", 2);
            this.model.notifyPropertyChange("OrmFileCreationDataModelProperties.PERSISTENCE_UNIT", 2);
            this.model.notifyPropertyChange("OrmFileCreationDataModelProperties.PERSISTENCE_UNIT", 4);
        } else if (propertyName.equals("OrmFileCreationDataModelProperties.ADD_TO_PERSISTENCE_UNIT")) {
            this.model.notifyPropertyChange("OrmFileCreationDataModelProperties.PERSISTENCE_UNIT", 3);
        }
        return ok;
    }

    public DataModelPropertyDescriptor[] getValidPropertyDescriptors(String propertyName) {
        if (propertyName.equals("OrmFileCreationDataModelProperties.PROJECT_NAME")) {
            return (DataModelPropertyDescriptor[])CollectionTools.array((Iterator)new TransformationIterator<IProject, DataModelPropertyDescriptor>(this.jpaIProjects()){

                protected DataModelPropertyDescriptor transform(IProject next) {
                    return new DataModelPropertyDescriptor((Object)next.getName());
                }
            }, (Object[])new DataModelPropertyDescriptor[0]);
        }
        if (propertyName.equals("OrmFileCreationDataModelProperties.DEFAULT_ACCESS")) {
            DataModelPropertyDescriptor[] accessTypes = new DataModelPropertyDescriptor[]{this.accessPropertyDescriptor(null), this.accessPropertyDescriptor(AccessType.FIELD), this.accessPropertyDescriptor(AccessType.PROPERTY)};
            return accessTypes;
        }
        if (propertyName.equals("OrmFileCreationDataModelProperties.PERSISTENCE_UNIT")) {
            return (DataModelPropertyDescriptor[])CollectionTools.array((Iterator)new TransformationIterator<String, DataModelPropertyDescriptor>((Iterator)new CompositeIterator(null, this.persistenceUnitNames())){

                protected DataModelPropertyDescriptor transform(String next) {
                    return OrmFileCreationDataModelProvider.this.persistenceUnitPropertyDescriptor(next);
                }
            }, (Object[])new DataModelPropertyDescriptor[0]);
        }
        return super.getValidPropertyDescriptors(propertyName);
    }

    public DataModelPropertyDescriptor getPropertyDescriptor(String propertyName) {
        if (propertyName.equals("OrmFileCreationDataModelProperties.PROJECT_NAME")) {
            return new DataModelPropertyDescriptor((Object)this.getStringProperty("OrmFileCreationDataModelProperties.PROJECT_NAME"));
        }
        if (propertyName.equals("OrmFileCreationDataModelProperties.DEFAULT_ACCESS")) {
            return this.accessPropertyDescriptor((AccessType)((Object)this.getProperty("OrmFileCreationDataModelProperties.DEFAULT_ACCESS")));
        }
        if (propertyName.equals("OrmFileCreationDataModelProperties.PERSISTENCE_UNIT")) {
            return this.persistenceUnitPropertyDescriptor(this.getStringProperty("OrmFileCreationDataModelProperties.PERSISTENCE_UNIT"));
        }
        return super.getPropertyDescriptor(propertyName);
    }

    private DataModelPropertyDescriptor accessPropertyDescriptor(AccessType accessType) {
        if (accessType == null) {
            return new DataModelPropertyDescriptor(null, JptCoreMessages.NONE);
        }
        return new DataModelPropertyDescriptor((Object)accessType, accessType.getName());
    }

    DataModelPropertyDescriptor persistenceUnitPropertyDescriptor(String persistenceUnitName) {
        if (StringTools.stringIsEmpty((String)persistenceUnitName)) {
            return new DataModelPropertyDescriptor(null, JptCoreMessages.NONE);
        }
        return new DataModelPropertyDescriptor((Object)persistenceUnitName);
    }

    public IStatus validate(String propertyName) {
        if (propertyName.equals("OrmFileCreationDataModelProperties.PROJECT_NAME") || propertyName.equals("OrmFileCreationDataModelProperties.SOURCE_FOLDER") || propertyName.equals("OrmFileCreationDataModelProperties.FILE_PATH")) {
            return this.validateProjectSourceFolderAndFilePath();
        }
        if (propertyName.equals("OrmFileCreationDataModelProperties.ADD_TO_PERSISTENCE_UNIT") || propertyName.equals("OrmFileCreationDataModelProperties.PERSISTENCE_UNIT")) {
            return this.validatePersistenceUnit();
        }
        return super.validate(propertyName);
    }

    private IStatus validateProjectSourceFolderAndFilePath() {
        String projectName = (String)this.getProperty("OrmFileCreationDataModelProperties.PROJECT_NAME");
        if (StringTools.stringIsEmpty((String)projectName)) {
            return new Status(4, "org.eclipse.jpt.core", JptCoreMessages.VALIDATE_PROJECT_NOT_SPECIFIED);
        }
        String sourceFolderPath = this.getStringProperty("OrmFileCreationDataModelProperties.SOURCE_FOLDER");
        if (StringTools.stringIsEmpty((String)sourceFolderPath)) {
            return new Status(4, "org.eclipse.jpt.core", JptCoreMessages.VALIDATE_SOURCE_FOLDER_NOT_SPECIFIED);
        }
        if (this.sourceFolderIsIllegal(sourceFolderPath)) {
            return new Status(4, "org.eclipse.jpt.core", JptCoreMessages.VALIDATE_SOURCE_FOLDER_ILLEGAL);
        }
        if (this.sourceFolderNotInProject(sourceFolderPath)) {
            return new Status(4, "org.eclipse.jpt.core", NLS.bind((String)JptCoreMessages.VALIDATE_SOURCE_FOLDER_NOT_IN_PROJECT, (Object)sourceFolderPath, (Object)projectName));
        }
        if (this.getVerifiedSourceFolder() == null) {
            return new Status(4, "org.eclipse.jpt.core", NLS.bind((String)JptCoreMessages.VALIDATE_SOURCE_FOLDER_DOES_NOT_EXIST, (Object)sourceFolderPath));
        }
        if (this.getVerifiedJavaSourceFolder() == null) {
            return new Status(4, "org.eclipse.jpt.core", NLS.bind((String)JptCoreMessages.VALIDATE_SOURCE_FOLDER_NOT_SOURCE_FOLDER, (Object)sourceFolderPath));
        }
        if (this.getExistingOrmFile() != null) {
            return new Status(4, "org.eclipse.jpt.core", JptCoreMessages.VALIDATE_ORM_FILE_ALREADY_EXISTS);
        }
        return Status.OK_STATUS;
    }

    private IStatus validatePersistenceUnit() {
        boolean addToPUnit = this.getBooleanProperty("OrmFileCreationDataModelProperties.ADD_TO_PERSISTENCE_UNIT");
        String projectName = this.getStringProperty("OrmFileCreationDataModelProperties.PROJECT_NAME");
        String pUnitName = this.getStringProperty("OrmFileCreationDataModelProperties.PERSISTENCE_UNIT");
        if (addToPUnit) {
            if (StringTools.stringIsEmpty((String)pUnitName)) {
                return new Status(4, "org.eclipse.jpt.core", NLS.bind((String)JptCoreMessages.VALIDATE_PERSISTENCE_UNIT_DOES_NOT_SPECIFIED, (Object)pUnitName));
            }
            if (this.getPersistenceUnit() == null) {
                return new Status(4, "org.eclipse.jpt.core", NLS.bind((String)JptCoreMessages.VALIDATE_PERSISTENCE_UNIT_NOT_IN_PROJECT, (Object)pUnitName, (Object)projectName));
            }
        }
        return Status.OK_STATUS;
    }

    private IProject getProject() {
        String projectName = (String)this.model.getProperty("OrmFileCreationDataModelProperties.PROJECT_NAME");
        if (StringTools.stringIsEmpty((String)projectName)) {
            return null;
        }
        return ProjectUtilities.getProject((String)projectName);
    }

    private JpaProject getJpaProject() {
        IProject project = this.getProject();
        if (project == null) {
            return null;
        }
        return JptCorePlugin.getJpaProject(project);
    }

    private IFolder getDefaultSourceFolder() {
        IProject project = this.getProject();
        if (project == null) {
            return null;
        }
        IPackageFragmentRoot[] sources = J2EEProjectUtilities.getSourceContainers((IProject)project);
        if (sources.length > 0) {
            try {
                return (IFolder)sources[0].getCorrespondingResource();
            }
            catch (Exception exception) {
                return null;
            }
        }
        return null;
    }

    private boolean sourceFolderIsIllegal(String folderPath) {
        IProject project = this.getProject();
        if (project == null) {
            return false;
        }
        try {
            project.getWorkspace().getRoot().getFolder((IPath)new Path(folderPath));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return true;
        }
        return false;
    }

    private boolean sourceFolderNotInProject(String folderPath) {
        IFolder folder;
        IProject project = this.getProject();
        if (project == null) {
            return false;
        }
        try {
            folder = project.getWorkspace().getRoot().getFolder((IPath)new Path(folderPath));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        return !project.equals((Object)folder.getProject());
    }

    private IFolder getVerifiedSourceFolder() {
        IFolder folder;
        String folderPath = this.getStringProperty("OrmFileCreationDataModelProperties.SOURCE_FOLDER");
        IProject project = this.getProject();
        if (project == null) {
            return null;
        }
        try {
            folder = project.getWorkspace().getRoot().getFolder((IPath)new Path(folderPath));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
        if (folder == null || !folder.exists()) {
            return null;
        }
        return folder;
    }

    private IFolder getVerifiedJavaSourceFolder() {
        IFolder folder = this.getVerifiedSourceFolder();
        if (folder == null) {
            return null;
        }
        IJavaProject jProject = JavaCore.create((IProject)this.getProject());
        if (jProject == null) {
            return null;
        }
        IPackageFragmentRoot packageFragmentRoot = jProject.getPackageFragmentRoot((IResource)folder);
        if (packageFragmentRoot == null || !packageFragmentRoot.exists()) {
            return null;
        }
        return folder;
    }

    private IFile getExistingOrmFile() {
        IFolder folder = this.getVerifiedSourceFolder();
        if (folder == null) {
            return null;
        }
        String filePath = this.getStringProperty("OrmFileCreationDataModelProperties.FILE_PATH");
        IFile existingFile = folder.getFile((IPath)new Path(filePath));
        if (!existingFile.exists()) {
            return null;
        }
        return existingFile;
    }

    private PersistenceUnit getDefaultPersistenceUnit() {
        JpaProject jpaProject = this.getJpaProject();
        if (jpaProject == null) {
            return null;
        }
        PersistenceXml persistenceXml = jpaProject.getRootContextNode().getPersistenceXml();
        if (persistenceXml == null) {
            return null;
        }
        Persistence persistence = persistenceXml.getPersistence();
        if (persistence == null) {
            return null;
        }
        if (persistence.persistenceUnitsSize() == 0) {
            return null;
        }
        return persistence.persistenceUnits().next();
    }

    private PersistenceUnit getPersistenceUnit() {
        Persistence persistence;
        String pUnitName = this.getStringProperty("OrmFileCreationDataModelProperties.PERSISTENCE_UNIT");
        JpaProject jpaProject = StringTools.stringIsEmpty((String)pUnitName) ? null : this.getJpaProject();
        PersistenceXml persistenceXml = jpaProject == null ? null : jpaProject.getRootContextNode().getPersistenceXml();
        Persistence persistence2 = persistence = persistenceXml == null ? null : persistenceXml.getPersistence();
        if (persistence != null) {
            ListIterator<PersistenceUnit> stream = persistence.persistenceUnits();
            while (stream.hasNext()) {
                PersistenceUnit next = (PersistenceUnit)stream.next();
                if (!pUnitName.equals(next.getName())) continue;
                return next;
            }
        }
        return null;
    }

    private Iterator<IProject> jpaIProjects() {
        return new FilteringIterator<IProject, IProject>(CollectionTools.iterator((Object[])ProjectUtilities.getAllProjects())){

            protected boolean accept(IProject project) {
                try {
                    return FacetedProjectFramework.hasProjectFacet((IProject)project, (String)"jpt.jpa");
                }
                catch (CoreException coreException) {
                    return false;
                }
            }
        };
    }

    private Iterator<PersistenceUnit> persistenceUnits() {
        return new CompositeIterator((Iterator)new TransformationIterator<IProject, Iterator<PersistenceUnit>>(this.jpaIProjects()){

            protected Iterator<PersistenceUnit> transform(IProject jpaIProject) {
                JpaProject jpaProject = JptCorePlugin.getJpaProject(jpaIProject);
                PersistenceXml persistenceXml = jpaProject == null ? null : jpaProject.getRootContextNode().getPersistenceXml();
                Persistence persistence = persistenceXml == null ? null : persistenceXml.getPersistence();
                return persistence == null ? EmptyIterator.instance() : persistence.persistenceUnits();
            }
        });
    }

    private Iterator<String> persistenceUnitNames() {
        return new TransformationIterator<PersistenceUnit, String>(this.persistenceUnits()){

            protected String transform(PersistenceUnit next) {
                return next.getName();
            }
        };
    }
}

