/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.operations;

import java.util.ListIterator;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.core.JptCorePlugin;
import org.eclipse.jpt.core.context.persistence.MappingFileRef;
import org.eclipse.jpt.core.context.persistence.Persistence;
import org.eclipse.jpt.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.core.context.persistence.PersistenceXml;
import org.eclipse.jpt.core.internal.operations.OrmFileCreationDataModelProperties;
import org.eclipse.jpt.core.internal.resource.orm.OrmResourceModelProvider;
import org.eclipse.jpt.core.internal.resource.persistence.PersistenceResourceModelProvider;
import org.eclipse.jpt.core.resource.orm.AccessType;
import org.eclipse.jpt.core.resource.orm.OrmFactory;
import org.eclipse.jpt.core.resource.orm.OrmResource;
import org.eclipse.jpt.core.resource.orm.XmlEntityMappings;
import org.eclipse.jpt.core.resource.orm.XmlPersistenceUnitDefaults;
import org.eclipse.jpt.core.resource.orm.XmlPersistenceUnitMetadata;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class OrmFileCreationOperation
extends AbstractDataModelOperation
implements OrmFileCreationDataModelProperties {
    public OrmFileCreationOperation(IDataModel dataModel) {
        super(dataModel);
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IFolder folder = this.createSourceFolder();
        this.createOrmXml(folder);
        this.addOrmXmlToPersistenceXml();
        return OK_STATUS;
    }

    private IProject getProject() throws ExecutionException {
        String projectName = (String)this.getDataModel().getProperty("OrmFileCreationDataModelProperties.PROJECT_NAME");
        IProject project = ProjectUtilities.getProject((String)projectName);
        if (project == null) {
            throw new ExecutionException("No project name specified");
        }
        return project;
    }

    private JpaProject getJpaProject() throws ExecutionException {
        IProject project = this.getProject();
        JpaProject jpaProject = JptCorePlugin.getJpaProject(project);
        if (jpaProject == null) {
            throw new ExecutionException("Project does not have JPA content");
        }
        return jpaProject;
    }

    private PersistenceUnit getPersistenceUnit() throws ExecutionException {
        String pUnitName = this.getDataModel().getStringProperty("OrmFileCreationDataModelProperties.PERSISTENCE_UNIT");
        JpaProject jpaProject = this.getJpaProject();
        PersistenceXml persistenceXml = jpaProject.getRootContextNode().getPersistenceXml();
        if (persistenceXml == null) {
            throw new ExecutionException("Project does not have a persistence.xml file");
        }
        Persistence persistence = persistenceXml.getPersistence();
        if (persistence == null) {
            throw new ExecutionException("persistence.xml does not have a persistence node.");
        }
        ListIterator<PersistenceUnit> stream = persistence.persistenceUnits();
        while (stream.hasNext()) {
            PersistenceUnit pUnit = (PersistenceUnit)stream.next();
            if (!pUnitName.equals(pUnit.getName())) continue;
            return pUnit;
        }
        throw new ExecutionException("persistence.xml does not have persistence unit named '" + pUnitName + "'");
    }

    private IFolder createSourceFolder() throws ExecutionException {
        String folderPath = this.model.getStringProperty("OrmFileCreationDataModelProperties.SOURCE_FOLDER");
        IProject project = this.getProject();
        IFolder folder = project.getWorkspace().getRoot().getFolder((IPath)new Path(folderPath));
        if (!folder.exists()) {
            try {
                folder.create(true, true, null);
            }
            catch (CoreException e) {
                throw new ExecutionException("Could not create folder", (Throwable)e);
            }
        }
        return folder;
    }

    private void createOrmXml(IFolder folder) throws ExecutionException {
        String filePath = this.getDataModel().getStringProperty("OrmFileCreationDataModelProperties.FILE_PATH");
        IFile file = folder.getFile((IPath)new Path(filePath));
        final OrmResourceModelProvider modelProvider = OrmResourceModelProvider.getModelProvider(this.getProject(), file.getProjectRelativePath().toString());
        modelProvider.modify(new Runnable(){

            public void run() {
                OrmResource ormResource = modelProvider.getResource();
                XmlEntityMappings entityMappings = OrmFactory.eINSTANCE.createXmlEntityMappings();
                entityMappings.setVersion("1.0");
                ormResource.getContents().add((Object)entityMappings);
                AccessType defaultAccess = (AccessType)((Object)OrmFileCreationOperation.this.getDataModel().getProperty("OrmFileCreationDataModelProperties.DEFAULT_ACCESS"));
                if (defaultAccess != null) {
                    XmlPersistenceUnitMetadata puMetadata = OrmFactory.eINSTANCE.createXmlPersistenceUnitMetadata();
                    entityMappings.setPersistenceUnitMetadata(puMetadata);
                    XmlPersistenceUnitDefaults puDefaults = OrmFactory.eINSTANCE.createXmlPersistenceUnitDefaults();
                    puMetadata.setPersistenceUnitDefaults(puDefaults);
                    puDefaults.setAccess(defaultAccess);
                }
            }
        });
    }

    private void addOrmXmlToPersistenceXml() throws ExecutionException {
        if (!this.getDataModel().getBooleanProperty("OrmFileCreationDataModelProperties.ADD_TO_PERSISTENCE_UNIT")) {
            return;
        }
        PersistenceResourceModelProvider modelProvider = PersistenceResourceModelProvider.getDefaultModelProvider(this.getProject());
        final PersistenceUnit pUnit = this.getPersistenceUnit();
        modelProvider.modify(new Runnable(){

            public void run() {
                String filePath = OrmFileCreationOperation.this.getDataModel().getStringProperty("OrmFileCreationDataModelProperties.FILE_PATH");
                ListIterator<MappingFileRef> stream = pUnit.specifiedMappingFileRefs();
                while (stream.hasNext()) {
                    if (!filePath.equals(((MappingFileRef)stream.next()).getFileName())) continue;
                    return;
                }
                MappingFileRef mfRef = pUnit.addSpecifiedMappingFileRef();
                mfRef.setFileName(new Path(filePath).toPortableString());
            }
        });
    }
}

