/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.platform;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jpt.core.EntityGeneratorDatabaseAnnotationNameBuilder;
import org.eclipse.jpt.core.JpaAnnotationProvider;
import org.eclipse.jpt.core.JpaFactory;
import org.eclipse.jpt.core.JpaFile;
import org.eclipse.jpt.core.JpaPlatform;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.core.ResourceModel;
import org.eclipse.jpt.core.context.java.DefaultJavaAttributeMappingProvider;
import org.eclipse.jpt.core.context.java.JavaAttributeMapping;
import org.eclipse.jpt.core.context.java.JavaAttributeMappingProvider;
import org.eclipse.jpt.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.core.context.java.JavaPersistentType;
import org.eclipse.jpt.core.context.java.JavaTypeMapping;
import org.eclipse.jpt.core.context.java.JavaTypeMappingProvider;
import org.eclipse.jpt.core.internal.context.java.JavaBasicMappingProvider;
import org.eclipse.jpt.core.internal.context.java.JavaEmbeddableProvider;
import org.eclipse.jpt.core.internal.context.java.JavaEmbeddedIdMappingProvider;
import org.eclipse.jpt.core.internal.context.java.JavaEmbeddedMappingProvider;
import org.eclipse.jpt.core.internal.context.java.JavaEntityProvider;
import org.eclipse.jpt.core.internal.context.java.JavaIdMappingProvider;
import org.eclipse.jpt.core.internal.context.java.JavaManyToManyMappingProvider;
import org.eclipse.jpt.core.internal.context.java.JavaManyToOneMappingProvider;
import org.eclipse.jpt.core.internal.context.java.JavaMappedSuperclassProvider;
import org.eclipse.jpt.core.internal.context.java.JavaNullAttributeMappingProvider;
import org.eclipse.jpt.core.internal.context.java.JavaNullTypeMappingProvider;
import org.eclipse.jpt.core.internal.context.java.JavaOneToManyMappingProvider;
import org.eclipse.jpt.core.internal.context.java.JavaOneToOneMappingProvider;
import org.eclipse.jpt.core.internal.context.java.JavaTransientMappingProvider;
import org.eclipse.jpt.core.internal.context.java.JavaVersionMappingProvider;
import org.eclipse.jpt.core.internal.platform.GenericEntityGeneratorDatabaseAnnotationNameBuilder;
import org.eclipse.jpt.core.internal.platform.GenericJpaAnnotationProvider;
import org.eclipse.jpt.core.internal.platform.GenericJpaFactory;
import org.eclipse.jpt.core.utility.PlatformUtilities;
import org.eclipse.jpt.db.ConnectionProfileFactory;
import org.eclipse.jpt.db.DatabaseFinder;
import org.eclipse.jpt.db.JptDbPlugin;
import org.eclipse.jpt.utility.internal.iterators.CloneIterator;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJpaPlatform
implements JpaPlatform {
    public static final String ID = "generic";
    private String id;
    protected JpaFactory jpaFactory;
    protected JpaAnnotationProvider annotationProvider;
    protected List<JavaTypeMappingProvider> javaTypeMappingProviders;
    protected List<JavaAttributeMappingProvider> javaAttributeMappingProviders;
    protected List<DefaultJavaAttributeMappingProvider> defaultJavaAttributeMappingProviders;

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String theId) {
        this.id = theId;
    }

    @Override
    public synchronized JpaFactory getJpaFactory() {
        if (this.jpaFactory == null) {
            this.jpaFactory = this.buildJpaFactory();
        }
        return this.jpaFactory;
    }

    protected JpaFactory buildJpaFactory() {
        return new GenericJpaFactory();
    }

    @Override
    public JpaFile buildJpaFile(JpaProject jpaProject, IFile file) {
        if (!JavaCore.create((IProject)file.getProject()).isOnClasspath((IResource)file)) {
            return null;
        }
        IContentType contentType = PlatformUtilities.contentType(file);
        if (contentType == null) {
            return null;
        }
        String contentTypeId = contentType.getId();
        if (this.supportsContentType(contentTypeId)) {
            ResourceModel resourceModel = this.getJpaFactory().buildResourceModel(jpaProject, file, contentTypeId);
            return this.getJpaFactory().buildJpaFile(jpaProject, file, resourceModel);
        }
        return null;
    }

    protected boolean supportsContentType(String contentTypeId) {
        return contentTypeId.equals("org.eclipse.jdt.core.javaSource") || contentTypeId.equals("org.eclipse.jpt.core.content.persistence") || contentTypeId.equals("org.eclipse.jpt.core.content.orm");
    }

    @Override
    public synchronized JpaAnnotationProvider getAnnotationProvider() {
        if (this.annotationProvider == null) {
            this.annotationProvider = this.buildAnnotationProvider();
        }
        return this.annotationProvider;
    }

    protected JpaAnnotationProvider buildAnnotationProvider() {
        return new GenericJpaAnnotationProvider();
    }

    @Override
    public JavaTypeMapping buildJavaTypeMappingFromMappingKey(String typeMappingKey, JavaPersistentType parent) {
        return this.javaTypeMappingProviderFromMappingKey(typeMappingKey).buildMapping(parent, this.getJpaFactory());
    }

    @Override
    public JavaTypeMapping buildJavaTypeMappingFromAnnotation(String mappingAnnotationName, JavaPersistentType parent) {
        return this.javaTypeMappingProviderFromAnnotation(mappingAnnotationName).buildMapping(parent, this.getJpaFactory());
    }

    protected synchronized Iterator<JavaTypeMappingProvider> javaTypeMappingProviders() {
        if (this.javaTypeMappingProviders == null) {
            this.javaTypeMappingProviders = new ArrayList<JavaTypeMappingProvider>();
            this.addJavaTypeMappingProvidersTo(this.javaTypeMappingProviders);
        }
        return new CloneIterator(this.javaTypeMappingProviders);
    }

    protected void addJavaTypeMappingProvidersTo(List<JavaTypeMappingProvider> providers) {
        providers.add(JavaEntityProvider.instance());
        providers.add(JavaMappedSuperclassProvider.instance());
        providers.add(JavaEmbeddableProvider.instance());
        providers.add(JavaNullTypeMappingProvider.instance());
    }

    protected JavaTypeMappingProvider javaTypeMappingProviderFromMappingKey(String typeMappingKey) {
        Iterator<JavaTypeMappingProvider> stream = this.javaTypeMappingProviders();
        while (stream.hasNext()) {
            JavaTypeMappingProvider provider = stream.next();
            if (provider.getKey() != typeMappingKey) continue;
            return provider;
        }
        throw new IllegalArgumentException("Illegal type mapping key: " + typeMappingKey);
    }

    protected JavaTypeMappingProvider javaTypeMappingProviderFromAnnotation(String annotationName) {
        Iterator<JavaTypeMappingProvider> stream = this.javaTypeMappingProviders();
        while (stream.hasNext()) {
            JavaTypeMappingProvider provider = stream.next();
            if (provider.getAnnotationName() != annotationName) continue;
            return provider;
        }
        throw new IllegalArgumentException("Illegal annotation name: " + annotationName);
    }

    @Override
    public JavaAttributeMapping buildJavaAttributeMappingFromMappingKey(String attributeMappingKey, JavaPersistentAttribute parent) {
        return this.javaAttributeMappingProviderFromMappingKey(attributeMappingKey).buildMapping(parent, this.getJpaFactory());
    }

    @Override
    public JavaAttributeMapping buildJavaAttributeMappingFromAnnotation(String mappingAnnotationName, JavaPersistentAttribute parent) {
        return this.javaAttributeMappingProviderFromAnnotation(mappingAnnotationName).buildMapping(parent, this.getJpaFactory());
    }

    @Override
    public JavaAttributeMapping buildDefaultJavaAttributeMapping(JavaPersistentAttribute parent) {
        return this.defaultJavaAttributeMappingProvider(parent).buildMapping(parent, this.getJpaFactory());
    }

    protected synchronized Iterator<JavaAttributeMappingProvider> javaAttributeMappingProviders() {
        if (this.javaAttributeMappingProviders == null) {
            this.javaAttributeMappingProviders = new ArrayList<JavaAttributeMappingProvider>();
            this.addJavaAttributeMappingProvidersTo(this.javaAttributeMappingProviders);
        }
        return new CloneIterator(this.javaAttributeMappingProviders);
    }

    protected void addJavaAttributeMappingProvidersTo(List<JavaAttributeMappingProvider> providers) {
        providers.add(JavaBasicMappingProvider.instance());
        providers.add(JavaEmbeddedMappingProvider.instance());
        providers.add(JavaEmbeddedIdMappingProvider.instance());
        providers.add(JavaIdMappingProvider.instance());
        providers.add(JavaManyToManyMappingProvider.instance());
        providers.add(JavaManyToOneMappingProvider.instance());
        providers.add(JavaOneToManyMappingProvider.instance());
        providers.add(JavaOneToOneMappingProvider.instance());
        providers.add(JavaTransientMappingProvider.instance());
        providers.add(JavaVersionMappingProvider.instance());
    }

    protected JavaAttributeMappingProvider javaAttributeMappingProviderFromMappingKey(String attributeMappingKey) {
        Iterator<JavaAttributeMappingProvider> stream = this.javaAttributeMappingProviders();
        while (stream.hasNext()) {
            JavaAttributeMappingProvider provider = stream.next();
            if (provider.getKey() != attributeMappingKey) continue;
            return provider;
        }
        throw new IllegalArgumentException("Illegal attribute mapping key: " + attributeMappingKey);
    }

    protected JavaAttributeMappingProvider javaAttributeMappingProviderFromAnnotation(String annotationName) {
        Iterator<JavaAttributeMappingProvider> stream = this.javaAttributeMappingProviders();
        while (stream.hasNext()) {
            JavaAttributeMappingProvider provider = stream.next();
            if (provider.getAnnotationName() != annotationName) continue;
            return provider;
        }
        throw new IllegalArgumentException("Illegal annotation name: " + annotationName);
    }

    protected synchronized ListIterator<DefaultJavaAttributeMappingProvider> defaultJavaAttributeMappingProviders() {
        if (this.defaultJavaAttributeMappingProviders == null) {
            this.defaultJavaAttributeMappingProviders = new ArrayList<DefaultJavaAttributeMappingProvider>();
            this.addDefaultJavaAttributeMappingProvidersTo(this.defaultJavaAttributeMappingProviders);
        }
        return new CloneListIterator(this.defaultJavaAttributeMappingProviders);
    }

    protected void addDefaultJavaAttributeMappingProvidersTo(List<DefaultJavaAttributeMappingProvider> providers) {
        providers.add(JavaEmbeddedMappingProvider.instance());
        providers.add(JavaBasicMappingProvider.instance());
    }

    protected JavaAttributeMappingProvider defaultJavaAttributeMappingProvider(JavaPersistentAttribute persistentAttribute) {
        ListIterator<DefaultJavaAttributeMappingProvider> stream = this.defaultJavaAttributeMappingProviders();
        while (stream.hasNext()) {
            DefaultJavaAttributeMappingProvider provider = (DefaultJavaAttributeMappingProvider)stream.next();
            if (!provider.defaultApplies(persistentAttribute)) continue;
            return provider;
        }
        return this.getNullAttributeMappingProvider();
    }

    @Override
    public String getDefaultJavaAttributeMappingKey(JavaPersistentAttribute persistentAttribute) {
        return this.defaultJavaAttributeMappingProvider(persistentAttribute).getKey();
    }

    protected JavaAttributeMappingProvider getNullAttributeMappingProvider() {
        return JavaNullAttributeMappingProvider.instance();
    }

    @Override
    public ConnectionProfileFactory getConnectionProfileFactory() {
        return JptDbPlugin.instance().getConnectionProfileFactory();
    }

    @Override
    public EntityGeneratorDatabaseAnnotationNameBuilder getEntityGeneratorDatabaseAnnotationNameBuilder() {
        return GenericEntityGeneratorDatabaseAnnotationNameBuilder.instance();
    }

    @Override
    public DatabaseFinder getDatabaseFinder() {
        return DatabaseFinder.Default.instance();
    }
}

