/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.resource.java;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jpt.core.internal.resource.java.AbstractJavaResourceNode;
import org.eclipse.jpt.core.internal.resource.java.ContainerAnnotationTools;
import org.eclipse.jpt.core.internal.utility.jdt.ASTNodeTextRange;
import org.eclipse.jpt.core.internal.utility.jdt.JDTTools;
import org.eclipse.jpt.core.resource.java.Annotation;
import org.eclipse.jpt.core.resource.java.ContainerAnnotation;
import org.eclipse.jpt.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentMember;
import org.eclipse.jpt.core.resource.java.NestableAnnotation;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.core.utility.jdt.Member;
import org.eclipse.jpt.utility.MethodSignature;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.CloneIterator;
import org.eclipse.jpt.utility.internal.iterators.EmptyListIterator;
import org.eclipse.jpt.utility.internal.iterators.FilteringIterator;
import org.eclipse.jpt.utility.internal.iterators.SingleElementListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJavaResourcePersistentMember<E extends Member>
extends AbstractJavaResourceNode
implements JavaResourcePersistentMember {
    private final E member;
    private final Collection<Annotation> annotations;
    private final Collection<Annotation> mappingAnnotations;
    private boolean persistable;

    AbstractJavaResourcePersistentMember(JavaResourceNode parent, E member) {
        super(parent);
        this.member = member;
        this.annotations = new ArrayList<Annotation>();
        this.mappingAnnotations = new ArrayList<Annotation>();
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        this.getMember().getBodyDeclaration(astRoot).accept(this.buildInitialAnnotationVisitor(astRoot));
        this.persistable = this.buildPersistable(astRoot);
    }

    protected ASTVisitor buildInitialAnnotationVisitor(CompilationUnit astRoot) {
        return new LocalASTVisitor(astRoot, this.getMember().getBodyDeclaration(astRoot)){

            @Override
            protected void visitChildAnnotation(org.eclipse.jdt.core.dom.Annotation node) {
                AbstractJavaResourcePersistentMember.this.addInitialAnnotation(node, this.astRoot);
            }
        };
    }

    protected void addInitialAnnotation(org.eclipse.jdt.core.dom.Annotation node, CompilationUnit astRoot) {
        String qualifiedAnnotationName = JDTTools.resolveAnnotation(node);
        if (qualifiedAnnotationName == null) {
            return;
        }
        if (this.isPossibleAnnotation(qualifiedAnnotationName)) {
            if (this.getAnnotation(qualifiedAnnotationName) == null) {
                Annotation annotation = this.buildAnnotation(qualifiedAnnotationName);
                annotation.initialize(astRoot);
                this.annotations.add(annotation);
            }
        } else if (this.isPossibleMappingAnnotation(qualifiedAnnotationName) && this.getMappingAnnotation(qualifiedAnnotationName) == null) {
            Annotation annotation = this.buildMappingAnnotation(qualifiedAnnotationName);
            annotation.initialize(astRoot);
            this.mappingAnnotations.add(annotation);
        }
    }

    public E getMember() {
        return this.member;
    }

    protected abstract Annotation buildAnnotation(String var1);

    protected abstract Annotation buildNullAnnotation(String var1);

    protected abstract Annotation buildMappingAnnotation(String var1);

    protected abstract Annotation buildNullMappingAnnotation(String var1);

    protected abstract ListIterator<String> possibleMappingAnnotationNames();

    protected abstract boolean isPossibleAnnotation(String var1);

    protected abstract boolean isPossibleMappingAnnotation(String var1);

    protected boolean buildPersistable(CompilationUnit astRoot) {
        return this.getMember().isPersistable(astRoot);
    }

    @Override
    public Annotation getAnnotation(String annotationName) {
        Iterator<Annotation> i = this.annotations();
        while (i.hasNext()) {
            Annotation annotation = i.next();
            if (!annotation.getAnnotationName().equals(annotationName)) continue;
            return annotation;
        }
        return null;
    }

    @Override
    public JavaResourceNode getNonNullAnnotation(String annotationName) {
        Annotation annotation = this.getAnnotation(annotationName);
        if (annotation == null) {
            return this.buildNullAnnotation(annotationName);
        }
        return annotation;
    }

    @Override
    public Annotation getMappingAnnotation(String annotationName) {
        Iterator<Annotation> i = this.mappingAnnotations();
        while (i.hasNext()) {
            Annotation mappingAnnotation = i.next();
            if (!mappingAnnotation.getAnnotationName().equals(annotationName)) continue;
            return mappingAnnotation;
        }
        return null;
    }

    @Override
    public JavaResourceNode getNullMappingAnnotation(String annotationName) {
        return this.buildNullMappingAnnotation(annotationName);
    }

    public Iterator<Annotation> annotations() {
        return new CloneIterator(this.annotations);
    }

    @Override
    public int annotationsSize() {
        return this.annotations.size();
    }

    @Override
    public Annotation addAnnotation(String annotationName) {
        Annotation annotation = this.buildAnnotation(annotationName);
        this.annotations.add(annotation);
        annotation.newAnnotation();
        this.fireItemAdded("annotations", annotation);
        return annotation;
    }

    protected ContainerAnnotation<NestableAnnotation> addContainerAnnotation(String containerAnnotationName) {
        return (ContainerAnnotation)this.addAnnotation(containerAnnotationName);
    }

    protected ContainerAnnotation<NestableAnnotation> addContainerAnnotationTwoNestableAnnotations(String containerAnnotationName) {
        ContainerAnnotation<NestableAnnotation> containerAnnotation = this.buildContainerAnnotation(containerAnnotationName);
        this.annotations.add(containerAnnotation);
        containerAnnotation.newAnnotation();
        containerAnnotation.addInternal(0).newAnnotation();
        containerAnnotation.addInternal(1).newAnnotation();
        return containerAnnotation;
    }

    protected ContainerAnnotation<NestableAnnotation> buildContainerAnnotation(String containerAnnotationName) {
        return (ContainerAnnotation)this.buildAnnotation(containerAnnotationName);
    }

    protected ContainerAnnotation<NestableAnnotation> getContainerAnnotation(String containerAnnotationName) {
        return (ContainerAnnotation)this.getAnnotation(containerAnnotationName);
    }

    protected NestableAnnotation getNestableAnnotation(String nestableAnnotationName) {
        return (NestableAnnotation)this.getAnnotation(nestableAnnotationName);
    }

    protected NestableAnnotation addNestableAnnotation(String nestableAnnotationName) {
        return (NestableAnnotation)this.addAnnotation(nestableAnnotationName);
    }

    @Override
    public NestableAnnotation addAnnotation(int index, String nestableAnnotationName, String containerAnnotationName) {
        NestableAnnotation nestedAnnotation = (NestableAnnotation)this.getAnnotation(nestableAnnotationName);
        ContainerAnnotation<NestableAnnotation> containerAnnotation = this.getContainerAnnotation(containerAnnotationName);
        if (containerAnnotation != null) {
            NestableAnnotation newNestedAnnotation = ContainerAnnotationTools.addNestedAnnotation(index, containerAnnotation);
            return newNestedAnnotation;
        }
        if (nestedAnnotation == null) {
            return this.addNestableAnnotation(nestableAnnotationName);
        }
        ContainerAnnotation<NestableAnnotation> newContainerAnnotation = this.addContainerAnnotationTwoNestableAnnotations(containerAnnotationName);
        if (index == 0) {
            newContainerAnnotation.nestedAnnotationAt(1).initializeFrom(nestedAnnotation);
        } else {
            newContainerAnnotation.nestedAnnotationAt(0).initializeFrom(nestedAnnotation);
        }
        this.removeAnnotation(nestedAnnotation);
        return newContainerAnnotation.nestedAnnotationAt(index);
    }

    @Override
    public void move(int targetIndex, int sourceIndex, String containerAnnotationName) {
        this.move(targetIndex, sourceIndex, this.getContainerAnnotation(containerAnnotationName));
    }

    protected void move(int targetIndex, int sourceIndex, ContainerAnnotation<NestableAnnotation> containerAnnotation) {
        containerAnnotation.move(targetIndex, sourceIndex);
        ContainerAnnotationTools.synchAnnotationsAfterMove(targetIndex, sourceIndex, containerAnnotation);
    }

    protected void addAnnotation(Annotation annotation) {
        this.addItemToCollection(annotation, this.annotations, "annotations");
    }

    protected void removeAnnotation(Annotation annotation) {
        this.removeAnnotation_(annotation);
        annotation.removeAnnotation();
    }

    protected void removeAnnotation_(Annotation annotation) {
        this.removeItemFromCollection(annotation, this.annotations, "annotations");
    }

    protected void addMappingAnnotation(String mappingAnnotationName) {
        if (this.getMappingAnnotation(mappingAnnotationName) != null) {
            return;
        }
        Annotation mappingAnnotation = this.buildMappingAnnotation(mappingAnnotationName);
        this.addMappingAnnotation(mappingAnnotation);
        mappingAnnotation.newAnnotation();
    }

    protected void addMappingAnnotation(Annotation annotation) {
        this.addItemToCollection(annotation, this.mappingAnnotations, "mappingAnnotations");
    }

    protected void removeMappingAnnotation(Annotation annotation) {
        this.removeMappingAnnotation_(annotation);
        annotation.removeAnnotation();
    }

    protected void removeMappingAnnotation_(Annotation annotation) {
        this.removeItemFromCollection(annotation, this.mappingAnnotations, "mappingAnnotations");
    }

    public Iterator<Annotation> mappingAnnotations() {
        return new CloneIterator(this.mappingAnnotations);
    }

    @Override
    public int mappingAnnotationsSize() {
        return this.mappingAnnotations.size();
    }

    @Override
    public void removeAnnotation(String annotationName) {
        Annotation annotation = this.getAnnotation(annotationName);
        if (annotation != null) {
            this.removeAnnotation(annotation);
        }
    }

    @Override
    public void removeAnnotation(int index, String nestableAnnotationName, String containerAnnotationName) {
        ContainerAnnotation<NestableAnnotation> containerAnnotation = this.getContainerAnnotation(containerAnnotationName);
        if (containerAnnotation == null) {
            Annotation annotation = this.getAnnotation(nestableAnnotationName);
            this.removeAnnotation(annotation);
        } else {
            this.removeAnnotation(index, containerAnnotation);
        }
    }

    protected void removeAnnotation(int index, ContainerAnnotation<NestableAnnotation> containerAnnotation) {
        NestableAnnotation nestableAnnotation = containerAnnotation.nestedAnnotationAt(index);
        containerAnnotation.remove(index);
        nestableAnnotation.removeAnnotation();
        ContainerAnnotationTools.synchAnnotationsAfterRemove(index, containerAnnotation);
        if (containerAnnotation.nestedAnnotationsSize() == 0) {
            this.removeAnnotation(containerAnnotation);
        } else if (containerAnnotation.nestedAnnotationsSize() == 1) {
            NestableAnnotation nestedAnnotation = containerAnnotation.nestedAnnotationAt(0);
            this.annotations.remove(containerAnnotation);
            containerAnnotation.removeAnnotation();
            NestableAnnotation newAnnotation = (NestableAnnotation)this.buildAnnotation(containerAnnotation.getNestableAnnotationName());
            this.annotations.add(newAnnotation);
            newAnnotation.newAnnotation();
            newAnnotation.initializeFrom(nestedAnnotation);
            this.fireItemAdded("annotations", newAnnotation);
            this.fireItemRemoved("annotations", containerAnnotation);
        }
    }

    @Override
    public void setMappingAnnotation(String annotationName) {
        if (this.getMappingAnnotation(annotationName) != null) {
            throw new IllegalStateException("The mapping annotation named " + annotationName + " already exists.");
        }
        Annotation oldMapping = this.getMappingAnnotation();
        Annotation newMapping = null;
        if (oldMapping != null) {
            this.removeUnnecessaryAnnotations(annotationName);
        }
        if (annotationName != null) {
            if (this.getMappingAnnotation(annotationName) != null) {
                return;
            }
            newMapping = this.buildMappingAnnotation(annotationName);
            this.mappingAnnotations.add(newMapping);
            newMapping.newAnnotation();
        }
        this.fireCollectionChanged("mappingAnnotations");
    }

    protected void removeUnnecessaryAnnotations(String newMappingAnnotationName) {
        ListIterator<String> i = this.possibleMappingAnnotationNames();
        while (i.hasNext()) {
            Annotation mappingAnnotation;
            String mappingAnnotationName = i.next();
            if (mappingAnnotationName == newMappingAnnotationName || (mappingAnnotation = this.getMappingAnnotation(mappingAnnotationName)) == null) continue;
            this.mappingAnnotations.remove(mappingAnnotation);
            mappingAnnotation.removeAnnotation();
        }
    }

    @Override
    public Annotation getMappingAnnotation() {
        ListIterator<String> i = this.possibleMappingAnnotationNames();
        while (i.hasNext()) {
            String mappingAnnotationName = i.next();
            Iterator<Annotation> j = this.mappingAnnotations();
            while (j.hasNext()) {
                Annotation mappingAnnotation = j.next();
                if (mappingAnnotationName != mappingAnnotation.getAnnotationName()) continue;
                return mappingAnnotation;
            }
        }
        return null;
    }

    public ListIterator<NestableAnnotation> annotations(String nestableAnnotationName, String containerAnnotationName) {
        ContainerAnnotation<NestableAnnotation> containerAnnotation = this.getContainerAnnotation(containerAnnotationName);
        if (containerAnnotation != null) {
            return containerAnnotation.nestedAnnotations();
        }
        NestableAnnotation nestableAnnotation = this.getNestableAnnotation(nestableAnnotationName);
        if (nestableAnnotation != null) {
            return new SingleElementListIterator((Object)nestableAnnotation);
        }
        return EmptyListIterator.instance();
    }

    @Override
    public void update(CompilationUnit astRoot) {
        this.updateAnnotations(astRoot);
        this.setPersistable(this.buildPersistable(astRoot));
    }

    @Override
    public void resolveTypes(CompilationUnit astRoot) {
        this.setPersistable(this.buildPersistable(astRoot));
    }

    protected void updateAnnotations(CompilationUnit astRoot) {
        this.getMember().getBodyDeclaration(astRoot).accept(this.buildUpdateAnnotationVisitor(astRoot));
        this.removeMappingAnnotationsNotInSource(astRoot);
        this.removeAnnotationsNotInSource(astRoot);
    }

    protected void removeAnnotationsNotInSource(CompilationUnit astRoot) {
        for (Annotation annotation : CollectionTools.iterable(this.annotations())) {
            if (annotation.getJdtAnnotation(astRoot) != null) continue;
            this.removeAnnotation_(annotation);
        }
    }

    protected void removeMappingAnnotationsNotInSource(CompilationUnit astRoot) {
        for (Annotation mappingAnnotation : CollectionTools.iterable(this.mappingAnnotations())) {
            if (mappingAnnotation.getJdtAnnotation(astRoot) != null) continue;
            this.removeMappingAnnotation_(mappingAnnotation);
        }
    }

    protected ASTVisitor buildUpdateAnnotationVisitor(CompilationUnit astRoot) {
        return new LocalASTVisitor(astRoot, this.getMember().getBodyDeclaration(astRoot)){

            @Override
            protected void visitChildAnnotation(org.eclipse.jdt.core.dom.Annotation node) {
                AbstractJavaResourcePersistentMember.this.addOrUpdateAnnotation(node, this.astRoot);
            }
        };
    }

    protected void addOrUpdateAnnotation(org.eclipse.jdt.core.dom.Annotation node, CompilationUnit astRoot) {
        String qualifiedAnnotationName = JDTTools.resolveAnnotation(node);
        if (qualifiedAnnotationName == null) {
            return;
        }
        if (this.isPossibleAnnotation(qualifiedAnnotationName)) {
            Annotation annotation = this.getAnnotation(qualifiedAnnotationName);
            if (annotation != null) {
                annotation.update(astRoot);
            } else {
                annotation = this.buildAnnotation(qualifiedAnnotationName);
                annotation.initialize(astRoot);
                this.addAnnotation(annotation);
            }
        } else if (this.isPossibleMappingAnnotation(qualifiedAnnotationName)) {
            Annotation annotation = this.getMappingAnnotation(qualifiedAnnotationName);
            if (annotation != null) {
                annotation.update(astRoot);
            } else {
                annotation = this.buildMappingAnnotation(qualifiedAnnotationName);
                annotation.initialize(astRoot);
                this.addMappingAnnotation(annotation);
            }
        }
    }

    @Override
    public boolean isFor(String memberName, int occurrence) {
        return this.member.matches(memberName, occurrence);
    }

    @Override
    public boolean isFor(MethodSignature methodSignature, int occurrence) {
        return false;
    }

    @Override
    public boolean isPersistable() {
        return this.persistable;
    }

    protected void setPersistable(boolean newPersistable) {
        boolean oldPersistable = this.persistable;
        this.persistable = newPersistable;
        this.firePropertyChanged("persistable", oldPersistable, newPersistable);
    }

    @Override
    public boolean isPersisted() {
        return this.getMappingAnnotation() != null;
    }

    public TextRange fullTextRange(CompilationUnit astRoot) {
        return this.getTextRange((ASTNode)this.getMember().getBodyDeclaration(astRoot));
    }

    @Override
    public TextRange getTextRange(CompilationUnit astRoot) {
        return this.fullTextRange(astRoot);
    }

    @Override
    public TextRange getNameTextRange(CompilationUnit astRoot) {
        return this.getMember().getNameTextRange(astRoot);
    }

    protected TextRange getTextRange(ASTNode astNode) {
        return astNode == null ? null : new ASTNodeTextRange(astNode);
    }

    protected static <T extends JavaResourcePersistentMember> Iterator<T> persistableMembers(Iterator<T> attributes) {
        return new FilteringIterator<T, T>(attributes){

            protected boolean accept(T attribute) {
                return attribute.isPersistable();
            }
        };
    }

    protected abstract class LocalASTVisitor
    extends ASTVisitor {
        protected final CompilationUnit astRoot;
        protected final BodyDeclaration bodyDeclaration;

        protected LocalASTVisitor(CompilationUnit astRoot, BodyDeclaration bodyDeclaration) {
            this.astRoot = astRoot;
            this.bodyDeclaration = bodyDeclaration;
        }

        public boolean visit(SingleMemberAnnotation node) {
            return this.visit_((org.eclipse.jdt.core.dom.Annotation)node);
        }

        public boolean visit(NormalAnnotation node) {
            return this.visit_((org.eclipse.jdt.core.dom.Annotation)node);
        }

        public boolean visit(MarkerAnnotation node) {
            return this.visit_((org.eclipse.jdt.core.dom.Annotation)node);
        }

        protected boolean visit_(org.eclipse.jdt.core.dom.Annotation node) {
            if (node.getParent() == this.bodyDeclaration) {
                this.visitChildAnnotation(node);
            }
            return false;
        }

        protected abstract void visitChildAnnotation(org.eclipse.jdt.core.dom.Annotation var1);
    }
}

