/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.resource.java;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jpt.core.internal.resource.java.AbstractJavaResourcePersistentMember;
import org.eclipse.jpt.core.internal.resource.java.JavaResourcePersistentAttributeImpl;
import org.eclipse.jpt.core.internal.utility.jdt.JDTTools;
import org.eclipse.jpt.core.internal.utility.jdt.JDTType;
import org.eclipse.jpt.core.resource.java.AccessType;
import org.eclipse.jpt.core.resource.java.Annotation;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentMember;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.resource.java.JpaCompilationUnit;
import org.eclipse.jpt.core.resource.java.NestableAnnotation;
import org.eclipse.jpt.core.utility.jdt.Type;
import org.eclipse.jpt.utility.MethodSignature;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.Counter;
import org.eclipse.jpt.utility.internal.iterators.CloneIterator;
import org.eclipse.jpt.utility.internal.iterators.CompositeIterator;
import org.eclipse.jpt.utility.internal.iterators.FilteringIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaResourcePersistentTypeImpl
extends AbstractJavaResourcePersistentMember<Type>
implements JavaResourcePersistentType {
    private String qualifiedName;
    private String name;
    private String superClassQualifiedName;
    private boolean abstract_;
    private final Vector<JavaResourcePersistentType> nestedTypes = new Vector();
    private final Vector<JavaResourcePersistentAttribute> fields = new Vector();
    private final Vector<JavaResourcePersistentAttribute> methods = new Vector();
    private AccessType accessType;

    public static JavaResourcePersistentType newInstance(JpaCompilationUnit jpaCompilationUnit, TypeDeclaration typeDeclaration, CompilationUnit astRoot) {
        JDTType type = new JDTType(typeDeclaration, jpaCompilationUnit.getCompilationUnit(), jpaCompilationUnit.getModifySharedDocumentCommandExecutorProvider(), jpaCompilationUnit.getAnnotationEditFormatter());
        JavaResourcePersistentTypeImpl jrpt = new JavaResourcePersistentTypeImpl(jpaCompilationUnit, type);
        jrpt.initialize(astRoot);
        return jrpt;
    }

    protected static JavaResourcePersistentType newInstance(JpaCompilationUnit jpaCompilationUnit, Type declaringType, TypeDeclaration typeDeclaration, int occurrence, CompilationUnit astRoot) {
        JDTType type = new JDTType(declaringType, typeDeclaration, occurrence, jpaCompilationUnit.getCompilationUnit(), jpaCompilationUnit.getModifySharedDocumentCommandExecutorProvider(), jpaCompilationUnit.getAnnotationEditFormatter());
        JavaResourcePersistentTypeImpl jrpt = new JavaResourcePersistentTypeImpl(jpaCompilationUnit, type);
        jrpt.initialize(astRoot);
        return jrpt;
    }

    public JavaResourcePersistentTypeImpl(JpaCompilationUnit jpaCompilationUnit, Type type) {
        super(jpaCompilationUnit, type);
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        super.initialize(astRoot);
        this.qualifiedName = this.buildQualifiedName(astRoot);
        this.name = this.buildName(astRoot);
        this.superClassQualifiedName = this.buildSuperClassQualifiedName(astRoot);
        this.abstract_ = this.buildAbstract(astRoot);
        this.initializeNestedTypes(astRoot);
        this.initializeFields(astRoot);
        this.initializeMethods(astRoot);
        this.accessType = this.buildAccessType();
    }

    protected void initializeNestedTypes(CompilationUnit astRoot) {
        CounterMap counters = new CounterMap();
        TypeDeclaration[] typeDeclarationArray = ((Type)this.getMember()).getTypes(astRoot);
        int n = typeDeclarationArray.length;
        int n2 = 0;
        while (n2 < n) {
            TypeDeclaration td = typeDeclarationArray[n2];
            String tdName = td.getName().getFullyQualifiedName();
            int occurrence = counters.increment(tdName);
            this.nestedTypes.add(this.buildNestedType(td, occurrence, astRoot));
            ++n2;
        }
    }

    protected void initializeFields(CompilationUnit astRoot) {
        CounterMap counters = new CounterMap();
        FieldDeclaration[] fieldDeclarationArray = ((Type)this.getMember()).getFields(astRoot);
        int n = fieldDeclarationArray.length;
        int n2 = 0;
        while (n2 < n) {
            FieldDeclaration fieldDeclaration = fieldDeclarationArray[n2];
            for (VariableDeclarationFragment fragment : JavaResourcePersistentTypeImpl.fragments(fieldDeclaration)) {
                String fieldName = fragment.getName().getFullyQualifiedName();
                int occurrence = counters.increment(fieldName);
                this.fields.add(this.buildField(fieldName, occurrence, astRoot));
            }
            ++n2;
        }
    }

    protected void initializeMethods(CompilationUnit astRoot) {
        CounterMap counters = new CounterMap();
        MethodDeclaration[] methodDeclarationArray = ((Type)this.getMember()).getMethods(astRoot);
        int n = methodDeclarationArray.length;
        int n2 = 0;
        while (n2 < n) {
            MethodDeclaration methodDeclaration = methodDeclarationArray[n2];
            MethodSignature signature = JDTTools.buildMethodSignature(methodDeclaration);
            int occurrence = counters.increment(signature);
            this.methods.add(this.buildMethod(signature, occurrence, astRoot));
            ++n2;
        }
    }

    @Override
    protected Annotation buildMappingAnnotation(String mappingAnnotationName) {
        return this.getAnnotationProvider().buildTypeMappingAnnotation(this, (Type)this.getMember(), mappingAnnotationName);
    }

    @Override
    protected Annotation buildNullMappingAnnotation(String annotationName) {
        return this.getAnnotationProvider().buildNullTypeMappingAnnotation(this, (Type)this.getMember(), annotationName);
    }

    @Override
    protected Annotation buildAnnotation(String annotationName) {
        return this.getAnnotationProvider().buildTypeAnnotation(this, (Type)this.getMember(), annotationName);
    }

    @Override
    protected Annotation buildNullAnnotation(String annotationName) {
        return this.getAnnotationProvider().buildNullTypeAnnotation(this, (Type)this.getMember(), annotationName);
    }

    @Override
    protected ListIterator<String> possibleMappingAnnotationNames() {
        return this.getAnnotationProvider().typeMappingAnnotationNames();
    }

    @Override
    protected boolean isPossibleAnnotation(String annotationName) {
        return CollectionTools.contains(this.getAnnotationProvider().typeAnnotationNames(), (Object)annotationName);
    }

    @Override
    protected boolean isPossibleMappingAnnotation(String annotationName) {
        return CollectionTools.contains(this.getAnnotationProvider().typeMappingAnnotationNames(), (Object)annotationName);
    }

    @Override
    public ListIterator<NestableAnnotation> annotations(String nestableAnnotationName, String containerAnnotationName) {
        return super.annotations(nestableAnnotationName, containerAnnotationName);
    }

    @Override
    public Iterator<Annotation> mappingAnnotations() {
        return super.mappingAnnotations();
    }

    @Override
    public Iterator<Annotation> annotations() {
        return super.annotations();
    }

    @Override
    public void resolveTypes(CompilationUnit astRoot) {
        super.resolveTypes(astRoot);
        this.setSuperClassQualifiedName(this.buildSuperClassQualifiedName(astRoot));
        Iterator<JavaResourcePersistentMember> stream = this.fields_();
        while (stream.hasNext()) {
            stream.next().resolveTypes(astRoot);
        }
        this.updateMethods(astRoot);
        stream = this.methods_();
        while (stream.hasNext()) {
            stream.next().resolveTypes(astRoot);
        }
        stream = this.nestedTypes_();
        while (stream.hasNext()) {
            ((JavaResourcePersistentType)stream.next()).resolveTypes(astRoot);
        }
    }

    public void toString(StringBuilder sb) {
        sb.append(this.name);
    }

    @Override
    public JavaResourcePersistentType getJavaPersistentTypeResource(String fullyQualifiedTypeName) {
        if (this.getQualifiedName().equals(fullyQualifiedTypeName)) {
            return this;
        }
        Iterator<JavaResourcePersistentType> stream = this.nestedTypes();
        while (stream.hasNext()) {
            JavaResourcePersistentType jrpt = stream.next();
            JavaResourcePersistentType nestedJRPT = jrpt.getJavaPersistentTypeResource(fullyQualifiedTypeName);
            if (nestedJRPT == null) continue;
            return nestedJRPT;
        }
        return null;
    }

    @Override
    public boolean hasAnyAttributeAnnotations() {
        Iterator<JavaResourcePersistentAttribute> stream = this.attributes();
        while (stream.hasNext()) {
            if (!stream.next().hasAnyAnnotation()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<JavaResourcePersistentType> nestedTypes() {
        return new FilteringIterator<JavaResourcePersistentType, JavaResourcePersistentType>(this.nestedTypes_()){

            protected boolean accept(JavaResourcePersistentType jrpt) {
                return jrpt.isPersistable();
            }
        };
    }

    protected Iterator<JavaResourcePersistentType> nestedTypes_() {
        return new CloneIterator(this.nestedTypes);
    }

    protected void addNestedType(JavaResourcePersistentType nestedType) {
        this.addItemToCollection(nestedType, this.nestedTypes, "nestedTypes");
    }

    protected void removeNestedType(JavaResourcePersistentType nestedType) {
        this.removeItemFromCollection(nestedType, this.nestedTypes, "nestedTypes");
    }

    protected void removeNestedTypes(Collection<JavaResourcePersistentType> remove) {
        this.removeItemsFromCollection(remove, this.nestedTypes, "nestedTypes");
    }

    protected JavaResourcePersistentType getNestedType(String typeName, int occurrence) {
        Iterator<JavaResourcePersistentType> stream = this.nestedTypes_();
        while (stream.hasNext()) {
            JavaResourcePersistentType nestedType = stream.next();
            if (!nestedType.isFor(typeName, occurrence)) continue;
            return nestedType;
        }
        return null;
    }

    @Override
    public Iterator<JavaResourcePersistentAttribute> attributes() {
        return JavaResourcePersistentTypeImpl.persistableMembers(this.attributes_());
    }

    protected Iterator<JavaResourcePersistentAttribute> attributes_() {
        return new CompositeIterator(new Iterator[]{this.fields_(), this.methods_()});
    }

    @Override
    public Iterator<JavaResourcePersistentAttribute> fields() {
        return JavaResourcePersistentTypeImpl.persistableMembers(this.fields_());
    }

    protected Iterator<JavaResourcePersistentAttribute> fields_() {
        return new CloneIterator(this.fields);
    }

    protected void addField(JavaResourcePersistentAttribute attribute) {
        this.addItemToCollection(attribute, this.fields, "attributes");
    }

    protected void removeField(JavaResourcePersistentAttribute attribute) {
        this.removeItemFromCollection(attribute, this.fields, "attributes");
    }

    protected void removeFields(Collection<JavaResourcePersistentAttribute> remove) {
        this.removeItemsFromCollection(remove, this.fields, "attributes");
    }

    protected JavaResourcePersistentAttribute getField(String fieldName, int occurrence) {
        Iterator<JavaResourcePersistentAttribute> stream = this.fields_();
        while (stream.hasNext()) {
            JavaResourcePersistentAttribute field = stream.next();
            if (!field.isFor(fieldName, occurrence)) continue;
            return field;
        }
        return null;
    }

    @Override
    public Iterator<JavaResourcePersistentAttribute> properties() {
        return JavaResourcePersistentTypeImpl.persistableMembers(this.methods_());
    }

    protected Iterator<JavaResourcePersistentAttribute> methods_() {
        return new CloneIterator(this.methods);
    }

    protected void addMethod(JavaResourcePersistentAttribute attribute) {
        this.addItemToCollection(attribute, this.methods, "attributes");
    }

    protected void removeMethod(JavaResourcePersistentAttribute attribute) {
        this.removeItemFromCollection(attribute, this.methods, "attributes");
    }

    protected void removeMethods(Collection<JavaResourcePersistentAttribute> remove) {
        this.removeItemsFromCollection(remove, this.methods, "attributes");
    }

    protected JavaResourcePersistentAttribute getMethod(MethodSignature signature, int occurrence) {
        Iterator<JavaResourcePersistentAttribute> stream = this.methods_();
        while (stream.hasNext()) {
            JavaResourcePersistentAttribute method = stream.next();
            if (!method.isFor(signature, occurrence)) continue;
            return method;
        }
        return null;
    }

    @Override
    public String getQualifiedName() {
        return this.qualifiedName;
    }

    protected void setQualifiedName(String qualifiedName) {
        String old = this.qualifiedName;
        this.qualifiedName = qualifiedName;
        this.firePropertyChanged("qualifiedName", old, qualifiedName);
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected void setName(String name) {
        String old = this.name;
        this.name = name;
        this.firePropertyChanged("name", old, name);
    }

    @Override
    public String getSuperClassQualifiedName() {
        return this.superClassQualifiedName;
    }

    protected void setSuperClassQualifiedName(String superClassQualifiedName) {
        String old = this.superClassQualifiedName;
        this.superClassQualifiedName = superClassQualifiedName;
        this.firePropertyChanged("superClassQualifiedName", old, superClassQualifiedName);
    }

    @Override
    public boolean isAbstract() {
        return this.abstract_;
    }

    protected void setAbstract(boolean abstract_) {
        boolean old = this.abstract_;
        this.abstract_ = abstract_;
        this.firePropertyChanged("abstract", old, abstract_);
    }

    @Override
    public AccessType getAccess() {
        return this.accessType;
    }

    protected void setAccess(AccessType accessType) {
        AccessType old = this.accessType;
        this.accessType = accessType;
        this.firePropertyChanged("access", (Object)old, (Object)accessType);
    }

    @Override
    public void update(CompilationUnit astRoot) {
        super.update(astRoot);
        this.setQualifiedName(this.buildQualifiedName(astRoot));
        this.setName(this.buildName(astRoot));
        this.setSuperClassQualifiedName(this.buildSuperClassQualifiedName(astRoot));
        this.setAbstract(this.buildAbstract(astRoot));
        this.updateNestedTypes(astRoot);
        this.updateFields(astRoot);
        this.updateMethods(astRoot);
        this.setAccess(this.buildAccessType());
    }

    protected void updateNestedTypes(CompilationUnit astRoot) {
        CounterMap counters = new CounterMap();
        Vector nestedTypesToRemove = (Vector)this.nestedTypes.clone();
        TypeDeclaration[] typeDeclarationArray = ((Type)this.getMember()).getTypes(astRoot);
        int n = typeDeclarationArray.length;
        int n2 = 0;
        while (n2 < n) {
            int occurrence;
            TypeDeclaration typeDeclaration = typeDeclarationArray[n2];
            String tdName = typeDeclaration.getName().getFullyQualifiedName();
            JavaResourcePersistentType nestedType = this.getNestedType(tdName, occurrence = counters.increment(tdName));
            if (nestedType == null) {
                this.addNestedType(this.buildNestedType(typeDeclaration, occurrence, astRoot));
            } else {
                nestedTypesToRemove.remove(nestedType);
                nestedType.update(astRoot);
            }
            ++n2;
        }
        this.removeNestedTypes(nestedTypesToRemove);
    }

    protected void updateFields(CompilationUnit astRoot) {
        CounterMap counters = new CounterMap();
        Vector fieldsToRemove = (Vector)this.fields.clone();
        FieldDeclaration[] fieldDeclarationArray = ((Type)this.getMember()).getFields(astRoot);
        int n = fieldDeclarationArray.length;
        int n2 = 0;
        while (n2 < n) {
            FieldDeclaration fieldDeclaration = fieldDeclarationArray[n2];
            for (VariableDeclarationFragment fragment : JavaResourcePersistentTypeImpl.fragments(fieldDeclaration)) {
                int occurrence;
                String fieldName = fragment.getName().getFullyQualifiedName();
                JavaResourcePersistentAttribute field = this.getField(fieldName, occurrence = counters.increment(fieldName));
                if (field == null) {
                    this.addField(this.buildField(fieldName, occurrence, astRoot));
                    continue;
                }
                fieldsToRemove.remove(field);
                field.update(astRoot);
            }
            ++n2;
        }
        this.removeFields(fieldsToRemove);
    }

    protected void updateMethods(CompilationUnit astRoot) {
        CounterMap counters = new CounterMap();
        Vector methodsToRemove = (Vector)this.methods.clone();
        MethodDeclaration[] methodDeclarationArray = ((Type)this.getMember()).getMethods(astRoot);
        int n = methodDeclarationArray.length;
        int n2 = 0;
        while (n2 < n) {
            int occurrence;
            MethodDeclaration methodDeclaration = methodDeclarationArray[n2];
            MethodSignature signature = JDTTools.buildMethodSignature(methodDeclaration);
            JavaResourcePersistentAttribute method = this.getMethod(signature, occurrence = counters.increment(signature));
            if (method == null) {
                this.addMethod(this.buildMethod(signature, occurrence, astRoot));
            } else {
                methodsToRemove.remove(method);
                method.update(astRoot);
            }
            ++n2;
        }
        this.removeMethods(methodsToRemove);
    }

    protected String buildQualifiedName(CompilationUnit astRoot) {
        return ((Type)this.getMember()).getBinding(astRoot).getQualifiedName();
    }

    protected String buildName(CompilationUnit astRoot) {
        return ((Type)this.getMember()).getBinding(astRoot).getName();
    }

    protected String buildSuperClassQualifiedName(CompilationUnit astRoot) {
        ITypeBinding typeBinding = ((Type)this.getMember()).getBinding(astRoot);
        if (typeBinding == null) {
            return null;
        }
        ITypeBinding superClassTypeBinding = typeBinding.getSuperclass();
        if (superClassTypeBinding == null) {
            return null;
        }
        return superClassTypeBinding.getTypeDeclaration().getQualifiedName();
    }

    protected boolean buildAbstract(CompilationUnit astRoot) {
        return Modifier.isAbstract((int)((Type)this.getMember()).getBinding(astRoot).getModifiers());
    }

    protected JavaResourcePersistentType buildNestedType(TypeDeclaration nestedTypeDeclaration, int occurrence, CompilationUnit astRoot) {
        return JavaResourcePersistentTypeImpl.newInstance(this.getJpaCompilationUnit(), (Type)this.getMember(), nestedTypeDeclaration, occurrence, astRoot);
    }

    protected JavaResourcePersistentAttribute buildField(String fieldName, int occurrence, CompilationUnit astRoot) {
        return JavaResourcePersistentAttributeImpl.newInstance((JavaResourcePersistentType)this, (Type)this.getMember(), fieldName, occurrence, this.getJpaCompilationUnit(), astRoot);
    }

    protected JavaResourcePersistentAttribute buildMethod(MethodSignature signature, int occurrence, CompilationUnit astRoot) {
        return JavaResourcePersistentAttributeImpl.newInstance((JavaResourcePersistentType)this, (Type)this.getMember(), signature, occurrence, this.getJpaCompilationUnit(), astRoot);
    }

    protected AccessType buildAccessType() {
        boolean hasPersistableFields = false;
        boolean hasPersistableProperties = false;
        for (JavaResourcePersistentAttribute field : CollectionTools.iterable(this.fields())) {
            hasPersistableFields = true;
            if (!field.hasAnyAnnotation()) continue;
            return AccessType.FIELD;
        }
        for (JavaResourcePersistentAttribute property : CollectionTools.iterable(this.properties())) {
            hasPersistableProperties = true;
            if (!property.hasAnyAnnotation()) continue;
            return AccessType.PROPERTY;
        }
        if (hasPersistableProperties && !hasPersistableFields) {
            return AccessType.PROPERTY;
        }
        return null;
    }

    protected static List<VariableDeclarationFragment> fragments(FieldDeclaration fd) {
        return fd.fragments();
    }

    protected static class CounterMap {
        HashMap<Object, Counter> counters = new HashMap();

        protected CounterMap() {
        }

        int increment(Object o) {
            Counter counter = this.counters.get(o);
            if (counter == null) {
                counter = new Counter();
                this.counters.put(o, counter);
            }
            counter.increment();
            return counter.count();
        }
    }
}

