/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.resource.java;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.resource.java.AbstractJavaResourceNode;
import org.eclipse.jpt.core.internal.resource.java.ContainerAnnotationTools;
import org.eclipse.jpt.core.internal.resource.java.GeneratorImpl;
import org.eclipse.jpt.core.internal.resource.java.UniqueConstraintImpl;
import org.eclipse.jpt.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.resource.java.Annotation;
import org.eclipse.jpt.core.resource.java.AnnotationDefinition;
import org.eclipse.jpt.core.resource.java.ContainerAnnotation;
import org.eclipse.jpt.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentMember;
import org.eclipse.jpt.core.resource.java.NestableUniqueConstraint;
import org.eclipse.jpt.core.resource.java.TableGeneratorAnnotation;
import org.eclipse.jpt.core.resource.java.UniqueConstraintAnnotation;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.Member;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableGeneratorImpl
extends GeneratorImpl
implements TableGeneratorAnnotation {
    private final AnnotationElementAdapter<String> tableAdapter = this.buildAdapter(TABLE_ADAPTER);
    private final AnnotationElementAdapter<String> catalogAdapter = this.buildAdapter(CATALOG_ADAPTER);
    private final AnnotationElementAdapter<String> schemaAdapter = this.buildAdapter(SCHEMA_ADAPTER);
    private final AnnotationElementAdapter<String> pkColumnNameAdapter = this.buildAdapter(PK_COLUMN_NAME_ADAPTER);
    private final AnnotationElementAdapter<String> valueColumnNameAdapter = this.buildAdapter(VALUE_COLUMN_NAME_ADAPTER);
    private final AnnotationElementAdapter<String> pkColumnValueAdapter = this.buildAdapter(PK_COLUMN_VALUE_ADAPTER);
    public static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.persistence.TableGenerator");
    private static final DeclarationAnnotationElementAdapter<String> NAME_ADAPTER = TableGeneratorImpl.buildAdapter("name");
    private static final DeclarationAnnotationElementAdapter<Integer> INITIAL_VALUE_ADAPTER = TableGeneratorImpl.buildIntegerAdapter("initialValue");
    private static final DeclarationAnnotationElementAdapter<Integer> ALLOCATION_SIZE_ADAPTER = TableGeneratorImpl.buildIntegerAdapter("allocationSize");
    private static final DeclarationAnnotationElementAdapter<String> TABLE_ADAPTER = TableGeneratorImpl.buildAdapter("table");
    private static final DeclarationAnnotationElementAdapter<String> CATALOG_ADAPTER = TableGeneratorImpl.buildAdapter("catalog");
    private static final DeclarationAnnotationElementAdapter<String> SCHEMA_ADAPTER = TableGeneratorImpl.buildAdapter("schema");
    private static final DeclarationAnnotationElementAdapter<String> PK_COLUMN_NAME_ADAPTER = TableGeneratorImpl.buildAdapter("pkColumnName");
    private static final DeclarationAnnotationElementAdapter<String> VALUE_COLUMN_NAME_ADAPTER = TableGeneratorImpl.buildAdapter("valueColumnName");
    private static final DeclarationAnnotationElementAdapter<String> PK_COLUMN_VALUE_ADAPTER = TableGeneratorImpl.buildAdapter("pkColumnValue");
    private String table;
    private String catalog;
    private String schema;
    private String pkColumnName;
    private String valueColumnName;
    private String pkColumnValue;
    final List<NestableUniqueConstraint> uniqueConstraints = new ArrayList<NestableUniqueConstraint>();
    private final UniqueConstraintsContainerAnnotation uniqueConstraintsContainerAnnotation = new UniqueConstraintsContainerAnnotation();

    protected TableGeneratorImpl(JavaResourceNode parent, Member member) {
        super(parent, member, DECLARATION_ANNOTATION_ADAPTER);
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        super.initialize(astRoot);
        this.table = this.table(astRoot);
        this.catalog = this.catalog(astRoot);
        this.schema = this.schema(astRoot);
        this.pkColumnName = this.pkColumnName(astRoot);
        this.valueColumnName = this.valueColumnName(astRoot);
        this.pkColumnValue = this.pkColumnValue(astRoot);
        ContainerAnnotationTools.initializeNestedAnnotations(astRoot, this.uniqueConstraintsContainerAnnotation);
    }

    @Override
    public String getAnnotationName() {
        return "javax.persistence.TableGenerator";
    }

    @Override
    protected DeclarationAnnotationElementAdapter<Integer> getAllocationSizeAdapter() {
        return ALLOCATION_SIZE_ADAPTER;
    }

    @Override
    protected DeclarationAnnotationElementAdapter<Integer> getInitialValueAdapter() {
        return INITIAL_VALUE_ADAPTER;
    }

    @Override
    protected DeclarationAnnotationElementAdapter<String> getNameAdapter() {
        return NAME_ADAPTER;
    }

    @Override
    public String getTable() {
        return this.table;
    }

    @Override
    public void setTable(String newTable) {
        if (this.attributeValueHasNotChanged(this.table, newTable)) {
            return;
        }
        String oldTable = this.table;
        this.table = newTable;
        this.tableAdapter.setValue(newTable);
        this.firePropertyChanged("table", oldTable, newTable);
    }

    @Override
    public String getCatalog() {
        return this.catalog;
    }

    @Override
    public void setCatalog(String newCatalog) {
        if (this.attributeValueHasNotChanged(this.catalog, newCatalog)) {
            return;
        }
        String oldCatalog = this.catalog;
        this.catalog = newCatalog;
        this.catalogAdapter.setValue(newCatalog);
        this.firePropertyChanged("catalog", oldCatalog, newCatalog);
    }

    @Override
    public String getSchema() {
        return this.schema;
    }

    @Override
    public void setSchema(String newSchema) {
        if (this.attributeValueHasNotChanged(this.schema, newSchema)) {
            return;
        }
        String oldSchema = this.schema;
        this.schema = newSchema;
        this.schemaAdapter.setValue(newSchema);
        this.firePropertyChanged("schema", oldSchema, newSchema);
    }

    @Override
    public String getPkColumnName() {
        return this.pkColumnName;
    }

    @Override
    public void setPkColumnName(String newPkColumnName) {
        if (this.attributeValueHasNotChanged(this.pkColumnName, newPkColumnName)) {
            return;
        }
        String oldPkColumnName = this.pkColumnName;
        this.pkColumnName = newPkColumnName;
        this.pkColumnNameAdapter.setValue(newPkColumnName);
        this.firePropertyChanged("pkColumnName", oldPkColumnName, newPkColumnName);
    }

    @Override
    public String getValueColumnName() {
        return this.valueColumnName;
    }

    @Override
    public void setValueColumnName(String newValueColumnName) {
        if (this.attributeValueHasNotChanged(this.valueColumnName, newValueColumnName)) {
            return;
        }
        String oldValueColumnName = this.valueColumnName;
        this.valueColumnName = newValueColumnName;
        this.valueColumnNameAdapter.setValue(newValueColumnName);
        this.firePropertyChanged("valueColumnName", oldValueColumnName, newValueColumnName);
    }

    @Override
    public String getPkColumnValue() {
        return this.pkColumnValue;
    }

    @Override
    public void setPkColumnValue(String newPkColumnValue) {
        if (this.attributeValueHasNotChanged(this.pkColumnValue, newPkColumnValue)) {
            return;
        }
        String oldPkColumnValue = this.pkColumnValue;
        this.pkColumnValue = newPkColumnValue;
        this.pkColumnValueAdapter.setValue(newPkColumnValue);
        this.firePropertyChanged("pkColumnValue", oldPkColumnValue, newPkColumnValue);
    }

    @Override
    public ListIterator<UniqueConstraintAnnotation> uniqueConstraints() {
        return new CloneListIterator(this.uniqueConstraints);
    }

    @Override
    public int uniqueConstraintsSize() {
        return this.uniqueConstraints.size();
    }

    @Override
    public NestableUniqueConstraint uniqueConstraintAt(int index) {
        return this.uniqueConstraints.get(index);
    }

    @Override
    public int indexOfUniqueConstraint(UniqueConstraintAnnotation uniqueConstraint) {
        return this.uniqueConstraints.indexOf(uniqueConstraint);
    }

    @Override
    public NestableUniqueConstraint addUniqueConstraint(int index) {
        NestableUniqueConstraint uniqueConstraint = (NestableUniqueConstraint)ContainerAnnotationTools.addNestedAnnotation(index, this.uniqueConstraintsContainerAnnotation);
        this.fireItemAdded("uniqueConstraints", index, uniqueConstraint);
        return uniqueConstraint;
    }

    protected void addUniqueConstraint(int index, NestableUniqueConstraint uniqueConstraint) {
        this.addItemToList(index, uniqueConstraint, this.uniqueConstraints, "uniqueConstraints");
    }

    @Override
    public void removeUniqueConstraint(int index) {
        NestableUniqueConstraint uniqueConstraint = this.uniqueConstraints.get(index);
        this.removeUniqueConstraint(uniqueConstraint);
        uniqueConstraint.removeAnnotation();
        this.synchUniqueConstraintAnnotationsAfterRemove(index);
    }

    protected void removeUniqueConstraint(NestableUniqueConstraint uniqueConstraint) {
        this.removeItemFromList(uniqueConstraint, this.uniqueConstraints, "uniqueConstraints");
    }

    @Override
    public void moveUniqueConstraint(int targetIndex, int sourceIndex) {
        this.moveUniqueConstraintInternal(targetIndex, sourceIndex);
        ContainerAnnotationTools.synchAnnotationsAfterMove(targetIndex, sourceIndex, this.uniqueConstraintsContainerAnnotation);
        this.fireItemMoved("uniqueConstraints", targetIndex, sourceIndex);
    }

    protected void moveUniqueConstraintInternal(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.uniqueConstraints, (int)targetIndex, (int)sourceIndex);
    }

    private void synchUniqueConstraintAnnotationsAfterRemove(int index) {
        ContainerAnnotationTools.synchAnnotationsAfterRemove(index, this.uniqueConstraintsContainerAnnotation);
    }

    protected NestableUniqueConstraint createUniqueConstraint(int index) {
        return UniqueConstraintImpl.createTableGeneratorUniqueConstraint(this, this.getMember(), index);
    }

    @Override
    public TextRange getTableTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(TABLE_ADAPTER, astRoot);
    }

    @Override
    public boolean tableTouches(int pos, CompilationUnit astRoot) {
        return this.elementTouches(TABLE_ADAPTER, pos, astRoot);
    }

    @Override
    public TextRange getCatalogTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(CATALOG_ADAPTER, astRoot);
    }

    @Override
    public boolean catalogTouches(int pos, CompilationUnit astRoot) {
        return this.elementTouches(CATALOG_ADAPTER, pos, astRoot);
    }

    @Override
    public TextRange getSchemaTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(SCHEMA_ADAPTER, astRoot);
    }

    @Override
    public boolean schemaTouches(int pos, CompilationUnit astRoot) {
        return this.elementTouches(SCHEMA_ADAPTER, pos, astRoot);
    }

    @Override
    public TextRange getPkColumnNameTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(PK_COLUMN_NAME_ADAPTER, astRoot);
    }

    @Override
    public boolean pkColumnNameTouches(int pos, CompilationUnit astRoot) {
        return this.elementTouches(PK_COLUMN_NAME_ADAPTER, pos, astRoot);
    }

    @Override
    public TextRange getPkColumnValueTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(PK_COLUMN_VALUE_ADAPTER, astRoot);
    }

    @Override
    public boolean pkColumnValueTouches(int pos, CompilationUnit astRoot) {
        return this.elementTouches(PK_COLUMN_VALUE_ADAPTER, pos, astRoot);
    }

    @Override
    public TextRange getValueColumnNameTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(VALUE_COLUMN_NAME_ADAPTER, astRoot);
    }

    @Override
    public boolean valueColumnNameTouches(int pos, CompilationUnit astRoot) {
        return this.elementTouches(VALUE_COLUMN_NAME_ADAPTER, pos, astRoot);
    }

    @Override
    public void update(CompilationUnit astRoot) {
        super.update(astRoot);
        this.setTable(this.table(astRoot));
        this.setCatalog(this.catalog(astRoot));
        this.setSchema(this.schema(astRoot));
        this.setPkColumnName(this.pkColumnName(astRoot));
        this.setValueColumnName(this.valueColumnName(astRoot));
        this.setPkColumnValue(this.pkColumnValue(astRoot));
        this.updateUniqueConstraintsFromJava(astRoot);
    }

    protected String table(CompilationUnit astRoot) {
        return this.tableAdapter.getValue(astRoot);
    }

    protected String catalog(CompilationUnit astRoot) {
        return this.catalogAdapter.getValue(astRoot);
    }

    protected String schema(CompilationUnit astRoot) {
        return this.schemaAdapter.getValue(astRoot);
    }

    protected String pkColumnName(CompilationUnit astRoot) {
        return this.pkColumnNameAdapter.getValue(astRoot);
    }

    protected String valueColumnName(CompilationUnit astRoot) {
        return this.valueColumnNameAdapter.getValue(astRoot);
    }

    protected String pkColumnValue(CompilationUnit astRoot) {
        return this.pkColumnValueAdapter.getValue(astRoot);
    }

    private void updateUniqueConstraintsFromJava(CompilationUnit astRoot) {
        ContainerAnnotationTools.updateNestedAnnotationsFromJava(astRoot, this.uniqueConstraintsContainerAnnotation);
    }

    private static DeclarationAnnotationElementAdapter<String> buildAdapter(String elementName) {
        return TableGeneratorImpl.buildAdapter(DECLARATION_ANNOTATION_ADAPTER, elementName);
    }

    private static DeclarationAnnotationElementAdapter<Integer> buildIntegerAdapter(String elementName) {
        return TableGeneratorImpl.buildIntegerAdapter(DECLARATION_ANNOTATION_ADAPTER, elementName);
    }

    public static class TableGeneratorAnnotationDefinition
    implements AnnotationDefinition {
        private static final TableGeneratorAnnotationDefinition INSTANCE = new TableGeneratorAnnotationDefinition();

        public static AnnotationDefinition instance() {
            return INSTANCE;
        }

        private TableGeneratorAnnotationDefinition() {
        }

        public Annotation buildAnnotation(JavaResourcePersistentMember parent, Member member) {
            return new TableGeneratorImpl(parent, member);
        }

        public Annotation buildNullAnnotation(JavaResourcePersistentMember parent, Member member) {
            return null;
        }

        public String getAnnotationName() {
            return "javax.persistence.TableGenerator";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class UniqueConstraintsContainerAnnotation
    extends AbstractJavaResourceNode
    implements ContainerAnnotation<NestableUniqueConstraint> {
        public UniqueConstraintsContainerAnnotation() {
            super(TableGeneratorImpl.this);
        }

        @Override
        public void initialize(CompilationUnit astRoot) {
        }

        @Override
        public NestableUniqueConstraint addInternal(int index) {
            NestableUniqueConstraint uniqueConstraint = TableGeneratorImpl.this.createUniqueConstraint(index);
            TableGeneratorImpl.this.uniqueConstraints.add(index, uniqueConstraint);
            return uniqueConstraint;
        }

        @Override
        public NestableUniqueConstraint add(int index) {
            NestableUniqueConstraint uniqueConstraint = TableGeneratorImpl.this.createUniqueConstraint(index);
            TableGeneratorImpl.this.addUniqueConstraint(index, uniqueConstraint);
            return uniqueConstraint;
        }

        @Override
        public String getAnnotationName() {
            return TableGeneratorImpl.this.getAnnotationName();
        }

        @Override
        public String getNestableAnnotationName() {
            return "javax.persistence.UniqueConstraint";
        }

        @Override
        public int indexOf(NestableUniqueConstraint uniqueConstraint) {
            return TableGeneratorImpl.this.indexOfUniqueConstraint(uniqueConstraint);
        }

        @Override
        public void move(int targetIndex, int sourceIndex) {
            TableGeneratorImpl.this.moveUniqueConstraint(targetIndex, sourceIndex);
        }

        @Override
        public void moveInternal(int targetIndex, int sourceIndex) {
            TableGeneratorImpl.this.moveUniqueConstraintInternal(targetIndex, sourceIndex);
        }

        @Override
        public NestableUniqueConstraint nestedAnnotationAt(int index) {
            return TableGeneratorImpl.this.uniqueConstraintAt(index);
        }

        @Override
        public NestableUniqueConstraint nestedAnnotationFor(org.eclipse.jdt.core.dom.Annotation jdtAnnotation) {
            for (NestableUniqueConstraint uniqueConstraint : CollectionTools.iterable(this.nestedAnnotations())) {
                if (jdtAnnotation != uniqueConstraint.getJdtAnnotation((CompilationUnit)jdtAnnotation.getRoot())) continue;
                return uniqueConstraint;
            }
            return null;
        }

        @Override
        public ListIterator<NestableUniqueConstraint> nestedAnnotations() {
            return new CloneListIterator(TableGeneratorImpl.this.uniqueConstraints);
        }

        @Override
        public int nestedAnnotationsSize() {
            return TableGeneratorImpl.this.uniqueConstraints.size();
        }

        @Override
        public void remove(NestableUniqueConstraint uniqueConstraint) {
            TableGeneratorImpl.this.removeUniqueConstraint(uniqueConstraint);
        }

        @Override
        public void remove(int index) {
            this.remove(this.nestedAnnotationAt(index));
        }

        @Override
        public org.eclipse.jdt.core.dom.Annotation getJdtAnnotation(CompilationUnit astRoot) {
            return TableGeneratorImpl.this.getJdtAnnotation(astRoot);
        }

        @Override
        public void newAnnotation() {
            TableGeneratorImpl.this.newAnnotation();
        }

        @Override
        public void removeAnnotation() {
            TableGeneratorImpl.this.removeAnnotation();
        }

        @Override
        public void update(CompilationUnit astRoot) {
            TableGeneratorImpl.this.update(astRoot);
        }

        @Override
        public TextRange getTextRange(CompilationUnit astRoot) {
            return TableGeneratorImpl.this.getTextRange(astRoot);
        }

        @Override
        public String getElementName() {
            return "uniqueConstraints";
        }
    }
}

