/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.synch;

import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.core.JptCorePlugin;
import org.eclipse.jpt.core.context.persistence.MappingFileRef;
import org.eclipse.jpt.core.context.persistence.Persistence;
import org.eclipse.jpt.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.core.context.persistence.PersistenceXml;
import org.eclipse.jpt.core.internal.JptCoreMessages;
import org.eclipse.jpt.core.internal.resource.persistence.PersistenceResourceModelProvider;
import org.eclipse.jpt.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.core.resource.persistence.PersistenceResource;
import org.eclipse.jpt.core.resource.persistence.XmlJavaClassRef;
import org.eclipse.jpt.core.resource.persistence.XmlPersistence;
import org.eclipse.jpt.core.resource.persistence.XmlPersistenceUnit;
import org.eclipse.jpt.utility.internal.CollectionTools;

public class SynchronizeClassesJob
extends WorkspaceJob {
    private IFile persistenceXmlFile;

    public SynchronizeClassesJob(IFile file) {
        super(JptCoreMessages.SYNCHRONIZE_CLASSES_JOB);
        this.setRule((ISchedulingRule)file.getProject());
        this.persistenceXmlFile = file;
    }

    public IStatus runInWorkspace(final IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(JptCoreMessages.SYNCHRONIZING_CLASSES_TASK, 200);
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        final JpaProject jpaProject = JptCorePlugin.getJpaProject(this.persistenceXmlFile.getProject());
        PersistenceResourceModelProvider modelProvider = PersistenceResourceModelProvider.getDefaultModelProvider(jpaProject.getProject());
        final PersistenceResource resource = modelProvider.getResource();
        monitor.worked(25);
        modelProvider.modify(new Runnable(){

            public void run() {
                XmlPersistenceUnit persistenceUnit;
                XmlPersistence persistence = resource.getPersistence();
                if (persistence == null) {
                    persistence = PersistenceFactory.eINSTANCE.createXmlPersistence();
                    resource.getContents().add((Object)persistence);
                }
                if (persistence.getPersistenceUnits().size() > 0) {
                    persistenceUnit = (XmlPersistenceUnit)persistence.getPersistenceUnits().get(0);
                } else {
                    persistenceUnit = PersistenceFactory.eINSTANCE.createXmlPersistenceUnit();
                    persistenceUnit.setName(jpaProject.getName());
                    persistence.getPersistenceUnits().add((Object)persistenceUnit);
                }
                persistenceUnit.getClasses().clear();
                monitor.worked(25);
                Iterator<String> stream = jpaProject.annotatedClassNames();
                while (stream.hasNext()) {
                    String fullyQualifiedTypeName = stream.next();
                    if (SynchronizeClassesJob.this.mappingFileContains(jpaProject, fullyQualifiedTypeName)) continue;
                    XmlJavaClassRef classRef = PersistenceFactory.eINSTANCE.createXmlJavaClassRef();
                    classRef.setJavaClass(fullyQualifiedTypeName);
                    persistenceUnit.getClasses().add((Object)classRef);
                }
                monitor.worked(100);
            }
        });
        monitor.done();
        return Status.OK_STATUS;
    }

    private boolean mappingFileContains(JpaProject jpaProject, String fullyQualifiedTypeName) {
        PersistenceXml persistenceXml = jpaProject.getRootContextNode().getPersistenceXml();
        if (persistenceXml == null) {
            return false;
        }
        Persistence persistence = persistenceXml.getPersistence();
        if (persistence == null) {
            return false;
        }
        if (persistence.persistenceUnitsSize() == 0) {
            return false;
        }
        PersistenceUnit persistenceUnit = persistence.persistenceUnits().next();
        for (MappingFileRef mappingFileRef : CollectionTools.iterable(persistenceUnit.mappingFileRefs())) {
            if (mappingFileRef.getPersistentType(fullyQualifiedTypeName) == null) continue;
            return true;
        }
        return false;
    }
}

