/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.resource;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.jem.util.emf.workbench.FlexibleProjectResourceSet;
import org.eclipse.jem.util.emf.workbench.ProjectResourceSet;
import org.eclipse.jem.util.emf.workbench.WorkbenchResourceHelperBase;
import org.eclipse.jpt.core.JptCorePlugin;
import org.eclipse.jpt.core.resource.JpaResourceModelProvider;
import org.eclipse.jpt.core.resource.JpaResourceModelProviderEvent;
import org.eclipse.jpt.core.resource.JpaResourceModelProviderListener;
import org.eclipse.jpt.core.resource.common.JpaXmlResource;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.wst.common.componentcore.internal.impl.ModuleURIUtil;
import org.eclipse.wst.common.componentcore.internal.impl.WTPResourceFactoryRegistry;
import org.eclipse.wst.common.internal.emf.resource.ReferencedResource;
import org.eclipse.wst.common.internal.emfworkbench.WorkbenchResourceHelper;
import org.eclipse.wst.common.internal.emfworkbench.validateedit.ResourceStateInputProvider;
import org.eclipse.wst.common.internal.emfworkbench.validateedit.ResourceStateValidator;
import org.eclipse.wst.common.internal.emfworkbench.validateedit.ResourceStateValidatorImpl;
import org.eclipse.wst.common.internal.emfworkbench.validateedit.ResourceStateValidatorPresenter;

public abstract class AbstractResourceModelProvider
implements JpaResourceModelProvider,
ResourceStateInputProvider,
ResourceStateValidator {
    protected IProject project;
    protected URI fileUri;
    protected JpaXmlResource resource;
    protected final ResourceAdapter resourceAdapter = new ResourceAdapter();
    protected final ListenerList listeners = new ListenerList();
    protected ResourceStateValidator stateValidator;

    public AbstractResourceModelProvider(IProject project, IPath resourcePath) {
        this.project = project;
        this.fileUri = this.buildFileUri(resourcePath);
    }

    protected URI buildFileUri(IPath resourcePath) {
        URI resourceUri = URI.createURI((String)resourcePath.toString());
        if (StringTools.stringIsEmpty((String)resourceUri.scheme())) {
            resourceUri = this.getModuleURI(resourceUri);
        }
        URIConverter uriConverter = this.getResourceSet().getURIConverter();
        return uriConverter.normalize(resourceUri);
    }

    public JpaXmlResource getResource() {
        if (this.resource == null) {
            try {
                this.resource = (JpaXmlResource)WorkbenchResourceHelper.getOrCreateResource((URI)this.fileUri, (ResourceSet)this.getResourceSet());
            }
            catch (ClassCastException classCastException) {
                Resource.Factory resourceFactory = WTPResourceFactoryRegistry.INSTANCE.getFactory(this.fileUri, this.getContentType(this.getContentTypeDescriber()));
                this.resource = (JpaXmlResource)((FlexibleProjectResourceSet)this.getResourceSet()).createResource(this.fileUri, resourceFactory);
            }
            if (this.resource != null) {
                this.resource.eAdapters().add((Object)this.resourceAdapter);
            }
        }
        return this.resource;
    }

    public JpaXmlResource createResource() throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                JpaXmlResource aResource = AbstractResourceModelProvider.this.getResource();
                if (!aResource.exists() && aResource.getContents().isEmpty()) {
                    AbstractResourceModelProvider.this.populateRoot(aResource);
                    try {
                        aResource.saveIfNecessary();
                    }
                    catch (Exception e) {
                        JptCorePlugin.log(e);
                    }
                }
            }
        };
        workspace.run(runnable, (ISchedulingRule)workspace.getRoot(), 1, (IProgressMonitor)new NullProgressMonitor());
        return this.resource;
    }

    protected URI getModuleURI(URI uri) {
        URI moduleuri = ModuleURIUtil.fullyQualifyURI((IProject)this.project);
        IPath requestPath = new Path(moduleuri.path()).append((IPath)new Path(uri.path()));
        URI resourceURI = URI.createURI((String)("module:" + requestPath.toString()));
        return resourceURI;
    }

    protected IContentDescription getContentType(String contentTypeDescriber) {
        if (contentTypeDescriber != null) {
            return Platform.getContentTypeManager().getContentType(contentTypeDescriber).getDefaultDescription();
        }
        return null;
    }

    protected String getContentTypeDescriber() {
        return null;
    }

    protected void populateRoot(JpaXmlResource resource) {
    }

    public void addListener(JpaResourceModelProviderListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeListener(JpaResourceModelProviderListener listener) {
        this.listeners.remove((Object)listener);
    }

    public boolean hasListeners() {
        return !this.listeners.isEmpty();
    }

    protected ProjectResourceSet getResourceSet() {
        return (ProjectResourceSet)WorkbenchResourceHelperBase.getResourceSet((IProject)this.project);
    }

    public IProject getProject() {
        return this.project;
    }

    protected void resourceIsLoadedChanged(Resource aResource, boolean oldValue, boolean newValue) {
        if (this.hasListeners()) {
            int eventType = newValue ? 1 : 2;
            JpaResourceModelProviderEvent evt = new JpaResourceModelProviderEvent(this, eventType);
            this.notifyListeners(evt);
        }
    }

    protected void notifyListeners(JpaResourceModelProviderEvent event) {
        NotifyRunner notifier = new NotifyRunner(event);
        Object[] notifyList = this.listeners.getListeners();
        int i = 0;
        while (i < notifyList.length) {
            notifier.setListener((JpaResourceModelProviderListener)notifyList[i]);
            SafeRunner.run((ISafeRunnable)notifier);
            ++i;
        }
    }

    public IStatus validateEdit(Object context) {
        IWorkspace work = ResourcesPlugin.getWorkspace();
        IFile file = WorkbenchResourceHelper.getFile((ReferencedResource)this.resource);
        if (file != null) {
            IFile[] files = new IFile[]{file};
            if (context == null) {
                context = IWorkspace.VALIDATE_PROMPT;
            }
            return work.validateEdit(files, context);
        }
        return Status.OK_STATUS;
    }

    public void modify(Runnable runnable) {
        try {
            runnable.run();
            try {
                if (this.resource != null) {
                    this.resource.save(Collections.EMPTY_MAP);
                }
            }
            catch (IOException ioe) {
                JptCorePlugin.log(ioe);
            }
        }
        catch (Exception e) {
            JptCorePlugin.log(e);
        }
    }

    public ResourceStateValidator getStateValidator() {
        if (this.stateValidator == null) {
            this.stateValidator = this.createStateValidator();
        }
        return this.stateValidator;
    }

    private ResourceStateValidator createStateValidator() {
        return new ResourceStateValidatorImpl((ResourceStateInputProvider)this);
    }

    public void checkActivation(ResourceStateValidatorPresenter presenter) throws CoreException {
        this.getStateValidator().checkActivation(presenter);
    }

    public void lostActivation(ResourceStateValidatorPresenter presenter) throws CoreException {
        this.getStateValidator().lostActivation(presenter);
    }

    public IStatus validateState(ResourceStateValidatorPresenter presenter) throws CoreException {
        if (presenter == null) {
            return Status.OK_STATUS;
        }
        return this.getStateValidator().validateState(presenter);
    }

    public boolean checkSave(ResourceStateValidatorPresenter presenter) throws CoreException {
        return this.getStateValidator().checkSave(presenter);
    }

    public boolean checkReadOnly() {
        return this.getStateValidator().checkReadOnly();
    }

    public boolean isDirty() {
        return this.resource.isModified();
    }

    public List getNonResourceFiles() {
        return Collections.emptyList();
    }

    public List getNonResourceInconsistentFiles() {
        return Collections.emptyList();
    }

    public List getResources() {
        return Collections.singletonList(this.getResource());
    }

    public void cacheNonResourceValidateState(List roNonResourceFiles) {
    }

    public class NotifyRunner
    implements ISafeRunnable {
        private final JpaResourceModelProviderEvent event;
        private JpaResourceModelProviderListener listener;

        public NotifyRunner(JpaResourceModelProviderEvent event) {
            Assert.isNotNull((Object)event);
            this.event = event;
        }

        public void setListener(JpaResourceModelProviderListener listener) {
            this.listener = listener;
        }

        public void run() throws Exception {
            if (this.listener != null) {
                this.listener.modelChanged(this.event);
            }
        }

        public void handleException(Throwable exception) {
            JptCorePlugin.log(exception);
        }
    }

    protected class ResourceAdapter
    extends AdapterImpl {
        protected ResourceAdapter() {
        }

        public void notifyChanged(Notification notification) {
            if (notification.getEventType() == 1 && notification.getFeatureID(null) == 4) {
                AbstractResourceModelProvider.this.resourceIsLoadedChanged((Resource)notification.getNotifier(), notification.getOldBooleanValue(), notification.getNewBooleanValue());
            }
        }
    }
}

