/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.resource;

import java.io.IOException;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jpt.core.internal.resource.JpaResourceModelProviderRegistry;
import org.eclipse.jpt.core.resource.JpaResourceModelProvider;
import org.eclipse.jpt.core.resource.JpaResourceModelProviderFactory;
import org.eclipse.jpt.core.utility.PlatformUtilities;

public class JpaResourceModelProviderManager {
    private static HashMap<String, JpaResourceModelProviderFactory> factories;

    public static JpaResourceModelProvider getModelProvider(IFile file) throws CoreException, IOException {
        IProject project = file.getProject();
        IPath path = file.getProjectRelativePath();
        IContentType contentType = PlatformUtilities.contentType(file);
        if (contentType == null) {
            return null;
        }
        JpaResourceModelProvider modelProvider = null;
        while (modelProvider == null && contentType != null) {
            modelProvider = JpaResourceModelProviderManager.getModelProvider(project, path, contentType.getId());
            contentType = contentType.getBaseType();
        }
        return modelProvider;
    }

    public static JpaResourceModelProvider getModelProvider(IProject project, IPath filePath, String fileContentType) {
        JpaResourceModelProviderFactory factory = JpaResourceModelProviderManager.getFactory(fileContentType);
        if (factory != null) {
            return factory.create(project, filePath);
        }
        return null;
    }

    private static JpaResourceModelProviderFactory getFactory(String fileContentType) {
        if (factories == null) {
            factories = new HashMap();
        }
        if (factories.containsKey(fileContentType)) {
            return factories.get(fileContentType);
        }
        JpaResourceModelProviderFactory factory = JpaResourceModelProviderRegistry.instance().getResourceModelProviderFactory(fileContentType);
        if (factory != null) {
            factories.put(fileContentType, factory);
        }
        return factory;
    }
}

