/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.resource.common;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jem.util.emf.workbench.WorkbenchResourceHelperBase;
import org.eclipse.jpt.core.ResourceModelListener;
import org.eclipse.jpt.core.resource.common.JpaXmlResourceModel;
import org.eclipse.wst.common.internal.emf.resource.Renderer;
import org.eclipse.wst.common.internal.emf.resource.TranslatorResourceImpl;
import org.xml.sax.EntityResolver;

public abstract class JpaXmlResource
extends TranslatorResourceImpl {
    private EntityResolver entityResolver;
    protected JpaXmlResourceModel resourceModel;
    protected final Collection<ResourceModelListener> resourceModelListeners = new ArrayList<ResourceModelListener>();

    protected JpaXmlResource(Renderer aRenderer) {
        super(aRenderer);
    }

    protected JpaXmlResource(URI uri, Renderer aRenderer) {
        super(uri, aRenderer);
    }

    public void eNotify(Notification notification) {
        if (!notification.isTouch() && this.isLoaded()) {
            super.eNotify(notification);
            this.resourceChanged();
        }
    }

    protected String getDefaultPublicId() {
        return null;
    }

    protected String getDefaultSystemId() {
        return null;
    }

    protected int getDefaultVersionID() {
        return 10;
    }

    public String getDoctype() {
        return null;
    }

    public IFile getFile() {
        IFile file = null;
        file = this.getFile(this.getURI());
        if (file == null && this.getResourceSet() != null) {
            URIConverter converter = this.getResourceSet().getURIConverter();
            URI convertedUri = converter.normalize(this.getURI());
            if (!this.getURI().equals((Object)convertedUri)) {
                file = this.getFile(convertedUri);
            }
        }
        return file;
    }

    private IFile getFile(URI uri) {
        if (WorkbenchResourceHelperBase.isPlatformResourceURI((URI)uri)) {
            String fileString = URI.decode((String)uri.path());
            fileString = fileString.substring("resource".length() + 1);
            return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(fileString));
        }
        return null;
    }

    public boolean exists() {
        return this.getFile().exists();
    }

    public void javaElementChanged(ElementChangedEvent event) {
    }

    public JpaXmlResourceModel getResourceModel() {
        return this.resourceModel;
    }

    public void setResourceModel(JpaXmlResourceModel resourceModel) {
        this.resourceModel = resourceModel;
    }

    public void resourceChanged() {
        for (ResourceModelListener listener : this.resourceModelListeners) {
            listener.resourceModelChanged();
        }
    }

    public void addResourceModelChangeListener(ResourceModelListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener cannot be null");
        }
        this.resourceModelListeners.add(listener);
    }

    public void removeResourceModelChangeListener(ResourceModelListener listener) {
        if (!this.resourceModelListeners.contains(listener)) {
            throw new IllegalArgumentException("Listener " + listener + " was never added");
        }
        this.resourceModelListeners.add(listener);
    }
}

