/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal.core.patch;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.compare.internal.core.patch.FileDiff;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;

public class DiffProject {
    private IProject fProject;
    private Set fDiffs = new HashSet();

    public DiffProject(IProject project) {
        this.fProject = project;
    }

    public void add(FileDiff diff) {
        this.fDiffs.add(diff);
        if (diff.getProject() != this) {
            diff.setProject(this);
        }
    }

    public IProject getProject() {
        return this.fProject;
    }

    public String getName() {
        return this.fProject.getName();
    }

    public IFile getFile(IPath path) {
        return this.fProject.getFile(path);
    }

    public void remove(FileDiff diff) {
        this.fDiffs.remove(diff);
    }

    public boolean contains(FileDiff diff) {
        return this.fDiffs.contains(diff);
    }

    public FileDiff[] getFileDiffs() {
        return this.fDiffs.toArray(new FileDiff[this.fDiffs.size()]);
    }
}

