/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.ui.editor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeywordsDialog
extends Dialog {
    private final List<String> selectedKeywords;
    private final List<String> validKeywords;
    private CheckboxTableViewer keyWordsList;

    public KeywordsDialog(Shell shell, String selectedKeywords, List<String> validKeywords) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        StringTokenizer st = new StringTokenizer(selectedKeywords, ",", false);
        this.selectedKeywords = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String s = st.nextToken().trim();
            this.selectedKeywords.add(s);
        }
        this.validKeywords = validKeywords;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText("Select Keywords");
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        GridData gd = new GridData(1808);
        composite.setLayoutData((Object)gd);
        this.keyWordsList = CheckboxTableViewer.newCheckList((Composite)composite, (int)2562);
        GridData keyWordsTextData = new GridData(1808);
        keyWordsTextData.heightHint = 175;
        keyWordsTextData.widthHint = 160;
        this.keyWordsList.getTable().setLayoutData((Object)keyWordsTextData);
        if (this.validKeywords != null) {
            this.keyWordsList.setContentProvider((IContentProvider)new ITreeContentProvider(){

                public Object[] getChildren(Object parentElement) {
                    if (parentElement instanceof Collection) {
                        return ((Collection)parentElement).toArray();
                    }
                    return null;
                }

                public Object getParent(Object element) {
                    return null;
                }

                public boolean hasChildren(Object element) {
                    return false;
                }

                public Object[] getElements(Object inputElement) {
                    return this.getChildren(inputElement);
                }

                public void dispose() {
                }

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                }
            });
            HashSet<String> invalidKeywords = new HashSet<String>();
            this.keyWordsList.setInput(this.validKeywords);
            for (String keyword : this.selectedKeywords) {
                if (this.keyWordsList.setChecked((Object)keyword, true)) continue;
                invalidKeywords.add(keyword);
            }
            this.selectedKeywords.removeAll(invalidKeywords);
        }
        this.keyWordsList.addCheckStateListener((ICheckStateListener)new KeywordListener());
        parent.pack();
        return composite;
    }

    public List<String> getSelectedKeywords() {
        return this.selectedKeywords;
    }

    public String getSelectedKeywordsString() {
        StringBuffer keywords = new StringBuffer();
        for (String sel : this.selectedKeywords) {
            keywords.append(sel);
            keywords.append(",");
        }
        String keywordsString = keywords.toString();
        if (keywordsString.endsWith(",")) {
            keywordsString = keywordsString.substring(0, keywordsString.length() - 1);
        }
        return keywordsString;
    }

    protected class KeywordListener
    implements ICheckStateListener {
        protected KeywordListener() {
        }

        public void checkStateChanged(CheckStateChangedEvent event) {
            if (event.getChecked()) {
                KeywordsDialog.this.selectedKeywords.add((String)event.getElement());
            } else {
                KeywordsDialog.this.selectedKeywords.remove(event.getElement());
            }
        }
    }
}

