/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.DeviceResourceException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.connection.CVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.ui.CVSDecoration;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ui.SWTUtils;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class CVSDecoratorPreferencesPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    protected static final Collection ROOT;
    protected static final Map BINDINGS;
    protected static final Map FOLDER_BINDINGS;
    private TextDecoratorTab fTextTab;
    private IconDecoratorTab fIconTab;
    private GeneralTab fGeneralTab;
    private Preview fPreview;
    private ThemeListener fThemeListener;

    static {
        BINDINGS = new HashMap();
        BINDINGS.put("name", CVSUIMessages.CVSDecoratorPreferencesPage_22);
        BINDINGS.put("tag", CVSUIMessages.CVSDecoratorPreferencesPage_23);
        BINDINGS.put("keyword", CVSUIMessages.CVSDecoratorPreferencesPage_24);
        BINDINGS.put("revision", CVSUIMessages.CVSDecoratorPreferencesPage_25);
        BINDINGS.put("outgoing_change_flag", CVSUIMessages.CVSDecoratorPreferencesPage_26);
        BINDINGS.put("added_flag", CVSUIMessages.CVSDecoratorPreferencesPage_27);
        FOLDER_BINDINGS = new HashMap();
        FOLDER_BINDINGS.put("name", CVSUIMessages.CVSDecoratorPreferencesPage_28);
        FOLDER_BINDINGS.put("tag", CVSUIMessages.CVSDecoratorPreferencesPage_29);
        FOLDER_BINDINGS.put("host", CVSUIMessages.CVSDecoratorPreferencesPage_30);
        FOLDER_BINDINGS.put("method", CVSUIMessages.CVSDecoratorPreferencesPage_31);
        FOLDER_BINDINGS.put("user", CVSUIMessages.CVSDecoratorPreferencesPage_32);
        FOLDER_BINDINGS.put("root", CVSUIMessages.CVSDecoratorPreferencesPage_33);
        FOLDER_BINDINGS.put("repository", CVSUIMessages.CVSDecoratorPreferencesPage_34);
        FOLDER_BINDINGS.put("label", CVSUIMessages.CVSDecoratorPreferencesPage_38);
        FOLDER_BINDINGS.put("outgoing_change_flag", CVSUIMessages.CVSDecoratorPreferencesPage_35);
        PreviewFile project = new PreviewFile("Project", 4, false, false, false, false, true, null, "v1_0");
        ArrayList<PreviewFile> children = new ArrayList<PreviewFile>();
        children.add(new PreviewFile("Folder", 2, false, false, false, false, true, null, null));
        children.add(new PreviewFile("ignored.txt", 1, false, false, false, true, false, null, null));
        children.add(new PreviewFile("dirty.cpp", 1, false, false, true, false, true, null, null));
        children.add(new PreviewFile("added.java", 1, true, false, true, false, false, null, null));
        children.add(new PreviewFile("todo.txt", 1, false, true, true, false, false, null, null));
        children.add(new PreviewFile("bugs.txt", 1, false, false, true, false, true, null, null));
        children.add(new PreviewFile("archive.zip", 1, false, false, true, false, true, Command.KSUBST_BINARY.getShortDisplayText(), null));
        project.children = children;
        ROOT = Collections.singleton(project);
    }

    protected Control createContents(Composite parent) {
        Composite composite = SWTUtils.createHVFillComposite((Composite)parent, (int)0);
        Composite folderComposite = SWTUtils.createHFillComposite((Composite)composite, (int)0);
        TabFolder tabFolder = new TabFolder(folderComposite, 0);
        tabFolder.setLayoutData((Object)SWTUtils.createHFillGridData());
        this.fGeneralTab = new GeneralTab(tabFolder);
        this.fTextTab = new TextDecoratorTab(tabFolder);
        this.fIconTab = new IconDecoratorTab(tabFolder);
        this.fPreview = new Preview(composite);
        this.fTextTab.addObserver(this.fPreview);
        this.fIconTab.addObserver(this.fPreview);
        this.fGeneralTab.addObserver(this.fPreview);
        this.initializeValues();
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.team.cvs.ui.decorators_preference_page_context");
        Dialog.applyDialogFont((Control)parent);
        this.fThemeListener = new ThemeListener(this.fPreview);
        PlatformUI.getWorkbench().getThemeManager().addPropertyChangeListener((IPropertyChangeListener)this.fThemeListener);
        return tabFolder;
    }

    public void dispose() {
        if (this.fThemeListener != null) {
            PlatformUI.getWorkbench().getThemeManager().removePropertyChangeListener((IPropertyChangeListener)this.fThemeListener);
        }
        if (this.fPreview != null) {
            this.fPreview.dispose();
        }
    }

    private void initializeValues() {
        IPreferenceStore store = this.getPreferenceStore();
        this.fTextTab.initializeValues(store);
        this.fIconTab.initializeValues(store);
        this.fGeneralTab.initializeValues(store);
        this.fPreview.refresh();
        this.setValid(true);
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        IPreferenceStore store = this.getPreferenceStore();
        this.fTextTab.performOk(store);
        this.fIconTab.performOk(store);
        this.fGeneralTab.performOk(store);
        if (store.needsSaving()) {
            CVSUIPlugin.broadcastPropertyChange(new PropertyChangeEvent((Object)this, "org.eclipse.team.cvs.ui.P_DECORATORS_CHANGED", null, null));
            CVSUIPlugin.getPlugin().savePluginPreferences();
        }
        return true;
    }

    protected void performDefaults() {
        IPreferenceStore store = this.getPreferenceStore();
        this.fTextTab.performDefaults(store);
        this.fIconTab.performDefaults(store);
        this.fGeneralTab.performDefaults(store);
        this.fPreview.refresh();
        super.performDefaults();
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return CVSUIPlugin.getPlugin().getPreferenceStore();
    }

    public CVSDecoration buildDecoration(PreviewFile file) {
        Preferences prefs = new Preferences();
        this.fIconTab.setPreferences(prefs);
        this.fTextTab.setPreferences(prefs);
        this.fGeneralTab.setPreferences(prefs);
        CVSDecoration decoration = new CVSDecoration(prefs, this.fTextTab.getFileTextFormat(), this.fTextTab.getFolderTextFormat(), this.fTextTab.getProjectTextFormat());
        decoration.setKeywordSubstitution(Command.KSUBST_TEXT.getShortDisplayText());
        decoration.setRevision("1.45");
        try {
            decoration.setLocation((ICVSRepositoryLocation)CVSRepositoryLocation.fromString((String)":pserver:alize@cvs.site.org:/home/cvsroot"));
        }
        catch (CVSException cVSException) {}
        return decoration;
    }

    private static class FormatEditor
    extends SelectionAdapter {
        private final Text fText;
        private final Map fBindings;
        private final String fKey;

        public FormatEditor(Composite composite, String title, String buttonText, Map bindings, String key) {
            this.fKey = key;
            this.fBindings = bindings;
            Label label = SWTUtils.createLabel((Composite)composite, (String)title);
            label.setLayoutData((Object)SWTUtils.createGridData((int)-1, (int)-1, (boolean)false, (boolean)false));
            this.fText = SWTUtils.createText((Composite)composite);
            Button button = new Button(composite, 0);
            button.setText(buttonText);
            button.setLayoutData((Object)new GridData());
            button.addSelectionListener((SelectionListener)this);
        }

        public void addModifyListener(ModifyListener listener) {
            this.fText.addModifyListener(listener);
        }

        public String getText() {
            return this.fText.getText();
        }

        public void widgetSelected(SelectionEvent e) {
            LabelProvider labelProvider = new LabelProvider(this){
                final /* synthetic */ FormatEditor this$1;
                {
                    this.this$1 = formatEditor;
                }

                public String getText(Object element) {
                    return ((Map.Entry)element).getKey() + " - " + ((Map.Entry)element).getValue();
                }
            };
            IStructuredContentProvider contentsProvider = new IStructuredContentProvider(this){
                final /* synthetic */ FormatEditor this$1;
                {
                    this.this$1 = formatEditor;
                }

                public Object[] getElements(Object inputElement) {
                    return ((Collection)inputElement).toArray();
                }

                public void dispose() {
                }

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                }
            };
            ListSelectionDialog dialog = new ListSelectionDialog(this.fText.getShell(), this.fBindings.entrySet(), contentsProvider, (ILabelProvider)labelProvider, CVSUIMessages.CVSDecoratorPreferencesPage_0);
            dialog.setHelpAvailable(false);
            dialog.setTitle(CVSUIMessages.CVSDecoratorPreferencesPage_1);
            if (dialog.open() != 0) {
                return;
            }
            Object[] result = dialog.getResult();
            int i = 0;
            while (i < result.length) {
                this.fText.insert("{" + ((Map.Entry)result[i]).getKey() + "}");
                ++i;
            }
        }

        public void performOk(IPreferenceStore store) {
            store.setValue(this.fKey, this.fText.getText());
        }

        public void performDefaults(IPreferenceStore store) {
            store.setToDefault(this.fKey);
            this.fText.setText(store.getDefaultString(this.fKey));
        }

        public void initializeValue(IPreferenceStore store) {
            this.fText.setText(CVSDecoration.updateOldDirtyFlag(store.getString(this.fKey)));
        }
    }

    private class GeneralTab
    extends Tab
    implements SelectionListener {
        private final Button fShowDirty;
        private final Button fUseFontDecorations;

        public GeneralTab(TabFolder parent) {
            Composite composite = SWTUtils.createHFillComposite((Composite)parent, (int)-1);
            Dialog.applyDialogFont((Control)composite);
            SWTUtils.createPreferenceLink((IWorkbenchPreferenceContainer)((IWorkbenchPreferenceContainer)CVSDecoratorPreferencesPage.this.getContainer()), (Composite)composite, (String)CVSUIMessages.CVSDecoratorPreferencesPage_36, (String)CVSUIMessages.CVSDecoratorPreferencesPage_37);
            this.fShowDirty = SWTUtils.createCheckBox((Composite)composite, (String)CVSUIMessages.CVSDecoratorPreferencesPage_16);
            SWTUtils.createLabel((Composite)composite, (String)CVSUIMessages.CVSDecoratorPreferencesPage_17);
            this.fUseFontDecorations = SWTUtils.createCheckBox((Composite)composite, (String)CVSUIMessages.CVSDecoratorPreferencesPage_18);
            SWTUtils.createPreferenceLink((IWorkbenchPreferenceContainer)((IWorkbenchPreferenceContainer)CVSDecoratorPreferencesPage.this.getContainer()), (Composite)composite, (String)CVSUIMessages.CVSDecoratorPreferencesPage_19, (String)CVSUIMessages.CVSDecoratorPreferencesPage_20);
            this.fShowDirty.addSelectionListener((SelectionListener)this);
            this.fUseFontDecorations.addSelectionListener((SelectionListener)this);
            TabItem item = new TabItem(parent, 0);
            item.setText(CVSUIMessages.CVSDecoratorPreferencesPage_21);
            item.setControl((Control)composite);
        }

        public void widgetSelected(SelectionEvent e) {
            this.setChanged();
            this.notifyObservers();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void initializeValues(IPreferenceStore store) {
            this.fShowDirty.setSelection(store.getBoolean("pref_calculate_dirty"));
            this.fUseFontDecorations.setSelection(store.getBoolean("pref_use_font_decorators"));
        }

        public void performDefaults(IPreferenceStore store) {
            this.fShowDirty.setSelection(store.getDefaultBoolean("pref_calculate_dirty"));
            this.fUseFontDecorations.setSelection(store.getDefaultBoolean("pref_use_font_decorators"));
        }

        public void performOk(IPreferenceStore store) {
            store.setValue("pref_calculate_dirty", this.fShowDirty.getSelection());
            store.setValue("pref_use_font_decorators", this.fUseFontDecorations.getSelection());
        }

        public void setPreferences(Preferences preferences) {
            preferences.setValue("pref_calculate_dirty", this.fShowDirty.getSelection());
            preferences.setValue("pref_use_font_decorators", this.fUseFontDecorations.getSelection());
        }

        public boolean isFontDecorationEnabled() {
            return this.fUseFontDecorations.getEnabled();
        }
    }

    private class IconDecoratorTab
    extends Tab
    implements SelectionListener {
        private final Button fDirty;
        private final Button fHasRemote;
        private final Button fAdded;
        private final Button fNewResource;

        public IconDecoratorTab(TabFolder parent) {
            Composite composite = SWTUtils.createHFillComposite((Composite)parent, (int)-1);
            this.fDirty = SWTUtils.createCheckBox((Composite)composite, (String)CVSUIMessages.CVSDecoratorPreferencesPage_2);
            this.fDirty.addSelectionListener((SelectionListener)this);
            this.fHasRemote = SWTUtils.createCheckBox((Composite)composite, (String)CVSUIMessages.CVSDecoratorPreferencesPage_3);
            this.fHasRemote.addSelectionListener((SelectionListener)this);
            this.fAdded = SWTUtils.createCheckBox((Composite)composite, (String)CVSUIMessages.CVSDecoratorPreferencesPage_4);
            this.fAdded.addSelectionListener((SelectionListener)this);
            this.fNewResource = SWTUtils.createCheckBox((Composite)composite, (String)CVSUIMessages.CVSDecoratorPreferencesPage_5);
            this.fNewResource.addSelectionListener((SelectionListener)this);
            TabItem item = new TabItem(parent, 0);
            item.setText(CVSUIMessages.CVSDecoratorPreferencesPage_6);
            item.setControl((Control)composite);
        }

        public void widgetSelected(SelectionEvent e) {
            this.setChanged();
            this.notifyObservers();
        }

        public void initializeValues(IPreferenceStore store) {
            this.fDirty.setSelection(store.getBoolean("pref_show_overlaydirty"));
            this.fAdded.setSelection(store.getBoolean("pref_show_added"));
            this.fHasRemote.setSelection(store.getBoolean("pref_show_hasremote"));
            this.fNewResource.setSelection(store.getBoolean("pref_show_newresource"));
        }

        public void performOk(IPreferenceStore store) {
            store.setValue("pref_show_overlaydirty", this.fDirty.getSelection());
            store.setValue("pref_show_added", this.fAdded.getSelection());
            store.setValue("pref_show_hasremote", this.fHasRemote.getSelection());
            store.setValue("pref_show_newresource", this.fNewResource.getSelection());
        }

        public void performDefaults(IPreferenceStore store) {
            this.fDirty.setSelection(store.getDefaultBoolean("pref_show_overlaydirty"));
            this.fAdded.setSelection(store.getDefaultBoolean("pref_show_added"));
            this.fHasRemote.setSelection(store.getDefaultBoolean("pref_show_hasremote"));
            this.fNewResource.setSelection(store.getDefaultBoolean("pref_show_newresource"));
        }

        public void setPreferences(Preferences prefs) {
            prefs.setDefault("pref_show_overlaydirty", this.fDirty.getSelection());
            prefs.setDefault("pref_show_added", this.fAdded.getSelection());
            prefs.setDefault("pref_show_hasremote", this.fHasRemote.getSelection());
            prefs.setDefault("pref_show_newresource", this.fNewResource.getSelection());
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    public class Preview
    extends LabelProvider
    implements Observer,
    ITreeContentProvider {
        private final ResourceManager fImageCache;
        private final TreeViewer fViewer;

        public Preview(Composite composite) {
            SWTUtils.createLabel((Composite)composite, (String)CVSUIMessages.CVSDecoratorPreferencesPage_39);
            this.fImageCache = new LocalResourceManager(JFaceResources.getResources());
            this.fViewer = new TreeViewer(composite);
            this.fViewer.getControl().setLayoutData((Object)SWTUtils.createHVFillGridData());
            this.fViewer.setContentProvider((IContentProvider)this);
            this.fViewer.setLabelProvider((IBaseLabelProvider)this);
            this.fViewer.setInput((Object)ROOT);
            this.fViewer.expandAll();
        }

        public void refresh() {
            this.fViewer.refresh(true);
            this.setColorsAndFonts();
        }

        private void setColorsAndFonts() {
            TreeItem[] items = this.fViewer.getTree().getItems();
            this.setColorsAndFonts(items);
        }

        private void setColorsAndFonts(TreeItem[] items) {
            int i = 0;
            while (i < items.length) {
                if (CVSDecoratorPreferencesPage.this.fGeneralTab.isFontDecorationEnabled()) {
                    Color backGroundColor = this.getBackground(items[i].getData());
                    items[i].setBackground(backGroundColor);
                    Color foreGroundColor = this.getForeground(items[i].getData());
                    items[i].setForeground(foreGroundColor);
                    Font font = this.getFont(items[i].getData());
                    items[i].setFont(font);
                } else {
                    items[i].setBackground(null);
                    items[i].setForeground(null);
                    items[i].setFont(null);
                }
                this.setColorsAndFonts(items[i].getItems());
                ++i;
            }
        }

        public void update(Observable o, Object arg) {
            this.refresh();
        }

        public Object[] getChildren(Object parentElement) {
            return ((PreviewFile)parentElement).children.toArray();
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return !((PreviewFile)element).children.isEmpty();
        }

        public Object[] getElements(Object inputElement) {
            return ((Collection)inputElement).toArray();
        }

        public void dispose() {
            this.fImageCache.dispose();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Color getBackground(Object element) {
            return this.getDecoration(element).getBackgroundColor();
        }

        public Color getForeground(Object element) {
            return this.getDecoration(element).getForegroundColor();
        }

        public Font getFont(Object element) {
            return this.getDecoration(element).getFont();
        }

        public String getText(Object element) {
            CVSDecoration decoration = this.getDecoration(element);
            StringBuffer buffer = new StringBuffer();
            String prefix = decoration.getPrefix();
            if (prefix != null) {
                buffer.append(prefix);
            }
            buffer.append(((PreviewFile)element).name);
            String suffix = decoration.getSuffix();
            if (suffix != null) {
                buffer.append(suffix);
            }
            return buffer.toString();
        }

        public CVSDecoration getDecoration(Object element) {
            CVSDecoration decoration = CVSDecoratorPreferencesPage.this.buildDecoration((PreviewFile)element);
            ((PreviewFile)element).configureDecoration(decoration);
            decoration.compute();
            return decoration;
        }

        public Image getImage(Object element) {
            String s;
            switch (((PreviewFile)element).type) {
                case 4: {
                    s = "IMG_OBJ_PROJECT";
                    break;
                }
                case 2: {
                    s = "IMG_OBJ_FOLDER";
                    break;
                }
                default: {
                    s = "IMG_OBJ_FILE";
                }
            }
            Image baseImage = PlatformUI.getWorkbench().getSharedImages().getImage(s);
            ImageDescriptor overlay = this.getDecoration(element).getOverlay();
            if (overlay == null) {
                return baseImage;
            }
            try {
                return this.fImageCache.createImage((ImageDescriptor)new DecorationOverlayIcon(baseImage, overlay, 3));
            }
            catch (DeviceResourceException e) {
                CVSUIPlugin.log((IStatus)new Status(4, "org.eclipse.team.cvs.ui", 0, "Error creating decorator image", (Throwable)e));
                return null;
            }
        }
    }

    private static class PreviewFile {
        public final String name;
        public final String tag;
        public final String mode;
        public final int type;
        public final boolean added;
        public final boolean dirty;
        public final boolean hasRemote;
        public final boolean ignored;
        public final boolean newResource;
        public Collection children;

        public PreviewFile(String name, int type, boolean added, boolean newResource, boolean dirty, boolean ignored, boolean hasRemote, String mode, String tag) {
            this.name = name;
            this.type = type;
            this.added = added;
            this.ignored = ignored;
            this.dirty = dirty;
            this.hasRemote = hasRemote;
            this.newResource = newResource;
            this.mode = mode != null ? mode : Command.KSUBST_TEXT.getShortDisplayText();
            this.tag = tag != null ? tag : "";
            this.children = Collections.EMPTY_LIST;
        }

        public void configureDecoration(CVSDecoration decoration) {
            decoration.setResourceType(this.type);
            decoration.setAdded(this.added);
            decoration.setDirty(this.dirty);
            decoration.setNewResource(this.newResource);
            decoration.setIgnored(this.ignored);
            decoration.setHasRemote(this.hasRemote);
            decoration.setTag(this.tag);
            decoration.setKeywordSubstitution(this.mode);
        }
    }

    private abstract class Tab
    extends Observable {
        private Tab() {
        }

        public abstract void initializeValues(IPreferenceStore var1);

        public abstract void performDefaults(IPreferenceStore var1);

        public abstract void performOk(IPreferenceStore var1);

        public abstract void setPreferences(Preferences var1);
    }

    private class TextDecoratorTab
    extends Tab
    implements ModifyListener {
        private final FormatEditor fFileDecoration;
        private final FormatEditor fFolderDecoration;
        private final FormatEditor fProjectDecoration;
        private final Text dirtyFlag;
        private final Text addedFlag;

        public TextDecoratorTab(TabFolder parent) {
            Composite composite = SWTUtils.createHFillComposite((Composite)parent, (int)-1, (int)3);
            Dialog.applyDialogFont((Control)composite);
            this.fFileDecoration = new FormatEditor(composite, CVSUIMessages.CVSDecoratorPreferencesPage_7, CVSUIMessages.CVSDecoratorPreferencesPage_8, BINDINGS, "pref_filetext_decoration");
            this.fFolderDecoration = new FormatEditor(composite, CVSUIMessages.CVSDecoratorPreferencesPage_9, CVSUIMessages.CVSDecoratorPreferencesPage_10, FOLDER_BINDINGS, "pref_foldertext_decoration");
            this.fProjectDecoration = new FormatEditor(composite, CVSUIMessages.CVSDecoratorPreferencesPage_11, CVSUIMessages.CVSDecoratorPreferencesPage_12, FOLDER_BINDINGS, "pref_projecttext_decoration");
            this.fFileDecoration.addModifyListener(this);
            this.fFolderDecoration.addModifyListener(this);
            this.fProjectDecoration.addModifyListener(this);
            SWTUtils.createPlaceholder((Composite)composite, (int)1, (int)3);
            Label dirtyLabel = SWTUtils.createLabel((Composite)composite, (String)CVSUIMessages.CVSDecoratorPreferencesPage_13, (int)1);
            dirtyLabel.setLayoutData((Object)new GridData());
            this.dirtyFlag = new Text(composite, 2048);
            this.dirtyFlag.setLayoutData((Object)SWTUtils.createHFillGridData((int)1));
            this.dirtyFlag.addModifyListener((ModifyListener)this);
            SWTUtils.createPlaceholder((Composite)composite, (int)1, (int)1);
            Label addedLabel = SWTUtils.createLabel((Composite)composite, (String)CVSUIMessages.CVSDecoratorPreferencesPage_14, (int)1);
            addedLabel.setLayoutData((Object)new GridData());
            this.addedFlag = new Text(composite, 2048);
            this.addedFlag.setLayoutData((Object)SWTUtils.createHFillGridData((int)1));
            this.addedFlag.addModifyListener((ModifyListener)this);
            SWTUtils.createPlaceholder((Composite)composite, (int)1, (int)1);
            SWTUtils.createPlaceholder((Composite)composite, (int)1, (int)3);
            TabItem item = new TabItem(parent, 0);
            item.setText(CVSUIMessages.CVSDecoratorPreferencesPage_15);
            item.setControl((Control)composite);
        }

        public void initializeValues(IPreferenceStore store) {
            this.fFileDecoration.initializeValue(store);
            this.fFolderDecoration.initializeValue(store);
            this.fProjectDecoration.initializeValue(store);
            this.addedFlag.setText(store.getString("pref_added_flag"));
            this.dirtyFlag.setText(store.getString("pref_dirty_flag"));
        }

        public void performOk(IPreferenceStore store) {
            this.fFileDecoration.performOk(store);
            this.fFolderDecoration.performOk(store);
            this.fProjectDecoration.performOk(store);
            store.setValue("pref_added_flag", this.addedFlag.getText());
            store.setValue("pref_dirty_flag", this.dirtyFlag.getText());
        }

        public void performDefaults(IPreferenceStore store) {
            this.fFileDecoration.performDefaults(store);
            this.fFolderDecoration.performDefaults(store);
            this.fProjectDecoration.performDefaults(store);
            this.addedFlag.setText(store.getDefaultString("pref_added_flag"));
            this.dirtyFlag.setText(store.getDefaultString("pref_dirty_flag"));
        }

        public String getFileTextFormat() {
            return this.fFileDecoration.getText();
        }

        public String getFolderTextFormat() {
            return this.fFolderDecoration.getText();
        }

        public String getProjectTextFormat() {
            return this.fProjectDecoration.getText();
        }

        public void modifyText(ModifyEvent e) {
            this.setChanged();
            this.notifyObservers();
        }

        public void setPreferences(Preferences prefs) {
            prefs.setDefault("pref_calculate_dirty", true);
            prefs.setDefault("pref_dirty_flag", this.dirtyFlag.getText());
            prefs.setDefault("pref_added_flag", this.addedFlag.getText());
        }
    }

    private static class ThemeListener
    implements IPropertyChangeListener {
        private final Preview fPreview;

        ThemeListener(Preview preview) {
            this.fPreview = preview;
        }

        public void propertyChange(PropertyChangeEvent event) {
            this.fPreview.refresh();
        }
    }
}

