/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.internal.ui;

import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.dialogs.DataColumnBindingDialog;
import org.eclipse.birt.report.designer.internal.ui.dnd.DNDLocation;
import org.eclipse.birt.report.designer.internal.ui.dnd.DNDService;
import org.eclipse.birt.report.designer.internal.ui.dnd.IDropAdapter;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.ui.newelement.DesignElementFactory;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabCellHandle;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.editparts.CrosstabCellEditPart;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.model.CrosstabCellAdapter;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.CreateRequest;

public class AggregationDropAdapter
implements IDropAdapter {
    public int canDrop(Object transfer, Object target, int operation, DNDLocation location) {
        if (transfer.equals("DATA_AGG") && target instanceof CrosstabCellEditPart) {
            CrosstabCellAdapter adapter = (CrosstabCellAdapter)((CrosstabCellEditPart)((Object)target)).getModel();
            if (adapter.getCrosstabCellHandle() != null && DEUtil.isReferenceElement((DesignElementHandle)adapter.getCrosstabCellHandle().getCrosstabHandle())) {
                return DNDService.LOGIC_FALSE;
            }
            String posType = adapter.getPositionType();
            if ("measure_aggregation".equals(posType) || "cell_measure".equals(posType)) {
                return DNDService.LOGIC_TRUE;
            }
        }
        return DNDService.LOGIC_UNKNOW;
    }

    public boolean performDrop(Object transfer, Object target, int operation, DNDLocation location) {
        if (target instanceof EditPart) {
            EditPart editPart = (EditPart)target;
            CommandStack stack = SessionHandleAdapter.getInstance().getCommandStack();
            stack.startTrans("Add Aggregation");
            DataItemHandle dataHandle = DesignElementFactory.getInstance().newDataItem(null);
            CrosstabCellHandle cellHandle = ((CrosstabCellAdapter)((CrosstabCellEditPart)((Object)target)).getModel()).getCrosstabCellHandle();
            try {
                cellHandle.addContent((DesignElementHandle)dataHandle, 0);
                DataColumnBindingDialog dialog = new DataColumnBindingDialog(true);
                dialog.setInput((ReportItemHandle)dataHandle, null, (Object)cellHandle);
                dialog.setAggreate(true);
                if (dialog.open() == 0) {
                    cellHandle.getModelHandle().getPropertyHandle("content").removeItem((Object)dataHandle);
                    CreateRequest request = new CreateRequest();
                    request.getExtendedData().put("newObject", dataHandle);
                    request.setLocation(location.getPoint());
                    Command command = editPart.getCommand((Request)request);
                    if (command != null && command.canExecute()) {
                        dataHandle.setResultSetColumn(dialog.getBindingColumn().getName());
                        editPart.getViewer().getEditDomain().getCommandStack().execute(command);
                        stack.commit();
                    } else {
                        stack.rollback();
                    }
                } else {
                    stack.rollback();
                }
            }
            catch (Exception e) {
                stack.rollback();
                ExceptionHandler.handle((Throwable)e);
            }
        }
        return true;
    }
}

