/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.internal.ui.dialogs;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.dialogs.BaseDialog;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.ui.cubebuilder.provider.CubeContentProvider;
import org.eclipse.birt.report.designer.ui.cubebuilder.provider.CubeLabelProvider;
import org.eclipse.birt.report.item.crosstab.ui.i18n.Messages;
import org.eclipse.birt.report.model.api.olap.DimensionHandle;
import org.eclipse.birt.report.model.api.olap.LevelHandle;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class LevelViewDialog
extends BaseDialog {
    private DimensionHandle dimension;
    private List showLevels;
    private CheckboxTreeViewer levelViewer;

    public LevelViewDialog(Shell shell) {
        super(Messages.getString("LevelViewDialog.Title"));
    }

    public void setInput(DimensionHandle dimension, List showLevels) {
        this.dimension = dimension;
        this.showLevels = new LinkedList();
        this.showLevels.addAll(showLevels);
    }

    protected Control createDialogArea(Composite parent) {
        UIUtil.bindHelp((Control)parent, (String)"org.eclipse.birt.cshelp.CrossTabLevelViewDialog_ID");
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        Label infoLabel = new Label(dialogArea, 64);
        infoLabel.setText(Messages.getString("LevelViewDialog.Label.Info"));
        GridData gd = new GridData(768);
        gd.widthHint = 340;
        infoLabel.setLayoutData((Object)gd);
        this.createLevelViewer(dialogArea);
        this.init();
        return dialogArea;
    }

    private void init() {
        if (this.dimension != null) {
            this.levelViewer.setInput((Object)this.dimension);
            this.levelViewer.expandToLevel(this.dimension.getDefaultHierarchy().getContentCount("levels"));
        }
        this.checkOKButtonStatus();
        if (this.showLevels == null || this.showLevels.size() == 0) {
            return;
        }
        Object item = this.levelViewer.getTree().getItem(0);
        while (item != null) {
            LevelHandle level = (LevelHandle)item.getData();
            if (this.showLevels.contains(level)) {
                item.setChecked(true);
            }
            item = item.getItemCount() > 0 ? item.getItem(0) : null;
        }
    }

    private void createLevelViewer(Composite parent) {
        this.levelViewer = new CheckboxTreeViewer(parent, 2052);
        GridData gd = new GridData(1808);
        gd.widthHint = 340;
        gd.heightHint = 250;
        this.levelViewer.getTree().setLayoutData((Object)gd);
        this.levelViewer.setContentProvider((IContentProvider)new CubeContentProvider());
        this.levelViewer.setLabelProvider((IBaseLabelProvider)new CubeLabelProvider());
        this.levelViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                LevelHandle item = (LevelHandle)event.getElement();
                if (event.getChecked()) {
                    if (!LevelViewDialog.this.showLevels.contains(item)) {
                        LevelViewDialog.this.showLevels.add(item);
                    }
                } else if (LevelViewDialog.this.showLevels.contains(item)) {
                    LevelViewDialog.this.showLevels.remove(item);
                }
                LevelViewDialog.this.checkOKButtonStatus();
            }
        });
    }

    public Object getResult() {
        return this.showLevels;
    }

    private void checkOKButtonStatus() {
        if (this.showLevels == null || this.showLevels.size() == 0) {
            if (this.getOkButton() != null) {
                this.getOkButton().setEnabled(false);
            }
        } else if (this.getOkButton() != null) {
            this.getOkButton().setEnabled(true);
        }
    }
}

