/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.internal.ui.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.dialogs.BaseDialog;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.item.crosstab.core.de.AggregationCellHandle;
import org.eclipse.birt.report.item.crosstab.core.de.ComputedMeasureViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabReportItemHandle;
import org.eclipse.birt.report.item.crosstab.core.de.MeasureViewHandle;
import org.eclipse.birt.report.item.crosstab.internal.ui.AggregationCellProviderWrapper;
import org.eclipse.birt.report.item.crosstab.internal.ui.util.CrosstabUIHelper;
import org.eclipse.birt.report.item.crosstab.ui.extension.IAggregationCellViewProvider;
import org.eclipse.birt.report.item.crosstab.ui.extension.SwitchCellInfo;
import org.eclipse.birt.report.item.crosstab.ui.i18n.Messages;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class ShowSummaryFieldDialog
extends BaseDialog {
    private String[] columnNames = new String[]{Messages.getString("ShowSummaryFieldDialog.Column.Measures"), Messages.getString("ShowSummaryFieldDialog.Column.View")};
    private int[] columnWidth = new int[]{230, 130};
    private CellEditor[] cellEditor;
    private String[] comboItems = null;
    private String[] viewNames;
    private CrosstabReportItemHandle crosstab;
    private AggregationCellProviderWrapper cellProviderWrapper;
    private List input = new ArrayList();
    private CheckboxTableViewer summaryFieldViewer;
    private ICellModifier cellModifier = new ICellModifier(){

        public boolean canModify(Object element, String property) {
            if (element instanceof Item) {
                element = ((Item)element).getData();
            }
            MeasureInfo info = (MeasureInfo)element;
            MeasureViewHandle measureView = ShowSummaryFieldDialog.this.crosstab.getMeasure(info.getMeasureName());
            if (measureView != null && measureView instanceof ComputedMeasureViewHandle) {
                return false;
            }
            if (Arrays.asList(ShowSummaryFieldDialog.this.columnNames).indexOf(property) == 1) {
                return ShowSummaryFieldDialog.this.summaryFieldViewer.getChecked(element);
            }
            return false;
        }

        public Object getValue(Object element, String property) {
            if (element instanceof Item) {
                element = ((Item)element).getData();
            }
            Object value = null;
            int index = Arrays.asList(ShowSummaryFieldDialog.this.columnNames).indexOf(property);
            switch (index) {
                case 0: {
                    value = "Measure";
                    break;
                }
                case 1: {
                    int sel;
                    ShowSummaryFieldDialog.this.initializeItems((MeasureInfo)element);
                    ((ComboBoxCellEditor)ShowSummaryFieldDialog.this.cellEditor[1]).setItems(ShowSummaryFieldDialog.this.comboItems);
                    String expectedView = ((MeasureInfo)element).getExpectedView();
                    if (expectedView == null) {
                        expectedView = "";
                    }
                    value = (sel = Arrays.asList(ShowSummaryFieldDialog.this.viewNames).indexOf(expectedView)) <= 0 ? new Integer(0) : new Integer(sel);
                }
            }
            return value;
        }

        public void modify(Object element, String property, Object value) {
            if (element instanceof Item) {
                element = ((Item)element).getData();
            }
            int index = Arrays.asList(ShowSummaryFieldDialog.this.columnNames).indexOf(property);
            switch (index) {
                case 0: {
                    break;
                }
                case 1: {
                    int sel = (Integer)value;
                    if (sel < 0) {
                        ((MeasureInfo)element).setExpectedView("");
                        break;
                    }
                    ((MeasureInfo)element).setExpectedView(ShowSummaryFieldDialog.this.viewNames[sel]);
                }
            }
            ShowSummaryFieldDialog.this.summaryFieldViewer.refresh();
        }
    };

    private void setCrosstab(CrosstabReportItemHandle crosstab) {
        this.crosstab = crosstab;
        this.cellProviderWrapper = new AggregationCellProviderWrapper(crosstab);
    }

    public ShowSummaryFieldDialog(Shell parentShell, CrosstabReportItemHandle crosstab) {
        super(parentShell, Messages.getString("ShowSummaryFieldDialog.Title"));
        this.setCrosstab(crosstab);
    }

    protected Control createDialogArea(Composite parent) {
        UIUtil.bindHelp((Control)parent, (String)"org.eclipse.birt.cshelp.CrossTabShowSummaryFieldDialog_ID");
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        Label infoLabel = new Label(dialogArea, 0);
        infoLabel.setText(Messages.getString("ShowSummaryFieldDialog.Label.Info"));
        this.createSummaryFiledViewer(dialogArea);
        this.init();
        return dialogArea;
    }

    public void setInput(List input) {
        if (input != null) {
            this.input.addAll(input);
        }
    }

    private void createSummaryFiledViewer(Composite dialogArea) {
        Table table = new Table(dialogArea, 68388);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        GridData gd = new GridData(1808);
        gd.heightHint = 250;
        table.setLayoutData((Object)gd);
        this.summaryFieldViewer = new CheckboxTableViewer(table);
        SummaryFieldProvider provider = new SummaryFieldProvider();
        int i = 0;
        while (i < this.columnNames.length) {
            TableColumn column = new TableColumn(table, 16384);
            column.setText(this.columnNames[i]);
            column.setWidth(this.columnWidth[i]);
            ++i;
        }
        ComboBoxCellEditor comboCell = new ComboBoxCellEditor((Composite)table, new String[0], 8);
        CellEditor[] cellEditorArray = new CellEditor[2];
        cellEditorArray[1] = comboCell;
        this.cellEditor = cellEditorArray;
        this.summaryFieldViewer.setColumnProperties(this.columnNames);
        this.summaryFieldViewer.setCellEditors(this.cellEditor);
        this.summaryFieldViewer.setCellModifier(this.cellModifier);
        this.summaryFieldViewer.setUseHashlookup(true);
        this.summaryFieldViewer.setContentProvider((IContentProvider)provider);
        this.summaryFieldViewer.setLabelProvider((IBaseLabelProvider)provider);
        this.summaryFieldViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                MeasureInfo info = (MeasureInfo)event.getElement();
                if (event.getChecked()) {
                    info.setShow(true);
                } else {
                    info.setShow(false);
                }
                ShowSummaryFieldDialog.this.checkOKButtonStatus();
            }
        });
    }

    private void init() {
        if (this.input != null) {
            this.summaryFieldViewer.setInput((Object)this.input);
            int i = 0;
            while (i < this.summaryFieldViewer.getTable().getItemCount()) {
                TableItem item = this.summaryFieldViewer.getTable().getItem(i);
                if (item.getData() != null && item.getData() instanceof MeasureInfo) {
                    item.setChecked(((MeasureInfo)item.getData()).isShow());
                }
                ++i;
            }
        }
    }

    public Object getResult() {
        return this.input;
    }

    private void checkOKButtonStatus() {
        int count = 0;
        int listSize = this.input.size();
        int i = 0;
        while (i < listSize) {
            MeasureInfo measureInfo = (MeasureInfo)this.input.get(i);
            if (measureInfo.isShow()) {
                ++count;
            }
            ++i;
        }
        if (count <= 0 && this.getOkButton() != null) {
            this.getOkButton().setEnabled(false);
        } else if (this.getOkButton() != null) {
            this.getOkButton().setEnabled(true);
        }
    }

    private void initializeItems(MeasureInfo measureInfo) {
        Messages.getString("GrandTotalProvider.ViewStatus");
        ArrayList<String> viewNameList = new ArrayList<String>();
        ArrayList<String> itemList = new ArrayList<String>();
        MeasureViewHandle measureView = this.crosstab.getMeasure(measureInfo.getMeasureName());
        if (measureView != null && measureView instanceof ComputedMeasureViewHandle) {
            itemList.add("");
            viewNameList.add("");
        } else {
            AggregationCellHandle cell = this.getAggregationCell(measureInfo);
            if (cell != null && this.cellProviderWrapper.getMatchProvider(cell) == null) {
                itemList.add("");
                viewNameList.add("");
            }
            IAggregationCellViewProvider[] providers = this.cellProviderWrapper.getAllProviders();
            int i = 0;
            while (i < providers.length) {
                IAggregationCellViewProvider tmp = providers[i];
                if (tmp != null) {
                    SwitchCellInfo info = new SwitchCellInfo(this.crosstab, 3);
                    info.setMeasureInfo(measureInfo);
                    if (providers[i].canSwitch(info)) {
                        String displayName = tmp.getViewDisplayName();
                        viewNameList.add(tmp.getViewName());
                        itemList.add(Messages.getString("GrandTotalProvider.ShowAs", new String[]{displayName}));
                    }
                }
                ++i;
            }
        }
        this.comboItems = itemList.toArray(new String[itemList.size()]);
        this.viewNames = viewNameList.toArray(new String[viewNameList.size()]);
    }

    private AggregationCellHandle getAggregationCell(MeasureInfo measureInfo) {
        AggregationCellHandle cell = null;
        MeasureViewHandle measureView = this.crosstab.getMeasure(measureInfo.getMeasureName());
        if (measureView == null) {
            return cell;
        }
        cell = measureView.getCell();
        return cell;
    }

    public static class MeasureInfo {
        private String measureName = "";
        private String measureDisplayName = "";
        private boolean isShow = false;
        private String expectedView = "";

        public MeasureInfo copy() {
            MeasureInfo retValue = new MeasureInfo();
            retValue.setShow(this.isShow());
            retValue.setMeasureName(this.getMeasureName());
            retValue.setMeasureDisplayName(this.getMeasureDisplayName());
            retValue.setExpectedView(new String(this.expectedView));
            return retValue;
        }

        public boolean isSameInfo(MeasureInfo comparedOne) {
            return comparedOne.measureName.equals(this.measureName);
        }

        public void setExpectedView(String view) {
            this.expectedView = new String(view);
        }

        public String getExpectedView() {
            return this.expectedView;
        }

        public void setShow(boolean show) {
            this.isShow = show;
        }

        public boolean isShow() {
            return this.isShow;
        }

        public String getMeasureName() {
            return this.measureName;
        }

        public void setMeasureName(String name) {
            this.measureName = new String(name);
        }

        public String getMeasureDisplayName() {
            return this.measureDisplayName;
        }

        public void setMeasureDisplayName(String displayName) {
            this.measureDisplayName = new String(displayName);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MeasureInfo)) {
                return false;
            }
            MeasureInfo temp = (MeasureInfo)obj;
            return temp.getMeasureName().equals(this.measureName) && temp.isShow() == this.isShow && temp.getExpectedView() == this.expectedView;
        }
    }

    class SummaryFieldProvider
    extends LabelProvider
    implements ITableLabelProvider,
    IStructuredContentProvider {
        SummaryFieldProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            Image image = null;
            switch (columnIndex) {
                case 0: {
                    image = CrosstabUIHelper.getImage(CrosstabUIHelper.MEASURE_IMAGE);
                    break;
                }
            }
            return image;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof MeasureInfo) {
                if (columnIndex == 0) {
                    return ((MeasureInfo)element).getMeasureDisplayName() == null ? "" : ((MeasureInfo)element).getMeasureDisplayName();
                }
                ShowSummaryFieldDialog.this.initializeItems((MeasureInfo)element);
                ((ComboBoxCellEditor)ShowSummaryFieldDialog.this.cellEditor[1]).setItems(ShowSummaryFieldDialog.this.comboItems);
                String expectedView = ((MeasureInfo)element).getExpectedView();
                if (expectedView == null) {
                    return ShowSummaryFieldDialog.this.comboItems[0];
                }
                int index = Arrays.asList(ShowSummaryFieldDialog.this.viewNames).indexOf(expectedView);
                if (index < 0) {
                    index = 0;
                    ((MeasureInfo)element).setExpectedView(ShowSummaryFieldDialog.this.viewNames[index]);
                }
                return ShowSummaryFieldDialog.this.comboItems[index];
            }
            return "";
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof List) {
                return ((List)inputElement).toArray();
            }
            return new Object[0];
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

