/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.internal.ui.editors.commands;

import org.eclipse.birt.report.designer.core.DesignerConstants;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.commands.AbstractCrosstabCommand;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.model.CrosstabAdaptUtil;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.core.runtime.IAdaptable;

public class CrosstabFlowMoveChildCommand
extends AbstractCrosstabCommand {
    private static final String TRANS_LABEL_MOVE_ELEMENT = Messages.getString((String)"FlowMoveChildCommand.transLabel.moveElement");
    private Object child = null;
    private Object after = null;
    private Object container = null;

    public CrosstabFlowMoveChildCommand(Object child, Object after, Object container) {
        super((DesignElementHandle)child);
        this.child = child;
        this.after = after;
        this.container = container instanceof IAdaptable ? ((IAdaptable)container).getAdapter(DesignElementHandle.class) : container;
        this.setLabel(TRANS_LABEL_MOVE_ELEMENT);
    }

    public void execute() {
        if (DesignerConstants.TRACING_COMMANDS) {
            System.out.println("FlowMoveChildCommand >> Starts ... ");
        }
        try {
            DesignElementHandle containerHandle = null;
            int pos = -1;
            containerHandle = (DesignElementHandle)this.container;
            String contentProperty = DEUtil.getContentProperty((Object)containerHandle, (Object)this.after);
            pos = CrosstabAdaptUtil.findInsertPosition(containerHandle, (DesignElementHandle)this.after);
            DesignElementHandle handle = (DesignElementHandle)this.child;
            this.transStart(TRANS_LABEL_MOVE_ELEMENT);
            handle.moveTo(containerHandle, contentProperty);
            containerHandle.shift(contentProperty, handle, pos);
            this.transEnd();
        }
        catch (SemanticException e) {
            this.rollBack();
            ExceptionHandler.handle((Throwable)e);
        }
    }
}

