/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.internal.ui.editors.model;

import org.eclipse.birt.report.designer.util.IVirtualValidator;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabCellHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabReportItemHandle;
import org.eclipse.birt.report.item.crosstab.core.util.CrosstabUtil;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.model.CrosstabAdaptUtil;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.model.CrosstabCellAdapter;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.olap.DimensionHandle;
import org.eclipse.birt.report.model.api.olap.LevelHandle;
import org.eclipse.birt.report.model.api.olap.MeasureGroupHandle;
import org.eclipse.birt.report.model.api.olap.MeasureHandle;

public class NormalCrosstabCellAdapter
extends CrosstabCellAdapter
implements IVirtualValidator {
    public NormalCrosstabCellAdapter(CrosstabCellHandle handle) {
        super(handle);
    }

    public int hashCode() {
        return this.getCrosstabItemHandle().hashCode();
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public boolean handleValidate(Object obj) {
        CrosstabReportItemHandle crosstab = this.getCrosstabCellHandle().getCrosstab();
        if (obj instanceof Object[]) {
            Object[] objects = (Object[])obj;
            int len = objects.length;
            if (len == 0) {
                return false;
            }
            if (len == 1) {
                return this.handleValidate(objects[0]);
            }
            int i = 0;
            while (i < len) {
                Object temp = objects[i];
                if (temp instanceof MeasureHandle || temp instanceof MeasureGroupHandle) {
                    if (!this.getPositionType().equals("cell_measure") || crosstab.getCube() != CrosstabAdaptUtil.getCubeHandle((DesignElementHandle)temp)) {
                        return false;
                    }
                } else if (temp instanceof LevelHandle) {
                    if (i > 0) {
                        DesignElementHandle preContainer;
                        if (!(objects[i - 1] instanceof LevelHandle)) {
                            return false;
                        }
                        DesignElementHandle container = ((LevelHandle)temp).getContainer();
                        if (container != (preContainer = ((LevelHandle)objects[i - 1]).getContainer())) {
                            return false;
                        }
                    }
                } else {
                    return false;
                }
                ++i;
            }
            return true;
        }
        if (obj instanceof DimensionHandle && (this.getPositionType().equals("level_handle") || this.getPositionType().equals("first_level_handle")) && CrosstabUtil.canContain((CrosstabReportItemHandle)crosstab, (DimensionHandle)((DimensionHandle)obj))) {
            return true;
        }
        if (obj instanceof LevelHandle) {
            return this.handleValidate(CrosstabAdaptUtil.getDimensionHandle((LevelHandle)obj));
        }
        if (obj instanceof MeasureHandle && this.getPositionType().equals("cell_measure") && CrosstabUtil.canContain((CrosstabReportItemHandle)crosstab, (MeasureHandle)((MeasureHandle)obj))) {
            return true;
        }
        return obj instanceof MeasureGroupHandle && this.getPositionType().equals("cell_measure") && crosstab.getCube() == CrosstabAdaptUtil.getCubeHandle((DesignElementHandle)obj);
    }
}

