/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.internal.ui.editors.tools;

import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.AbstractTableEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.TableUtil;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.tools.TableDragGuideTracker;
import org.eclipse.birt.report.designer.util.MetricUtility;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.editparts.CrosstabTableEditPart;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.editparts.CrosstabTableUtil;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.model.CrosstabHandleAdapter;
import org.eclipse.birt.report.item.crosstab.ui.i18n.Messages;
import org.eclipse.birt.report.model.api.util.DimensionUtil;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;

public class CrosstabRowDragTracker
extends TableDragGuideTracker {
    private static final String PREFIX_LABEL = Messages.getString("CrosstabRowDragTracker.Show.Label");

    public CrosstabRowDragTracker(EditPart sourceEditPart, int start, int end) {
        super(sourceEditPart, start, end);
        this.setDisabledCursor(Cursors.SIZENS);
    }

    protected Dimension getDragWidth(int start, int end) {
        return new Dimension(TableUtil.getMinHeight((AbstractTableEditPart)this.getCrosstabTableEditPart(), (int)this.getStart()) - CrosstabTableUtil.caleVisualHeight(this.getCrosstabTableEditPart(), this.getStart()), Integer.MAX_VALUE);
    }

    protected Rectangle getMarqueeSelectionRectangle() {
        IFigure figure = this.getCrosstabTableEditPart().getFigure();
        Insets insets = figure.getInsets();
        int value = this.getLocation().y - this.getStartLocation().y;
        value = this.getTrueValue(value);
        Point p = this.getStartLocation().getCopy();
        figure.translateToAbsolute((Translatable)p);
        figure.translateToRelative((Translatable)p);
        Rectangle bounds = figure.getBounds().getCopy();
        figure.translateToAbsolute((Translatable)bounds);
        return new Rectangle(bounds.x + insets.left, value + p.y, bounds.width - (insets.left + insets.right), 2);
    }

    protected void resize() {
        CrosstabTableEditPart part = (CrosstabTableEditPart)this.getSourceEditPart().getParent();
        int value = this.getLocation().y - this.getStartLocation().y;
        value = this.getTrueValue(value);
        CrosstabHandleAdapter adapter = part.getCrosstabHandleAdapter();
        int baseHeight = CrosstabTableUtil.caleVisualHeight(part, this.getStart());
        adapter.setRowHeight(this.getStart(), value + baseHeight);
    }

    private CrosstabTableEditPart getCrosstabTableEditPart() {
        return (CrosstabTableEditPart)this.getSourceEditPart().getParent();
    }

    protected String getInfomation() {
        CrosstabTableEditPart part = (CrosstabTableEditPart)this.getSourceEditPart().getParent();
        return this.getShowLabel(CrosstabTableUtil.caleVisualHeight(part, this.getStart()));
    }

    private String getShowLabel(int pix) {
        CrosstabTableEditPart part = (CrosstabTableEditPart)this.getSourceEditPart().getParent();
        CrosstabHandleAdapter crosstabAdapter = part.getCrosstabHandleAdapter();
        String unit = crosstabAdapter.getDesignElementHandle().getModuleHandle().getDefaultUnits();
        double doubleValue = MetricUtility.pixelToPixelInch((int)pix);
        double showValue = DimensionUtil.convertTo((double)doubleValue, (String)"in", (String)unit).getMeasure();
        return String.valueOf(PREFIX_LABEL) + " " + this.getShowValue(showValue) + " " + this.getUnitDisplayName(unit) + " (" + pix + " " + PIXELS_LABEL + ")";
    }

    private String getShowValue(double value) {
        return FORMAT.format(value);
    }

    protected boolean handleDragInProgress() {
        CrosstabTableEditPart part = (CrosstabTableEditPart)this.getSourceEditPart().getParent();
        boolean bool = super.handleDragInProgress();
        int value = this.getTrueValue(this.getLocation().y - this.getStartLocation().y);
        int adjustWidth = CrosstabTableUtil.caleVisualHeight(part, this.getStart()) + value;
        this.updateInfomation(this.getShowLabel(adjustWidth));
        return bool;
    }
}

