/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.ui.views.attributes.page;

import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.AttributePage;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.WidgetUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.ComboPropertyDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.IDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.SimpleComboPropertyDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.section.ComboSection;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.section.Section;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.section.SeperatorSection;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.section.SimpleComboSection;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.MasterPageHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class CrosstabSectionPage
extends AttributePage {
    private SimpleComboSection masterSection;
    private SeperatorSection sepSection;
    private ComboSection beforeSection;
    private ComboSection insideSection;
    private ComboSection afterSection;

    public void buildUI(Composite parent) {
        super.buildUI(parent);
        this.container.setLayout((Layout)WidgetUtil.createGridLayout((int)5, (int)15));
        ComboPropertyDescriptorProvider beforeProvider = new ComboPropertyDescriptorProvider("pageBreakBefore", "Style");
        SimpleComboPropertyDescriptorProvider masterProvider = new SimpleComboPropertyDescriptorProvider("masterPage", "Style");
        ComboPropertyDescriptorProvider afterProvider = new ComboPropertyDescriptorProvider("pageBreakAfter", "Style");
        ComboPropertyDescriptorProvider insideProvider = new ComboPropertyDescriptorProvider("pageBreakInside", "Style");
        this.beforeSection = new ComboSection(beforeProvider.getDisplayName(), this.container, true);
        this.insideSection = new ComboSection(insideProvider.getDisplayName(), this.container, true);
        this.masterSection = new SimpleComboSection(masterProvider.getDisplayName(), this.container, true);
        this.afterSection = new ComboSection(afterProvider.getDisplayName(), this.container, true);
        this.sepSection = new SeperatorSection(this.container, 256);
        this.beforeSection.setProvider((IDescriptorProvider)beforeProvider);
        this.masterSection.setProvider((IDescriptorProvider)masterProvider);
        this.afterSection.setProvider((IDescriptorProvider)afterProvider);
        this.insideSection.setProvider((IDescriptorProvider)insideProvider);
        this.beforeSection.setWidth(200);
        this.masterSection.setWidth(200);
        this.afterSection.setWidth(200);
        this.insideSection.setWidth(200);
        this.beforeSection.setLayoutNum(2);
        this.afterSection.setLayoutNum(3);
        this.insideSection.setLayoutNum(5);
        this.masterSection.setLayoutNum(2);
        this.afterSection.setGridPlaceholder(1, true);
        this.insideSection.setGridPlaceholder(3, true);
        this.addSection("SECION_PAGE_BREAK_BEFORE", (Section)this.beforeSection);
        this.addSection("SECION_PAGE_BREAK_AFTER", (Section)this.afterSection);
        this.addSection("SECION_PAGE_BREAK_INSIDE", (Section)this.insideSection);
        this.addSection("SECION_SEPERATOR", (Section)this.sepSection);
        this.addSection("SECION_MASTER_PAGE", (Section)this.masterSection);
        this.createSections();
        this.layoutSections();
    }

    public void refresh() {
        super.refresh();
        this.setVisible();
        this.container.layout(true);
        this.container.redraw();
    }

    protected void setVisible() {
        if (DEUtil.getInputSize((Object)this.input) == 1 && DEUtil.getInputFirstElement((Object)this.input) instanceof DesignElementHandle && this.isElementInMasterPage((DesignElementHandle)DEUtil.getInputFirstElement((Object)this.input))) {
            this.masterSection.setVisible(false);
            this.beforeSection.getLabelControl().setEnabled(false);
            this.beforeSection.getComboControl().getControl().setEnabled(false);
            this.afterSection.getLabelControl().setEnabled(false);
            this.afterSection.getComboControl().getControl().setEnabled(false);
            this.insideSection.getLabelControl().setEnabled(false);
            this.insideSection.getComboControl().getControl().setEnabled(false);
        } else {
            this.masterSection.setVisible(true);
            this.sepSection.setVisible(true);
            this.beforeSection.getLabelControl().setEnabled(true);
            this.beforeSection.getComboControl().getControl().setEnabled(true);
            this.afterSection.getLabelControl().setEnabled(true);
            this.afterSection.getComboControl().getControl().setEnabled(true);
            this.insideSection.getLabelControl().setEnabled(true);
            this.insideSection.getComboControl().getControl().setEnabled(true);
        }
    }

    protected boolean isElementInMasterPage(DesignElementHandle elementHandle) {
        ModuleHandle root = elementHandle.getRoot();
        DesignElementHandle container = elementHandle;
        while (container != null && container != root) {
            if (container instanceof MasterPageHandle) {
                return true;
            }
            container = container.getContainer();
        }
        return false;
    }
}

