/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.ui.views.attributes.provider;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.IDescriptorProvider;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabReportItemHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.DimensionViewHandle;
import org.eclipse.birt.report.item.crosstab.ui.i18n.Messages;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.extension.ExtendedElementException;
import org.eclipse.birt.report.model.api.olap.LevelHandle;
import org.eclipse.swt.widgets.Control;

public class EmptyRowColumnProvider
implements IDescriptorProvider {
    private static final String EMPTY_COLUMN_TEXT = Messages.getString("EmptyRowColumnProvider.ColumnView.Button.Text");
    private static final String EMPTY_ROW_TEXT = Messages.getString("EmptyRowColumnProvider.RowView.Button.Text");
    private int viewType;
    protected Object input;

    public EmptyRowColumnProvider(int viewType) {
        this.viewType = viewType;
    }

    public String getDisplayName() {
        if (this.viewType == 0) {
            return EMPTY_ROW_TEXT;
        }
        return EMPTY_COLUMN_TEXT;
    }

    public int getMaxLengthOfDisplayName(Control control) {
        return UIUtil.getMaxStringWidth((String[])new String[]{EMPTY_COLUMN_TEXT, EMPTY_ROW_TEXT}, (Control)control);
    }

    public Object load() {
        try {
            ExtendedItemHandle crossTabHandle = (ExtendedItemHandle)DEUtil.getInputFirstElement((Object)this.input);
            CrosstabReportItemHandle crossTab = (CrosstabReportItemHandle)crossTabHandle.getReportItem();
            CrosstabViewHandle crossTabViewHandle = crossTab.getCrosstabView(this.viewType);
            if (crossTabViewHandle != null) {
                return crossTabViewHandle.getMirroredStartingLevel();
            }
        }
        catch (ExtendedElementException extendedElementException) {}
        return null;
    }

    public void save(Object value) throws SemanticException {
        LevelHandle handle = this.getLevelHandle(value);
        try {
            ExtendedItemHandle crossTabHandle = (ExtendedItemHandle)DEUtil.getInputFirstElement((Object)this.input);
            CrosstabReportItemHandle crossTab = (CrosstabReportItemHandle)crossTabHandle.getReportItem();
            CrosstabViewHandle crossTabViewHandle = crossTab.getCrosstabView(this.viewType);
            if (crossTabViewHandle != null) {
                crossTabViewHandle.setMirroredStartingLevel(handle);
            }
        }
        catch (ExtendedElementException extendedElementException) {}
    }

    private LevelHandle getLevelHandle(Object value) {
        if (value == null) {
            return null;
        }
        for (LevelHandle level : this.getViewLevels()) {
            if (!value.equals(level.getName())) continue;
            return level;
        }
        return null;
    }

    public List getViewLevels() {
        ArrayList<LevelHandle> list = new ArrayList<LevelHandle>();
        try {
            ExtendedItemHandle crossTabHandle = (ExtendedItemHandle)DEUtil.getInputFirstElement((Object)this.input);
            CrosstabReportItemHandle crossTab = (CrosstabReportItemHandle)crossTabHandle.getReportItem();
            CrosstabViewHandle crossTabViewHandle = crossTab.getCrosstabView(this.viewType);
            if (crossTabViewHandle != null) {
                int dimensionCount = crossTabViewHandle.getDimensionCount();
                int i = 0;
                while (i < dimensionCount) {
                    DimensionViewHandle dimension = crossTabViewHandle.getDimension(i);
                    int levelCount = dimension.getLevelCount();
                    int j = 0;
                    while (j < levelCount) {
                        list.add(dimension.getLevel(j).getCubeLevel());
                        ++j;
                    }
                    ++i;
                }
            }
        }
        catch (ExtendedElementException extendedElementException) {}
        if (list.size() > 0) {
            list.remove(0);
        }
        return list;
    }

    public void setInput(Object input) {
        this.input = input;
    }
}

