/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.ui.views.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.report.data.adapter.api.DataRequestSession;
import org.eclipse.birt.report.data.adapter.api.DataSessionContext;
import org.eclipse.birt.report.data.adapter.api.IBindingMetaInfo;
import org.eclipse.birt.report.data.adapter.api.IDimensionLevel;
import org.eclipse.birt.report.designer.internal.ui.swt.custom.MultiValueCombo;
import org.eclipse.birt.report.designer.internal.ui.swt.custom.ValueCombo;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.util.WidgetUtil;
import org.eclipse.birt.report.designer.ui.dialogs.ExpressionBuilder;
import org.eclipse.birt.report.designer.ui.dialogs.FilterConditionBuilder;
import org.eclipse.birt.report.designer.ui.dialogs.IExpressionProvider;
import org.eclipse.birt.report.designer.ui.dialogs.SelectValueDialog;
import org.eclipse.birt.report.designer.ui.dialogs.TreeValueDialog;
import org.eclipse.birt.report.designer.ui.newelement.DesignElementFactory;
import org.eclipse.birt.report.designer.ui.preferences.PreferenceFactory;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ChoiceSetFactory;
import org.eclipse.birt.report.designer.ui.widget.CGridData;
import org.eclipse.birt.report.designer.ui.widget.CGridLayout;
import org.eclipse.birt.report.designer.util.AlphabeticallyComparator;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.designer.util.FontManager;
import org.eclipse.birt.report.item.crosstab.core.de.ComputedMeasureViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabReportItemHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.DimensionViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.LevelViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.MeasureViewHandle;
import org.eclipse.birt.report.item.crosstab.core.util.CrosstabUtil;
import org.eclipse.birt.report.item.crosstab.internal.ui.dialogs.CrosstabFilterExpressionProvider;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.model.CrosstabAdaptUtil;
import org.eclipse.birt.report.item.crosstab.internal.ui.util.CrosstabUIHelper;
import org.eclipse.birt.report.item.crosstab.plugin.CrosstabPlugin;
import org.eclipse.birt.report.item.crosstab.ui.i18n.Messages;
import org.eclipse.birt.report.item.crosstab.ui.views.attributes.widget.ExpressionValueCellEditor;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.FilterConditionElementHandle;
import org.eclipse.birt.report.model.api.MemberValueHandle;
import org.eclipse.birt.report.model.api.RuleHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.extension.ExtendedElementException;
import org.eclipse.birt.report.model.api.extension.IReportItem;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.birt.report.model.api.olap.CubeHandle;
import org.eclipse.birt.report.model.api.olap.DimensionHandle;
import org.eclipse.birt.report.model.api.olap.LevelHandle;
import org.eclipse.birt.report.model.api.olap.TabularCubeHandle;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class CrosstabFilterConditionBuilder
extends FilterConditionBuilder {
    private final String NULL_STRING;
    public static final String DLG_MESSAGE_NEW = Messages.getString("CrosstabFilterConditionBuilder.DialogMessage.New");
    public static final String DLG_MESSAGE_EDIT = Messages.getString("CrosstabFilterConditionBuilder.DialogMessage.Edit");
    protected static final String[][] OPERATOR;
    protected Composite parentComposite = null;
    private transient boolean refreshItems = true;
    protected Combo comboGroupLevel;
    protected List groupLevelList;
    protected List groupLevelNameList;
    protected List measureList;
    protected List measureNameList;
    protected FilterConditionElementHandle inputHandle;
    protected LevelViewHandle levelViewHandle;
    protected MeasureViewHandle measureViewHandle;
    protected Group group;
    protected Table memberValueTable;
    protected TableViewer dynamicViewer;
    protected Button groupBtn;
    protected Button measureBtn;
    protected Composite memberValueGroup;
    protected ValueCombo expression;
    protected Label targetLabel;
    protected String[] columns = new String[]{" ", Messages.getString("SelColumnMemberValue.Column.Level"), Messages.getString("SelColumnMemberValue.Column.Value")};
    private static String[] actions;
    protected MemberValueHandle memberValueHandle;
    protected List referencedLevelList;
    protected List valueListConList = new ArrayList();
    protected SelectionListener OpoertorSelection = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            CrosstabFilterConditionBuilder.this.operatorChange();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    };
    private static String[] expActions;
    protected Listener targetSelectionListener = new Listener(){

        public void handleEvent(Event event) {
            CrosstabFilterConditionBuilder.this.targetSelectionChanged();
        }
    };
    protected Listener exprValuePopBtnListener = new Listener(){

        public void handleEvent(Event event) {
            Combo thisCombo = (Combo)event.widget;
            int selectionIndex = thisCombo.getSelectionIndex();
            if (selectionIndex < 0) {
                return;
            }
            String value = thisCombo.getItem(selectionIndex);
            List bindingList = new ArrayList();
            boolean returnValue = false;
            if (value != null) {
                String newValue = null;
                if (value.equals(expActions[0])) {
                    LevelViewHandle level = null;
                    MeasureViewHandle measure = null;
                    if (CrosstabFilterConditionBuilder.this.groupBtn.getSelection()) {
                        if (CrosstabFilterConditionBuilder.this.comboGroupLevel.getSelectionIndex() != -1 && CrosstabFilterConditionBuilder.this.groupLevelList != null && CrosstabFilterConditionBuilder.this.groupLevelList.size() > 0) {
                            level = (LevelViewHandle)CrosstabFilterConditionBuilder.this.groupLevelList.get(CrosstabFilterConditionBuilder.this.comboGroupLevel.getSelectionIndex());
                        }
                        if (level == null) {
                            return;
                        }
                        bindingList = CrosstabFilterConditionBuilder.this.getReferableBindings(level);
                    } else if (CrosstabFilterConditionBuilder.this.measureBtn.getSelection()) {
                        if (CrosstabFilterConditionBuilder.this.comboGroupLevel.getSelectionIndex() != -1 && CrosstabFilterConditionBuilder.this.measureList != null && CrosstabFilterConditionBuilder.this.measureList.size() > 0) {
                            measure = (MeasureViewHandle)CrosstabFilterConditionBuilder.this.measureList.get(CrosstabFilterConditionBuilder.this.comboGroupLevel.getSelectionIndex());
                        }
                        if (measure == null) {
                            return;
                        }
                        bindingList = CrosstabFilterConditionBuilder.this.getReferableBindings(measure);
                    }
                    BindingGroup[] bindingGroup = new BindingGroup[]{new BindingGroup(1), new BindingGroup(2), new BindingGroup(11), new BindingGroup(12), new BindingGroup(13)};
                    int i = 0;
                    while (i < bindingList.size()) {
                        IBindingMetaInfo metaInfo = (IBindingMetaInfo)bindingList.get(i);
                        int j = 0;
                        while (j < bindingGroup.length) {
                            if (bindingGroup[j].type == metaInfo.getBindingType()) {
                                bindingGroup[j].addBinding(metaInfo.getBindingName());
                                break;
                            }
                            ++j;
                        }
                        ++i;
                    }
                    TreeValueDialog dialog = new TreeValueDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), CrosstabFilterConditionBuilder.this.treeLabelProvider, CrosstabFilterConditionBuilder.this.treeContentProvider);
                    dialog.setInput((Object)bindingGroup);
                    dialog.setValidator(CrosstabFilterConditionBuilder.this.vialidator);
                    dialog.setTitle(Messages.getString("FilterbyTree.Title"));
                    dialog.setMessage(Messages.getString("FilterbyTree.Message"));
                    dialog.addListener(42, CrosstabFilterConditionBuilder.this.valueTreePaintListener);
                    if (dialog.open() == 0) {
                        returnValue = true;
                        String string = (String)dialog.getResult()[0];
                        newValue = ExpressionUtil.createJSDataExpression((String)string);
                    }
                } else if (value.equals(expActions[1])) {
                    ExpressionBuilder dialog = new ExpressionBuilder(PlatformUI.getWorkbench().getDisplay().getActiveShell(), CrosstabFilterConditionBuilder.this.expression.getText());
                    dialog.setExpressionProvier((IExpressionProvider)new CrosstabFilterExpressionProvider(CrosstabFilterConditionBuilder.this.designHandle));
                    if (dialog.open() == 0) {
                        returnValue = true;
                        newValue = dialog.getResult();
                    }
                }
                if (returnValue) {
                    thisCombo.setText(DEUtil.resolveNull(newValue));
                }
            }
        }
    };
    private Listener valueTreePaintListener = new Listener(){

        public void handleEvent(Event event) {
            TreeItem item = (TreeItem)event.item;
            Object data = item.getData();
            if (data != null && data instanceof BindingGroup) {
                Font font = item.getFont();
                FontData[] fontData = font.getFontData();
                Font newFont = FontManager.getFont((String)fontData[0].getName(), (int)fontData[0].getHeight(), (int)(fontData[0].getStyle() | 1));
                item.setFont(newFont);
            }
        }
    };
    private ISelectionStatusValidator vialidator = new ISelectionStatusValidator(){

        public IStatus validate(Object[] selection) {
            if (selection.length == 1 && selection[0] instanceof String) {
                return new Status(0, "org.eclipse.birt.report.item.crosstab.ui", 0, "", null);
            }
            return new Status(4, "org.eclipse.birt.report.item.crosstab.ui", 4, "", null);
        }
    };
    protected ILabelProvider treeLabelProvider = new ILabelProvider(){

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            if (element == null) {
                return null;
            }
            if (element instanceof BindingGroup) {
                return ((BindingGroup)element).getBindingGroupName();
            }
            return element.toString();
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    };
    protected ITreeContentProvider treeContentProvider = new ITreeContentProvider(){

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof BindingGroup[]) {
                return (BindingGroup[])parentElement;
            }
            if (parentElement instanceof BindingGroup) {
                return ((BindingGroup)parentElement).getBindings().toArray();
            }
            if (parentElement instanceof String) {
                parentElement.toString();
            }
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof BindingGroup[]) {
                return true;
            }
            if (element instanceof BindingGroup) {
                return ((BindingGroup)element).getBindings().size() > 0;
            }
            if (element instanceof String) {
                return false;
            }
            return false;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof BindingGroup[]) {
                return (BindingGroup[])inputElement;
            }
            if (inputElement instanceof BindingGroup) {
                return ((BindingGroup)inputElement).getBindings().toArray();
            }
            return null;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    };
    protected Listener ComboGroupLeveModify = new Listener(){

        public void handleEvent(Event e) {
            CrosstabFilterConditionBuilder.this.updateMemberValues();
        }
    };
    protected Listener expressionModify = new Listener(){

        public void handleEvent(Event e) {
            if (!$assertionsDisabled && !(e.widget instanceof Combo)) {
                throw new AssertionError();
            }
            CrosstabFilterConditionBuilder.this.updateMemberValues();
            CrosstabFilterConditionBuilder.this.needRefreshList = true;
            CrosstabFilterConditionBuilder.this.updateButtons();
        }
    };
    private ISelectionChangedListener selectionChangeListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            Object obj;
            ISelection selection = event.getSelection();
            if (selection instanceof StructuredSelection && (obj = ((StructuredSelection)selection).getFirstElement()) != null && obj instanceof MemberValueHandle && CrosstabFilterConditionBuilder.this.editor != null) {
                CrosstabFilterConditionBuilder.this.editor.setMemberValue((MemberValueHandle)obj);
            }
        }
    };
    private static final String dummyChoice = "dummy";
    private IStructuredContentProvider contentProvider = new IStructuredContentProvider(){

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputObj) {
            if (!(inputObj instanceof List)) {
                return new Object[0];
            }
            return ((List)inputObj).toArray();
        }
    };
    private ITableLabelProvider labelProvider = new ITableLabelProvider(){

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (columnIndex == 0) {
                if (element == CrosstabFilterConditionBuilder.dummyChoice) {
                    return Messages.getString("LevelPropertyDialog.MSG.CreateNew");
                }
                if (element instanceof RuleHandle) {
                    return ((RuleHandle)element).getDisplayExpression();
                }
                return "";
            }
            if (columnIndex == 1) {
                LevelHandle level = ((MemberValueHandle)element).getLevel();
                if (level != null) {
                    return DEUtil.resolveNull((String)level.getName());
                }
                return "";
            }
            if (columnIndex == 2) {
                String value = ((MemberValueHandle)element).getValue();
                return value == null ? "" : value;
            }
            return "";
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    };
    private ICellModifier cellModifier = new ICellModifier(){

        public boolean canModify(Object element, String property) {
            return Arrays.asList(CrosstabFilterConditionBuilder.this.columns).indexOf(property) == 2;
        }

        public Object getValue(Object element, String property) {
            if (Arrays.asList(CrosstabFilterConditionBuilder.this.columns).indexOf(property) != 2) {
                return "";
            }
            String value = ((MemberValueHandle)element).getValue();
            return value == null ? "" : value;
        }

        public void modify(Object element, String property, Object value) {
            if (Arrays.asList(CrosstabFilterConditionBuilder.this.columns).indexOf(property) != 2) {
                return;
            }
            TableItem item = (TableItem)element;
            MemberValueHandle memberValue = (MemberValueHandle)item.getData();
            try {
                memberValue.setValue((String)value);
            }
            catch (SemanticException e) {
                CrosstabFilterConditionBuilder.access$10().log(Level.SEVERE, e.getMessage(), e);
            }
            CrosstabFilterConditionBuilder.this.dynamicViewer.refresh();
        }
    };
    private ExpressionValueCellEditor editor;
    private transient boolean needRefreshList = true;
    protected ValueCombo.ISelection filterByAction;

    static {
        IChoiceSet chset = ChoiceSetFactory.getElementChoiceSet((String)"FilterConditionElement", (String)"operator");
        IChoice[] chs = chset.getChoices((Comparator)new AlphabeticallyComparator());
        OPERATOR = new String[chs.length][2];
        int i = 0;
        while (i < chs.length) {
            CrosstabFilterConditionBuilder.OPERATOR[i][0] = chs[i].getDisplayName();
            CrosstabFilterConditionBuilder.OPERATOR[i][1] = chs[i].getName();
            ++i;
        }
        actions = new String[]{Messages.getString("ExpressionValueCellEditor.selectValueAction"), Messages.getString("ExpressionValueCellEditor.buildExpressionAction")};
        expActions = new String[]{Messages.getString("ExpressionValueCellEditor.filterBy"), Messages.getString("ExpressionValueCellEditor.buildExpressionAction")};
    }

    public void setInput(FilterConditionElementHandle input, Object target) {
        this.inputHandle = input;
        this.levelViewHandle = target instanceof LevelViewHandle ? (LevelViewHandle)target : null;
        this.measureViewHandle = target instanceof MeasureViewHandle ? (MeasureViewHandle)target : null;
    }

    public void setDesignHandle(DesignElementHandle handle) {
        super.setDesignHandle(handle);
        if (this.editor != null) {
            this.editor.setExpressionProvider((IExpressionProvider)new CrosstabFilterExpressionProvider(handle));
        }
    }

    private int createValueListComposite(Composite parent) {
        if (this.addExpressionValue != null && !this.addExpressionValue.isDisposed()) {
            return 0;
        }
        if (this.expressionValue1 != null && !this.expressionValue1.isDisposed()) {
            this.expressionValue1.dispose();
            this.expressionValue1 = null;
            this.expressionValue2.dispose();
            this.expressionValue2 = null;
            this.andLable.dispose();
            this.andLable = null;
        }
        this.valueListConList.clear();
        CGridData expgd = new CGridData(256);
        expgd.horizontalSpan = 2;
        this.addExpressionValue = new MultiValueCombo(parent, 0);
        this.addExpressionValue.setLayoutData((Object)expgd);
        this.valueListConList.add(this.addExpressionValue);
        this.refreshList();
        this.addExpressionValue.setItems(this.popupItems);
        this.addExpressionValue.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CrosstabFilterConditionBuilder.this.checkAddButtonStatus();
                CrosstabFilterConditionBuilder.this.updateButtons();
            }
        });
        this.addBtn = new Button(parent, 8);
        this.addBtn.setText(Messages.getString("FilterConditionBuilder.button.add"));
        this.addBtn.setToolTipText(Messages.getString("FilterConditionBuilder.button.add.tooltip"));
        this.setButtonCGridLayoutData(this.addBtn);
        this.valueListConList.add(this.addBtn);
        this.addBtn.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                String value = CrosstabFilterConditionBuilder.this.addExpressionValue.getText().trim();
                if (CrosstabFilterConditionBuilder.this.valueList.indexOf(value) < 0) {
                    CrosstabFilterConditionBuilder.this.valueList.add(value);
                    CrosstabFilterConditionBuilder.this.tableViewer.refresh();
                    CrosstabFilterConditionBuilder.this.updateButtons();
                    CrosstabFilterConditionBuilder.this.addExpressionValue.setFocus();
                    CrosstabFilterConditionBuilder.this.addExpressionValue.setText("");
                } else {
                    CrosstabFilterConditionBuilder.this.addBtn.setEnabled(false);
                }
            }
        });
        Label dummy = new Label(parent, 0);
        this.valueListConList.add(dummy);
        Label dummy2 = new Label(parent, 0);
        this.valueListConList.add(dummy2);
        int tableStyle = 68356;
        this.table = new Table(parent, tableStyle);
        CGridData data = new CGridData(1808);
        data.horizontalSpan = 3;
        data.grabExcessHorizontalSpace = true;
        this.table.setLayoutData((Object)data);
        this.valueListConList.add(this.table);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        String[] columNames = new String[]{Messages.getString("FilterConditionBuilder.list.item1")};
        int[] columLength = new int[]{268};
        int i = 0;
        while (i < columNames.length) {
            TableColumn column = new TableColumn(this.table, 0, i);
            column.setText(columNames[i]);
            column.setWidth(columLength[i]);
            ++i;
        }
        this.table.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                CrosstabFilterConditionBuilder.this.checkEditDelButtonStatus();
            }
        });
        this.table.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 127) {
                    CrosstabFilterConditionBuilder.this.delTableValue();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                CrosstabFilterConditionBuilder.this.editTableValue();
            }
        });
        this.tableViewer = new TableViewer(this.table);
        this.tableViewer.setUseHashlookup(true);
        this.tableViewer.setColumnProperties(columNames);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)this.tableLableProvier);
        this.tableViewer.setContentProvider((IContentProvider)this.tableContentProvider);
        Composite rightPart = new Composite(parent, 0);
        data = new CGridData(1816);
        rightPart.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.makeColumnsEqualWidth = true;
        rightPart.setLayout((Layout)layout);
        this.valueListConList.add(rightPart);
        this.editBtn = new Button(rightPart, 8);
        this.editBtn.setText(Messages.getString("FilterConditionBuilder.button.edit"));
        this.editBtn.setToolTipText(Messages.getString("FilterConditionBuilder.button.edit.tooltip"));
        this.setButtonLayoutData(this.editBtn);
        this.editBtn.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                CrosstabFilterConditionBuilder.this.editTableValue();
            }
        });
        this.delBtn = new Button(rightPart, 8);
        this.delBtn.setText(Messages.getString("FilterConditionBuilder.button.delete"));
        this.delBtn.setToolTipText(Messages.getString("FilterConditionBuilder.button.delete.tooltip"));
        this.setButtonLayoutData(this.delBtn);
        this.delBtn.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                CrosstabFilterConditionBuilder.this.delTableValue();
            }
        });
        this.delAllBtn = new Button(rightPart, 8);
        this.delAllBtn.setText(Messages.getString("FilterConditionBuilder.button.deleteall"));
        this.delAllBtn.setToolTipText(Messages.getString("FilterConditionBuilder.button.deleteall.tooltip"));
        this.setButtonLayoutData(this.delAllBtn);
        this.delAllBtn.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int count = CrosstabFilterConditionBuilder.this.valueList.size();
                if (count > 0) {
                    CrosstabFilterConditionBuilder.this.valueList.clear();
                    CrosstabFilterConditionBuilder.this.tableViewer.refresh();
                    CrosstabFilterConditionBuilder.this.updateButtons();
                } else {
                    CrosstabFilterConditionBuilder.this.delAllBtn.setEnabled(false);
                }
            }
        });
        this.addExpressionValue.addSelectionListener(0, this.mAddSelValueAction);
        this.addExpressionValue.addSelectionListener(1, this.mAddExpValueAction);
        this.parentComposite.layout(true, true);
        if (this.getButtonBar() != null) {
            parent.getShell().pack();
        }
        return 1;
    }

    private int create2ValueComposite(Composite condition) {
        if (this.expressionValue1 != null && !this.expressionValue1.isDisposed()) {
            return 0;
        }
        if (this.valueListConList.size() > 0) {
            int count = this.valueListConList.size();
            int i = 0;
            while (i < count) {
                Object obj = this.valueListConList.get(i);
                if (obj != null && obj instanceof Widget && !((Widget)obj).isDisposed()) {
                    ((Widget)obj).dispose();
                }
                ++i;
            }
        }
        this.valueListConList.clear();
        CGridData expgd = new CGridData();
        expgd.horizontalSpan = 2;
        expgd.widthHint = 150;
        this.expressionValue1 = new ValueCombo(condition, 0);
        this.expressionValue1.setLayoutData((Object)expgd);
        this.expressionValue1.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CrosstabFilterConditionBuilder.this.updateButtons();
            }
        });
        this.expressionValue1.addSelectionListener(0, this.selectValueAction);
        this.expressionValue1.addSelectionListener(1, this.expValueAction);
        this.refreshList();
        this.expressionValue1.setItems(this.popupItems);
        this.andLable = new Label(condition, 0);
        this.andLable.setText(Messages.getString("FilterConditionBuilder.text.AND"));
        this.andLable.setEnabled(false);
        this.andLable.setLayoutData((Object)new CGridData(128));
        this.expressionValue2 = new ValueCombo(condition, 0);
        expgd = new CGridData();
        expgd.horizontalAlignment = 4;
        expgd.horizontalSpan = 1;
        this.expressionValue2.setLayoutData((Object)expgd);
        this.expressionValue2.setItems(this.popupItems);
        this.expressionValue2.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CrosstabFilterConditionBuilder.this.updateButtons();
            }
        });
        this.expressionValue2.addSelectionListener(0, this.selectValueAction);
        this.expressionValue2.addSelectionListener(1, this.expValueAction);
        if (this.operator.getItemCount() > 0 && this.operator.getSelectionIndex() == -1) {
            this.operator.select(0);
            this.operatorChange();
        }
        this.parentComposite.layout(true, true);
        if (this.getButtonBar() != null) {
            condition.getShell().pack();
        }
        return 1;
    }

    protected void operatorChange() {
        String value = CrosstabFilterConditionBuilder.getValueForOperator((String)this.operator.getText());
        this.valueVisible = CrosstabFilterConditionBuilder.determineValueVisible((String)value);
        if (this.valueVisible == 3) {
            int ret = this.createValueListComposite(this.operator.getParent());
            if (ret != 0) {
                if (this.inputHandle != null) {
                    this.valueList = new ArrayList(this.inputHandle.getValue1List());
                }
                this.tableViewer.setInput((Object)this.valueList);
            }
        } else {
            int ret = this.create2ValueComposite(this.operator.getParent());
            if (ret != 0 && this.inputHandle != null) {
                this.expressionValue1.setText(DEUtil.resolveNull((String)this.inputHandle.getValue1()));
                this.expressionValue2.setText(DEUtil.resolveNull((String)this.inputHandle.getValue2()));
            }
        }
        if (this.valueVisible == 0) {
            this.expressionValue1.setVisible(false);
            this.expressionValue2.setVisible(false);
            this.andLable.setVisible(false);
        } else if (this.valueVisible == 1) {
            this.expressionValue1.setVisible(true);
            this.expressionValue2.setVisible(false);
            this.andLable.setVisible(false);
        } else if (this.valueVisible == 2) {
            this.expressionValue1.setVisible(true);
            this.expressionValue2.setVisible(true);
            this.andLable.setVisible(true);
            this.andLable.setEnabled(true);
        }
        this.updateButtons();
    }

    public CrosstabFilterConditionBuilder(String title, String message) {
        this(UIUtil.getDefaultShell(), title, message);
    }

    public CrosstabFilterConditionBuilder(Shell parentShell, String title, String message) {
        super(parentShell, title, message);
        this.NULL_STRING = null;
        this.initializeListener();
    }

    private void initializeDialog() {
        this.getLevels();
        this.getMeasures();
        String[] groupLeveNames = this.groupLevelNameList.toArray(new String[this.groupLevelNameList.size()]);
        this.comboGroupLevel.setItems(groupLeveNames);
        this.expression.setItems(expActions);
        this.groupBtn.setSelection(true);
        this.measureBtn.setSelection(false);
        this.targetLabel.setText(Messages.getString("CrosstabFilterConditionBuilder.DialogTitle.Label.GroupLevel"));
    }

    protected void createFilterConditionContent(Composite innerParent) {
        UIUtil.bindHelp((Control)innerParent, (String)"org.eclipse.birt.cshelp.CrossTabFilterConditionBuilder_ID");
        this.parentComposite = innerParent;
        Composite parentControl = new Composite(innerParent, 0);
        GridData gd = new GridData(768);
        gd.heightHint = 400;
        parentControl.setLayoutData((Object)gd);
        parentControl.setLayout((Layout)new GridLayout());
        Composite targetComposite = new Composite(parentControl, 0);
        gd = new GridData(768);
        targetComposite.setLayoutData((Object)gd);
        GridLayout glayout = new GridLayout(3, false);
        targetComposite.setLayout((Layout)glayout);
        new Label(targetComposite, 0).setText(Messages.getString("CrosstabFilterConditionBuilder.Label.Target"));
        this.groupBtn = new Button(targetComposite, 16);
        this.groupBtn.setText(Messages.getString("CrosstabFilterConditionBuilder.Button.GroupLevel"));
        this.measureBtn = new Button(targetComposite, 16);
        this.measureBtn.setText(Messages.getString("CrosstabFilterConditionBuilder.Button.Measure"));
        this.groupBtn.addListener(13, this.targetSelectionListener);
        this.measureBtn.addListener(13, this.targetSelectionListener);
        Composite groupLevelParent = new Composite(parentControl, 0);
        gd = new GridData(768);
        groupLevelParent.setLayoutData((Object)gd);
        CGridLayout cglayout = new CGridLayout(5, false);
        groupLevelParent.setLayout((Layout)cglayout);
        this.targetLabel = new Label(groupLevelParent, 0);
        CGridData cgd = new CGridData();
        this.targetLabel.setLayoutData((Object)cgd);
        cgd.widthHint = UIUtil.getMaxStringWidth((String[])new String[]{Messages.getString("CrosstabFilterConditionBuilder.DialogTitle.Label.GroupLevel"), Messages.getString("CrosstabFilterConditionBuilder.DialogTitle.Label.Measure")}, (Control)this.targetLabel);
        this.targetLabel.setText(Messages.getString("CrosstabFilterConditionBuilder.DialogTitle.Label.GroupLevel"));
        this.comboGroupLevel = new Combo(groupLevelParent, 8);
        CGridData cgdata = new CGridData(256);
        cgdata.horizontalSpan = 2;
        cgdata.maximumWidth = 180;
        this.comboGroupLevel.setLayoutData((Object)cgdata);
        Label dummyLabel = new Label(groupLevelParent, 0);
        cgdata = new CGridData(768);
        cgdata.horizontalSpan = 2;
        dummyLabel.setLayoutData((Object)cgdata);
        this.comboGroupLevel.addListener(24, this.ComboGroupLeveModify);
        Label lb = new Label(groupLevelParent, 0);
        lb.setText(Messages.getString("FilterConditionBuilder.text.Condition"));
        lb.setLayoutData((Object)new CGridData());
        this.expression = new ValueCombo(groupLevelParent, 0);
        CGridData expgd = new CGridData();
        expgd.horizontalSpan = 2;
        expgd.widthHint = 150;
        this.expression.setLayoutData((Object)expgd);
        this.expression.addListener(24, this.expressionModify);
        this.expression.addSelectionListener(0, this.filterByAction);
        this.expression.addSelectionListener(1, this.expValueAction);
        this.operator = new Combo(groupLevelParent, 8);
        cgd = new CGridData(768);
        cgd.horizontalSpan = 2;
        this.operator.setLayoutData((Object)cgd);
        int i = 0;
        while (i < OPERATOR.length) {
            this.operator.add(OPERATOR[i][0]);
            ++i;
        }
        this.operator.addSelectionListener(this.OpoertorSelection);
        new Label(groupLevelParent, 0);
        this.create2ValueComposite(groupLevelParent);
        this.memberValueGroup = new Composite(parentControl, 0);
        this.memberValueGroup.setLayout((Layout)new GridLayout());
        gd = new GridData(768);
        gd.horizontalSpan = 5;
        this.memberValueGroup.setLayoutData((Object)gd);
        this.createMemberValuesGroup(this.memberValueGroup);
        this.initializeDialog();
        this.syncViewProperties();
    }

    private void targetSelectionChanged() {
        if (this.groupBtn.getSelection()) {
            this.memberValueGroup.setVisible(true);
            this.targetLabel.setText(Messages.getString("CrosstabFilterConditionBuilder.DialogTitle.Label.GroupLevel"));
            String[] groupLeveNames = this.groupLevelNameList.toArray(new String[this.groupLevelNameList.size()]);
            this.comboGroupLevel.removeAll();
            this.comboGroupLevel.setItems(groupLeveNames);
            if (this.comboGroupLevel.getItemCount() == 0) {
                this.comboGroupLevel.add(DEUtil.resolveNull(null));
            }
            this.comboGroupLevel.select(0);
            this.updateMemberValues();
        } else if (this.measureBtn.getSelection()) {
            this.memberValueGroup.setVisible(false);
            this.targetLabel.setText(Messages.getString("CrosstabFilterConditionBuilder.DialogTitle.Label.Measure"));
            String[] measureNames = this.measureNameList.toArray(new String[this.measureNameList.size()]);
            this.comboGroupLevel.removeAll();
            this.comboGroupLevel.setItems(measureNames);
            if (this.comboGroupLevel.getItemCount() == 0) {
                this.comboGroupLevel.add(DEUtil.resolveNull(null));
            }
            this.comboGroupLevel.select(0);
        }
    }

    protected void createMemberValuesGroup(Composite content) {
        this.group = new Group(content, 0);
        this.group.setText(Messages.getString("CrosstabFilterConditionBuilder.Label.SelColumnMemberValue"));
        this.group.setLayout((Layout)new GridLayout());
        this.memberValueTable = new Table((Composite)this.group, 68356);
        this.memberValueTable.setLinesVisible(true);
        this.memberValueTable.setHeaderVisible(true);
        this.memberValueTable.setLayoutData((Object)new GridData(1808));
        GridData gd = new GridData(1808);
        gd.heightHint = 150;
        gd.horizontalSpan = 3;
        this.group.setLayoutData((Object)gd);
        this.dynamicViewer = new TableViewer(this.memberValueTable);
        TableColumn column = new TableColumn(this.memberValueTable, 16384);
        column.setText(this.columns[0]);
        column.setWidth(15);
        TableColumn column1 = new TableColumn(this.memberValueTable, 16384);
        column1.setResizable(this.columns[1] != null);
        if (this.columns[1] != null) {
            column1.setText(this.columns[1]);
        }
        column1.setWidth(200);
        TableColumn column2 = new TableColumn(this.memberValueTable, 16384);
        column2.setResizable(this.columns[2] != null);
        if (this.columns[2] != null) {
            column2.setText(this.columns[2]);
        }
        column2.setWidth(200);
        this.dynamicViewer.setColumnProperties(this.columns);
        this.editor = new ExpressionValueCellEditor((Composite)this.dynamicViewer.getTable(), 8);
        TextCellEditor textEditor = new TextCellEditor((Composite)this.dynamicViewer.getTable(), 8);
        TextCellEditor textEditor2 = new TextCellEditor((Composite)this.dynamicViewer.getTable(), 8);
        CellEditor[] cellEditors = new CellEditor[]{textEditor, textEditor2, this.editor};
        if (this.designHandle != null) {
            this.editor.setExpressionProvider((IExpressionProvider)new CrosstabFilterExpressionProvider(this.designHandle));
            this.editor.setReportElement((ExtendedItemHandle)this.designHandle);
        }
        this.dynamicViewer.setCellEditors(cellEditors);
        this.dynamicViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.dynamicViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.dynamicViewer.setCellModifier(this.cellModifier);
        this.dynamicViewer.addSelectionChangedListener(this.selectionChangeListener);
    }

    protected void syncViewProperties() {
        if (this.inputHandle == null) {
            if (this.comboGroupLevel.getItemCount() == 0) {
                this.comboGroupLevel.add(DEUtil.resolveNull(null));
            }
            this.comboGroupLevel.select(0);
            this.updateMemberValues();
        } else {
            this.groupBtn.setSelection(this.measureViewHandle == null);
            this.measureBtn.setSelection(this.measureViewHandle != null);
            this.targetSelectionChanged();
            this.valueVisible = CrosstabFilterConditionBuilder.determineValueVisible((String)this.inputHandle.getOperator());
            if (this.valueVisible == 3) {
                this.createValueListComposite(this.operator.getParent());
                this.valueList = new ArrayList(this.inputHandle.getValue1List());
                this.tableViewer.setInput((Object)this.valueList);
            } else {
                this.create2ValueComposite(this.operator.getParent());
                this.expressionValue1.setText(DEUtil.resolveNull((String)this.inputHandle.getValue1()));
                this.expressionValue2.setText(DEUtil.resolveNull((String)this.inputHandle.getValue2()));
            }
            int index = 0;
            index = this.groupBtn.getSelection() ? this.groupLevelList.indexOf(this.levelViewHandle) : this.measureList.indexOf(this.measureViewHandle);
            if (index >= 0) {
                this.comboGroupLevel.select(index);
            }
            this.expression.setText(DEUtil.resolveNull((String)this.inputHandle.getExpr()));
            this.operator.select(CrosstabFilterConditionBuilder.getIndexForOperatorValue((String)this.inputHandle.getOperator()));
            int vv = CrosstabFilterConditionBuilder.determineValueVisible((String)this.inputHandle.getOperator());
            if (vv == 0) {
                this.expressionValue1.setVisible(false);
                this.expressionValue2.setVisible(false);
                this.andLable.setVisible(false);
            } else if (vv == 1) {
                this.expressionValue1.setVisible(true);
                this.expressionValue2.setVisible(false);
                this.andLable.setVisible(false);
            } else if (vv == 2) {
                this.expressionValue1.setVisible(true);
                this.expressionValue2.setVisible(true);
                this.andLable.setVisible(true);
                this.andLable.setEnabled(true);
            } else if (this.valueVisible == 3) {
                if (this.expression.getText().length() == 0) {
                    this.setEnableValueListComposite(false);
                } else {
                    this.setEnableValueListComposite(true);
                }
            }
        }
    }

    private void setEnableValueListComposite(boolean val) {
        if (this.valueListConList.size() > 0) {
            int count = this.valueListConList.size();
            int i = 0;
            while (i < count) {
                Object obj = this.valueListConList.get(i);
                if (obj != null && obj instanceof Control && !((Widget)obj).isDisposed()) {
                    ((Control)obj).setEnabled(val);
                }
                ++i;
            }
        }
    }

    private List getSelectedValueList() {
        if (!this.needRefreshList) {
            return this.selValueList;
        }
        CubeHandle cube = null;
        CrosstabReportItemHandle crosstab = null;
        if (this.designHandle instanceof ExtendedItemHandle) {
            try {
                IReportItem obj = ((ExtendedItemHandle)this.designHandle).getReportItem();
                if (obj instanceof CrosstabReportItemHandle) {
                    crosstab = (CrosstabReportItemHandle)obj;
                }
                crosstab = (CrosstabReportItemHandle)((ExtendedItemHandle)this.designHandle).getReportItem();
                cube = crosstab.getCube();
            }
            catch (ExtendedElementException e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        if (cube == null || !(cube instanceof TabularCubeHandle) || this.expression.getText().length() == 0) {
            return new ArrayList();
        }
        Iterator iter = null;
        ICubeQueryDefinition cubeQueryDefn = null;
        DataRequestSession session = null;
        try {
            session = DataRequestSession.newSession((DataSessionContext)new DataSessionContext(3));
            cubeQueryDefn = CrosstabUIHelper.createBindingQuery(crosstab);
            iter = session.getCubeQueryUtil().getMemberValueIterator((TabularCubeHandle)cube, this.expression.getText(), cubeQueryDefn);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        this.selValueList = new ArrayList();
        int count = 0;
        int MAX_COUNT = PreferenceFactory.getInstance().getPreferences((AbstractUIPlugin)CrosstabPlugin.getDefault(), UIUtil.getCurrentProject()).getInt("Filter.Limit");
        while (iter != null && iter.hasNext()) {
            Object obj = iter.next();
            if (obj == null || this.selValueList.indexOf(obj) >= 0) continue;
            this.selValueList.add(obj);
            if (++count >= MAX_COUNT) break;
        }
        this.needRefreshList = false;
        return this.selValueList;
    }

    private void refreshList() {
        if (this.refreshItems) {
            ArrayList<String> finalItems = new ArrayList<String>(10);
            int n = 0;
            while (n < actions.length) {
                finalItems.add(actions[n]);
                ++n;
            }
            this.popupItems = finalItems.toArray(EMPTY_ARRAY);
        }
        this.refreshItems = false;
    }

    private List getMeasures() {
        if (this.measureList != null) {
            return this.measureList;
        }
        this.measureList = new ArrayList();
        this.measureNameList = new ArrayList();
        ExtendedItemHandle element = (ExtendedItemHandle)this.designHandle;
        CrosstabReportItemHandle crossTab = null;
        try {
            crossTab = (CrosstabReportItemHandle)element.getReportItem();
        }
        catch (ExtendedElementException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        if (crossTab == null) {
            return this.measureList;
        }
        int count = crossTab.getMeasureCount();
        int i = 0;
        while (i < count) {
            MeasureViewHandle measure = crossTab.getMeasure(i);
            if (!(measure instanceof ComputedMeasureViewHandle)) {
                this.measureList.add(measure);
                this.measureNameList.add(measure.getCubeMeasure().getFullName());
            }
            ++i;
        }
        return this.measureList;
    }

    private List getLevels() {
        DesignElementHandle elementHandle;
        if (this.groupLevelList != null) {
            return this.groupLevelList;
        }
        this.groupLevelList = new ArrayList();
        this.groupLevelNameList = new ArrayList();
        ExtendedItemHandle element = (ExtendedItemHandle)this.designHandle;
        CrosstabReportItemHandle crossTab = null;
        try {
            crossTab = (CrosstabReportItemHandle)element.getReportItem();
        }
        catch (ExtendedElementException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        if (crossTab == null) {
            return this.groupLevelList;
        }
        if (crossTab.getCrosstabView(1) != null) {
            elementHandle = crossTab.getCrosstabView(1).getModelHandle();
            this.getLevel((ExtendedItemHandle)elementHandle);
        }
        if (crossTab.getCrosstabView(0) != null) {
            elementHandle = crossTab.getCrosstabView(0).getModelHandle();
            this.getLevel((ExtendedItemHandle)elementHandle);
        }
        return this.groupLevelList;
    }

    private void getLevel(ExtendedItemHandle handle) {
        CrosstabViewHandle crossTabViewHandle = null;
        try {
            crossTabViewHandle = (CrosstabViewHandle)handle.getReportItem();
        }
        catch (ExtendedElementException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        if (crossTabViewHandle == null) {
            return;
        }
        int dimensionCount = crossTabViewHandle.getDimensionCount();
        int i = 0;
        while (i < dimensionCount) {
            DimensionViewHandle dimension = crossTabViewHandle.getDimension(i);
            int levelCount = dimension.getLevelCount();
            int j = 0;
            while (j < levelCount) {
                LevelViewHandle levelHandle = dimension.getLevel(j);
                this.groupLevelList.add(levelHandle);
                if (levelHandle.getCubeLevel() != null) {
                    this.groupLevelNameList.add(levelHandle.getCubeLevel().getFullName());
                }
                ++j;
            }
            ++i;
        }
    }

    protected void checkAddButtonStatus() {
        String value = this.addExpressionValue.getText();
        if (value == null || value.length() == 0 || value.trim().length() == 0) {
            this.addBtn.setEnabled(false);
            return;
        }
        if (value != null) {
            value = value.trim();
        }
        if (this.valueList.indexOf(value) < 0) {
            this.addBtn.setEnabled(true);
        } else {
            this.addBtn.setEnabled(false);
        }
    }

    protected void checkEditDelButtonStatus() {
        StructuredSelection selection;
        boolean enabled;
        boolean bl = enabled = this.tableViewer.getSelection() != null;
        if (enabled && this.tableViewer.getSelection() instanceof StructuredSelection && (selection = (StructuredSelection)this.tableViewer.getSelection()).toList().size() <= 0) {
            enabled = false;
        }
        this.editBtn.setEnabled(enabled);
        this.delBtn.setEnabled(enabled);
        enabled = this.table.getItemCount() > 0;
        this.delAllBtn.setEnabled(enabled);
    }

    protected boolean isConditionOK() {
        if (this.comboGroupLevel.getText() != null && this.comboGroupLevel.getText().length() == 0) {
            return false;
        }
        if (this.expression == null) {
            return false;
        }
        if (!this.isExpressionOK()) {
            return false;
        }
        return this.checkValues();
    }

    protected boolean isExpressionOK() {
        if (this.expression == null) {
            return false;
        }
        return this.expression.getText() != null && this.expression.getText().length() != 0;
    }

    protected void okPressed() {
        LevelViewHandle level = null;
        MeasureViewHandle measure = null;
        assert (this.comboGroupLevel.getSelectionIndex() >= 0);
        if (this.groupBtn.getSelection()) {
            level = (LevelViewHandle)this.groupLevelList.get(this.comboGroupLevel.getSelectionIndex());
        } else if (this.measureBtn.getSelection()) {
            measure = (MeasureViewHandle)this.measureList.get(this.comboGroupLevel.getSelectionIndex());
        }
        try {
            if (this.inputHandle == null) {
                FilterConditionElementHandle filter = DesignElementFactory.getInstance().newFilterConditionElement();
                filter.setProperty("operator", (Object)DEUtil.resolveNull((String)CrosstabFilterConditionBuilder.getValueForOperator((String)this.operator.getText())));
                filter.setExpr(DEUtil.resolveNull((String)this.expression.getText()));
                if (this.valueVisible == 3) {
                    filter.setValue1(this.valueList);
                    filter.setValue2("");
                } else {
                    assert (!this.expressionValue1.isDisposed());
                    assert (!this.expressionValue2.isDisposed());
                    if (this.expressionValue1.getVisible()) {
                        filter.setValue1(DEUtil.resolveNull((String)this.expressionValue1.getText()));
                    } else {
                        filter.setValue1(this.NULL_STRING);
                    }
                    if (this.expressionValue2.getVisible()) {
                        filter.setValue2(DEUtil.resolveNull((String)this.expressionValue2.getText()));
                    } else {
                        filter.setValue2(this.NULL_STRING);
                    }
                }
                if (this.groupBtn.getSelection()) {
                    if (this.referencedLevelList != null && this.referencedLevelList.size() > 0) {
                        filter.add("member", (DesignElementHandle)this.memberValueHandle);
                    }
                    level.getModelHandle().add("filter", (DesignElementHandle)filter);
                } else if (this.measureBtn.getSelection()) {
                    measure.getModelHandle().add("filter", (DesignElementHandle)filter);
                }
            } else if (this.groupBtn.getSelection() && level == this.levelViewHandle || this.measureBtn.getSelection() && measure == this.measureViewHandle) {
                this.inputHandle.setOperator(DEUtil.resolveNull((String)CrosstabFilterConditionBuilder.getValueForOperator((String)this.operator.getText())));
                if (this.valueVisible == 3) {
                    this.inputHandle.setValue1(this.valueList);
                    this.inputHandle.setValue2("");
                } else {
                    if (this.expressionValue1.getVisible()) {
                        this.inputHandle.setValue1(DEUtil.resolveNull((String)this.expressionValue1.getText()));
                    } else {
                        this.inputHandle.setValue1(this.NULL_STRING);
                    }
                    if (this.expressionValue2.getVisible()) {
                        this.inputHandle.setValue2(DEUtil.resolveNull((String)this.expressionValue2.getText()));
                    } else {
                        this.inputHandle.setValue2(this.NULL_STRING);
                    }
                }
                this.inputHandle.setExpr(DEUtil.resolveNull((String)this.expression.getText()));
                if (this.groupBtn.getSelection()) {
                    if (this.inputHandle.getMember() != null) {
                        this.inputHandle.drop("member", 0);
                    }
                    if (this.referencedLevelList != null && this.referencedLevelList.size() > 0) {
                        this.inputHandle.add("member", (DesignElementHandle)this.memberValueHandle);
                    }
                } else if (this.measureBtn.getSelection() && this.inputHandle.getMember() != null) {
                    this.inputHandle.drop("member", 0);
                }
            } else if (this.groupBtn.getSelection() && level != this.levelViewHandle || this.measureBtn.getSelection() && measure != this.measureViewHandle) {
                FilterConditionElementHandle filter = DesignElementFactory.getInstance().newFilterConditionElement();
                filter.setProperty("operator", (Object)DEUtil.resolveNull((String)CrosstabFilterConditionBuilder.getValueForOperator((String)this.operator.getText())));
                filter.setExpr(DEUtil.resolveNull((String)this.expression.getText()));
                if (this.valueVisible == 3) {
                    filter.setValue1(this.valueList);
                    filter.setValue2("");
                } else {
                    assert (!this.expressionValue1.isDisposed());
                    assert (!this.expressionValue2.isDisposed());
                    if (this.expressionValue1.getVisible()) {
                        filter.setValue1(DEUtil.resolveNull((String)this.expressionValue1.getText()));
                    } else {
                        filter.setValue1(this.NULL_STRING);
                    }
                    if (this.expressionValue2.getVisible()) {
                        filter.setValue2(DEUtil.resolveNull((String)this.expressionValue2.getText()));
                    } else {
                        filter.setValue2(this.NULL_STRING);
                    }
                }
                if (this.levelViewHandle != null) {
                    this.levelViewHandle.getModelHandle().drop("filter", (DesignElementHandle)this.inputHandle);
                }
                if (this.measureViewHandle != null) {
                    this.measureViewHandle.getModelHandle().drop("filter", (DesignElementHandle)this.inputHandle);
                }
                if (this.groupBtn.getSelection()) {
                    if (this.referencedLevelList != null && this.referencedLevelList.size() > 0) {
                        filter.add("member", (DesignElementHandle)this.memberValueHandle);
                    }
                    level.getModelHandle().add("filter", (DesignElementHandle)filter);
                } else if (this.measureBtn.getSelection()) {
                    measure.getModelHandle().add("filter", (DesignElementHandle)filter);
                }
            }
        }
        catch (Exception e) {
            WidgetUtil.processError((Shell)this.getShell(), (Exception)e);
        }
        this.setReturnCode(0);
        this.close();
    }

    private List getReferableBindings(Object target) {
        List retList = new ArrayList();
        String targetString = null;
        CrosstabReportItemHandle crosstab = null;
        if (target instanceof LevelViewHandle) {
            LevelViewHandle level = (LevelViewHandle)target;
            if (level.getCubeLevel() == null) {
                return retList;
            }
            DimensionHandle dimensionHandle = CrosstabAdaptUtil.getDimensionHandle(level.getCubeLevel());
            targetString = ExpressionUtil.createJSDimensionExpression((String)dimensionHandle.getName(), (String)level.getCubeLevel().getName());
            crosstab = level.getCrosstab();
        } else if (target instanceof MeasureViewHandle) {
            MeasureViewHandle measure = (MeasureViewHandle)target;
            if (measure.getCubeMeasure() == null) {
                return retList;
            }
            targetString = measure.getCubeMeasure().getName();
            crosstab = measure.getCrosstab();
        }
        ICubeQueryDefinition cubeQueryDefn = null;
        DataRequestSession session = null;
        try {
            session = DataRequestSession.newSession((DataSessionContext)new DataSessionContext(3));
            cubeQueryDefn = CrosstabUIHelper.createBindingQuery(crosstab);
            if (target instanceof LevelViewHandle) {
                retList = session.getCubeQueryUtil().getReferableBindings(targetString, cubeQueryDefn, false);
            } else if (target instanceof MeasureViewHandle) {
                retList = session.getCubeQueryUtil().getReferableMeasureBindings(targetString, cubeQueryDefn);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        return retList;
    }

    private MemberValueHandle getChildMemberValue(MemberValueHandle memberValue) {
        if (memberValue.getContentCount("memberValues") != 1 || memberValue.getContent("memberValues", 0) == null) {
            return null;
        }
        return (MemberValueHandle)memberValue.getContent("memberValues", 0);
    }

    private void dropChildMemberValue(MemberValueHandle memberValue) {
        MemberValueHandle child = this.getChildMemberValue(memberValue);
        if (child == null) {
            return;
        }
        try {
            memberValue.drop("memberValues", 0);
        }
        catch (SemanticException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    private MemberValueHandle updateMemberValuesFromLevelList(List referenceLevels, MemberValueHandle memberValue) {
        if (this.measureBtn.getSelection()) {
            this.memberValueGroup.setVisible(false);
            return null;
        }
        this.memberValueGroup.setVisible(true);
        int count = referenceLevels.size();
        MemberValueHandle lastMemberValue = memberValue;
        int hasCount = 0;
        while (true) {
            LevelHandle tempLevel = this.getLevelHandle((IDimensionLevel)referenceLevels.get(++hasCount - 1));
            if (lastMemberValue.getLevel() != tempLevel) {
                try {
                    lastMemberValue.setLevel(tempLevel);
                    this.dropChildMemberValue(lastMemberValue);
                }
                catch (SemanticException e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
                break;
            }
            if (this.getChildMemberValue(lastMemberValue) == null) break;
            if (hasCount >= count) {
                this.dropChildMemberValue(lastMemberValue);
                break;
            }
            lastMemberValue = this.getChildMemberValue(lastMemberValue);
        }
        int i = hasCount;
        while (i < count) {
            MemberValueHandle newValue = DesignElementFactory.getInstance().newMemberValue();
            LevelHandle tempLevel = this.getLevelHandle((IDimensionLevel)referenceLevels.get(i));
            try {
                newValue.setLevel(tempLevel);
                lastMemberValue.add("memberValues", (DesignElementHandle)newValue);
            }
            catch (SemanticException e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
            lastMemberValue = newValue;
            ++i;
        }
        return memberValue;
    }

    private LevelHandle getLevelHandle(IDimensionLevel levelInfo) {
        LevelHandle levelHandle = null;
        String levelName = levelInfo.getLevelName();
        String dimensionName = levelInfo.getDimensionName();
        ExtendedItemHandle extHandle = (ExtendedItemHandle)this.designHandle;
        CrosstabReportItemHandle crosstab = null;
        try {
            crosstab = (CrosstabReportItemHandle)extHandle.getReportItem();
        }
        catch (ExtendedElementException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        DimensionViewHandle dimension = CrosstabUtil.getDimensionViewHandle((CrosstabReportItemHandle)crosstab, (String)dimensionName);
        LevelViewHandle level = dimension.findLevel(levelName);
        levelHandle = level.getCubeLevel();
        return levelHandle;
    }

    private void updateMemberValues() {
        if (this.measureBtn.getSelection()) {
            this.memberValueGroup.setVisible(false);
            return;
        }
        this.memberValueGroup.setVisible(true);
        if (this.comboGroupLevel.getSelectionIndex() < 0 || this.expression.getText().length() == 0) {
            this.memberValueTable.setEnabled(false);
            return;
        }
        LevelViewHandle level = null;
        if (this.comboGroupLevel.getSelectionIndex() != -1 && this.groupLevelList != null && this.groupLevelList.size() > 0) {
            level = (LevelViewHandle)this.groupLevelList.get(this.comboGroupLevel.getSelectionIndex());
        }
        if (level == null) {
            this.memberValueTable.setEnabled(false);
            return;
        }
        if (level.getAxisType() == 1) {
            this.group.setText(Messages.getString("CrosstabFilterConditionBuilder.Label.SelColumnMemberValue"));
        } else {
            this.group.setText(Messages.getString("CrosstabFilterConditionBuilder.Label.SelRowMemberValue"));
        }
        this.referencedLevelList = CrosstabUtil.getReferencedLevels((LevelViewHandle)level, (String)this.expression.getText());
        if (this.referencedLevelList == null || this.referencedLevelList.size() == 0) {
            this.memberValueTable.setEnabled(false);
            return;
        }
        this.editor.setReferencedLevelList(this.referencedLevelList);
        this.memberValueTable.setEnabled(true);
        this.memberValueHandle = null;
        if (level == this.levelViewHandle) {
            this.memberValueHandle = this.inputHandle.getMember();
        }
        if (this.memberValueHandle == null) {
            this.memberValueHandle = DesignElementFactory.getInstance().newMemberValue();
        }
        this.memberValueHandle = this.updateMemberValuesFromLevelList(this.referencedLevelList, this.memberValueHandle);
        List memList = this.getMemberValueList(this.memberValueHandle);
        this.dynamicViewer.setInput((Object)memList);
    }

    private List getMemberValueList(MemberValueHandle parent) {
        ArrayList<MemberValueHandle> list = new ArrayList<MemberValueHandle>();
        if (parent == null) {
            return list;
        }
        MemberValueHandle memberValue = parent;
        while (true) {
            list.add(memberValue);
            if (memberValue.getContentCount("memberValues") != 1 || memberValue.getContent("memberValues", 0) == null) break;
            memberValue = (MemberValueHandle)memberValue.getContent("memberValues", 0);
        }
        return list;
    }

    protected void setButtonCGridLayoutData(Button button) {
        CGridData data = new CGridData(256);
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        Point minSize = button.computeSize(-1, -1, true);
        data.widthHint = Math.max(widthHint, minSize.x);
        button.setLayoutData((Object)data);
    }

    private void initializeListener() {
        this.mAddExpValueAction = new MultiValueCombo.ISelection(){

            public void doAfterSelection(MultiValueCombo combo) {
                CrosstabFilterConditionBuilder.this.mAddSelValueAction.doAfterSelection(combo);
            }

            public String[] doSelection(String input) {
                String[] retValue = null;
                ExpressionBuilder dialog = new ExpressionBuilder(PlatformUI.getWorkbench().getDisplay().getActiveShell(), input);
                dialog.setExpressionProvier((IExpressionProvider)new CrosstabFilterExpressionProvider(CrosstabFilterConditionBuilder.this.designHandle));
                if (dialog.open() == 0 && dialog.getResult().length() != 0) {
                    retValue = new String[]{dialog.getResult()};
                }
                return retValue;
            }
        };
        this.mAddSelValueAction = new MultiValueCombo.ISelection(){

            public void doAfterSelection(MultiValueCombo combo) {
                CrosstabFilterConditionBuilder.this.addBtn.setEnabled(false);
                if (CrosstabFilterConditionBuilder.this.addExpressionValue.getSelStrings().length == 1) {
                    CrosstabFilterConditionBuilder.this.addExpressionValue.setText(DEUtil.resolveNull((String)CrosstabFilterConditionBuilder.this.addExpressionValue.getSelStrings()[0]));
                } else if (CrosstabFilterConditionBuilder.this.addExpressionValue.getSelStrings().length > 1) {
                    CrosstabFilterConditionBuilder.this.addExpressionValue.setText("");
                }
                boolean change = false;
                int i = 0;
                while (i < CrosstabFilterConditionBuilder.this.addExpressionValue.getSelStrings().length) {
                    if (CrosstabFilterConditionBuilder.this.valueList.indexOf(DEUtil.resolveNull((String)CrosstabFilterConditionBuilder.this.addExpressionValue.getSelStrings()[i])) < 0) {
                        CrosstabFilterConditionBuilder.this.valueList.add(DEUtil.resolveNull((String)CrosstabFilterConditionBuilder.this.addExpressionValue.getSelStrings()[i]));
                        change = true;
                    }
                    ++i;
                }
                if (change) {
                    CrosstabFilterConditionBuilder.this.tableViewer.refresh();
                    CrosstabFilterConditionBuilder.this.updateButtons();
                    CrosstabFilterConditionBuilder.this.addExpressionValue.setFocus();
                }
            }

            public String[] doSelection(String input) {
                String[] retValue = null;
                List selectValueList = CrosstabFilterConditionBuilder.this.getSelectedValueList();
                if (selectValueList == null || selectValueList.size() == 0) {
                    MessageDialog.openInformation(null, (String)Messages.getString("SelectValueDialog.selectValue"), (String)Messages.getString("SelectValueDialog.messages.info.selectVauleUnavailable"));
                } else {
                    SelectValueDialog dialog = new SelectValueDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), Messages.getString("ExpressionValueCellEditor.title"));
                    dialog.setSelectedValueList((Collection)selectValueList);
                    dialog.setMultipleSelection(true);
                    if (dialog.open() == 0) {
                        retValue = dialog.getSelectedExprValues();
                    }
                }
                return retValue;
            }
        };
        this.selectValueAction = new ValueCombo.ISelection(){

            public String doSelection(String input) {
                String retValue = null;
                List selectValueList = CrosstabFilterConditionBuilder.this.getSelectedValueList();
                if (selectValueList == null || selectValueList.size() == 0) {
                    MessageDialog.openInformation(null, (String)Messages.getString("SelectValueDialog.selectValue"), (String)Messages.getString("SelectValueDialog.messages.info.selectVauleUnavailable"));
                } else {
                    SelectValueDialog dialog = new SelectValueDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), Messages.getString("ExpressionValueCellEditor.title"));
                    dialog.setSelectedValueList((Collection)selectValueList);
                    if (dialog.open() == 0) {
                        retValue = dialog.getSelectedExprValue();
                    }
                }
                return retValue;
            }
        };
        this.expValueAction = new ValueCombo.ISelection(){

            public String doSelection(String input) {
                String retValue = null;
                ExpressionBuilder dialog = new ExpressionBuilder(PlatformUI.getWorkbench().getDisplay().getActiveShell(), input);
                dialog.setExpressionProvier((IExpressionProvider)new CrosstabFilterExpressionProvider(CrosstabFilterConditionBuilder.this.designHandle));
                if (dialog.open() == 0) {
                    retValue = dialog.getResult();
                }
                return retValue;
            }
        };
        this.filterByAction = new ValueCombo.ISelection(){

            public String doSelection(String input) {
                String retValue = null;
                List bindingList = new ArrayList();
                LevelViewHandle level = null;
                MeasureViewHandle measure = null;
                if (CrosstabFilterConditionBuilder.this.groupBtn.getSelection()) {
                    if (CrosstabFilterConditionBuilder.this.comboGroupLevel.getSelectionIndex() != -1 && CrosstabFilterConditionBuilder.this.groupLevelList != null && CrosstabFilterConditionBuilder.this.groupLevelList.size() > 0) {
                        level = (LevelViewHandle)CrosstabFilterConditionBuilder.this.groupLevelList.get(CrosstabFilterConditionBuilder.this.comboGroupLevel.getSelectionIndex());
                    }
                    if (level == null) {
                        return retValue;
                    }
                    bindingList = CrosstabFilterConditionBuilder.this.getReferableBindings(level);
                } else if (CrosstabFilterConditionBuilder.this.measureBtn.getSelection()) {
                    if (CrosstabFilterConditionBuilder.this.comboGroupLevel.getSelectionIndex() != -1 && CrosstabFilterConditionBuilder.this.measureList != null && CrosstabFilterConditionBuilder.this.measureList.size() > 0) {
                        measure = (MeasureViewHandle)CrosstabFilterConditionBuilder.this.measureList.get(CrosstabFilterConditionBuilder.this.comboGroupLevel.getSelectionIndex());
                    }
                    if (measure == null) {
                        return retValue;
                    }
                    bindingList = CrosstabFilterConditionBuilder.this.getReferableBindings(measure);
                }
                BindingGroup[] bindingGroup = new BindingGroup[]{new BindingGroup(1), new BindingGroup(2), new BindingGroup(11), new BindingGroup(12), new BindingGroup(13)};
                int i = 0;
                while (i < bindingList.size()) {
                    IBindingMetaInfo metaInfo = (IBindingMetaInfo)bindingList.get(i);
                    int j = 0;
                    while (j < bindingGroup.length) {
                        if (bindingGroup[j].type == metaInfo.getBindingType()) {
                            bindingGroup[j].addBinding(metaInfo.getBindingName());
                            break;
                        }
                        ++j;
                    }
                    ++i;
                }
                TreeValueDialog dialog = new TreeValueDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), CrosstabFilterConditionBuilder.this.treeLabelProvider, CrosstabFilterConditionBuilder.this.treeContentProvider);
                dialog.setInput((Object)bindingGroup);
                dialog.setValidator(CrosstabFilterConditionBuilder.this.vialidator);
                dialog.setTitle(Messages.getString("FilterbyTree.Title"));
                dialog.setMessage(Messages.getString("FilterbyTree.Message"));
                dialog.addListener(42, CrosstabFilterConditionBuilder.this.valueTreePaintListener);
                if (dialog.open() == 0) {
                    String string = (String)dialog.getResult()[0];
                    retValue = ExpressionUtil.createJSDataExpression((String)string);
                }
                return retValue;
            }
        };
    }

    protected void editTableValue() {
        IStructuredSelection selection = (IStructuredSelection)this.tableViewer.getSelection();
        if (selection.getFirstElement() != null && selection.getFirstElement() instanceof String) {
            String initValue = (String)selection.getFirstElement();
            ExpressionBuilder expressionBuilder = new ExpressionBuilder(this.getShell(), initValue);
            if (this.designHandle != null) {
                if (this.expressionProvider == null || !(this.expressionProvider instanceof CrosstabFilterExpressionProvider)) {
                    this.expressionProvider = new CrosstabFilterExpressionProvider(this.designHandle);
                }
                expressionBuilder.setExpressionProvier(this.expressionProvider);
            }
            if (expressionBuilder.open() == 0) {
                String result = DEUtil.resolveNull((String)expressionBuilder.getResult());
                if (result.length() == 0) {
                    MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.getString("MapRuleBuilderDialog.MsgDlg.Title"), (String)Messages.getString("MapRuleBuilderDialog.MsgDlg.Msg"));
                    return;
                }
                int index = this.table.getSelectionIndex();
                this.valueList.remove(index);
                this.valueList.add(index, result);
                this.tableViewer.refresh();
                this.table.select(index);
            }
            this.updateButtons();
        } else {
            this.editBtn.setEnabled(false);
        }
    }

    static /* synthetic */ Logger access$10() {
        return FilterConditionBuilder.logger;
    }

    class BindingGroup {
        int type;
        String displayName;
        List list = new ArrayList();

        BindingGroup(int type) {
            this.type = type;
        }

        void addBinding(String bindingName) {
            this.list.add(bindingName);
        }

        List getBindings() {
            return this.list;
        }

        String getBindingGroupName() {
            if (this.type == 1) {
                return Messages.getString("FilterbyTree.Bindings.Catogory.Measures");
            }
            if (this.type == 2) {
                return Messages.getString("FilterbyTree.Bindings.Catogory.Dimension");
            }
            if (this.type == 11) {
                return Messages.getString("FilterbyTree.Bindings.Catogory.GrandTotal");
            }
            if (this.type == 12) {
                return Messages.getString("FilterbyTree.Bindings.Catogory.SubTotal");
            }
            if (this.type == 13) {
                return Messages.getString("FilterbyTree.Bindings.Catogory.OtherType");
            }
            return Messages.getString("FilterbyTree.Bindings.Catogory.Undefined");
        }
    }
}

