/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.usagedata.internal.gathering.monitors;

import org.eclipse.epp.usagedata.internal.gathering.monitors.ExtensionIdToBundleMapper;
import org.eclipse.epp.usagedata.internal.gathering.monitors.UsageMonitor;
import org.eclipse.epp.usagedata.internal.gathering.services.UsageDataService;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class PartUsageMonitor
implements UsageMonitor {
    private UsageDataService usageDataService;
    private IWindowListener windowListener = new IWindowListener(){

        public void windowOpened(IWorkbenchWindow window) {
            PartUsageMonitor.this.recordEvent("opened", window);
            PartUsageMonitor.this.hookListener(window);
        }

        public void windowClosed(IWorkbenchWindow window) {
            PartUsageMonitor.this.recordEvent("closed", window);
            PartUsageMonitor.this.unhookListeners(window);
        }

        public void windowActivated(IWorkbenchWindow window) {
            PartUsageMonitor.this.recordEvent("activated", window);
        }

        public void windowDeactivated(IWorkbenchWindow window) {
            PartUsageMonitor.this.recordEvent("deactivated", window);
        }
    };
    private IPageListener pageListener = new IPageListener(){

        public void pageActivated(IWorkbenchPage page) {
        }

        public void pageClosed(IWorkbenchPage page) {
            PartUsageMonitor.this.unhookListeners(page);
        }

        public void pageOpened(IWorkbenchPage page) {
            PartUsageMonitor.this.hookListeners(page);
        }
    };
    private IPartListener partListener = new IPartListener(){

        public void partActivated(IWorkbenchPart part) {
            PartUsageMonitor.this.recordEvent("activated", part);
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
            PartUsageMonitor.this.recordEvent("closed", part);
        }

        public void partOpened(IWorkbenchPart part) {
            PartUsageMonitor.this.recordEvent("opened", part);
        }
    };
    private IPerspectiveListener perspectiveListener = new IPerspectiveListener(){

        public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
            PartUsageMonitor.this.recordEvent("activated", perspective);
        }

        public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
        }
    };
    private ExtensionIdToBundleMapper perspectiveToBundleIdMapper;

    public void startMonitoring(UsageDataService usageDataService) {
        this.usageDataService = usageDataService;
        IWorkbench workbench = PlatformUI.getWorkbench();
        this.perspectiveToBundleIdMapper = new ExtensionIdToBundleMapper("org.eclipse.ui.perspectives");
        this.hookListeners(workbench);
    }

    public void stopMonitoring() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        this.unhookListeners(workbench);
        this.perspectiveToBundleIdMapper.dispose();
    }

    private void hookListeners(IWorkbench workbench) {
        workbench.addWindowListener(this.windowListener);
        IWorkbenchWindow[] iWorkbenchWindowArray = workbench.getWorkbenchWindows();
        int n = iWorkbenchWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
            this.hookListener(window);
            ++n2;
        }
    }

    private void unhookListeners(IWorkbench workbench) {
        if (workbench.getDisplay().isDisposed()) {
            return;
        }
        workbench.removeWindowListener(this.windowListener);
        IWorkbenchWindow[] iWorkbenchWindowArray = workbench.getWorkbenchWindows();
        int n = iWorkbenchWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
            this.unhookListeners(window);
            ++n2;
        }
    }

    private void hookListener(IWorkbenchWindow window) {
        if (window == null) {
            return;
        }
        window.addPageListener(this.pageListener);
        window.addPerspectiveListener(this.perspectiveListener);
        IWorkbenchPage[] iWorkbenchPageArray = window.getPages();
        int n = iWorkbenchPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchPage page = iWorkbenchPageArray[n2];
            this.hookListeners(page);
            ++n2;
        }
    }

    private void unhookListeners(IWorkbenchWindow window) {
        if (window == null) {
            return;
        }
        window.removePageListener(this.pageListener);
        window.removePerspectiveListener(this.perspectiveListener);
        IWorkbenchPage[] iWorkbenchPageArray = window.getPages();
        int n = iWorkbenchPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchPage page = iWorkbenchPageArray[n2];
            this.unhookListeners(page);
            ++n2;
        }
    }

    private void hookListeners(IWorkbenchPage page) {
        IPerspectiveDescriptor perspective = page.getPerspective();
        if (perspective != null) {
            this.recordEvent("activated", perspective);
        }
        page.addPartListener(this.partListener);
    }

    private void unhookListeners(IWorkbenchPage page) {
        page.removePartListener(this.partListener);
    }

    protected void recordEvent(String event, IWorkbenchWindow window) {
        this.usageDataService.recordEvent(event, "workbench", "", "org.eclipse.ui.workbench");
    }

    protected void recordEvent(String event, IPerspectiveDescriptor perspective) {
        String id = perspective.getId();
        this.usageDataService.recordEvent(event, "perspective", id, this.perspectiveToBundleIdMapper.getBundleId(id));
    }

    private void recordEvent(String event, IWorkbenchPart part) {
        IWorkbenchPartSite site = part.getSite();
        this.usageDataService.recordEvent(event, this.getKind(site), site.getId(), site.getPluginId());
    }

    private String getKind(IWorkbenchPartSite site) {
        if (site instanceof IEditorSite) {
            return "editor";
        }
        if (site instanceof IViewSite) {
            return "view";
        }
        return "part";
    }
}

