/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.context.core;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.context.core.AbstractContextStructureBridge;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.context.core.IInteractionContextScaling;
import org.eclipse.mylyn.internal.context.core.AbstractRelationProvider;
import org.eclipse.mylyn.internal.context.core.InteractionContextManager;
import org.eclipse.mylyn.internal.context.core.InteractionContextScaling;
import org.eclipse.mylyn.internal.context.core.LocalContextStore;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextCorePlugin
extends Plugin {
    public static final String ID_PLUGIN = "org.eclipse.mylyn.core";
    private final Map<String, AbstractContextStructureBridge> bridges = new ConcurrentHashMap<String, AbstractContextStructureBridge>();
    private final Map<String, Set<String>> childContentTypeMap = new ConcurrentHashMap<String, Set<String>>();
    private AbstractContextStructureBridge defaultBridge = null;
    private static ContextCorePlugin INSTANCE;
    private InteractionContextManager contextManager;
    private static LocalContextStore contextStore;
    private final Map<String, Set<AbstractRelationProvider>> relationProviders = new HashMap<String, Set<AbstractRelationProvider>>();
    private final InteractionContextScaling commonContextScaling = new InteractionContextScaling();
    private static final AbstractContextStructureBridge DEFAULT_BRIDGE;

    static {
        DEFAULT_BRIDGE = new AbstractContextStructureBridge(){

            @Override
            public String getContentType() {
                return null;
            }

            @Override
            public String getHandleIdentifier(Object object) {
                return null;
            }

            @Override
            public Object getObjectForHandle(String handle) {
                return null;
            }

            @Override
            public String getParentHandle(String handle) {
                return null;
            }

            @Override
            public String getLabel(Object object) {
                return "";
            }

            @Override
            public boolean canBeLandmark(String handle) {
                return false;
            }

            @Override
            public boolean acceptsObject(Object object) {
                return false;
            }

            @Override
            public boolean canFilter(Object element) {
                return true;
            }

            @Override
            public boolean isDocument(String handle) {
                return false;
            }

            @Override
            public String getContentType(String elementHandle) {
                return this.getContentType();
            }

            @Override
            public String getHandleForOffsetInObject(Object resource, int offset) {
                return null;
            }

            @Override
            public List<String> getChildHandles(String handle) {
                return Collections.emptyList();
            }
        };
    }

    public ContextCorePlugin() {
        INSTANCE = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        contextStore = new LocalContextStore(this.commonContextScaling);
        this.contextManager = new InteractionContextManager(contextStore);
    }

    public void stop(BundleContext context) throws Exception {
        try {
            super.stop(context);
            INSTANCE = null;
            for (AbstractRelationProvider provider : this.getRelationProviders()) {
                provider.stopAllRunningJobs();
            }
        }
        catch (Exception e) {
            StatusHandler.log((IStatus)new Status(4, ID_PLUGIN, "Mylyn Core stop failed", (Throwable)e));
        }
    }

    private void addRelationProvider(String contentType, AbstractRelationProvider provider) {
        Set<AbstractRelationProvider> providers = this.relationProviders.get(contentType);
        if (providers == null) {
            providers = new HashSet<AbstractRelationProvider>();
            this.relationProviders.put(contentType, providers);
        }
        providers.add(provider);
        ContextCore.getContextManager().addListener(provider);
    }

    public Set<AbstractRelationProvider> getRelationProviders() {
        HashSet<AbstractRelationProvider> allProviders = new HashSet<AbstractRelationProvider>();
        for (Set<AbstractRelationProvider> providers : this.relationProviders.values()) {
            allProviders.addAll(providers);
        }
        return allProviders;
    }

    public Set<AbstractRelationProvider> getRelationProviders(String contentType) {
        return this.relationProviders.get(contentType);
    }

    public static ContextCorePlugin getDefault() {
        return INSTANCE;
    }

    public static InteractionContextManager getContextManager() {
        return ContextCorePlugin.INSTANCE.contextManager;
    }

    public Map<String, AbstractContextStructureBridge> getStructureBridges() {
        BridgesExtensionPointReader.initExtensions();
        return this.bridges;
    }

    public AbstractContextStructureBridge getStructureBridge(String contentType) {
        AbstractContextStructureBridge bridge;
        BridgesExtensionPointReader.initExtensions();
        if (contentType != null && (bridge = this.bridges.get(contentType)) != null) {
            return bridge;
        }
        return this.defaultBridge == null ? DEFAULT_BRIDGE : this.defaultBridge;
    }

    public Set<String> getContentTypes() {
        BridgesExtensionPointReader.initExtensions();
        return this.bridges.keySet();
    }

    public AbstractContextStructureBridge getStructureBridge(Object object) {
        BridgesExtensionPointReader.initExtensions();
        for (AbstractContextStructureBridge structureBridge : this.bridges.values()) {
            if (!structureBridge.acceptsObject(object)) continue;
            return structureBridge;
        }
        return this.defaultBridge != null && this.defaultBridge.acceptsObject(object) ? this.defaultBridge : DEFAULT_BRIDGE;
    }

    public synchronized void addStructureBridge(AbstractContextStructureBridge bridge) {
        if (bridge.getContentType().equals("resource")) {
            this.defaultBridge = bridge;
        } else {
            this.bridges.put(bridge.getContentType(), bridge);
        }
        if (bridge.getParentContentType() != null) {
            Set<String> childContentTypes = this.childContentTypeMap.get(bridge.getParentContentType());
            if (childContentTypes == null) {
                childContentTypes = new CopyOnWriteArraySet<String>();
            }
            childContentTypes.add(bridge.getContentType());
            this.childContentTypeMap.put(bridge.getParentContentType(), childContentTypes);
        }
    }

    public static LocalContextStore getContextStore() {
        return contextStore;
    }

    public Set<String> getChildContentTypes(String contentType) {
        Set<String> contentTypes = this.childContentTypeMap.get(contentType);
        if (contentTypes != null) {
            return contentTypes;
        }
        return Collections.emptySet();
    }

    public IInteractionContextScaling getCommonContextScaling() {
        return this.commonContextScaling;
    }

    static class BridgesExtensionPointReader {
        private static final String EXTENSION_ID_CONTEXT = "org.eclipse.mylyn.context.core.bridges";
        private static final String EXTENSION_ID_RELATION_PROVIDERS = "org.eclipse.mylyn.context.core.relationProviders";
        private static final String ELEMENT_STRUCTURE_BRIDGE = "structureBridge";
        private static final String ELEMENT_RELATION_PROVIDER = "provider";
        private static final String ATTR_CLASS = "class";
        private static final String ATTR_CONTENT_TYPE = "contentType";
        private static final String ATTR_PARENT_CONTENT_TYPE = "parentContentType";
        private static boolean extensionsRead = false;

        BridgesExtensionPointReader() {
        }

        public static void initExtensions() {
            if (!extensionsRead) {
                IConfigurationElement element;
                int n;
                int n2;
                IConfigurationElement[] iConfigurationElementArray;
                IConfigurationElement[] elements;
                IExtension extension;
                IExtension[] extensions;
                IExtensionRegistry registry = Platform.getExtensionRegistry();
                IExtensionPoint extensionPoint = registry.getExtensionPoint(EXTENSION_ID_CONTEXT);
                IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
                int n3 = extensions.length;
                int n4 = 0;
                while (n4 < n3) {
                    extension = iExtensionArray[n4];
                    iConfigurationElementArray = elements = extension.getConfigurationElements();
                    n2 = elements.length;
                    n = 0;
                    while (n < n2) {
                        element = iConfigurationElementArray[n];
                        if (element.getName().compareTo(ELEMENT_STRUCTURE_BRIDGE) == 0) {
                            BridgesExtensionPointReader.readBridge(element);
                        }
                        ++n;
                    }
                    ++n4;
                }
                extensionPoint = registry.getExtensionPoint(EXTENSION_ID_RELATION_PROVIDERS);
                iExtensionArray = extensions = extensionPoint.getExtensions();
                n3 = extensions.length;
                n4 = 0;
                while (n4 < n3) {
                    extension = iExtensionArray[n4];
                    iConfigurationElementArray = elements = extension.getConfigurationElements();
                    n2 = elements.length;
                    n = 0;
                    while (n < n2) {
                        element = iConfigurationElementArray[n];
                        if (element.getName().compareTo(ELEMENT_RELATION_PROVIDER) == 0) {
                            BridgesExtensionPointReader.readRelationProvider(element);
                        }
                        ++n;
                    }
                    ++n4;
                }
                extensionsRead = true;
            }
        }

        private static void readBridge(IConfigurationElement element) {
            try {
                String parentContentType;
                Object object = element.createExecutableExtension(ATTR_CLASS);
                if (!(object instanceof AbstractContextStructureBridge)) {
                    StatusHandler.log((IStatus)new Status(2, ContextCorePlugin.ID_PLUGIN, "Could not load bridge: " + object.getClass().getCanonicalName() + " must implement " + AbstractContextStructureBridge.class.getCanonicalName()));
                    return;
                }
                AbstractContextStructureBridge bridge = (AbstractContextStructureBridge)object;
                if (element.getAttribute(ATTR_PARENT_CONTENT_TYPE) != null && (parentContentType = element.getAttribute(ATTR_PARENT_CONTENT_TYPE)) != null) {
                    bridge.setParentContentType(parentContentType);
                }
                ContextCorePlugin.getDefault().addStructureBridge(bridge);
            }
            catch (CoreException e) {
                StatusHandler.log((IStatus)new Status(2, ContextCorePlugin.ID_PLUGIN, "Could not load bridge extension", (Throwable)e));
            }
        }

        private static void readRelationProvider(IConfigurationElement element) {
            try {
                String contentType = element.getAttribute(ATTR_CONTENT_TYPE);
                AbstractRelationProvider relationProvider = (AbstractRelationProvider)element.createExecutableExtension(ATTR_CLASS);
                if (contentType != null) {
                    ContextCorePlugin.getDefault().addRelationProvider(contentType, relationProvider);
                }
            }
            catch (Exception e) {
                StatusHandler.log((IStatus)new Status(2, ContextCorePlugin.ID_PLUGIN, "Could not load relation provider", (Throwable)e));
            }
        }
    }
}

