/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.gen.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.jpt.db.Column;
import org.eclipse.jpt.db.ForeignKey;
import org.eclipse.jpt.db.Table;
import org.eclipse.jpt.gen.internal.EntityGenTools;
import org.eclipse.jpt.gen.internal.EntityGenerator;
import org.eclipse.jpt.gen.internal.GenScope;
import org.eclipse.jpt.gen.internal.ManyToManyRelation;
import org.eclipse.jpt.gen.internal.ManyToOneRelation;
import org.eclipse.jpt.gen.internal.OneToManyRelation;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.NameTools;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.iterators.FilteringIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GenTable {
    private final GenScope scope;
    private final Table table;
    private ManyToManyRelation joinTableRelation;
    private final ArrayList<ManyToManyRelation> ownedManyToManyRelations = new ArrayList();
    private final ArrayList<ManyToManyRelation> nonOwnedManyToManyRelations = new ArrayList();
    private final ArrayList<ManyToOneRelation> manyToOneRelations = new ArrayList();
    private final ArrayList<OneToManyRelation> oneToManyRelations = new ArrayList();
    private final HashSet<Column> foreignKeyColumns = new HashSet();
    private final HashMap<Object, String> attributeNames = new HashMap();
    private static final Object EMBEDDED_ID_VIRTUAL_COLUMN = new Object();

    GenTable(GenScope scope, Table table) {
        this.scope = scope;
        this.table = table;
    }

    EntityGenerator.Config getEntityConfig() {
        return this.scope.getEntityConfig();
    }

    String getCollectionAttributeName() {
        String name = this.getName();
        String suffix = this.getEntityConfig().getCollectionAttributeNameSuffix();
        if (StringTools.stringIsUppercase((String)name)) {
            suffix = String.valueOf('_') + suffix.toUpperCase();
        }
        return String.valueOf(name) + suffix;
    }

    void buildJoinTableRelation() {
        if (!this.table.isPossibleJoinTable()) {
            return;
        }
        ForeignKey owningFK = this.table.getJoinTableOwningForeignKey();
        GenTable owningGenTable = this.scope.getGenTable(owningFK.getReferencedTable());
        if (owningGenTable == null) {
            return;
        }
        ForeignKey nonOwningFK = this.table.getJoinTableNonOwningForeignKey();
        GenTable nonOwningGenTable = this.scope.getGenTable(nonOwningFK.getReferencedTable());
        if (nonOwningGenTable == null) {
            return;
        }
        this.joinTableRelation = new ManyToManyRelation(this, owningFK, owningGenTable, nonOwningFK, nonOwningGenTable);
    }

    void addReferencedGenTablesTo(Set<GenTable> referencedTables) {
        Iterator stream = this.table.foreignKeys();
        while (stream.hasNext()) {
            ForeignKey fk = (ForeignKey)stream.next();
            GenTable genTable = this.scope.getGenTable(fk.getReferencedTable());
            if (genTable == null) continue;
            referencedTables.add(genTable);
        }
    }

    void clearJoinTableRelation() {
        this.joinTableRelation.clear();
        this.joinTableRelation = null;
    }

    void buildManyToOneRelations() {
        Iterator stream = this.table.foreignKeys();
        while (stream.hasNext()) {
            ForeignKey fk = (ForeignKey)stream.next();
            GenTable referencedGenTable = this.scope.getGenTable(fk.getReferencedTable());
            if (referencedGenTable == null) continue;
            this.manyToOneRelations.add(new ManyToOneRelation(this, fk, referencedGenTable));
        }
    }

    void buildAttributeNames() {
        if (this.table.primaryKeyColumnsSize() > 1 && this.getEntityConfig().generateEmbeddedIdForCompoundPK()) {
            this.configureAttributeName(EMBEDDED_ID_VIRTUAL_COLUMN, this.getEntityConfig().getEmbeddedIdAttributeName());
        }
        Set columns = CollectionTools.set((Iterator)this.table.columns(), (int)this.table.columnsSize());
        this.buildManyToOneAttributeNames(columns);
        this.buildBasicAttributeNames(columns);
        this.buildOneToManyAttributeNames();
        this.buildOwnedManyToManyAttributeNames();
        this.buildNonOwnedManyToManyAttributeNames();
    }

    Iterator<Column> readOnlyPrimaryKeyColumns() {
        return new FilteringIterator<Column, Column>(this.table.primaryKeyColumns()){

            protected boolean accept(Column pkColumn) {
                return pkColumn.isPartOfForeignKey();
            }
        };
    }

    Iterator<Column> writablePrimaryKeyColumns() {
        return new FilteringIterator<Column, Column>(this.table.primaryKeyColumns()){

            protected boolean accept(Column pkColumn) {
                return !pkColumn.isPartOfForeignKey();
            }
        };
    }

    Iterator<Column> nonPrimaryKeyBasicColumns() {
        return new FilteringIterator<Column, Column>(this.table.columns()){

            protected boolean accept(Column column) {
                return !column.isPartOfPrimaryKey() && !column.isPartOfForeignKey();
            }
        };
    }

    Table getTable() {
        return this.table;
    }

    String getEntityName() {
        return this.getEntityConfig().getEntityName(this.table);
    }

    boolean isJoinTable() {
        return this.joinTableRelation != null;
    }

    void addOwnedManyToManyRelation(ManyToManyRelation relation) {
        this.ownedManyToManyRelations.add(relation);
    }

    void removeOwnedManyToManyRelation(ManyToManyRelation relation) {
        this.ownedManyToManyRelations.remove(relation);
    }

    void addNonOwnedManyToManyRelation(ManyToManyRelation relation) {
        this.nonOwnedManyToManyRelations.add(relation);
    }

    void removeNonOwnedManyToManyRelation(ManyToManyRelation relation) {
        this.nonOwnedManyToManyRelations.remove(relation);
    }

    void addOneToManyRelation(OneToManyRelation relation) {
        this.oneToManyRelations.add(relation);
    }

    Iterator<ManyToOneRelation> manyToOneRelations() {
        return this.manyToOneRelations.iterator();
    }

    Iterator<OneToManyRelation> oneToManyRelations() {
        return this.oneToManyRelations.iterator();
    }

    Iterator<ManyToManyRelation> ownedManyToManyRelations() {
        return this.ownedManyToManyRelations.iterator();
    }

    Iterator<ManyToManyRelation> nonOwnedManyToManyRelations() {
        return this.nonOwnedManyToManyRelations.iterator();
    }

    private String getAttributeNameFor_(Object o) {
        return this.attributeNames.get(o);
    }

    String getAttributeNameForEmbeddedId() {
        return this.getAttributeNameFor_(EMBEDDED_ID_VIRTUAL_COLUMN);
    }

    String getAttributeNameFor(Column column) {
        return this.getAttributeNameFor_(column);
    }

    String getAttributeNameFor(ManyToOneRelation relation) {
        return this.getAttributeNameFor_(relation);
    }

    String getAttributeNameFor(OneToManyRelation relation) {
        return this.getAttributeNameFor_(relation);
    }

    String getAttributeNameFor(ManyToManyRelation relation) {
        return this.getAttributeNameFor_(relation);
    }

    String getName() {
        return this.table.getName();
    }

    boolean joinTableNameIsDefault() {
        return this.table.joinTableNameIsDefault();
    }

    private void buildManyToOneAttributeNames(Set<Column> columns) {
        for (ManyToOneRelation relation : this.manyToOneRelations) {
            CollectionTools.removeAll(columns, (Iterator)relation.getForeignKey().nonPrimaryKeyBaseColumns());
            CollectionTools.addAll(this.foreignKeyColumns, (Iterator)relation.getForeignKey().baseColumns());
            relation.setMappedBy(this.configureAttributeName(relation, relation.getAttributeName()));
        }
    }

    private void buildBasicAttributeNames(Set<Column> columns) {
        for (Column column : columns) {
            this.configureAttributeName(column, column.getName());
        }
    }

    private void buildOneToManyAttributeNames() {
        for (OneToManyRelation relation : this.oneToManyRelations) {
            this.configureAttributeName(relation, relation.getAttributeName());
        }
    }

    private void buildOwnedManyToManyAttributeNames() {
        for (ManyToManyRelation relation : this.ownedManyToManyRelations) {
            relation.setMappedBy(this.configureAttributeName(relation, relation.getOwnedAttributeName()));
        }
    }

    private void buildNonOwnedManyToManyAttributeNames() {
        for (ManyToManyRelation relation : this.nonOwnedManyToManyRelations) {
            this.configureAttributeName(relation, relation.getNonOwnedAttributeName());
        }
    }

    private String configureAttributeName(Object o, String attributeName) {
        String result = attributeName;
        Collection<String> existingAttributeNames = this.attributeNames.values();
        if (this.getEntityConfig().convertToJavaStyleIdentifiers()) {
            result = EntityGenTools.convertToUniqueJavaStyleAttributeName(result, existingAttributeNames);
        } else {
            result = NameTools.convertToJavaIdentifier((String)result);
            result = NameTools.uniqueNameForIgnoreCase((String)attributeName, existingAttributeNames);
        }
        this.attributeNames.put(o, result);
        return result;
    }

    public String toString() {
        return StringTools.buildToStringFor((Object)this, (Object)this.table);
    }
}

