/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.debug.internal.ui.launcher.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.TreeMap;
import org.eclipse.core.internal.resources.ProjectDescription;
import org.eclipse.core.internal.resources.ProjectDescriptionReader;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.launcher.LaunchListener;
import org.osgi.framework.Bundle;

public class DebugUtil {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;

    public static void importProject(String prjFilePath) throws Exception {
        Path path = new Path(String.valueOf(prjFilePath) + File.separator + ".project");
        IProjectDescription newDescription = DebugUtil.loadProjectDescription((IPath)path);
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(newDescription.getName());
        if (project == null) {
            throw new Exception("DebugUtil.importProject.fail");
        }
        NullProgressMonitor monitor = new NullProgressMonitor();
        project.create(newDescription, (IProgressMonitor)monitor);
        project.open((IProgressMonitor)monitor);
    }

    private static IProjectDescription loadProjectDescription(IPath path) throws IOException {
        ProjectDescription result = null;
        result = new ProjectDescriptionReader().read(path);
        if (result != null) {
            IPath user = path.removeLastSegments(1);
            IPath platform = Platform.getLocation().append(result.getName());
            if (!user.toFile().equals(platform.toFile())) {
                result.setLocation(user);
            }
        }
        return result;
    }

    public static String copyToWorkspace(String folderPath) throws Exception {
        File folder = new File(folderPath);
        if (!folder.isDirectory()) {
            throw new Exception();
        }
        String newFolderName = folder.getName();
        String workspaceRootPath = ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString();
        String newFolderPath = String.valueOf(workspaceRootPath) + File.separator + newFolderName;
        File newFolder = new File(newFolderPath);
        if (!newFolder.exists()) {
            newFolder.mkdir();
        }
        DebugUtil.copyFiles(folder, newFolder);
        return newFolderPath;
    }

    private static void copyFiles(File folder, File newFolder) throws IOException {
        File[] folderFiles = folder.listFiles();
        if (folderFiles != null) {
            int i = 0;
            while (i < folderFiles.length) {
                if (folderFiles[i].isFile()) {
                    File newFile = new File(newFolder, folderFiles[i].getName());
                    if (!newFile.exists()) {
                        newFile.createNewFile();
                    }
                    DebugUtil.copyFile(folderFiles[i], newFile);
                } else {
                    File newSubFolder = new File(newFolder, folderFiles[i].getName());
                    if (!newSubFolder.exists()) {
                        newSubFolder.mkdir();
                    }
                    DebugUtil.copyFiles(folderFiles[i], newSubFolder);
                }
                ++i;
            }
        }
    }

    private static void copyFile(File in, File out) throws IOException {
        FileInputStream fis = new FileInputStream(in);
        FileOutputStream fos = new FileOutputStream(out);
        byte[] buf = new byte[1024];
        int i = 0;
        while ((i = fis.read(buf)) != -1) {
            fos.write(buf, 0, i);
        }
        fis.close();
        fos.close();
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = Platform.getResourceBundle((Bundle)PDEPlugin.getDefault().getBundleContext().getBundle());
        if (bundle != null) {
            try {
                String bundleString = bundle.getString(key);
                return bundleString;
            }
            catch (MissingResourceException missingResourceException) {}
        }
        return key;
    }

    public static LaunchListener getPDEPluginLaunchListener(PDEPlugin in) {
        Method method = null;
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.pde.internal.ui.PDEPlugin");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            method = clazz.getDeclaredMethod("getLaunchesListener", new Class[0]);
            return (LaunchListener)method.invoke((Object)in, new Object[0]);
        }
        catch (Exception exception) {
            if (method == null) {
                try {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.eclipse.pde.internal.ui.PDEPlugin");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    method = clazz.getDeclaredMethod("getLaunchListener", new Class[0]);
                    return (LaunchListener)method.invoke((Object)in, new Object[0]);
                }
                catch (Exception exception2) {}
            }
            return null;
        }
    }

    public static void runCreatePlatformConfigurationArea(TreeMap pluginMap, File configDir, String primaryFeatureId, HashMap autoStartPlugins) {
        Method method = null;
        try {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.pde.core.plugin.TargetPlatform");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Class[] classArray = new Class[4];
            Class<?> clazz2 = class$2;
            if (clazz2 == null) {
                try {
                    clazz2 = class$2 = Class.forName("java.util.TreeMap");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz2;
            Class<?> clazz3 = class$3;
            if (clazz3 == null) {
                try {
                    clazz3 = class$3 = Class.forName("java.io.File");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[1] = clazz3;
            Class<?> clazz4 = class$4;
            if (clazz4 == null) {
                try {
                    clazz4 = class$4 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[2] = clazz4;
            Class<?> clazz5 = class$5;
            if (clazz5 == null) {
                try {
                    clazz5 = class$5 = Class.forName("java.util.HashMap");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[3] = clazz5;
            method = clazz.getDeclaredMethod("createPlatformConfigurationArea", classArray);
            Class<?> clazz6 = class$1;
            if (clazz6 == null) {
                try {
                    clazz6 = class$1 = Class.forName("org.eclipse.pde.core.plugin.TargetPlatform");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            method.invoke(clazz6, pluginMap, configDir, primaryFeatureId, autoStartPlugins);
            return;
        }
        catch (Exception exception) {
            method = null;
            if (method == null) {
                try {
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = class$1 = Class.forName("org.eclipse.pde.core.plugin.TargetPlatform");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    Class[] classArray = new Class[3];
                    Class<?> clazz7 = class$2;
                    if (clazz7 == null) {
                        try {
                            clazz7 = class$2 = Class.forName("java.util.TreeMap");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    classArray[0] = clazz7;
                    Class<?> clazz8 = class$3;
                    if (clazz8 == null) {
                        try {
                            clazz8 = class$3 = Class.forName("java.io.File");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    classArray[1] = clazz8;
                    Class<?> clazz9 = class$4;
                    if (clazz9 == null) {
                        try {
                            clazz9 = class$4 = Class.forName("java.lang.String");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    classArray[2] = clazz9;
                    method = clazz.getDeclaredMethod("createPlatformConfigurationArea", classArray);
                    Class<?> clazz10 = class$1;
                    if (clazz10 == null) {
                        try {
                            clazz10 = class$1 = Class.forName("org.eclipse.pde.core.plugin.TargetPlatform");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    method.invoke(clazz10, pluginMap, configDir, primaryFeatureId);
                }
                catch (Exception exception2) {}
            }
            return;
        }
    }
}

