/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.debug.internal.ui.script.launcher;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.birt.core.framework.Platform;
import org.eclipse.birt.report.debug.internal.core.launcher.IReportLaunchConstants;
import org.eclipse.birt.report.debug.internal.core.launcher.LauncherEngineConfig;
import org.eclipse.birt.report.debug.internal.core.launcher.ReportLauncher;
import org.eclipse.birt.report.debug.internal.ui.script.launcher.ScriptDebugClasspathProvider;
import org.eclipse.birt.report.debug.internal.ui.script.util.ScriptDebugUtil;
import org.eclipse.birt.report.debug.ui.DebugUI;
import org.eclipse.birt.report.designer.ui.dialogs.InputParameterDialog;
import org.eclipse.birt.report.designer.ui.parameters.ParameterFactory;
import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.IGetParameterDefinitionTask;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.IReportEngineFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Display;

public class ReportLaunchHelper
implements IReportLaunchConstants {
    private Map paramValues = new HashMap();
    String fileName;
    String engineHome;
    String tempFolder;
    String targetFormat;
    boolean isOpenTargetFile;
    boolean useDefaultEngineHome;
    int debugType;
    int taskType;
    int listenPort;

    void init(ILaunchConfiguration configuration) throws CoreException {
        this.fileName = ReportLaunchHelper.covertVariables(configuration.getAttribute("report.file.name", ""));
        this.engineHome = ReportLaunchHelper.covertVariables(configuration.getAttribute("engine.home", ""));
        this.tempFolder = ReportLaunchHelper.covertVariables(configuration.getAttribute("temp.folder", ""));
        this.useDefaultEngineHome = configuration.getAttribute("use.default.engine.home", true);
        this.targetFormat = configuration.getAttribute("engine.target.format", "html");
        this.isOpenTargetFile = configuration.getAttribute("open.target.file", false);
        this.debugType = configuration.getAttribute("engine.debug.type", 2);
        this.taskType = configuration.getAttribute("engine.task.type", 4);
    }

    void addUserClassPath(List list, ILaunchConfiguration config) {
        list.add("-Dreport.user.class.path=" + ReportLaunchHelper.convertClassPath(ReportLaunchHelper.getUserClasspath(config)));
    }

    void addPortArgs(List list) {
        this.listenPort = ReportLaunchHelper.findFreePort();
        list.add("-Dreport.listen.port=" + this.listenPort);
    }

    void addParameterArgs(List list) {
        Iterator iterator = this.paramValues.keySet().iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            Object obj = this.paramValues.get(key);
            if (obj instanceof Object[]) {
                Object[] temp = (Object[])obj;
                int i = 0;
                while (i < temp.length) {
                    String value = String.valueOf(temp[i]);
                    StringBuffer buff = new StringBuffer();
                    buff.append("-D");
                    buff.append("mulparam:");
                    buff.append(i);
                    buff.append(key);
                    buff.append("=");
                    buff.append(value);
                    list.add(buff.toString());
                    ++i;
                }
                continue;
            }
            String value = String.valueOf(this.paramValues.get(key));
            StringBuffer buff = new StringBuffer();
            buff.append("-D");
            buff.append("param:");
            buff.append(key);
            buff.append("=");
            buff.append(value);
            list.add(buff.toString());
        }
    }

    void addTypeArgs(List list) {
        list.add("-Dengine.debug.type=" + this.debugType);
        list.add("-Dengine.task.type=" + this.taskType);
        list.add("-Dengine.target.format=" + this.targetFormat);
    }

    void addTempFolder(List list) {
        list.add("-Dtemp.folder=" + this.tempFolder);
    }

    void addFileNameArgs(List list) {
        list.add("-Dreport.file.name=" + this.fileName);
    }

    void addEngineHomeArgs(List list) {
        list.add("-Dengine.home=" + this.engineHome);
    }

    private static String covertVariables(String str) {
        try {
            return ScriptDebugUtil.getSubstitutedString(str);
        }
        catch (CoreException coreException) {
            return str;
        }
    }

    private static String[] getUserClasspath(ILaunchConfiguration configuration) {
        try {
            ScriptDebugClasspathProvider provider = new ScriptDebugClasspathProvider();
            IRuntimeClasspathEntry[] entries = provider.computeUserClasspath(configuration);
            entries = JavaRuntime.resolveRuntimeClasspath((IRuntimeClasspathEntry[])entries, (ILaunchConfiguration)configuration);
            ArrayList<String> userEntries = new ArrayList<String>();
            HashSet<String> set = new HashSet<String>(entries.length);
            int i = 0;
            while (i < entries.length) {
                String location;
                if (entries[i].getClasspathProperty() == 3 && (location = entries[i].getLocation()) != null && !set.contains(location)) {
                    userEntries.add(location);
                    set.add(location);
                }
                ++i;
            }
            return userEntries.toArray(new String[userEntries.size()]);
        }
        catch (CoreException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String convertClassPath(String[] cp) {
        int pathCount = 0;
        StringBuffer buf = new StringBuffer();
        if (cp == null || cp.length == 0) {
            return "";
        }
        int i = 0;
        while (i < cp.length) {
            if (pathCount > 0) {
                buf.append(File.pathSeparator);
            }
            buf.append(cp[i]);
            ++pathCount;
            ++i;
        }
        return buf.toString();
    }

    /*
     * Exception decompiling
     */
    private static int findFreePort() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [3 : 46->49)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static boolean getParameterValues(List params, Map paramValues) {
        if (params != null && params.size() > 0) {
            InputParameterDialog dialog = new InputParameterDialog(DebugUI.getShell(), params, paramValues);
            if (dialog.open() == 0) {
                paramValues.clear();
                paramValues.putAll(dialog.getParameters());
                return true;
            }
            return false;
        }
        return true;
    }

    private static List getInputParameters(String reportDesignFile, int taskType, IReportEngine engine) {
        IGetParameterDefinitionTask task = null;
        try {
            task = taskType == 2 ? engine.createGetParameterDefinitionTask(engine.openReportDocument(reportDesignFile).getReportRunnable()) : engine.createGetParameterDefinitionTask(engine.openReportDesign(reportDesignFile));
            ParameterFactory factory = new ParameterFactory(task);
            List parameters = factory.getRootChildren();
            task.close();
            task = null;
            return parameters;
        }
        catch (EngineException engineException) {
            if (task != null) {
                task.close();
            }
            return null;
        }
    }

    boolean finalLaunchCheck(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        this.paramValues = new HashMap();
        LauncherEngineConfig engineConfig = new LauncherEngineConfig();
        IReportEngineFactory factory = (IReportEngineFactory)Platform.createFactoryObject((String)"org.eclipse.birt.report.engine.ReportEngineFactory");
        final IReportEngine engine = factory.createReportEngine((EngineConfig)engineConfig);
        engine.changeLogLevel(Level.WARNING);
        final String fileName = ReportLaunchHelper.covertVariables(configuration.getAttribute("report.file.name", ""));
        final int taskType = configuration.getAttribute("engine.task.type", 4);
        Display display = DebugUI.getStandardDisplay();
        if (display.getThread().equals(Thread.currentThread())) {
            return ReportLaunchHelper.getParameterValues(ReportLaunchHelper.getInputParameters(fileName, taskType, engine), this.paramValues);
        }
        final Object[] result = new Object[]{Boolean.FALSE};
        Runnable r = new Runnable(){

            public void run() {
                result[0] = new Boolean(ReportLaunchHelper.getParameterValues(ReportLaunchHelper.getInputParameters(fileName, taskType, engine), ReportLaunchHelper.this.paramValues));
            }
        };
        DebugUI.getStandardDisplay().syncExec(r);
        return (Boolean)result[0];
    }

    static void handleProcessTermination(ILaunch launch, final IProcess process, final String fileName, final String outputFolder) throws CoreException {
        if (launch.getLaunchConfiguration().getAttribute("open.target.file", false) && launch.getLaunchConfiguration().getAttribute("engine.task.type", 4) != 1) {
            final String suffix = launch.getLaunchConfiguration().getAttribute("engine.target.format", "html");
            Thread monitorThread = new Thread(new Runnable(){

                public void run() {
                    while (!process.isTerminated()) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    DebugUI.getStandardDisplay().asyncExec(new Runnable(this, process, fileName, outputFolder, suffix){
                        final /* synthetic */ 2 this$1;
                        private final /* synthetic */ IProcess val$process;
                        private final /* synthetic */ String val$fileName;
                        private final /* synthetic */ String val$outputFolder;
                        private final /* synthetic */ String val$suffix;
                        {
                            this.this$1 = var1_1;
                            this.val$process = iProcess;
                            this.val$fileName = string;
                            this.val$outputFolder = string2;
                            this.val$suffix = string3;
                        }

                        public void run() {
                            try {
                                File file;
                                String openName;
                                if (this.val$process.getExitValue() == 1 && (openName = ReportLauncher.getOutputFileName((String)this.val$outputFolder, (String)(file = new File(this.val$fileName)).getName(), (String)this.val$suffix)) != null && new File(openName).exists()) {
                                    Program.launch((String)openName);
                                }
                            }
                            catch (DebugException debugException) {}
                        }
                    });
                }
            }, "Process Termination Monitor");
            monitorThread.setDaemon(true);
            monitorThread.start();
        }
    }
}

