/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.director.app;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.equinox.internal.p2.console.ProvisioningHelper;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.director.app.Activator;
import org.eclipse.equinox.internal.p2.director.app.LatestIUVersionCollector;
import org.eclipse.equinox.internal.p2.director.app.Messages;
import org.eclipse.equinox.internal.provisional.p2.director.IDirector;
import org.eclipse.equinox.internal.provisional.p2.director.IPlanner;
import org.eclipse.equinox.internal.provisional.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.provisional.p2.director.ProvisioningPlan;
import org.eclipse.equinox.internal.provisional.p2.engine.DefaultPhaseSet;
import org.eclipse.equinox.internal.provisional.p2.engine.IEngine;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfile;
import org.eclipse.equinox.internal.provisional.p2.engine.PhaseSet;
import org.eclipse.equinox.internal.provisional.p2.engine.ProvisioningContext;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.query.InstallableUnitQuery;
import org.eclipse.equinox.internal.provisional.p2.query.Collector;
import org.eclipse.equinox.internal.provisional.p2.query.Query;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.service.packageadmin.PackageAdmin;

public class Application
implements IApplication {
    private static final Integer EXIT_ERROR = new Integer(13);
    private static String FLAVOR_DEFAULT = "tooling";
    private static String EXEMPLARY_SETUP = "org.eclipse.equinox.p2.exemplarysetup";
    private static String FRAMEWORKADMIN_EQUINOX = "org.eclipse.equinox.frameworkadmin.equinox";
    private static String SIMPLE_CONFIGURATOR_MANIPULATOR = "org.eclipse.equinox.simpleconfigurator.manipulator";
    public static final int COMMAND_INSTALL = 0;
    public static final int COMMAND_UNINSTALL = 1;
    public static final int COMMAND_LIST = 2;
    public static final String[] COMMAND_NAMES = new String[]{"-installIU", "-uninstallIU", "-list"};
    private Path destination;
    private URL[] artifactRepositoryLocations;
    private URL[] metadataRepositoryLocations;
    private String root;
    private Version version = null;
    private String flavor;
    private String profileId;
    private String profileProperties;
    private String bundlePool = null;
    private String nl;
    private String os;
    private String arch;
    private String ws;
    private boolean roamingProfile = false;
    private IPlanner planner;
    private IEngine engine;
    private int command = -1;
    private ServiceReference packageAdminRef;
    private PackageAdmin packageAdmin;
    private boolean needsToUpdateRoamingValues = false;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    private void ambigousCommand(int cmd1, int cmd2) throws CoreException {
        throw new CoreException((IStatus)new Status(4, "org.eclipse.equinox.p2.director.app", NLS.bind((String)Messages.Ambigous_Command, (Object[])new Object[]{COMMAND_NAMES[cmd1], COMMAND_NAMES[cmd2]})));
    }

    private ProfileChangeRequest buildProvisioningRequest(IProfile profile, Collector roots, boolean install) {
        ProfileChangeRequest request = new ProfileChangeRequest(profile);
        this.markRoots(request, roots);
        if (install) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            request.addInstallableUnits((IInstallableUnit[])roots.toArray((Class)clazz));
        } else {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            request.removeInstallableUnits((IInstallableUnit[])roots.toArray((Class)clazz));
        }
        return request;
    }

    synchronized Bundle getBundle(String symbolicName) {
        if (this.packageAdmin == null) {
            return null;
        }
        Bundle[] bundles = this.packageAdmin.getBundles(symbolicName, null);
        if (bundles == null) {
            return null;
        }
        int i = 0;
        while (i < bundles.length) {
            if ((bundles[i].getState() & 3) == 0) {
                return bundles[i];
            }
            ++i;
        }
        return null;
    }

    private String getEnvironmentProperty() {
        Properties values = new Properties();
        if (this.os != null) {
            ((Hashtable)values).put("osgi.os", this.os);
        }
        if (this.nl != null) {
            ((Hashtable)values).put("osgi.nl", this.nl);
        }
        if (this.ws != null) {
            ((Hashtable)values).put("osgi.ws", this.ws);
        }
        if (this.arch != null) {
            ((Hashtable)values).put("osgi.arch", this.arch);
        }
        if (((Hashtable)values).isEmpty()) {
            return null;
        }
        return this.toString(values);
    }

    private IProfile initializeProfile() throws CoreException {
        IProfile profile;
        if (this.profileId == null) {
            this.profileId = "_SELF_";
        }
        if ((profile = ProvisioningHelper.getProfile((String)this.profileId)) != null && ProvisioningHelper.getProfile((String)"_SELF_") != null && !profile.getProfileId().equals(ProvisioningHelper.getProfile((String)"_SELF_").getProfileId())) {
            this.needsToUpdateRoamingValues = true;
        }
        if (profile == null) {
            String currentFlavor;
            String env;
            if (this.destination == null) {
                this.missingArgument("destination");
            }
            if (this.flavor == null) {
                this.flavor = System.getProperty("eclipse.p2.configurationFlavor", FLAVOR_DEFAULT);
            }
            Properties props = new Properties();
            props.setProperty("org.eclipse.equinox.p2.installFolder", this.destination.toOSString());
            props.setProperty("org.eclipse.equinox.p2.flavor", this.flavor);
            if (this.bundlePool != null) {
                if (this.bundlePool.equals(Messages.destination_commandline)) {
                    props.setProperty("org.eclipse.equinox.p2.cache", this.destination.toOSString());
                } else {
                    props.setProperty("org.eclipse.equinox.p2.cache", this.bundlePool);
                }
            }
            if (this.roamingProfile) {
                props.setProperty("org.eclipse.equinox.p2.roaming", Boolean.TRUE.toString());
            }
            if ((env = this.getEnvironmentProperty()) != null) {
                props.setProperty("org.eclipse.equinox.p2.environments", env);
            }
            if (this.profileProperties != null) {
                this.putProperties(this.profileProperties, props);
            }
            if ((currentFlavor = (profile = ProvisioningHelper.addProfile((String)this.profileId, (Properties)props)).getProperty("org.eclipse.equinox.p2.flavor")) != null && !currentFlavor.endsWith(this.flavor)) {
                throw new RuntimeException(Messages.Inconsistent_flavor);
            }
        }
        return profile;
    }

    private void initializeRepositories(boolean throwException) throws CoreException {
        int i;
        if (this.artifactRepositoryLocations == null) {
            if (throwException) {
                this.missingArgument("artifactRepository");
            }
        } else {
            i = 0;
            while (i < this.artifactRepositoryLocations.length) {
                ProvisioningHelper.addArtifactRepository((URL)this.artifactRepositoryLocations[i]);
                ++i;
            }
        }
        if (this.metadataRepositoryLocations == null) {
            if (throwException) {
                this.missingArgument("metadataRepository");
            }
        } else {
            i = 0;
            while (i < this.metadataRepositoryLocations.length) {
                ProvisioningHelper.addMetadataRepository((URL)this.metadataRepositoryLocations[i]);
                ++i;
            }
        }
    }

    private void initializeServices() {
        IDirector director;
        BundleContext bundleContext = Activator.getContext();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.equinox.internal.provisional.p2.director.IDirector");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((director = (IDirector)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName())) == null) {
            throw new RuntimeException(Messages.Missing_director);
        }
        BundleContext bundleContext2 = Activator.getContext();
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("org.eclipse.equinox.internal.provisional.p2.director.IPlanner");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.planner = (IPlanner)ServiceHelper.getService((BundleContext)bundleContext2, (String)clazz2.getName());
        if (this.planner == null) {
            throw new RuntimeException(Messages.Missing_planner);
        }
        this.engine = (IEngine)ServiceHelper.getService((BundleContext)Activator.getContext(), (String)IEngine.SERVICE_NAME);
        if (this.engine == null) {
            throw new RuntimeException(Messages.Missing_Engine);
        }
    }

    private void markRoots(ProfileChangeRequest request, Collector roots) {
        Iterator iterator = roots.iterator();
        while (iterator.hasNext()) {
            request.setInstallableUnitProfileProperty((IInstallableUnit)iterator.next(), "org.eclipse.equinox.p2.type.root", (Object)Boolean.TRUE.toString());
        }
    }

    private void missingArgument(String argumentName) throws CoreException {
        throw new CoreException((IStatus)new Status(4, "org.eclipse.equinox.p2.director.app", NLS.bind((String)Messages.Missing_Required_Argument, (Object)argumentName)));
    }

    private IStatus planAndExecute(IProfile profile, ProvisioningContext context, ProfileChangeRequest request) {
        ProvisioningPlan result = this.planner.getProvisioningPlan(request, context, (IProgressMonitor)new NullProgressMonitor());
        IStatus operationStatus = !result.getStatus().isOK() ? result.getStatus() : this.engine.perform(profile, (PhaseSet)new DefaultPhaseSet(), result.getOperands(), context, (IProgressMonitor)new NullProgressMonitor());
        return operationStatus;
    }

    private void printRequest(ProfileChangeRequest request) {
        IInstallableUnit[] toAdd = request.getAddedInstallableUnits();
        IInstallableUnit[] toRemove = request.getRemovedInstallableUnits();
        int i = 0;
        while (i < toAdd.length) {
            System.out.println(NLS.bind((String)Messages.Installing, (Object)toAdd[i].getId(), (Object)toAdd[i].getVersion()));
            ++i;
        }
        i = 0;
        while (i < toRemove.length) {
            System.out.println(NLS.bind((String)Messages.Uninstalling, (Object)toRemove[i].getId(), (Object)toRemove[i].getVersion()));
            ++i;
        }
    }

    public void processArguments(String[] args) throws Exception {
        if (args == null) {
            return;
        }
        int i = 0;
        while (i < args.length) {
            String opt = args[i];
            if (opt.equals("-roaming")) {
                this.roamingProfile = true;
            }
            if (opt.equals(COMMAND_NAMES[2])) {
                if (this.command != -1) {
                    this.ambigousCommand(2, this.command);
                }
                this.command = 2;
            }
            if (i != args.length - 1 && !args[i + 1].startsWith("-")) {
                String arg = args[++i];
                if (opt.equalsIgnoreCase("-profile")) {
                    this.profileId = arg;
                }
                if (opt.equalsIgnoreCase("-profileProperties") || opt.equalsIgnoreCase("-props")) {
                    this.profileProperties = arg;
                }
                if (opt.equalsIgnoreCase("-destination") || opt.equalsIgnoreCase("-dest")) {
                    this.destination = new Path(arg);
                }
                if (opt.equalsIgnoreCase("-bundlepool") || opt.equalsIgnoreCase("-bp")) {
                    this.bundlePool = new Path(arg).toOSString();
                }
                if (opt.equalsIgnoreCase("-metadataRepository") || opt.equalsIgnoreCase("-metadataRepositories") || opt.equalsIgnoreCase("-mr")) {
                    this.metadataRepositoryLocations = Application.getURLs(arg);
                }
                if (opt.equalsIgnoreCase("-artifactRepository") || opt.equalsIgnoreCase("-artifactRepositories") || opt.equalsIgnoreCase("-ar")) {
                    this.artifactRepositoryLocations = Application.getURLs(arg);
                }
                if (opt.equalsIgnoreCase("-flavor")) {
                    this.flavor = arg;
                }
                if (opt.equalsIgnoreCase(COMMAND_NAMES[0])) {
                    if (this.command != -1) {
                        this.ambigousCommand(0, this.command);
                    }
                    this.root = arg;
                    this.command = 0;
                }
                if (opt.equalsIgnoreCase("-version")) {
                    this.version = new Version(arg);
                }
                if (opt.equalsIgnoreCase(COMMAND_NAMES[1])) {
                    if (this.command != -1) {
                        this.ambigousCommand(1, this.command);
                    }
                    this.root = arg;
                    this.command = 1;
                }
                if (opt.equalsIgnoreCase("-p2.os")) {
                    this.os = arg;
                }
                if (opt.equalsIgnoreCase("-p2.ws")) {
                    this.ws = arg;
                }
                if (opt.equalsIgnoreCase("-p2.nl")) {
                    this.nl = arg;
                }
                if (opt.equalsIgnoreCase("-p2.arch")) {
                    this.arch = arg;
                }
            }
            ++i;
        }
    }

    private void putProperties(String pairs, Properties properties) {
        StringTokenizer tok = new StringTokenizer(pairs, ",", true);
        while (tok.hasMoreTokens()) {
            String next = tok.nextToken().trim();
            int i = next.indexOf(61);
            if (i <= 0 || i >= next.length() - 1) continue;
            String tag = next.substring(0, i).trim();
            String value = next.substring(i + 1, next.length()).trim();
            if (tag.length() <= 0 || value.length() <= 0) continue;
            ((Hashtable)properties).put(tag, value);
        }
    }

    public Object run(String[] args) throws Exception {
        long time = -System.currentTimeMillis();
        this.initializeServices();
        this.processArguments(args);
        IStatus operationStatus = Status.OK_STATUS;
        switch (this.command) {
            case 0: 
            case 1: {
                this.initializeRepositories(this.command == 0);
                IProfile profile = this.initializeProfile();
                InstallableUnitQuery query = new InstallableUnitQuery(this.root, this.version == null ? VersionRange.emptyRange : new VersionRange(this.version, true, this.version, true));
                Collector roots = ProvisioningHelper.getInstallableUnits(null, (Query)query, (Collector)new LatestIUVersionCollector(), (IProgressMonitor)new NullProgressMonitor());
                if (roots.size() <= 0) {
                    roots = profile.query((Query)query, roots, (IProgressMonitor)new NullProgressMonitor());
                }
                if (roots.size() <= 0) {
                    LogHelper.log((IStatus)new Status(4, "org.eclipse.equinox.p2.director.app", NLS.bind((String)Messages.Missing_IU, (Object)this.root)));
                    System.out.println(NLS.bind((String)Messages.Missing_IU, (Object)this.root));
                    return EXIT_ERROR;
                }
                if (!this.updateRoamingProperties(profile).isOK()) {
                    LogHelper.log((IStatus)new Status(4, "org.eclipse.equinox.p2.director.app", NLS.bind((String)Messages.Cant_change_roaming, (Object)profile.getProfileId())));
                    System.out.println(NLS.bind((String)Messages.Cant_change_roaming, (Object)profile.getProfileId()));
                    return EXIT_ERROR;
                }
                ProvisioningContext context = new ProvisioningContext();
                ProfileChangeRequest request = this.buildProvisioningRequest(profile, roots, this.command == 0);
                this.printRequest(request);
                operationStatus = this.planAndExecute(profile, context, request);
                break;
            }
            case 2: {
                InstallableUnitQuery query = new InstallableUnitQuery(null, VersionRange.emptyRange);
                if (this.metadataRepositoryLocations == null) {
                    this.missingArgument("metadataRepository");
                }
                int i = 0;
                while (i < this.metadataRepositoryLocations.length) {
                    Collector roots = ProvisioningHelper.getInstallableUnits((URL)this.metadataRepositoryLocations[i], (Query)query, (IProgressMonitor)new NullProgressMonitor());
                    Iterator unitIterator = roots.iterator();
                    while (unitIterator.hasNext()) {
                        IInstallableUnit iu = (IInstallableUnit)unitIterator.next();
                        System.out.println(iu.getId());
                    }
                    ++i;
                }
                break;
            }
        }
        time += System.currentTimeMillis();
        if (!operationStatus.isOK()) {
            System.out.println(Messages.Operation_failed);
            LogHelper.log((IStatus)operationStatus);
            return EXIT_ERROR;
        }
        System.out.println(NLS.bind((String)Messages.Operation_complete, (Object)new Long(time)));
        return IApplication.EXIT_OK;
    }

    private synchronized void setPackageAdmin(PackageAdmin service) {
        this.packageAdmin = service;
    }

    private boolean startEarly(String bundleName) throws BundleException {
        Bundle bundle = this.getBundle(bundleName);
        if (bundle == null) {
            return false;
        }
        bundle.start(1);
        return true;
    }

    public Object start(IApplicationContext context) throws Exception {
        BundleContext bundleContext = Activator.getContext();
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.osgi.service.packageadmin.PackageAdmin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.packageAdminRef = bundleContext.getServiceReference(clazz.getName());
        this.setPackageAdmin((PackageAdmin)Activator.getContext().getService(this.packageAdminRef));
        if (!this.startEarly(EXEMPLARY_SETUP)) {
            LogHelper.log((IStatus)new Status(4, "org.eclipse.equinox.p2.director.app", NLS.bind((String)Messages.Missing_bundle, (Object)EXEMPLARY_SETUP)));
            return EXIT_ERROR;
        }
        if (!this.startEarly(SIMPLE_CONFIGURATOR_MANIPULATOR)) {
            LogHelper.log((IStatus)new Status(4, "org.eclipse.equinox.p2.director.app", NLS.bind((String)Messages.Missing_bundle, (Object)SIMPLE_CONFIGURATOR_MANIPULATOR)));
            return EXIT_ERROR;
        }
        if (!this.startEarly(FRAMEWORKADMIN_EQUINOX)) {
            LogHelper.log((IStatus)new Status(4, "org.eclipse.equinox.p2.director.app", NLS.bind((String)Messages.Missing_bundle, (Object)FRAMEWORKADMIN_EQUINOX)));
            return EXIT_ERROR;
        }
        return this.run((String[])context.getArguments().get("application.args"));
    }

    public void stop() {
        this.setPackageAdmin(null);
        Activator.getContext().ungetService(this.packageAdminRef);
    }

    private String toString(Properties context) {
        StringBuffer result = new StringBuffer();
        Enumeration iter = ((Hashtable)context).keys();
        while (iter.hasMoreElements()) {
            String key = (String)iter.nextElement();
            result.append(key);
            result.append('=');
            result.append(((Hashtable)context).get(key));
            if (!iter.hasMoreElements()) continue;
            result.append(',');
        }
        return result.toString();
    }

    private IStatus updateRoamingProperties(IProfile profile) {
        if (!this.needsToUpdateRoamingValues) {
            return Status.OK_STATUS;
        }
        ProfileChangeRequest request = new ProfileChangeRequest(profile);
        if (!Boolean.valueOf(profile.getProperty("org.eclipse.equinox.p2.roaming")).booleanValue()) {
            return Status.OK_STATUS;
        }
        File destinationFile = this.destination.toFile();
        if (!destinationFile.equals(new File(profile.getProperty("org.eclipse.equinox.p2.installFolder")))) {
            request.setProfileProperty("org.eclipse.equinox.p2.installFolder", (Object)this.destination.toOSString());
        }
        if (!destinationFile.equals(new File(profile.getProperty("org.eclipse.equinox.p2.cache")))) {
            request.setProfileProperty("org.eclipse.equinox.p2.cache", (Object)this.destination.toOSString());
        }
        if (request.getProfileProperties().size() == 0) {
            return Status.OK_STATUS;
        }
        ProvisioningPlan result = this.planner.getProvisioningPlan(request, new ProvisioningContext(), (IProgressMonitor)new NullProgressMonitor());
        if (!result.getStatus().isOK()) {
            return result.getStatus();
        }
        return this.engine.perform(profile, (PhaseSet)new DefaultPhaseSet(), result.getOperands(), new ProvisioningContext(), (IProgressMonitor)new NullProgressMonitor());
    }

    private static URL[] getURLs(String spec) {
        if (spec == null) {
            return null;
        }
        String[] urlSpecs = Application.getArrayFromString(spec, ",");
        ArrayList<URL> result = new ArrayList<URL>(urlSpecs.length);
        int i = 0;
        while (i < urlSpecs.length) {
            try {
                result.add(new URL(urlSpecs[i]));
            }
            catch (MalformedURLException malformedURLException) {
                NLS.bind((String)Messages.Ignored_repo, (Object)urlSpecs[i]);
            }
            ++i;
        }
        return result.toArray(new URL[result.size()]);
    }

    public static String[] getArrayFromString(String list, String separator) {
        if (list == null || list.trim().equals("")) {
            return new String[0];
        }
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer tokens = new StringTokenizer(list, separator);
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken().trim();
            if (token.equals("")) continue;
            result.add(token);
        }
        return result.toArray(new String[result.size()]);
    }
}

