/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.reportitem;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.attribute.SortOption;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.data.Query;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.reportitem.ChartReportItemUtil;
import org.eclipse.birt.chart.reportitem.ChartXTabUtil;
import org.eclipse.birt.chart.reportitem.i18n.Messages;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IDataQueryDefinition;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.api.ISortDefinition;
import org.eclipse.birt.data.engine.api.querydefn.Binding;
import org.eclipse.birt.data.engine.api.querydefn.ConditionalExpression;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.olap.api.query.IBaseCubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ICubeFilterDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ICubeOperation;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ICubeSortDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IDimensionDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IEdgeDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IHierarchyDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ILevelDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IMeasureDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ISubCubeQueryDefinition;
import org.eclipse.birt.report.data.adapter.api.DataAdapterUtil;
import org.eclipse.birt.report.item.crosstab.core.de.AggregationCellHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabCellHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabReportItemHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.DimensionViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.LevelViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.MeasureViewHandle;
import org.eclipse.birt.report.model.api.AggregationArgumentHandle;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.FilterConditionElementHandle;
import org.eclipse.birt.report.model.api.MemberValueHandle;
import org.eclipse.birt.report.model.api.ModuleUtil;
import org.eclipse.birt.report.model.api.MultiViewsHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.extension.ExtendedElementException;
import org.eclipse.birt.report.model.api.olap.CubeHandle;
import org.eclipse.birt.report.model.api.olap.LevelHandle;
import org.eclipse.birt.report.model.api.util.CubeUtil;
import org.eclipse.emf.common.util.EList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChartCubeQueryHelper {
    private static ILogger logger = Logger.getLogger((String)"org.eclipse.birt.chart.reportitem/trace");
    private final ExtendedItemHandle handle;
    private final Chart cm;
    private Map<String, IBinding> registeredBindings = new HashMap<String, IBinding>();
    private Map<String, String> registeredQueries = new HashMap<String, String>();
    private Map<String, ILevelDefinition> registeredLevels = new HashMap<String, ILevelDefinition>();
    private Map<String, IMeasureDefinition> registeredMeasures = new HashMap<String, IMeasureDefinition>();
    private Map<LevelHandle, ILevelDefinition> registeredLevelHandles = new HashMap<LevelHandle, ILevelDefinition>();
    private String rowEdgeDimension;
    private boolean bSingleChart = false;

    public ChartCubeQueryHelper(ExtendedItemHandle handle, Chart cm) {
        this.handle = handle;
        this.cm = cm;
    }

    public IBaseCubeQueryDefinition createCubeQuery(IDataQueryDefinition parent) throws BirtException {
        this.bSingleChart = parent == null;
        CubeHandle cubeHandle = this.handle.getCube();
        ICubeQueryDefinition cubeQuery = null;
        if (cubeHandle == null) {
            ISubCubeQueryDefinition subQuery;
            cubeHandle = ChartXTabUtil.getBindingCube((DesignElementHandle)this.handle);
            if (cubeHandle == null) {
                throw new ChartException("org.eclipse.birt.chart.reportitem", 17, Messages.getString("ChartCubeQueryHelper.Error.MustBindCube"));
            }
            if (!this.bSingleChart && (subQuery = this.createSubCubeQuery()) != null) {
                if (parent instanceof ICubeQueryDefinition && ChartXTabUtil.isPlotChart((DesignElementHandle)this.handle)) {
                    this.addMinMaxBinding((ICubeQueryDefinition)parent);
                }
                return subQuery;
            }
        }
        cubeQuery = ChartXTabUtil.getCubeElementFactory().createCubeQuery(cubeHandle.getQualifiedName());
        this.initBindings(cubeQuery, cubeHandle);
        List<SeriesDefinition> sdList = ChartCubeQueryHelper.getAllSeriesDefinitions(this.cm);
        int i = 0;
        while (i < sdList.size()) {
            SeriesDefinition sd = sdList.get(i);
            EList queryList = sd.getDesignTimeSeries().getDataDefinition();
            int j = 0;
            while (j < queryList.size()) {
                Query query = (Query)queryList.get(j);
                this.bindSeriesQuery(query.getDefinition(), cubeQuery, cubeHandle);
                ++j;
            }
            this.bindSeriesQuery(sd.getQuery().getDefinition(), cubeQuery, cubeHandle);
            ++i;
        }
        Collection<ILevelDefinition> levelsInOrder = this.getAllLevelsInHierarchyOrder(cubeHandle, cubeQuery);
        Iterator<String> measureNames = this.registeredMeasures.keySet().iterator();
        while (measureNames.hasNext()) {
            IBinding binding = this.registeredBindings.get(measureNames.next());
            if (binding == null || !binding.getAggregatOns().isEmpty()) continue;
            for (ILevelDefinition level : levelsInOrder) {
                String dimensionName = level.getHierarchy().getDimension().getName();
                binding.addAggregateOn(ExpressionUtil.createJSDimensionExpression((String)dimensionName, (String)level.getName()));
            }
        }
        int i2 = 0;
        while (i2 < sdList.size()) {
            SeriesDefinition sd = sdList.get(i2);
            this.addSorting(cubeQuery, cubeHandle, sd, i2);
            ++i2;
        }
        this.addCubeFilter(cubeQuery);
        return cubeQuery;
    }

    private ISubCubeQueryDefinition createSubCubeQuery() throws BirtException {
        String queryName = "chart_subquery";
        AggregationCellHandle containerCell = ChartXTabUtil.getXtabContainerCell((DesignElementHandle)this.handle);
        if (containerCell == null) {
            return null;
        }
        CrosstabReportItemHandle xtab = containerCell.getCrosstab();
        int columnLevelCount = ChartXTabUtil.getLevelCount(xtab, 1);
        int rowLevelCount = ChartXTabUtil.getLevelCount(xtab, 0);
        if (this.cm instanceof ChartWithAxes) {
            if (((ChartWithAxes)this.cm).isTransposed()) {
                if (columnLevelCount >= 1) {
                    ISubCubeQueryDefinition subCubeQuery = ChartXTabUtil.getCubeElementFactory().createSubCubeQuery(queryName);
                    subCubeQuery.setStartingLevelOnColumn(ChartXTabUtil.createDimensionExpression(ChartXTabUtil.getLevel(xtab, 1, columnLevelCount - 1).getCubeLevel()));
                    if (rowLevelCount > 1) {
                        subCubeQuery.setStartingLevelOnRow(ChartXTabUtil.createDimensionExpression(ChartXTabUtil.getLevel(xtab, 0, rowLevelCount - 2).getCubeLevel()));
                    }
                    return subCubeQuery;
                }
                if (rowLevelCount > 1) {
                    ISubCubeQueryDefinition subCubeQuery = ChartXTabUtil.getCubeElementFactory().createSubCubeQuery(queryName);
                    subCubeQuery.setStartingLevelOnRow(ChartXTabUtil.createDimensionExpression(ChartXTabUtil.getLevel(xtab, 0, rowLevelCount - 2).getCubeLevel()));
                    return subCubeQuery;
                }
            } else {
                if (rowLevelCount >= 1) {
                    ISubCubeQueryDefinition subCubeQuery = ChartXTabUtil.getCubeElementFactory().createSubCubeQuery(queryName);
                    subCubeQuery.setStartingLevelOnRow(ChartXTabUtil.createDimensionExpression(ChartXTabUtil.getLevel(xtab, 0, rowLevelCount - 1).getCubeLevel()));
                    if (columnLevelCount > 1) {
                        subCubeQuery.setStartingLevelOnColumn(ChartXTabUtil.createDimensionExpression(ChartXTabUtil.getLevel(xtab, 1, columnLevelCount - 2).getCubeLevel()));
                    }
                    return subCubeQuery;
                }
                if (columnLevelCount > 1) {
                    ISubCubeQueryDefinition subCubeQuery = ChartXTabUtil.getCubeElementFactory().createSubCubeQuery(queryName);
                    subCubeQuery.setStartingLevelOnColumn(ChartXTabUtil.createDimensionExpression(ChartXTabUtil.getLevel(xtab, 1, columnLevelCount - 2).getCubeLevel()));
                    return subCubeQuery;
                }
            }
        }
        return null;
    }

    private void addMinMaxBinding(ICubeQueryDefinition parent) throws BirtException {
        Axis xAxis = (Axis)((ChartWithAxes)this.cm).getAxes().get(0);
        SeriesDefinition sdValue = (SeriesDefinition)((ChartWithAxes)this.cm).getOrthogonalAxes(xAxis, true)[0].getSeriesDefinitions().get(0);
        Query queryValue = (Query)sdValue.getDesignTimeSeries().getDataDefinition().get(0);
        String bindingValue = ChartXTabUtil.getBindingName(queryValue.getDefinition(), false);
        String maxBindingName = "chart__max" + bindingValue;
        String minBindingName = "chart__min" + bindingValue;
        Iterator<ComputedColumnHandle> bindings = ChartReportItemUtil.getAllColumnBindingsIterator((ReportItemHandle)this.handle);
        while (bindings.hasNext()) {
            ComputedColumnHandle column = bindings.next();
            if (!column.getName().equals(bindingValue)) continue;
            Binding maxBinding = new Binding(maxBindingName);
            maxBinding.setExpression((IBaseExpression)new ScriptExpression(queryValue.getDefinition()));
            maxBinding.setAggrFunction("MAX");
            maxBinding.setExportable(false);
            Binding minBinding = new Binding(minBindingName);
            minBinding.setExpression((IBaseExpression)new ScriptExpression(queryValue.getDefinition()));
            minBinding.setAggrFunction("MIN");
            minBinding.setExportable(false);
            ICubeOperation op = ChartXTabUtil.getCubeElementFactory().getCubeOperationFactory().createAddingNestAggregationsOperation(new IBinding[]{maxBinding, minBinding});
            parent.addCubeOperation(op);
            break;
        }
    }

    private void initBindings(ICubeQueryDefinition cubeQuery, CubeHandle cube) throws BirtException {
        Iterator<ComputedColumnHandle> bindings = ChartReportItemUtil.getAllColumnBindingsIterator((ReportItemHandle)this.handle);
        while (bindings.hasNext()) {
            ComputedColumnHandle column = bindings.next();
            Binding binding = new Binding(column.getName());
            binding.setDataType(DataAdapterUtil.adaptModelDataType((String)column.getDataType()));
            binding.setAggrFunction(column.getAggregateFunction() == null ? null : DataAdapterUtil.adaptModelAggregationType((String)column.getAggregateFunction()));
            String expression = column.getExpression();
            if (expression == null) {
                Iterator argItr = column.argumentsIterator();
                while (argItr.hasNext()) {
                    AggregationArgumentHandle aah = (AggregationArgumentHandle)argItr.next();
                    expression = aah.getValue();
                }
            }
            binding.setExpression((IBaseExpression)new ScriptExpression(expression));
            List lstAggOn = column.getAggregateOnList();
            if (expression == null || !this.bSingleChart && !lstAggOn.isEmpty()) {
                this.addAggregateOn((IBinding)binding, lstAggOn, cubeQuery, cube);
            }
            this.registeredBindings.put(column.getName(), (IBinding)binding);
            this.registeredQueries.put(binding.getBindingName(), expression);
        }
    }

    private void addAggregateOn(IBinding binding, List lstAggOn, ICubeQueryDefinition cubeQuery, CubeHandle cube) throws BirtException {
        for (String aggOn : lstAggOn) {
            String[] levelNames = CubeUtil.splitLevelName((String)aggOn);
            String dimExpr = ExpressionUtil.createJSDimensionExpression((String)levelNames[0], (String)levelNames[1]);
            binding.addAggregateOn(dimExpr);
        }
    }

    private void addSorting(ICubeQueryDefinition cubeQuery, CubeHandle cube, SeriesDefinition sd, int i) throws BirtException {
        if (sd.getSortKey() == null) {
            return;
        }
        String sortKey = sd.getSortKey().getDefinition();
        if (sd.isSetSorting() && sortKey != null && sortKey.length() > 0) {
            String sortKeyBinding = ChartXTabUtil.getBindingName(sd.getSortKey().getDefinition(), true);
            if (this.registeredLevels.containsKey(sortKeyBinding)) {
                ICubeSortDefinition sortDef = ChartXTabUtil.getCubeElementFactory().createCubeSortDefinition(sortKey, this.registeredLevels.get(sortKeyBinding), null, null, sd.getSorting() == SortOption.ASCENDING_LITERAL ? 0 : 1);
                cubeQuery.addSort((ISortDefinition)sortDef);
            } else if (this.registeredMeasures.containsKey(sortKeyBinding)) {
                Query targetQuery = i > 0 ? sd.getQuery() : (Query)sd.getDesignTimeSeries().getDataDefinition().get(0);
                IMeasureDefinition mDef = this.registeredMeasures.get(sortKeyBinding);
                String targetBindingName = ChartXTabUtil.getBindingName(targetQuery.getDefinition(), true);
                IBinding measureBinding = this.registeredBindings.get(sortKeyBinding);
                Binding aggBinding = new Binding(String.valueOf(measureBinding.getBindingName()) + targetBindingName);
                aggBinding.setDataType(measureBinding.getDataType());
                aggBinding.setExpression(measureBinding.getExpression());
                aggBinding.addAggregateOn(this.registeredQueries.get(targetBindingName));
                aggBinding.setAggrFunction(mDef.getAggrFunction());
                aggBinding.setExportable(false);
                cubeQuery.addBinding((IBinding)aggBinding);
                ICubeSortDefinition sortDef = ChartXTabUtil.getCubeElementFactory().createCubeSortDefinition(ExpressionUtil.createJSDataExpression((String)aggBinding.getBindingName()), this.registeredLevels.get(targetBindingName), null, null, sd.getSorting() == SortOption.ASCENDING_LITERAL ? 0 : 1);
                cubeQuery.addSort((ISortDefinition)sortDef);
            }
        }
    }

    private void bindSeriesQuery(String expr, ICubeQueryDefinition cubeQuery, CubeHandle cube) throws BirtException {
        if (expr != null && expr.length() > 0) {
            String bindingName = ChartXTabUtil.getBindingName(expr, true);
            IBinding colBinding = null;
            if (bindingName != null) {
                List<String> nameList = ChartXTabUtil.getBindingNameList(expr);
                if (nameList.size() > 1) {
                    for (String bn : nameList) {
                        this.bindSeriesQuery(ExpressionUtil.createJSDataExpression((String)bn), cubeQuery, cube);
                    }
                    return;
                }
                colBinding = this.registeredBindings.get(bindingName);
            }
            if (colBinding != null) {
                bindingName = colBinding.getBindingName();
                expr = this.registeredQueries.get(bindingName);
                if (!cubeQuery.getBindings().contains(colBinding)) {
                    cubeQuery.addBinding(colBinding);
                }
                if (ChartXTabUtil.isBinding(expr, true)) {
                    this.bindSeriesQuery(expr, cubeQuery, cube);
                    return;
                }
                String measure = ChartXTabUtil.getMeasureName(expr);
                if (measure != null) {
                    if (this.registeredMeasures.containsKey(bindingName)) {
                        return;
                    }
                    IMeasureDefinition mDef = cubeQuery.createMeasure(measure);
                    String aggFun = DataAdapterUtil.adaptModelAggregationType((String)cube.getMeasure(measure).getFunction());
                    mDef.setAggrFunction(aggFun);
                    this.registeredMeasures.put(bindingName, mDef);
                } else if (ChartXTabUtil.isDimensionExpresion(expr)) {
                    if (this.registeredLevels.containsKey(bindingName)) {
                        return;
                    }
                    String[] levels = ChartXTabUtil.getLevelNameFromDimensionExpression(expr);
                    String dimensionName = levels[0];
                    int edgeType = this.getEdgeType(dimensionName);
                    IEdgeDefinition edge = cubeQuery.getEdge(edgeType);
                    IHierarchyDefinition hieDef = null;
                    if (edge == null) {
                        edge = cubeQuery.createEdge(edgeType);
                        IDimensionDefinition dimDef = edge.createDimension(dimensionName);
                        hieDef = dimDef.createHierarchy(cube.getDimension(dimDef.getName()).getDefaultHierarchy().getName());
                    } else {
                        hieDef = (IHierarchyDefinition)((IDimensionDefinition)edge.getDimensions().get(0)).getHierarchy().get(0);
                    }
                    boolean bMultipleLevels = !hieDef.getLevels().isEmpty();
                    ILevelDefinition levelDef = hieDef.createLevel(levels[1]);
                    this.registeredLevels.put(bindingName, levelDef);
                    LevelHandle levelHandle = this.handle.getModuleHandle().findLevel(String.valueOf(levelDef.getHierarchy().getDimension().getName()) + "/" + levelDef.getName());
                    this.registeredLevelHandles.put(levelHandle, levelDef);
                    if (bMultipleLevels) {
                        Iterator<ILevelDefinition> levelsInOrder = this.getAllLevelsInHierarchyOrder(cube, cubeQuery).iterator();
                        hieDef.getLevels().clear();
                        while (levelsInOrder.hasNext()) {
                            ILevelDefinition level = levelsInOrder.next();
                            hieDef.createLevel(level.getName());
                        }
                    }
                }
            }
        }
    }

    private List<FilterConditionElementHandle> getCubeFiltersFromHandle() {
        PropertyHandle propHandle = this.handle.getPropertyHandle("cubeFilter");
        if (propHandle == null) {
            return Collections.EMPTY_LIST;
        }
        return propHandle.getListValue();
    }

    private void addCubeFilter(ICubeQueryDefinition cubeQuery) throws BirtException {
        ReportItemHandle rih;
        CrosstabReportItemHandle crossTab;
        DesignElementHandle xtabHandle;
        ArrayList<ILevelDefinition> levels = new ArrayList<ILevelDefinition>();
        ArrayList<String> values = new ArrayList<String>();
        List<FilterConditionElementHandle> filters = null;
        if (this.handle.getContainer() instanceof MultiViewsHandle) {
            xtabHandle = this.handle.getContainer().getContainer();
            if (xtabHandle instanceof ExtendedItemHandle) {
                crossTab = (CrosstabReportItemHandle)((ExtendedItemHandle)xtabHandle).getReportItem();
                filters = this.getFiltersFromXtab(crossTab);
            }
        } else if (this.handle.getContainer() instanceof ExtendedItemHandle) {
            xtabHandle = (ExtendedItemHandle)this.handle.getContainer();
            String exName = xtabHandle.getExtensionName();
            if ("AggregationCell".equals(exName) || "CrosstabCell".equals(exName)) {
                CrosstabCellHandle cell = (CrosstabCellHandle)xtabHandle.getReportItem();
                filters = this.getFiltersFromXtab(cell.getCrosstab());
                filters.addAll(this.getCubeFiltersFromHandle());
            }
        } else if (ChartReportItemUtil.getReportItemReference((ReportItemHandle)this.handle) != null && (rih = ChartReportItemUtil.getReportItemReference((ReportItemHandle)this.handle)) instanceof ExtendedItemHandle) {
            crossTab = (CrosstabReportItemHandle)((ExtendedItemHandle)rih).getReportItem();
            filters = this.getFiltersFromXtab(crossTab);
        }
        if (filters == null) {
            filters = this.getCubeFiltersFromHandle();
        }
        for (FilterConditionElementHandle filterCon : filters) {
            levels.clear();
            values.clear();
            this.addMembers(levels, values, filterCon.getMember());
            ILevelDefinition[] qualifyLevels = null;
            Object[] qualifyValues = null;
            if (levels.size() > 0) {
                qualifyLevels = levels.toArray(new ILevelDefinition[levels.size()]);
                qualifyValues = values.toArray(new Object[values.size()]);
            }
            ConditionalExpression filterCondExpr = ModuleUtil.isListFilterValue((FilterConditionElementHandle)filterCon) ? new ConditionalExpression(filterCon.getExpr(), DataAdapterUtil.adaptModelFilterOperator((String)filterCon.getOperator()), filterCon.getValue1List()) : new ConditionalExpression(filterCon.getExpr(), DataAdapterUtil.adaptModelFilterOperator((String)filterCon.getOperator()), filterCon.getValue1(), filterCon.getValue2());
            ILevelDefinition levelDefinition = null;
            levelDefinition = filterCon.getMember() != null ? this.registeredLevelHandles.get(filterCon.getMember().getLevel()) : this.registeredLevels.get(ChartXTabUtil.getBindingName(filterCondExpr.getExpression().getText(), true));
            ICubeFilterDefinition filterDef = ChartXTabUtil.getCubeElementFactory().creatCubeFilterDefinition((IBaseExpression)filterCondExpr, levelDefinition, qualifyLevels, qualifyValues);
            cubeQuery.addFilter((IFilterDefinition)filterDef);
        }
    }

    private List<FilterConditionElementHandle> getFiltersFromXtab(CrosstabReportItemHandle crossTab) {
        DesignElementHandle elementHandle;
        ArrayList<FilterConditionElementHandle> list = new ArrayList<FilterConditionElementHandle>();
        if (crossTab == null) {
            return list;
        }
        if (crossTab.getCrosstabView(1) != null) {
            elementHandle = crossTab.getCrosstabView(1).getModelHandle();
            list.addAll(this.getLevelOnCrosstab((ExtendedItemHandle)elementHandle));
        }
        if (crossTab.getCrosstabView(0) != null) {
            elementHandle = crossTab.getCrosstabView(0).getModelHandle();
            list.addAll(this.getLevelOnCrosstab((ExtendedItemHandle)elementHandle));
        }
        int measureCount = crossTab.getMeasureCount();
        int i = 0;
        while (i < measureCount) {
            MeasureViewHandle measureView = crossTab.getMeasure(i);
            Iterator iter = measureView.filtersIterator();
            while (iter.hasNext()) {
                list.add((FilterConditionElementHandle)iter.next());
            }
            ++i;
        }
        return list;
    }

    private List getLevelOnCrosstab(ExtendedItemHandle handle) {
        CrosstabViewHandle crossTabViewHandle = null;
        try {
            crossTabViewHandle = (CrosstabViewHandle)handle.getReportItem();
        }
        catch (ExtendedElementException e) {
            logger.log((Exception)((Object)e));
        }
        ArrayList list = new ArrayList();
        if (crossTabViewHandle == null) {
            return list;
        }
        int dimensionCount = crossTabViewHandle.getDimensionCount();
        int i = 0;
        while (i < dimensionCount) {
            DimensionViewHandle dimension = crossTabViewHandle.getDimension(i);
            int levelCount = dimension.getLevelCount();
            int j = 0;
            while (j < levelCount) {
                LevelViewHandle levelHandle = dimension.getLevel(j);
                Iterator iter = levelHandle.filtersIterator();
                while (iter.hasNext()) {
                    list.add(iter.next());
                }
                ++j;
            }
            ++i;
        }
        return list;
    }

    private void addMembers(List<ILevelDefinition> levels, List<String> values, MemberValueHandle member) {
        ILevelDefinition levelDef;
        if (member != null && (levelDef = this.registeredLevelHandles.get(member.getLevel())) != null) {
            levels.add(levelDef);
            values.add(member.getValue());
            if (member.getContentCount("memberValues") > 0) {
                this.addMembers(levels, values, (MemberValueHandle)member.getContent("memberValues", 0));
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private Collection<ILevelDefinition> getAllLevelsInHierarchyOrder(CubeHandle cubeHandle, ICubeQueryDefinition cubeQuery) {
        block5: {
            levelValues = this.registeredLevels.values();
            if (cubeQuery.getEdge(2) != null || levelValues.size() <= 1) break block5;
            levelList = new ArrayList<ILevelDefinition>(levelValues.size());
            dimensionName = null;
            firstLevelIndex = 0;
            i = 0;
            hh = null;
            for (ILevelDefinition level : levelValues) {
                block6: {
                    if (i != 0) ** GOTO lbl21
                    dimensionName = level.getHierarchy().getDimension().getName();
                    hh = cubeHandle.getDimension(dimensionName).getDefaultHierarchy();
                    while (firstLevelIndex < hh.getLevelCount()) {
                        if (hh.getLevel(firstLevelIndex).getName().equals(level.getName())) break;
                        ++firstLevelIndex;
                    }
                    levelList.add(level);
                    break block6;
                    while (!hh.getLevel(firstLevelIndex).getName().equals(level.getName())) {
                        ++firstLevelIndex;
lbl21:
                        // 2 sources

                        if (firstLevelIndex < hh.getLevelCount()) continue;
                    }
                    if (firstLevelIndex < hh.getLevelCount()) {
                        levelList.add(level);
                    } else {
                        levelList.add(0, level);
                    }
                }
                ++i;
            }
            return levelList;
        }
        return levelValues;
    }

    private int getEdgeType(String dimensionName) {
        if (this.rowEdgeDimension == null) {
            this.rowEdgeDimension = dimensionName;
            return 1;
        }
        return this.rowEdgeDimension.equals(dimensionName) ? 1 : 2;
    }

    static List<SeriesDefinition> getAllSeriesDefinitions(Chart chart) {
        ArrayList<SeriesDefinition> seriesList = new ArrayList<SeriesDefinition>();
        if (chart instanceof ChartWithAxes) {
            Axis xAxis = (Axis)((ChartWithAxes)chart).getAxes().get(0);
            seriesList.addAll((Collection<SeriesDefinition>)xAxis.getSeriesDefinitions());
            EList axisList = xAxis.getAssociatedAxes();
            int i = 0;
            while (i < axisList.size()) {
                seriesList.addAll((Collection<SeriesDefinition>)((Axis)axisList.get(i)).getSeriesDefinitions());
                ++i;
            }
        } else if (chart instanceof ChartWithoutAxes) {
            SeriesDefinition sdBase = (SeriesDefinition)((ChartWithoutAxes)chart).getSeriesDefinitions().get(0);
            seriesList.add(sdBase);
            seriesList.addAll((Collection<SeriesDefinition>)sdBase.getSeriesDefinitions());
        }
        return seriesList;
    }
}

