/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.provisional.p2.metadata.generator;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.core.helpers.FileUtils;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.metadata.ArtifactKey;
import org.eclipse.equinox.internal.p2.metadata.generator.Activator;
import org.eclipse.equinox.internal.p2.metadata.generator.LocalizationHelper;
import org.eclipse.equinox.internal.p2.metadata.generator.Messages;
import org.eclipse.equinox.internal.p2.metadata.generator.ProductQuery;
import org.eclipse.equinox.internal.p2.metadata.generator.features.DefaultSiteParser;
import org.eclipse.equinox.internal.p2.metadata.generator.features.FeatureParser;
import org.eclipse.equinox.internal.p2.metadata.generator.features.ProductFile;
import org.eclipse.equinox.internal.p2.metadata.generator.features.SiteCategory;
import org.eclipse.equinox.internal.p2.metadata.generator.features.SiteFeature;
import org.eclipse.equinox.internal.p2.metadata.generator.features.SiteModel;
import org.eclipse.equinox.internal.provisional.frameworkadmin.BundleInfo;
import org.eclipse.equinox.internal.provisional.frameworkadmin.ConfigData;
import org.eclipse.equinox.internal.provisional.frameworkadmin.LauncherData;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.ArtifactDescriptor;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactDescriptor;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepository;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IFileArtifactRepository;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.metadata.IArtifactKey;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.MetadataFactory;
import org.eclipse.equinox.internal.provisional.p2.metadata.ProvidedCapability;
import org.eclipse.equinox.internal.provisional.p2.metadata.RequiredCapability;
import org.eclipse.equinox.internal.provisional.p2.metadata.generator.BundleDescriptionFactory;
import org.eclipse.equinox.internal.provisional.p2.metadata.generator.EclipseInstallGeneratorInfoProvider;
import org.eclipse.equinox.internal.provisional.p2.metadata.generator.Feature;
import org.eclipse.equinox.internal.provisional.p2.metadata.generator.FeatureEntry;
import org.eclipse.equinox.internal.provisional.p2.metadata.generator.GeneratorBundleInfo;
import org.eclipse.equinox.internal.provisional.p2.metadata.generator.IGeneratorInfo;
import org.eclipse.equinox.internal.provisional.p2.metadata.generator.MetadataGeneratorHelper;
import org.eclipse.equinox.internal.provisional.p2.metadata.generator.URLEntry;
import org.eclipse.equinox.internal.provisional.p2.metadata.query.InstallableUnitQuery;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepository;
import org.eclipse.equinox.internal.provisional.p2.query.Collector;
import org.eclipse.equinox.internal.provisional.p2.query.Query;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.PlatformAdmin;
import org.eclipse.osgi.service.resolver.StateObjectFactory;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;

public class Generator {
    private static final String ORG_ECLIPSE_EQUINOX_SIMPLECONFIGURATOR = "org.eclipse.equinox.simpleconfigurator";
    private static final String ORG_ECLIPSE_UPDATE_CONFIGURATOR = "org.eclipse.update.configurator";
    private static final String ORG_ECLIPSE_EQUINOX_LAUNCHER = "org.eclipse.equinox.launcher";
    private static final String PRODUCT_CONFIG_SUFFIX = ".config";
    private static final String PRODUCT_INI_SUFFIX = ".ini";
    private static final String PRODUCT_LAUCHER_SUFFIX = ".launcher";
    private static final String CONFIG_ANY = "ANY";
    static final String DEFAULT_BUNDLE_LOCALIZATION = "plugin";
    private static final String PROTOCOL_FILE = "file";
    protected final IGeneratorInfo info;
    private GeneratorResult incrementalResult = null;
    private ProductFile productFile = null;
    private boolean generateRootIU = true;
    protected final Set rootCategory = new HashSet();
    private StateObjectFactory stateObjectFactory;
    static /* synthetic */ Class class$0;

    public static String[] getArrayFromString(String list, String separator) {
        if (list == null || list.trim().equals("")) {
            return new String[0];
        }
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer tokens = new StringTokenizer(list, separator);
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken().trim();
            if (token.equals("")) continue;
            result.add(token);
        }
        return result.toArray(new String[result.size()]);
    }

    public static String[] parseConfigSpec(String config) {
        String[] parsed = Generator.getArrayFromString(config, "_");
        int i = 0;
        while (i < parsed.length) {
            if (parsed[i].equals("*")) {
                parsed[i] = CONFIG_ANY;
            }
            ++i;
        }
        if (parsed.length > 3) {
            String[] adjusted = new String[]{parsed[0], parsed[1], String.valueOf(parsed[2]) + '_' + parsed[3]};
            return adjusted;
        }
        return parsed;
    }

    public Generator(IGeneratorInfo infoProvider) {
        PlatformAdmin platformAdmin;
        this.info = infoProvider;
        BundleContext bundleContext = Activator.getContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.osgi.service.resolver.PlatformAdmin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((platformAdmin = (PlatformAdmin)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName())) != null) {
            this.stateObjectFactory = platformAdmin.getFactory();
        }
    }

    public void setIncrementalResult(GeneratorResult result) {
        this.incrementalResult = result;
    }

    private String getProductVersion() {
        String version = "1.0.0";
        if (this.productFile != null && !this.productFile.getVersion().equals("0.0.0")) {
            version = this.productFile.getVersion();
        } else if (!this.info.getRootVersion().equals("0.0.0")) {
            version = this.info.getRootVersion();
        }
        return version;
    }

    protected IInstallableUnit createProductIU(GeneratorResult result) {
        this.generateProductConfigCUs(result);
        GeneratorResult productContents = new GeneratorResult();
        ProductQuery query = new ProductQuery(this.productFile, this.info.getFlavor(), result.configurationIUs, this.info.getVersionAdvice());
        Collector collector = this.info.getMetadataRepository().query((Query)query, query.getCollector(), null);
        Iterator iterator = collector.iterator();
        while (iterator.hasNext()) {
            productContents.rootIUs.add(iterator.next());
        }
        String version = this.getProductVersion();
        VersionRange range = new VersionRange(new Version(version), true, new Version(version), true);
        ArrayList<RequiredCapability> requires = new ArrayList<RequiredCapability>(1);
        requires.add(MetadataFactory.createRequiredCapability((String)(String.valueOf(this.info.getFlavor()) + this.productFile.getId()), (String)(String.valueOf(this.productFile.getId()) + PRODUCT_LAUCHER_SUFFIX), (VersionRange)range, null, (boolean)false, (boolean)true));
        requires.add(MetadataFactory.createRequiredCapability((String)(String.valueOf(this.info.getFlavor()) + this.productFile.getId()), (String)(String.valueOf(this.productFile.getId()) + PRODUCT_INI_SUFFIX), (VersionRange)range, null, (boolean)false, (boolean)false));
        requires.add(MetadataFactory.createRequiredCapability((String)(String.valueOf(this.info.getFlavor()) + this.productFile.getId()), (String)(String.valueOf(this.productFile.getId()) + PRODUCT_CONFIG_SUFFIX), (VersionRange)range, null, (boolean)false, (boolean)false));
        requires.add(MetadataFactory.createRequiredCapability((String)"org.eclipse.equinox.p2.iu", (String)MetadataGeneratorHelper.createDefaultConfigUnitId("osgi.bundle", this.info.getFlavor()), (VersionRange)VersionRange.emptyRange, null, (boolean)false, (boolean)false));
        requires.add(MetadataFactory.createRequiredCapability((String)"org.eclipse.equinox.p2.iu", (String)MetadataGeneratorHelper.createDefaultConfigUnitId("source", this.info.getFlavor()), (VersionRange)VersionRange.emptyRange, null, (boolean)false, (boolean)false));
        if (this.productFile.useFeatures()) {
            requires.add(MetadataFactory.createRequiredCapability((String)"org.eclipse.equinox.p2.iu", (String)MetadataGeneratorHelper.createDefaultConfigUnitId("org.eclipse.update.feature", this.info.getFlavor()), (VersionRange)VersionRange.emptyRange, (String)"(org.eclipse.update.install.features=true)", (boolean)true, (boolean)false));
        }
        MetadataFactory.InstallableUnitDescription root = this.createTopLevelIUDescription(productContents, this.productFile.getId(), version, this.productFile.getProductName(), requires, false);
        return MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)root);
    }

    protected IInstallableUnit createTopLevelIU(GeneratorResult result, String configurationIdentification, String configurationVersion) {
        MetadataFactory.InstallableUnitDescription root = this.createTopLevelIUDescription(result, configurationIdentification, configurationVersion, configurationIdentification, null, true);
        return MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)root);
    }

    protected MetadataFactory.InstallableUnitDescription createTopLevelIUDescription(GeneratorResult result, String configurationIdentification, String configurationVersion, String configurationName, List requires, boolean configureLauncherData) {
        LauncherData launcherData;
        MetadataFactory.InstallableUnitDescription root = new MetadataFactory.InstallableUnitDescription();
        root.setSingleton(true);
        root.setId(configurationIdentification);
        root.setVersion(new Version(configurationVersion));
        root.setProperty("org.eclipse.equinox.p2.name", configurationName);
        ArrayList<RequiredCapability> reqsConfigurationUnits = new ArrayList<RequiredCapability>(result.rootIUs.size());
        Iterator iterator = result.rootIUs.iterator();
        while (iterator.hasNext()) {
            IInstallableUnit iu = (IInstallableUnit)iterator.next();
            VersionRange range = new VersionRange(iu.getVersion(), true, iu.getVersion(), true);
            reqsConfigurationUnits.add(MetadataFactory.createRequiredCapability((String)"org.eclipse.equinox.p2.iu", (String)iu.getId(), (VersionRange)range, (String)iu.getFilter(), (boolean)false, (boolean)false));
        }
        if (requires != null) {
            reqsConfigurationUnits.addAll(requires);
        }
        root.setRequiredCapabilities(reqsConfigurationUnits.toArray(new RequiredCapability[reqsConfigurationUnits.size()]));
        root.setArtifacts(new IArtifactKey[0]);
        root.setProperty("lineUp", "true");
        root.setUpdateDescriptor(MetadataFactory.createUpdateDescriptor((String)configurationIdentification, (VersionRange)VersionRange.emptyRange, (int)0, null));
        root.setProperty("org.eclipse.equinox.p2.type.group", Boolean.TRUE.toString());
        root.setCapabilities(new ProvidedCapability[]{MetadataGeneratorHelper.createSelfCapability(configurationIdentification, new Version(configurationVersion))});
        root.setTouchpointType(MetadataGeneratorHelper.TOUCHPOINT_OSGI);
        HashMap<String, String> touchpointData = new HashMap<String, String>();
        String configurationData = "";
        String unconfigurationData = "";
        ConfigData configData = this.info.getConfigData();
        if (configData != null) {
            String[] dataStrings = this.getConfigurationStrings(configData);
            configurationData = String.valueOf(configurationData) + dataStrings[0];
            unconfigurationData = String.valueOf(unconfigurationData) + dataStrings[1];
        }
        if (configureLauncherData && (launcherData = this.info.getLauncherData()) != null) {
            String[] dataStrings = this.getLauncherConfigStrings(launcherData.getJvmArgs(), launcherData.getProgramArgs());
            configurationData = String.valueOf(configurationData) + dataStrings[0];
            unconfigurationData = String.valueOf(unconfigurationData) + dataStrings[1];
        }
        touchpointData.put("configure", configurationData);
        touchpointData.put("unconfigure", unconfigurationData);
        root.addTouchpointData(MetadataFactory.createTouchpointData(touchpointData));
        return root;
    }

    private String[] getConfigurationStrings(ConfigData configData) {
        String key;
        Map.Entry<Object, Object> aProperty;
        String configurationData = "";
        String unconfigurationData = "";
        Iterator<Map.Entry<Object, Object>> iterator = configData.getFwDependentProps().entrySet().iterator();
        while (iterator.hasNext()) {
            aProperty = iterator.next();
            key = (String)aProperty.getKey();
            if (key.equals("osgi.frameworkClassPath") || key.equals("osgi.framework") || key.equals("osgi.bundles") || key.equals("eof")) continue;
            configurationData = String.valueOf(configurationData) + "setProgramProperty(propName:" + key + ", propValue:" + (String)aProperty.getValue() + ");";
            unconfigurationData = String.valueOf(unconfigurationData) + "setProgramProperty(propName:" + key + ", propValue:);";
        }
        iterator = configData.getFwIndependentProps().entrySet().iterator();
        while (iterator.hasNext()) {
            aProperty = iterator.next();
            key = (String)aProperty.getKey();
            if (key.equals("osgi.frameworkClassPath") || key.equals("osgi.framework") || key.equals("osgi.bundles") || key.equals("eof")) continue;
            configurationData = String.valueOf(configurationData) + "setProgramProperty(propName:" + key + ", propValue:" + (String)aProperty.getValue() + ");";
            unconfigurationData = String.valueOf(unconfigurationData) + "setProgramProperty(propName:" + key + ", propValue:);";
        }
        return new String[]{configurationData, unconfigurationData};
    }

    private String[] getLauncherConfigStrings(String[] jvmArgs, String[] programArgs) {
        String configurationData = "";
        String unconfigurationData = "";
        int i = 0;
        while (i < jvmArgs.length) {
            configurationData = String.valueOf(configurationData) + "addJvmArg(jvmArg:" + jvmArgs[i] + ");";
            unconfigurationData = String.valueOf(unconfigurationData) + "removeJvmArg(jvmArg:" + jvmArgs[i] + ");";
            ++i;
        }
        i = 0;
        while (i < programArgs.length) {
            String programArg = programArgs[i];
            if (programArg.equals("--launcher.library") || programArg.equals("-startup") || programArg.equals("-configuration")) {
                ++i;
            }
            configurationData = String.valueOf(configurationData) + "addProgramArg(programArg:" + programArg + ");";
            unconfigurationData = String.valueOf(unconfigurationData) + "removeProgramArg(programArg:" + programArg + ");";
            ++i;
        }
        return new String[]{configurationData, unconfigurationData};
    }

    public IStatus generate() {
        IMetadataRepository metadataRepository;
        GeneratorResult result;
        GeneratorResult generatorResult = result = this.incrementalResult != null ? this.incrementalResult : new GeneratorResult();
        if (this.info.getProductFile() != null) {
            try {
                this.productFile = new ProductFile(this.info.getProductFile(), null);
            }
            catch (Exception exception) {}
        }
        Feature[] features = this.getFeatures(this.info.getFeaturesLocation());
        this.generateFeatureIUs(features, result, this.info.getArtifactRepository());
        BundleDescription[] bundles = this.getBundleDescriptions(this.info.getBundleLocations());
        this.generateBundleIUs(bundles, result, this.info.getArtifactRepository());
        this.generateNativeIUs(this.info.getExecutableLocation(), result, this.info.getArtifactRepository());
        this.generateConfigIUs(result);
        if (this.info.addDefaultIUs()) {
            this.generateDefaultConfigIU(result.rootIUs);
        }
        if (this.generateRootIU) {
            this.generateRootIU(result, this.info.getRootId(), this.info.getRootVersion());
        }
        if ((metadataRepository = this.info.getMetadataRepository()) != null) {
            Set allGeneratedUnits = result.allGeneratedIUs();
            metadataRepository.addInstallableUnits(allGeneratedUnits.toArray(new IInstallableUnit[allGeneratedUnits.size()]));
        }
        return Status.OK_STATUS;
    }

    protected void generateBundleIUs(BundleDescription[] bundles, GeneratorResult result, IArtifactRepository destination) {
        HashMap<String, String[]> bundleLocalizationMap = new HashMap<String, String[]>(bundles.length);
        HashSet localizationIUs = new HashSet(32);
        int phase = 0;
        while (phase <= 1) {
            int i = 0;
            while (i < bundles.length) {
                BundleDescription bd = bundles[i];
                if (bd != null && bd.getSymbolicName() != null && bd.getVersion() != null) {
                    Map bundleManifest = (Map)bd.getUserObject();
                    if (phase == 0) {
                        if (bundleManifest != null) {
                            String[] cachedValues = MetadataGeneratorHelper.getManifestCachedValues(bundleManifest);
                            bundleLocalizationMap.put(Generator.makeSimpleKey(bd), cachedValues);
                        }
                    } else {
                        String hostId;
                        String hostKey;
                        String[] cachedValues;
                        File packFile;
                        String format = (String)result.getPluginShapeInfo().get(String.valueOf(bd.getSymbolicName()) + '_' + bd.getVersion());
                        if (format == null) {
                            format = (String)bundleManifest.get(BundleDescriptionFactory.BUNDLE_FILE_KEY);
                        }
                        boolean isDir = format != null && format.equals("dir");
                        IArtifactKey key = MetadataGeneratorHelper.createBundleArtifactKey(bd.getSymbolicName(), bd.getVersion().toString());
                        IArtifactDescriptor ad = MetadataGeneratorHelper.createArtifactDescriptor(key, new File(bd.getLocation()), true, false);
                        ((ArtifactDescriptor)ad).setProperty("download.contentType", "application/zip");
                        File bundleFile = new File(bd.getLocation());
                        if (bundleFile.isDirectory()) {
                            this.publishArtifact(ad, bundleFile.listFiles(), destination, false, bundleFile);
                        } else {
                            this.publishArtifact(ad, new File[]{bundleFile}, destination, true);
                        }
                        if (this.info.reuseExistingPack200Files() && !this.info.publishArtifacts() && (packFile = new Path(bd.getLocation()).addFileExtension("pack.gz").toFile()).exists()) {
                            IArtifactDescriptor ad200 = MetadataGeneratorHelper.createPack200ArtifactDescriptor(key, packFile, ad.getProperty("artifact.size"));
                            this.publishArtifact(ad200, new File[]{packFile}, destination, true);
                        }
                        IInstallableUnit bundleIU = MetadataGeneratorHelper.createBundleIU(bd, bundleManifest, isDir, key, true);
                        if (Generator.isFragment(bd) && (cachedValues = (String[])bundleLocalizationMap.get(hostKey = Generator.makeSimpleKey(hostId = bd.getHost().getName()))) != null) {
                            MetadataGeneratorHelper.createHostLocalizationFragment(bundleIU, bd, hostId, cachedValues, localizationIUs);
                        }
                        result.rootIUs.add(bundleIU);
                        result.nonRootIUs.addAll(localizationIUs);
                        localizationIUs.clear();
                    }
                }
                ++i;
            }
            ++phase;
        }
    }

    private static boolean isFragment(BundleDescription bd) {
        return bd.getHost() != null;
    }

    private static String makeSimpleKey(BundleDescription bd) {
        return Generator.makeSimpleKey(bd.getSymbolicName());
    }

    private static String makeSimpleKey(String id) {
        return id;
    }

    protected void generateCategoryIUs(Map categoriesToFeatures, GeneratorResult result) {
        Iterator it = categoriesToFeatures.keySet().iterator();
        while (it.hasNext()) {
            SiteCategory category = (SiteCategory)it.next();
            result.nonRootIUs.add(MetadataGeneratorHelper.createCategoryIU(category, (Set)categoriesToFeatures.get(category), null));
        }
    }

    private void storeConfigData(GeneratorResult result) {
        if (result.configData.containsKey(this.info.getLauncherConfig())) {
            return;
        }
        LauncherData launcherData = this.info.getLauncherData();
        if (launcherData == null) {
            return;
        }
        File fwConfigFile = new File(launcherData.getFwConfigLocation(), "config.ini");
        if (fwConfigFile.exists() && this.info instanceof EclipseInstallGeneratorInfoProvider) {
            ((EclipseInstallGeneratorInfoProvider)this.info).loadConfigData(fwConfigFile);
            ConfigData data = this.info.getConfigData();
            result.configData.put(this.info.getLauncherConfig(), data);
        }
    }

    protected GeneratorBundleInfo createGeneratorBundleInfo(BundleInfo bundleInfo, GeneratorResult result) {
        if (bundleInfo.getLocation() != null) {
            return new GeneratorBundleInfo(bundleInfo);
        }
        String name = bundleInfo.getSymbolicName();
        IInstallableUnit iu = result.getInstallableUnit(name);
        if (iu != null) {
            bundleInfo.setVersion(iu.getVersion().toString());
            return new GeneratorBundleInfo(bundleInfo);
        }
        int i = name.indexOf(95);
        while (i > -1) {
            Version version = null;
            try {
                version = new Version(name.substring(i));
                bundleInfo.setSymbolicName(name.substring(0, i));
                bundleInfo.setVersion(version.toString());
                return new GeneratorBundleInfo(bundleInfo);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                i = name.indexOf(95, i);
            }
        }
        InstallableUnitQuery query = new InstallableUnitQuery(name);
        Collector collector = new Collector();
        Iterator matches = this.info.getMetadataRepository().query((Query)query, collector, null).iterator();
        IInstallableUnit newest = null;
        while (matches.hasNext()) {
            IInstallableUnit candidate = (IInstallableUnit)matches.next();
            if (newest != null && newest.getVersion().compareTo((Object)candidate.getVersion()) >= 0) continue;
            newest = candidate;
        }
        if (newest != null) {
            bundleInfo.setVersion(newest.getVersion().toString());
            return new GeneratorBundleInfo(bundleInfo);
        }
        return null;
    }

    protected void generateBundleConfigIUs(BundleInfo[] infos, GeneratorResult result, String launcherConfig) {
        if (infos == null) {
            return;
        }
        String cuIdPrefix = "";
        String filter = null;
        if (launcherConfig != null) {
            String[] config = Generator.parseConfigSpec(launcherConfig);
            cuIdPrefix = String.valueOf(config[1]) + '.' + config[0] + '.' + config[2];
            filter = "(& (osgi.ws=" + config[1] + ") (osgi.os=" + config[0] + ") (osgi.arch=" + config[2] + "))";
        }
        ArrayList<IInstallableUnit> allCUs = new ArrayList<IInstallableUnit>();
        int i = 0;
        while (i < infos.length) {
            block10: {
                GeneratorBundleInfo bundle;
                block14: {
                    block13: {
                        block12: {
                            block11: {
                                bundle = this.createGeneratorBundleInfo(infos[i], result);
                                if (bundle == null) break block10;
                                if (!bundle.getSymbolicName().equals(ORG_ECLIPSE_EQUINOX_LAUNCHER)) break block11;
                                bundle = EclipseInstallGeneratorInfoProvider.createLauncher();
                                break block12;
                            }
                            if (bundle.getSymbolicName().startsWith("org.eclipse.equinox.launcher.")) break block10;
                        }
                        if (!bundle.getSymbolicName().equals(ORG_ECLIPSE_UPDATE_CONFIGURATOR)) break block13;
                        bundle.setStartLevel(-1);
                        bundle.setMarkedAsStarted(false);
                        bundle.setSpecialConfigCommands("setProgramProperty(propName:org.eclipse.update.reconcile, propValue:false);");
                        bundle.setSpecialUnconfigCommands("setProgramProperty(propName:org.eclipse.update.reconcile, propValue:);");
                        break block14;
                    }
                    if (bundle.getStartLevel() == -1 && !bundle.isMarkedAsStarted()) break block10;
                }
                IInstallableUnit cu = MetadataGeneratorHelper.createBundleConfigurationUnit(bundle.getSymbolicName(), new Version(bundle.getVersion()), false, bundle, String.valueOf(this.info.getFlavor()) + cuIdPrefix, filter);
                if (cu != null) {
                    String key;
                    allCUs.add(cu);
                    result.rootIUs.add(cu);
                    String string = key = this.productFile != null && this.productFile.useFeatures() ? "CONFIGURATION_CUS" : bundle.getSymbolicName();
                    if (result.configurationIUs.containsKey(key)) {
                        ((Set)result.configurationIUs.get(key)).add(cu);
                    } else {
                        HashSet<IInstallableUnit> set = new HashSet<IInstallableUnit>();
                        set.add(cu);
                        result.configurationIUs.put(key, set);
                    }
                }
            }
            ++i;
        }
        IMetadataRepository metadataRepository = this.info.getMetadataRepository();
        if (metadataRepository != null && !allCUs.isEmpty()) {
            metadataRepository.addInstallableUnits(allCUs.toArray(new IInstallableUnit[allCUs.size()]));
        }
    }

    protected void generateConfigIUs(GeneratorResult result) {
        ConfigData data = this.info.getConfigData();
        if ((data == null || data.getBundles().length == 0) && this.info.getLauncherConfig() != null) {
            this.storeConfigData(result);
        } else if (data != null) {
            this.generateBundleConfigIUs(data.getBundles(), result, this.info.getLauncherConfig());
        } else if (result.configData.size() > 0 && this.generateRootIU) {
            Iterator iterator = result.configData.keySet().iterator();
            while (iterator.hasNext()) {
                String launcherConfig = (String)iterator.next();
                data = (ConfigData)result.configData.get(launcherConfig);
                this.generateBundleConfigIUs(data.getBundles(), result, launcherConfig);
            }
        }
        ArrayList bundleInfoList = new ArrayList();
        if (this.info.addDefaultIUs()) {
            bundleInfoList.addAll(this.info.getDefaultIUs(result.rootIUs));
        }
        bundleInfoList.addAll(this.info.getOtherIUs());
        Iterator iterator = bundleInfoList.iterator();
        while (iterator.hasNext()) {
            GeneratorBundleInfo bundle = (GeneratorBundleInfo)((Object)iterator.next());
            IInstallableUnit configuredIU = result.getInstallableUnit(bundle.getSymbolicName());
            if (configuredIU == null) {
                if (!this.generateRootIU) continue;
                InstallableUnitQuery query = new InstallableUnitQuery(bundle.getSymbolicName());
                Collector collector = new Collector();
                IMetadataRepository metadataRepository = this.info.getMetadataRepository();
                if (metadataRepository == null) continue;
                Iterator matches = metadataRepository.query((Query)query, collector, null).iterator();
                IInstallableUnit newest = null;
                while (matches.hasNext()) {
                    IInstallableUnit candidate = (IInstallableUnit)matches.next();
                    if (newest != null && newest.getVersion().compareTo((Object)candidate.getVersion()) >= 0) continue;
                    newest = candidate;
                }
                if (newest == null) continue;
                configuredIU = newest;
            }
            bundle.setVersion(configuredIU.getVersion().toString());
            String filter = configuredIU == null ? null : configuredIU.getFilter();
            IInstallableUnit cu = MetadataGeneratorHelper.createBundleConfigurationUnit(bundle.getSymbolicName(), new Version(bundle.getVersion()), false, bundle, this.info.getFlavor(), filter);
            if (cu != null) {
                result.rootIUs.add(cu);
            }
            String key = null;
            key = this.productFile != null && this.productFile.useFeatures() ? "CONFIGURATION_CUS" : (bundle.getSymbolicName().startsWith("org.eclipse.equinox.launcher.") ? ORG_ECLIPSE_EQUINOX_LAUNCHER : bundle.getSymbolicName());
            if (result.configurationIUs.containsKey(key)) {
                ((Set)result.configurationIUs.get(key)).add(cu);
                continue;
            }
            HashSet<IInstallableUnit> set = new HashSet<IInstallableUnit>();
            set.add(cu);
            result.configurationIUs.put(key, set);
        }
    }

    private IInstallableUnit generateDefaultCategory(IInstallableUnit rootIU) {
        this.rootCategory.add(rootIU);
        MetadataFactory.InstallableUnitDescription cat = new MetadataFactory.InstallableUnitDescription();
        cat.setSingleton(true);
        String categoryId = String.valueOf(rootIU.getId()) + ".categoryIU";
        cat.setId(categoryId);
        cat.setVersion(Version.emptyVersion);
        cat.setProperty("org.eclipse.equinox.p2.name", rootIU.getProperty("org.eclipse.equinox.p2.name"));
        cat.setProperty("org.eclipse.equinox.p2.description", rootIU.getProperty("org.eclipse.equinox.p2.description"));
        ArrayList<RequiredCapability> required = new ArrayList<RequiredCapability>(this.rootCategory.size());
        Iterator iterator = this.rootCategory.iterator();
        while (iterator.hasNext()) {
            IInstallableUnit iu = (IInstallableUnit)iterator.next();
            required.add(MetadataFactory.createRequiredCapability((String)"org.eclipse.equinox.p2.iu", (String)iu.getId(), (VersionRange)VersionRange.emptyRange, (String)iu.getFilter(), (boolean)false, (boolean)false));
        }
        cat.setRequiredCapabilities(required.toArray(new RequiredCapability[required.size()]));
        cat.setCapabilities(new ProvidedCapability[]{MetadataFactory.createProvidedCapability((String)"org.eclipse.equinox.p2.iu", (String)categoryId, (Version)Version.emptyVersion)});
        cat.setArtifacts(new IArtifactKey[0]);
        cat.setProperty("org.eclipse.equinox.p2.type.category", "true");
        return MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)cat);
    }

    private void generateDefaultConfigIU(Set ius) {
        EclipseInstallGeneratorInfoProvider provider = (EclipseInstallGeneratorInfoProvider)this.info;
        ius.add(MetadataGeneratorHelper.createDefaultBundleConfigurationUnit(provider.createDefaultConfigurationBundleInfo(), provider.createDefaultUnconfigurationBundleInfo(), this.info.getFlavor()));
        ius.add(MetadataGeneratorHelper.createDefaultFeatureConfigurationUnit(this.info.getFlavor()));
        ius.add(MetadataGeneratorHelper.createDefaultConfigurationUnitForSourceBundles(this.info.getFlavor()));
    }

    private boolean generateExecutableFeatureIUs(GeneratorResult result, IArtifactRepository destination) {
        File parentDir = this.info.getFeaturesLocation();
        if (parentDir == null || !parentDir.exists()) {
            return false;
        }
        File[] featureDirs = parentDir.listFiles();
        if (featureDirs == null) {
            return false;
        }
        File executableFeatureDir = null;
        int i = 0;
        while (i < featureDirs.length) {
            if (featureDirs[i].getName().startsWith("org.eclipse.equinox.executable_")) {
                executableFeatureDir = featureDirs[i];
                break;
            }
            ++i;
        }
        if (executableFeatureDir == null) {
            return false;
        }
        File binDir = new File(executableFeatureDir, "bin");
        if (!binDir.exists()) {
            return false;
        }
        File[] wsDirs = binDir.listFiles();
        if (wsDirs == null) {
            return false;
        }
        String versionString = executableFeatureDir.getName().substring("org.eclipse.equinox.executable_".length());
        int wsIndex = 0;
        while (wsIndex < wsDirs.length) {
            String ws = wsDirs[wsIndex].getName();
            File[] osDirs = wsDirs[wsIndex].listFiles();
            if (osDirs != null) {
                int osIndex = 0;
                while (osIndex < osDirs.length) {
                    String os = osDirs[osIndex].getName();
                    File[] archDirs = osDirs[osIndex].listFiles();
                    if (archDirs != null) {
                        int archIndex = 0;
                        while (archIndex < archDirs.length) {
                            String arch = archDirs[archIndex].getName();
                            this.generateExecutableIUs(ws, os, arch, versionString, archDirs[archIndex], result, destination);
                            ++archIndex;
                        }
                    }
                    ++osIndex;
                }
            }
            ++wsIndex;
        }
        return true;
    }

    private void generateExecutableIUs(String ws, String os, String arch, String version, File root, GeneratorResult result, IArtifactRepository destination) {
        File[] launcherFiles;
        int i;
        if (root == null) {
            return;
        }
        MetadataFactory.InstallableUnitDescription iu = new MetadataFactory.InstallableUnitDescription();
        iu.setSingleton(true);
        String productNamespace = this.productFile != null ? this.productFile.getId() : "org.eclipse";
        String launcherIdPrefix = String.valueOf(productNamespace) + PRODUCT_LAUCHER_SUFFIX;
        String launcherId = String.valueOf(launcherIdPrefix) + '.' + ws + '.' + os + '.' + arch;
        iu.setId(launcherId);
        Version launcherVersion = new Version(version);
        iu.setVersion(launcherVersion);
        iu.setSingleton(true);
        String filter = null;
        if (!(ws.equals(CONFIG_ANY) || os.equals(CONFIG_ANY) || arch.equals(CONFIG_ANY))) {
            filter = "(& (osgi.ws=" + ws + ") (osgi.os=" + os + ") (osgi.arch=" + arch + "))";
            iu.setFilter(filter);
        }
        ArtifactKey key = MetadataGeneratorHelper.createLauncherArtifactKey(launcherId, launcherVersion);
        iu.setArtifacts(new IArtifactKey[]{key});
        iu.setTouchpointType(MetadataGeneratorHelper.TOUCHPOINT_NATIVE);
        ProvidedCapability launcherCapability = MetadataFactory.createProvidedCapability((String)(String.valueOf(this.info.getFlavor()) + productNamespace), (String)launcherIdPrefix, (Version)launcherVersion);
        iu.setCapabilities(new ProvidedCapability[]{MetadataGeneratorHelper.createSelfCapability(launcherId, launcherVersion), launcherCapability});
        String launcherFragment = "org.eclipse.equinox.launcher." + ws + '.' + os;
        if (!"macosx".equals(os)) {
            launcherFragment = String.valueOf(launcherFragment) + '.' + arch;
        }
        iu.setRequiredCapabilities(new RequiredCapability[]{MetadataFactory.createRequiredCapability((String)"org.eclipse.equinox.p2.iu", (String)launcherFragment, (VersionRange)VersionRange.emptyRange, (String)filter, (boolean)false, (boolean)false)});
        result.rootIUs.add(MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)iu));
        MetadataFactory.InstallableUnitFragmentDescription cu = new MetadataFactory.InstallableUnitFragmentDescription();
        String configUnitId = String.valueOf(this.info.getFlavor()) + launcherId;
        cu.setId(configUnitId);
        cu.setVersion(launcherVersion);
        if (filter != null) {
            cu.setFilter(filter);
        }
        cu.setHost(new RequiredCapability[]{MetadataFactory.createRequiredCapability((String)"org.eclipse.equinox.p2.iu", (String)launcherId, (VersionRange)new VersionRange(launcherVersion, true, launcherVersion, true), null, (boolean)false, (boolean)false)});
        cu.setProperty("org.eclipse.equinox.p2.type.fragment", Boolean.TRUE.toString());
        cu.setCapabilities(new ProvidedCapability[]{MetadataGeneratorHelper.createSelfCapability(configUnitId, launcherVersion)});
        this.mungeLauncherFileNames(root);
        cu.setTouchpointType(MetadataGeneratorHelper.TOUCHPOINT_NATIVE);
        HashMap<String, String> touchpointData = new HashMap<String, String>();
        String configurationData = "unzip(source:@artifact, target:${installFolder});";
        IInstallableUnit launcherNameIU = null;
        File executableLocation = this.info.getExecutableLocation();
        if (executableLocation != null) {
            if (!executableLocation.exists() && "win32".equals(os) && !executableLocation.getName().endsWith(".exe")) {
                executableLocation = new File(executableLocation.getParentFile(), String.valueOf(executableLocation.getName()) + ".exe");
            }
            if (executableLocation.exists() && executableLocation.isFile()) {
                launcherNameIU = MetadataGeneratorHelper.generateLauncherSetter(executableLocation.getName(), launcherId, launcherVersion, os, ws, arch, result.rootIUs);
            }
        }
        if ("macosx".equals(os)) {
            File[] appFolders = root.listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.substring(name.length() - 4, name.length()).equalsIgnoreCase(".app");
                }
            });
            i = 0;
            while (appFolders != null && i < appFolders.length) {
                File macOSFolder = new File(appFolders[i], "Contents/MacOS");
                if (macOSFolder.exists()) {
                    File[] launcherFiles2 = macOSFolder.listFiles();
                    int j = 0;
                    while (j < launcherFiles2.length) {
                        configurationData = String.valueOf(configurationData) + " chmod(targetDir:${installFolder}/" + appFolders[i].getName() + "/Contents/MacOS/, targetFile:" + launcherFiles2[j].getName() + ", permissions:755);";
                        if (executableLocation == null && launcherFiles2[i].isFile() && new Path(launcherFiles2[j].getName()).getFileExtension() == null) {
                            launcherNameIU = MetadataGeneratorHelper.generateLauncherSetter(launcherFiles2[j].getName(), launcherId, launcherVersion, os, ws, arch, result.rootIUs);
                        }
                        ++j;
                    }
                }
                ++i;
            }
        } else if (!"win32".equals(os)) {
            launcherFiles = root.listFiles();
            i = 0;
            while (launcherFiles != null && i < launcherFiles.length) {
                configurationData = String.valueOf(configurationData) + " chmod(targetDir:${installFolder}, targetFile:" + launcherFiles[i].getName() + ", permissions:755);";
                if (executableLocation == null && launcherFiles[i].isFile() && new Path(launcherFiles[i].getName()).getFileExtension() == null) {
                    launcherNameIU = MetadataGeneratorHelper.generateLauncherSetter(launcherFiles[i].getName(), launcherId, launcherVersion, os, ws, arch, result.rootIUs);
                }
                ++i;
            }
        } else if (launcherNameIU == null && (launcherFiles = root.listFiles(new FilenameFilter(){

            public boolean accept(File parent, String name) {
                return name.endsWith(".exe");
            }
        })) != null && launcherFiles.length > 0) {
            launcherNameIU = MetadataGeneratorHelper.generateLauncherSetter(launcherFiles[0].getName(), launcherId, launcherVersion, os, ws, arch, result.rootIUs);
        }
        touchpointData.put("install", configurationData);
        String unConfigurationData = "cleanupzip(source:@artifact, target:${installFolder});";
        touchpointData.put("uninstall", unConfigurationData);
        cu.addTouchpointData(MetadataFactory.createTouchpointData(touchpointData));
        IInstallableUnit unit = MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)cu);
        result.rootIUs.add(unit);
        if (result.configurationIUs.containsKey(launcherIdPrefix)) {
            ((Set)result.configurationIUs.get(launcherIdPrefix)).add(unit);
            if (launcherNameIU != null) {
                ((Set)result.configurationIUs.get(launcherIdPrefix)).add(launcherNameIU);
            }
        } else {
            HashSet<IInstallableUnit> set = new HashSet<IInstallableUnit>();
            set.add(unit);
            if (launcherNameIU != null) {
                set.add(launcherNameIU);
            }
            result.configurationIUs.put(launcherIdPrefix, set);
        }
        IArtifactDescriptor descriptor = MetadataGeneratorHelper.createArtifactDescriptor((IArtifactKey)key, root, false, true);
        this.publishArtifact(descriptor, root.listFiles(), destination, false);
    }

    private void generateProductConfigCUs(GeneratorResult result) {
        Iterator iterator = result.configData.keySet().iterator();
        while (iterator.hasNext()) {
            String launcherConfig = (String)iterator.next();
            String[] config = Generator.parseConfigSpec(launcherConfig);
            String ws = config[1];
            String os = config[0];
            String arch = config[2];
            ConfigData data = (ConfigData)result.configData.get(launcherConfig);
            MetadataFactory.InstallableUnitDescription cu = new MetadataFactory.InstallableUnitDescription();
            String configUnitId = String.valueOf(this.info.getFlavor()) + this.productFile.getId() + ".config." + ws + '.' + os + '.' + arch;
            String version = this.getProductVersion();
            Version cuVersion = new Version(version);
            cu.setId(configUnitId);
            cu.setVersion(cuVersion);
            cu.setSingleton(true);
            cu.setFilter("(& (osgi.ws=" + ws + ") (osgi.os=" + os + ") (osgi.arch=" + arch + "))");
            ProvidedCapability productConfigCapability = MetadataFactory.createProvidedCapability((String)(String.valueOf(this.info.getFlavor()) + this.productFile.getId()), (String)(String.valueOf(this.productFile.getId()) + PRODUCT_CONFIG_SUFFIX), (Version)cuVersion);
            ProvidedCapability selfCapability = MetadataGeneratorHelper.createSelfCapability(configUnitId, cuVersion);
            cu.setCapabilities(new ProvidedCapability[]{selfCapability, productConfigCapability});
            cu.setTouchpointType(MetadataGeneratorHelper.TOUCHPOINT_OSGI);
            HashMap<String, String> touchpointData = new HashMap<String, String>();
            String[] dataStrings = this.getConfigurationStrings(data);
            touchpointData.put("configure", dataStrings[0]);
            touchpointData.put("unconfigure", dataStrings[1]);
            cu.addTouchpointData(MetadataFactory.createTouchpointData(touchpointData));
            result.rootIUs.add(MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)cu));
        }
    }

    private void generateProductIniCU(String ws, String os, String arch, String version, GeneratorResult result) {
        if (this.productFile == null) {
            return;
        }
        LinkedHashSet<String> jvmArgs = new LinkedHashSet<String>();
        LinkedHashSet<String> progArgs = new LinkedHashSet<String>();
        LauncherData launcherData = this.info.getLauncherData();
        if (launcherData != null) {
            jvmArgs.addAll(Arrays.asList(launcherData.getJvmArgs()));
            progArgs.addAll(Arrays.asList(launcherData.getProgramArgs()));
        }
        progArgs.addAll(Arrays.asList(Generator.getArrayFromString(this.productFile.getProgramArguments(os), " ")));
        jvmArgs.addAll(Arrays.asList(Generator.getArrayFromString(this.productFile.getVMArguments(os), " ")));
        String[] dataStrings = this.getLauncherConfigStrings(jvmArgs.toArray(new String[jvmArgs.size()]), progArgs.toArray(new String[progArgs.size()]));
        String configurationData = dataStrings[0];
        String unconfigurationData = dataStrings[1];
        MetadataFactory.InstallableUnitDescription cu = new MetadataFactory.InstallableUnitDescription();
        String configUnitId = String.valueOf(this.info.getFlavor()) + this.productFile.getId() + ".ini." + ws + '.' + os + '.' + arch;
        Version cuVersion = new Version(version);
        cu.setId(configUnitId);
        cu.setVersion(cuVersion);
        cu.setSingleton(true);
        cu.setFilter("(& (osgi.ws=" + ws + ") (osgi.os=" + os + ") (osgi.arch=" + arch + "))");
        ProvidedCapability productIniCapability = MetadataFactory.createProvidedCapability((String)(String.valueOf(this.info.getFlavor()) + this.productFile.getId()), (String)(String.valueOf(this.productFile.getId()) + PRODUCT_INI_SUFFIX), (Version)cuVersion);
        ProvidedCapability selfCapability = MetadataGeneratorHelper.createSelfCapability(configUnitId, cuVersion);
        cu.setCapabilities(new ProvidedCapability[]{selfCapability, productIniCapability});
        cu.setTouchpointType(MetadataGeneratorHelper.TOUCHPOINT_OSGI);
        HashMap<String, String> touchpointData = new HashMap<String, String>();
        touchpointData.put("configure", configurationData);
        touchpointData.put("unconfigure", unconfigurationData);
        cu.addTouchpointData(MetadataFactory.createTouchpointData(touchpointData));
        result.rootIUs.add(MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)cu));
    }

    protected void generateFeatureIUs(Feature[] features, GeneratorResult result, IArtifactRepository destination) {
        HashMap<SiteCategory, HashSet<IInstallableUnit>> categoriesToFeatureIUs = new HashMap<SiteCategory, HashSet<IInstallableUnit>>();
        Map featuresToCategories = this.getFeatureToCategoryMappings();
        int i = 0;
        while (i < features.length) {
            Feature feature = features[i];
            String updateURL = feature.getUpdateSiteURL();
            if (updateURL != null) {
                this.generateSiteReference(updateURL, feature.getId(), false);
            }
            URLEntry[] discoverySites = feature.getDiscoverySites();
            int j = 0;
            while (j < discoverySites.length) {
                this.generateSiteReference(discoverySites[j].getURL(), feature.getId(), false);
                ++j;
            }
            String location = feature.getLocation();
            boolean isExploded = !location.endsWith(".jar");
            IInstallableUnit featureIU = MetadataGeneratorHelper.createFeatureJarIU(feature, true);
            IArtifactKey[] artifacts = featureIU.getArtifacts();
            this.storePluginShape(feature, result);
            int arti = 0;
            while (arti < artifacts.length) {
                IArtifactDescriptor ad = MetadataGeneratorHelper.createArtifactDescriptor(artifacts[arti], new File(location), true, false);
                if (isExploded) {
                    this.publishArtifact(ad, new File(location).listFiles(), destination, false, new File(location));
                } else {
                    this.publishArtifact(ad, new File[]{new File(location)}, destination, true);
                }
                ++arti;
            }
            IInstallableUnit generated = MetadataGeneratorHelper.createGroupIU(feature, featureIU);
            result.rootIUs.add(generated);
            result.rootIUs.add(featureIU);
            Set categories = this.getCategories(feature, featuresToCategories);
            if (categories != null) {
                Iterator it = categories.iterator();
                while (it.hasNext()) {
                    SiteCategory category = (SiteCategory)it.next();
                    HashSet<IInstallableUnit> featureIUs = (HashSet<IInstallableUnit>)categoriesToFeatureIUs.get(category);
                    if (featureIUs == null) {
                        featureIUs = new HashSet<IInstallableUnit>();
                        categoriesToFeatureIUs.put(category, featureIUs);
                    }
                    featureIUs.add(generated);
                }
            } else {
                this.rootCategory.add(generated);
            }
            ++i;
        }
        this.generateCategoryIUs(categoriesToFeatureIUs, result);
    }

    private void storePluginShape(Feature feature, GeneratorResult result) {
        FeatureEntry[] entries = feature.getEntries();
        int i = 0;
        while (i < entries.length) {
            if (entries[i].isPlugin() || entries[i].isFragment()) {
                result.getPluginShapeInfo().put(String.valueOf(entries[i].getId()) + '_' + entries[i].getVersion(), entries[i].isUnpack() ? "dir" : "jar");
            }
            ++i;
        }
    }

    protected void generateNativeIUs(File executableLocation, GeneratorResult result, IArtifactRepository destination) {
        File jreLocation = this.info.getJRELocation();
        IArtifactDescriptor artifact = MetadataGeneratorHelper.createJREData(jreLocation, result.rootIUs);
        this.publishArtifact(artifact, new File[]{jreLocation}, destination, false);
        if (this.info.getLauncherConfig() != null) {
            String[] config = Generator.parseConfigSpec(this.info.getLauncherConfig());
            String version = this.getProductVersion();
            File root = null;
            if (executableLocation != null) {
                root = executableLocation.getParentFile();
            } else if (this.info instanceof EclipseInstallGeneratorInfoProvider) {
                root = ((EclipseInstallGeneratorInfoProvider)this.info).getBaseLocation();
            }
            this.generateExecutableIUs(config[1], config[0], config[2], version, root, result, destination);
            this.generateProductIniCU(config[1], config[0], config[2], version, result);
            return;
        }
        if (this.generateExecutableFeatureIUs(result, destination) || executableLocation == null) {
            return;
        }
        artifact = MetadataGeneratorHelper.createLauncherIU(executableLocation, this.info.getFlavor(), result.rootIUs);
        File[] launcherFiles = null;
        File consoleLauncher = new File(executableLocation.getParentFile(), "eclipsec.exe");
        launcherFiles = consoleLauncher.exists() ? new File[]{executableLocation, consoleLauncher} : new File[]{executableLocation};
        this.publishArtifact(artifact, launcherFiles, destination, false);
    }

    protected void generateRootIU(GeneratorResult result, String rootIUId, String rootIUVersion) {
        IInstallableUnit rootIU = null;
        if (this.info.getProductFile() != null) {
            rootIU = this.createProductIU(result);
        } else if (rootIUId != null) {
            rootIU = this.createTopLevelIU(result, rootIUId, rootIUVersion);
        }
        if (rootIU == null) {
            return;
        }
        result.nonRootIUs.add(rootIU);
        result.nonRootIUs.add(this.generateDefaultCategory(rootIU));
    }

    private void generateSiteReference(String location, String featureId, boolean isEnabled) {
        IMetadataRepository metadataRepo = this.info.getMetadataRepository();
        try {
            URL associateLocation = new URL(location);
            int flags = isEnabled ? 1 : 0;
            metadataRepo.addReference(associateLocation, 0, flags);
            metadataRepo.addReference(associateLocation, 1, flags);
        }
        catch (MalformedURLException malformedURLException) {
            String message = "Invalid site reference: " + location;
            if (featureId != null) {
                message = String.valueOf(message) + " in feature: " + featureId;
            }
            LogHelper.log((IStatus)new Status(4, Activator.ID, message));
        }
    }

    protected BundleDescription[] getBundleDescriptions(File[] bundleLocations) {
        if (bundleLocations == null) {
            return new BundleDescription[0];
        }
        boolean addSimpleConfigurator = false;
        boolean scIn = false;
        int i = 0;
        while (i < bundleLocations.length) {
            if (!addSimpleConfigurator) {
                boolean bl = addSimpleConfigurator = bundleLocations[i].toString().indexOf(ORG_ECLIPSE_UPDATE_CONFIGURATOR) > 0;
            }
            if (!scIn) {
                boolean bl = scIn = bundleLocations[i].toString().indexOf(ORG_ECLIPSE_EQUINOX_SIMPLECONFIGURATOR) > 0;
                if (scIn) break;
            }
            ++i;
        }
        if (scIn) {
            addSimpleConfigurator = false;
        }
        BundleDescription[] result = new BundleDescription[bundleLocations.length + (addSimpleConfigurator ? 1 : 0)];
        BundleDescriptionFactory factory = this.getBundleFactory();
        int i2 = 0;
        while (i2 < bundleLocations.length) {
            BundleDescription desc = factory.getBundleDescription(bundleLocations[i2]);
            if (desc != null) {
                result[i2] = desc;
            }
            ++i2;
        }
        if (addSimpleConfigurator) {
            try {
                File location = new File(FileLocator.toFileURL((URL)Activator.getContext().getBundle().getEntry("org.eclipse.equinox.simpleconfigurator.jar")).getFile());
                result[result.length - 1] = factory.getBundleDescription(location);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    protected BundleDescriptionFactory getBundleFactory() {
        return new BundleDescriptionFactory(this.stateObjectFactory, null);
    }

    private Set getCategories(Feature feature, Map featuresToCategories) {
        Iterator it = featuresToCategories.keySet().iterator();
        while (it.hasNext()) {
            SiteFeature siteFeature = (SiteFeature)it.next();
            if (!siteFeature.getFeatureIdentifier().equals(feature.getId()) || !siteFeature.getFeatureVersion().equals(feature.getVersion())) continue;
            return (Set)featuresToCategories.get(siteFeature);
        }
        return null;
    }

    protected Feature[] getFeatures(File folder) {
        if (folder == null || !folder.exists()) {
            return new Feature[0];
        }
        File[] locations = folder.listFiles();
        ArrayList<Feature> result = new ArrayList<Feature>(locations.length);
        int i = 0;
        while (i < locations.length) {
            Feature feature = new FeatureParser().parse(locations[i]);
            if (feature != null) {
                feature.setLocation(locations[i].getAbsolutePath());
                result.add(feature);
            }
            ++i;
        }
        return result.toArray(new Feature[result.size()]);
    }

    protected Map getFeatureToCategoryMappings() {
        File siteFile;
        URLEntry[] associatedSites;
        HashMap<SiteFeature, HashSet<SiteCategory>> mappings = new HashMap<SiteFeature, HashSet<SiteCategory>>();
        URL siteLocation = this.info.getSiteLocation();
        if (siteLocation == null) {
            return mappings;
        }
        SiteModel site = null;
        try {
            BufferedInputStream input = new BufferedInputStream(siteLocation.openStream());
            site = new DefaultSiteParser().parse(input);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (Exception e) {
            LogHelper.log((IStatus)new Status(4, Activator.ID, NLS.bind((String)Messages.exception_errorParsingUpdateSite, (Object)siteLocation), (Throwable)e));
        }
        if (site == null) {
            return mappings;
        }
        String mirrors = site.getMirrorsURL();
        if (mirrors != null) {
            int index = mirrors.indexOf("site.xml");
            if (index != -1) {
                mirrors = String.valueOf(mirrors.substring(0, index)) + mirrors.substring(index + "site.xml".length());
            }
            this.info.getMetadataRepository().setProperty("p2.mirrorsURL", mirrors);
            this.info.getArtifactRepository().setProperty("p2.mirrorsURL", mirrors);
        }
        if ((associatedSites = site.getAssociatedSites()) != null) {
            int i = 0;
            while (i < associatedSites.length) {
                this.generateSiteReference(associatedSites[i].getURL(), null, true);
                ++i;
            }
        }
        if (PROTOCOL_FILE.equals(siteLocation.getProtocol()) && (siteFile = new File(siteLocation.getFile())).exists()) {
            String[] keyStrings;
            File siteParent = siteFile.getParentFile();
            List messageKeys = site.getMessageKeys();
            if (siteParent.isDirectory()) {
                keyStrings = messageKeys.toArray(new String[messageKeys.size()]);
                site.setLocalizations(LocalizationHelper.getDirPropertyLocalizations(siteParent, "site", null, keyStrings));
            } else if (siteFile.getName().endsWith(".jar")) {
                keyStrings = messageKeys.toArray(new String[messageKeys.size()]);
                site.setLocalizations(LocalizationHelper.getJarPropertyLocalizations(siteParent, "site", null, keyStrings));
            }
        }
        SiteFeature[] features = site.getFeatures();
        int i = 0;
        while (i < features.length) {
            String[] categoryNames = features[i].getCategoryNames();
            int j = 0;
            while (j < categoryNames.length) {
                SiteCategory category = site.getCategory(categoryNames[j]);
                if (category != null) {
                    HashSet<SiteCategory> categories = (HashSet<SiteCategory>)mappings.get(features[i]);
                    if (categories == null) {
                        categories = new HashSet<SiteCategory>();
                        mappings.put(features[i], categories);
                    }
                    categories.add(category);
                }
                ++j;
            }
            ++i;
        }
        return mappings;
    }

    protected IGeneratorInfo getGeneratorInfo() {
        return this.info;
    }

    private void mungeLauncherFileNames(File root) {
        if (root.isDirectory()) {
            File[] children = root.listFiles();
            int i = 0;
            while (i < children.length) {
                this.mungeLauncherFileNames(children[i]);
                ++i;
            }
        } else if (root.isFile()) {
            if (root.getName().equals("launcher")) {
                root.renameTo(new File(root.getParentFile(), "eclipse"));
            } else if (root.getName().equals("launcher.exe")) {
                root.renameTo(new File(root.getParentFile(), "eclipse.exe"));
            }
        }
    }

    protected void publishArtifact(IArtifactDescriptor descriptor, File[] files, IArtifactRepository destination, boolean asIs) {
        this.publishArtifact(descriptor, files, destination, asIs, null);
    }

    protected void publishArtifact(IArtifactDescriptor descriptor, File[] files, IArtifactRepository destination, boolean asIs, File root) {
        block19: {
            if (descriptor == null || destination == null) {
                return;
            }
            if (!this.info.publishArtifacts()) {
                destination.addDescriptor(descriptor);
                return;
            }
            if (asIs && files.length == 1) {
                try {
                    if (!destination.contains(descriptor)) {
                        File descriptorFile;
                        if (destination instanceof IFileArtifactRepository && files[0].equals(descriptorFile = ((IFileArtifactRepository)destination).getArtifactFile(descriptor))) {
                            destination.addDescriptor(descriptor);
                            return;
                        }
                        BufferedOutputStream output = new BufferedOutputStream(destination.getOutputStream(descriptor));
                        FileUtils.copyStream((InputStream)new BufferedInputStream(new FileInputStream(files[0])), (boolean)true, (OutputStream)output, (boolean)true);
                    }
                }
                catch (ProvisionException e) {
                    LogHelper.log((IStatus)e.getStatus());
                }
                catch (IOException e) {
                    LogHelper.log((IStatus)new Status(4, Activator.ID, "Error publishing artifacts", (Throwable)e));
                }
            } else {
                File tempFile = null;
                try {
                    try {
                        tempFile = File.createTempFile("p2.generator", "");
                        FileUtils.IPathComputer computer = null;
                        computer = root != null ? FileUtils.createRootPathComputer((File)root) : FileUtils.createDynamicPathComputer((int)0);
                        FileUtils.zip((File[])files, null, (File)tempFile, (FileUtils.IPathComputer)computer);
                        if (!destination.contains(descriptor)) {
                            destination.setProperty("download.contentType", "application/zip");
                            BufferedOutputStream output = new BufferedOutputStream(destination.getOutputStream(descriptor));
                            FileUtils.copyStream((InputStream)new BufferedInputStream(new FileInputStream(tempFile)), (boolean)true, (OutputStream)output, (boolean)true);
                        }
                    }
                    catch (ProvisionException e) {
                        LogHelper.log((IStatus)e.getStatus());
                        if (tempFile != null) {
                            tempFile.delete();
                        }
                    }
                    catch (IOException e) {
                        LogHelper.log((IStatus)new Status(4, Activator.ID, "Error publishing artifacts", (Throwable)e));
                        if (tempFile == null) break block19;
                        tempFile.delete();
                    }
                }
                finally {
                    if (tempFile != null) {
                        tempFile.delete();
                    }
                }
            }
        }
    }

    public void setGenerateRootIU(boolean generateRootIU) {
        this.generateRootIU = generateRootIU;
    }

    public static class GeneratorResult {
        public static final String CONFIGURATION_CUS = "CONFIGURATION_CUS";
        public final Map pluginShape = new HashMap();
        public final Set rootIUs = new HashSet();
        public final Set nonRootIUs = new HashSet();
        public final Map configurationIUs = new HashMap();
        public final Map configData = new HashMap();

        public Set allGeneratedIUs() {
            HashSet all = new HashSet();
            all.addAll(this.rootIUs);
            all.addAll(this.nonRootIUs);
            return all;
        }

        public IInstallableUnit getInstallableUnit(String id) {
            IInstallableUnit tmp;
            Iterator iterator = this.rootIUs.iterator();
            while (iterator.hasNext()) {
                tmp = (IInstallableUnit)iterator.next();
                if (!tmp.getId().equals(id)) continue;
                return tmp;
            }
            iterator = this.nonRootIUs.iterator();
            while (iterator.hasNext()) {
                tmp = (IInstallableUnit)iterator.next();
                if (!tmp.getId().equals(id)) continue;
                return tmp;
            }
            return null;
        }

        public Map getPluginShapeInfo() {
            return this.pluginShape;
        }
    }
}

