/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.context.ui;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.context.core.AbstractContextListener;
import org.eclipse.mylyn.context.core.AbstractContextStructureBridge;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.context.core.IInteractionContext;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.context.ui.AbstractContextUiBridge;
import org.eclipse.mylyn.context.ui.ContextUi;
import org.eclipse.mylyn.context.ui.IContextAwareEditor;
import org.eclipse.mylyn.internal.context.ui.ContextUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.deprecated.NewTaskEditorInput;
import org.eclipse.mylyn.monitor.ui.MonitorUi;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditorInput;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.internal.EditorManager;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextEditorManager
extends AbstractContextListener {
    private static final String PREFS_PREFIX = "editors.task.";
    private static final String KEY_CONTEXT_EDITORS = "ContextOpenEditors";
    private static final String KEY_MONITORED_WINDOW_OPEN_EDITORS = "MonitoredWindowOpenEditors";
    private static final String ATTRIBUTE_CLASS = "class";
    private static final String ATTRIBUTE_NUMER = "number";
    private static final String ATTRIBUTE_IS_LAUNCHING = "isLaunching";
    private static final String ATTRIBUTE_IS_ACTIVE = "isActive";
    private boolean previousCloseEditorsSetting = Workbench.getInstance().getPreferenceStore().getBoolean("REUSE_OPEN_EDITORS_BOOLEAN");
    private final IPreferenceStore preferenceStore = new ScopedPreferenceStore((IScopeContext)new InstanceScope(), "org.eclipse.mylyn.resources.ui");

    public void contextActivated(IInteractionContext context) {
        if (!Workbench.getInstance().isStarting() && ContextUiPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.mylyn.context.ui.editors.auto.manage")) {
            Workbench workbench = (Workbench)PlatformUI.getWorkbench();
            this.previousCloseEditorsSetting = workbench.getPreferenceStore().getBoolean("REUSE_OPEN_EDITORS_BOOLEAN");
            workbench.getPreferenceStore().setValue("REUSE_OPEN_EDITORS_BOOLEAN", false);
            boolean wasPaused = ContextCore.getContextManager().isContextCapturePaused();
            try {
                try {
                    if (!wasPaused) {
                        ContextCore.getContextManager().setContextCapturePaused(true);
                    }
                    String mementoString = null;
                    IWorkbenchWindow activeWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    try {
                        mementoString = this.readEditorMemento(context);
                        if (mementoString != null && !mementoString.trim().equals("")) {
                            XMLMemento memento = XMLMemento.createReadRoot((Reader)new StringReader(mementoString));
                            IMemento[] children = memento.getChildren(KEY_MONITORED_WINDOW_OPEN_EDITORS);
                            if (children.length > 0) {
                                IMemento[] iMementoArray = children;
                                int n = children.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    IMemento child = iMementoArray[n2];
                                    WorkbenchPage page = this.getWorkbenchPageForMemento(child, activeWindow);
                                    if (child != null && page != null) {
                                        this.restoreEditors(page, child, page.getWorkbenchWindow() == activeWindow);
                                    }
                                    ++n2;
                                }
                            } else {
                                WorkbenchPage page = (WorkbenchPage)activeWindow.getActivePage();
                                if (memento != null) {
                                    this.restoreEditors(page, (IMemento)memento, true);
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.context.ui", "Could not restore all editors, memento: \"" + mementoString + "\"", (Throwable)e));
                    }
                    activeWindow.setActivePage(activeWindow.getActivePage());
                    IInteractionElement activeNode = context.getActiveNode();
                    if (activeNode != null) {
                        ContextUi.getUiBridge(activeNode.getContentType()).open(activeNode);
                    }
                }
                catch (Exception e) {
                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.context.ui", "Failed to open editors on activation", (Throwable)e));
                    ContextCore.getContextManager().setContextCapturePaused(false);
                }
            }
            finally {
                ContextCore.getContextManager().setContextCapturePaused(false);
            }
        }
    }

    private WorkbenchPage getWorkbenchPageForMemento(IMemento memento, IWorkbenchWindow activeWindow) {
        Integer windowToRestorenumber;
        String windowToRestoreClassName = memento.getString(ATTRIBUTE_CLASS);
        if (windowToRestoreClassName == null) {
            windowToRestoreClassName = "";
        }
        if ((windowToRestorenumber = memento.getInteger(ATTRIBUTE_NUMER)) == null) {
            windowToRestorenumber = 0;
        }
        Set monitoredWindows = MonitorUi.getMonitoredWindows();
        for (IWorkbenchWindow window : monitoredWindows) {
            int windowNumber = 0;
            if (window instanceof WorkbenchWindow) {
                windowNumber = ((WorkbenchWindow)window).getNumber();
            }
            if (!window.getClass().getCanonicalName().equals(windowToRestoreClassName) || windowNumber != windowToRestorenumber) continue;
            return (WorkbenchPage)window.getActivePage();
        }
        Boolean isActive = Boolean.valueOf(memento.getString(ATTRIBUTE_IS_ACTIVE));
        if (isActive == null) {
            isActive = false;
        }
        boolean shouldRestoreUnknownWindowToActive = true;
        boolean shouldRestoreActiveWindowToActive = true;
        if (isActive.booleanValue() && shouldRestoreActiveWindowToActive) {
            return (WorkbenchPage)activeWindow.getActivePage();
        }
        if (shouldRestoreUnknownWindowToActive) {
            return (WorkbenchPage)activeWindow.getActivePage();
        }
        if (shouldRestoreActiveWindowToActive && shouldRestoreUnknownWindowToActive) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.context.ui", "Unable to find window to restore memento to.", (Throwable)new Exception()));
        }
        return null;
    }

    private String readEditorMemento(IInteractionContext context) {
        return this.preferenceStore.getString(PREFS_PREFIX + context.getHandleIdentifier());
    }

    public void contextDeactivated(IInteractionContext context) {
        if (!PlatformUI.getWorkbench().isClosing() && ContextUiPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.mylyn.context.ui.editors.auto.manage")) {
            this.closeAllButActiveTaskEditor(context.getHandleIdentifier());
            XMLMemento rootMemento = XMLMemento.createWriteRoot((String)KEY_CONTEXT_EDITORS);
            IWorkbenchWindow activeWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            IWorkbenchWindow launchingWindow = MonitorUi.getLaunchingWorkbenchWindow();
            Set monitoredWindows = MonitorUi.getMonitoredWindows();
            for (IWorkbenchWindow window : monitoredWindows) {
                IMemento memento = rootMemento.createChild(KEY_MONITORED_WINDOW_OPEN_EDITORS);
                memento.putString(ATTRIBUTE_CLASS, window.getClass().getCanonicalName());
                int number = 0;
                if (window instanceof WorkbenchWindow) {
                    number = ((WorkbenchWindow)window).getNumber();
                }
                memento.putInteger(ATTRIBUTE_NUMER, number);
                memento.putString(ATTRIBUTE_IS_LAUNCHING, window == launchingWindow ? "true" : "false");
                memento.putString(ATTRIBUTE_IS_ACTIVE, window == activeWindow ? "true" : "false");
                ((WorkbenchPage)window.getActivePage()).getEditorManager().saveState(memento);
            }
            StringWriter writer = new StringWriter();
            try {
                rootMemento.save((Writer)writer);
                this.writeEditorMemento(context, writer.getBuffer().toString());
            }
            catch (IOException e) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.context.ui", "Could not store editor state", (Throwable)e));
            }
            Workbench.getInstance().getPreferenceStore().setValue("REUSE_OPEN_EDITORS_BOOLEAN", this.previousCloseEditorsSetting);
            this.closeAllEditors();
        }
    }

    public void writeEditorMemento(IInteractionContext context, String memento) {
        this.preferenceStore.setValue(PREFS_PREFIX + context.getHandleIdentifier(), memento);
    }

    public void contextCleared(IInteractionContext context) {
        if (context == null) {
            return;
        }
        this.closeAllButActiveTaskEditor(context.getHandleIdentifier());
        XMLMemento memento = XMLMemento.createWriteRoot((String)KEY_CONTEXT_EDITORS);
        StringWriter writer = new StringWriter();
        try {
            memento.save((Writer)writer);
            this.writeEditorMemento(context, writer.getBuffer().toString());
        }
        catch (IOException e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.context.ui", "Could not store editor state", (Throwable)e));
        }
        Workbench.getInstance().getPreferenceStore().setValue("REUSE_OPEN_EDITORS_BOOLEAN", this.previousCloseEditorsSetting);
        this.closeAllEditors();
    }

    private void restoreEditors(WorkbenchPage page, IMemento memento, boolean isActiveWindow) {
        EditorManager editorManager = page.getEditorManager();
        ArrayList visibleEditors = new ArrayList(5);
        IEditorReference[] activeEditor = new IEditorReference[1];
        MultiStatus result = new MultiStatus("org.eclipse.ui", 0, WorkbenchMessages.EditorManager_problemsRestoringEditors, null);
        try {
            IWorkbenchPart editor;
            IMemento[] editorMementos = memento.getChildren("editor");
            HashSet editorMementoSet = new HashSet();
            editorMementoSet.addAll(Arrays.asList(editorMementos));
            HashSet<String> restoredPartNames = new HashSet<String>();
            List<IEditorReference> alreadyVisibleEditors = Arrays.asList(editorManager.getEditors());
            for (IEditorReference editorReference : alreadyVisibleEditors) {
                restoredPartNames.add(editorReference.getPartName());
            }
            for (IMemento editorMemento : editorMementoSet) {
                String partName = editorMemento.getString("partName");
                if (!restoredPartNames.contains(partName)) {
                    editorManager.restoreEditorState(editorMemento, visibleEditors, activeEditor, result);
                    continue;
                }
                restoredPartNames.add(partName);
            }
            int i = 0;
            while (i < visibleEditors.size()) {
                editorManager.setVisibleEditor((IEditorReference)visibleEditors.get(i), false);
                ++i;
            }
            if (activeEditor[0] != null && isActiveWindow && (editor = activeEditor[0].getPart(true)) != null) {
                page.activate(editor);
            }
        }
        catch (Exception e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.context.ui", "Could not restore editors", (Throwable)e));
        }
    }

    public void closeAllButActiveTaskEditor(String taskHandle) {
        try {
            if (PlatformUI.getWorkbench().isClosing()) {
                return;
            }
            for (IWorkbenchWindow window : MonitorUi.getMonitoredWindows()) {
                IWorkbenchPage page = window.getActivePage();
                if (page == null) continue;
                IEditorReference[] references = page.getEditorReferences();
                ArrayList<IEditorReference> toClose = new ArrayList<IEditorReference>();
                IEditorReference[] iEditorReferenceArray = references;
                int n = references.length;
                int n2 = 0;
                while (n2 < n) {
                    IEditorReference reference = iEditorReferenceArray[n2];
                    if (this.canClose(reference)) {
                        try {
                            ITask task;
                            IEditorInput input = reference.getEditorInput();
                            if (input instanceof TaskEditorInput && ((task = ((TaskEditorInput)input).getTask()) == null || !task.getHandleIdentifier().equals(taskHandle))) {
                                toClose.add(reference);
                            }
                        }
                        catch (PartInitException partInitException) {}
                    }
                    ++n2;
                }
                page.closeEditors(toClose.toArray(new IEditorReference[toClose.size()]), true);
            }
        }
        catch (Throwable t) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.context.ui", "Could not auto close editor", t));
        }
    }

    public void closeAllEditors() {
        try {
            if (PlatformUI.getWorkbench().isClosing()) {
                return;
            }
            for (IWorkbenchWindow window : MonitorUi.getMonitoredWindows()) {
                IWorkbenchPage page = window.getActivePage();
                if (page == null) continue;
                IEditorReference[] references = page.getEditorReferences();
                ArrayList<IEditorReference> toClose = new ArrayList<IEditorReference>();
                int i = 0;
                while (i < references.length) {
                    if (this.canClose(references[i]) && !this.isUnsubmittedTaskEditor(references[i])) {
                        toClose.add(references[i]);
                    }
                    ++i;
                }
                page.closeEditors(toClose.toArray(new IEditorReference[toClose.size()]), true);
            }
        }
        catch (Throwable t) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.context.ui", "Could not auto close editor", t));
        }
    }

    private boolean canClose(IEditorReference editorReference) {
        IEditorPart editor = editorReference.getEditor(false);
        if (editor instanceof IContextAwareEditor) {
            return ((IContextAwareEditor)editor).canClose();
        }
        return true;
    }

    private boolean isUnsubmittedTaskEditor(IEditorReference editorReference) {
        try {
            IEditorInput input = editorReference.getEditorInput();
            if (input instanceof NewTaskEditorInput) {
                return true;
            }
        }
        catch (PartInitException partInitException) {}
        return false;
    }

    public void interestChanged(List<IInteractionElement> elements) {
        for (IInteractionElement element : elements) {
            this.closeEditor(element, false);
        }
    }

    public void elementsDeleted(List<IInteractionElement> elements) {
        for (IInteractionElement element : elements) {
            this.closeEditor(element, true);
        }
    }

    private void closeEditor(IInteractionElement element, boolean force) {
        AbstractContextStructureBridge bridge;
        if (ContextUiPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.mylyn.context.ui.editors.auto.manage") && (force || !element.getInterest().isInteresting()) && (bridge = ContextCore.getStructureBridge((String)element.getContentType())).isDocument(element.getHandleIdentifier())) {
            AbstractContextUiBridge uiBridge = ContextUi.getUiBridge(element.getContentType());
            uiBridge.close(element);
        }
    }
}

