/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.context.ui.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.internal.context.ui.wizards.ContextAttachWizard;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.deprecated.AbstractAttachmentHandler;
import org.eclipse.mylyn.internal.tasks.core.deprecated.AbstractLegacyRepositoryConnector;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListView;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.TasksUiImages;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;

@Deprecated
public class ContextAttachAction
extends Action
implements IViewActionDelegate {
    private ITask task;
    private TaskRepository repository;
    private AbstractRepositoryConnector connector;
    private static final String ID_ACTION = "org.eclipse.mylyn.context.ui.repository.task.attach";

    public ContextAttachAction() {
        this.setText("Attach...");
        this.setToolTipText("Attach Task Context");
        this.setId(ID_ACTION);
        this.setImageDescriptor(TasksUiImages.CONTEXT_ATTACH);
    }

    public void init(IViewPart view) {
    }

    public void run() {
        this.run((IAction)this);
    }

    public void run(IAction action) {
        if (this.task == null) {
            return;
        }
        this.run(this.task);
    }

    public void run(ITask task) {
        if (task.getSynchronizationState() != ITask.SynchronizationState.SYNCHRONIZED) {
            MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Context Attachment", (String)"Task must be synchronized before attaching context");
            return;
        }
        ContextAttachWizard wizard = new ContextAttachWizard(task);
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        if (shell != null && !shell.isDisposed()) {
            WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
            dialog.create();
            dialog.setTitle("Attach Context");
            dialog.setBlockOnOpen(true);
            if (dialog.open() == 1) {
                dialog.close();
                return;
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        AbstractTask selectedTask = TaskListView.getSelectedTask((ISelection)selection);
        if (selectedTask != null) {
            this.task = selectedTask;
            this.repository = TasksUi.getRepositoryManager().getRepository(this.task.getConnectorKind(), this.task.getRepositoryUrl());
            this.connector = TasksUi.getRepositoryManager().getRepositoryConnector(this.task.getConnectorKind());
            if (this.connector instanceof AbstractLegacyRepositoryConnector) {
                AbstractAttachmentHandler handler = ((AbstractLegacyRepositoryConnector)this.connector).getAttachmentHandler();
                action.setEnabled(handler != null && handler.canUploadAttachment(this.repository, this.task) && (this.task.isActive() || ContextCore.getContextManager().hasContext(this.task.getHandleIdentifier())));
            }
        } else {
            this.task = null;
            action.setEnabled(false);
        }
    }
}

