/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.context.ui.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.context.core.IInteractionContext;
import org.eclipse.mylyn.internal.context.ui.actions.TaskContextAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.TaskSelectionDialog;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.TasksUiImages;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;

@Deprecated
public class ContextCopyAction
extends TaskContextAction {
    private static final String TITLE_DIALOG = "Copy Context";
    private static final String ID_ACTION = "org.eclipse.mylyn.context.ui.task.copy.context.to";

    public ContextCopyAction() {
        this.setText("Copy to...");
        this.setToolTipText("Copy Task Context to...");
        this.setId(ID_ACTION);
        this.setImageDescriptor(TasksUiImages.CONTEXT_TRANSFER);
    }

    public void init(IViewPart view) {
    }

    public void run() {
        this.run(this.getSelectedTask(this.selection));
    }

    public void run(IAction action) {
        this.run(this.getSelectedTask(this.selection));
    }

    public void run(ITask sourceTask) {
        if (sourceTask == null) {
            MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)TITLE_DIALOG, (String)"No source task selected.");
            return;
        }
        TaskSelectionDialog dialog = new TaskSelectionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        dialog.setNeedsCreateTask(false);
        dialog.setTitle("Select Target Task");
        dialog.setMessage("&Select the target task (? = any character, * = any String):");
        if (dialog.open() != 0) {
            return;
        }
        Object result = dialog.getFirstResult();
        if (result instanceof ITask) {
            ITask targetTask = (ITask)result;
            TasksUi.getTaskActivityManager().deactivateActiveTask();
            if (targetTask.equals(sourceTask)) {
                MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)TITLE_DIALOG, (String)"Target task can not be the same as source task.");
            } else {
                IInteractionContext context = ContextCore.getContextStore().cloneContext(sourceTask.getHandleIdentifier(), targetTask.getHandleIdentifier());
                if (context == null) {
                    MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)TITLE_DIALOG, (String)"Source task does not have a context.");
                } else {
                    TasksUi.getTaskActivityManager().activateTask(targetTask);
                }
            }
        } else {
            MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)TITLE_DIALOG, (String)"No target task selected.");
        }
    }
}

