/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.context.ui.views;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mylyn.context.core.AbstractContextStructureBridge;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.context.core.IInteractionRelation;
import org.eclipse.mylyn.internal.context.core.InteractionContextRelation;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IViewSite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextContentProvider
implements IStructuredContentProvider,
ITreeContentProvider {
    private IViewSite site = null;
    private Tree tree;
    private Shell shell = null;
    private final boolean landmarkOnlyMode;

    public ContextContentProvider(Tree tree, IViewSite site, boolean landmarkOnlyMode) {
        this.tree = tree;
        this.site = site;
        this.landmarkOnlyMode = landmarkOnlyMode;
    }

    public ContextContentProvider(Shell shell, boolean landmarkOnlyMode) {
        this.shell = shell;
        this.landmarkOnlyMode = landmarkOnlyMode;
    }

    public ContextContentProvider(Tree tree, Shell shell, boolean landmarkOnlyMode) {
        this.shell = shell;
        this.tree = tree;
        this.landmarkOnlyMode = landmarkOnlyMode;
    }

    public void inputChanged(Viewer v, Object oldInput, Object newInput) {
    }

    public void dispose() {
    }

    public Object[] getElements(Object parent) {
        if (this.matchesParent(parent)) {
            ArrayList<IInteractionElement> nodes;
            if (this.landmarkOnlyMode) {
                Set landmarks = ContextCore.getContextManager().getActiveLandmarks();
                nodes = new ArrayList<IInteractionElement>();
                for (IInteractionElement node : landmarks) {
                    if (node.getContentType().equals("resource") || node.getInterest().isPredicted()) continue;
                    nodes.add(node);
                }
            } else {
                nodes = ContextCore.getContextManager().getActiveContext().getAllElements();
            }
            ArrayList<Object> resolvedNodes = new ArrayList<Object>();
            for (IInteractionElement node : nodes) {
                AbstractContextStructureBridge bridge = ContextCore.getStructureBridge((String)node.getContentType());
                Object object = bridge.getObjectForHandle(node.getHandleIdentifier());
                if (object == null) continue;
                resolvedNodes.add(object);
            }
            return resolvedNodes.toArray();
        }
        return this.getChildren(parent);
    }

    private boolean matchesParent(Object parent) {
        if (this.site != null && parent.equals(this.site)) {
            return true;
        }
        return this.shell != null && parent.equals(this.shell);
    }

    public Object getParent(Object child) {
        return null;
    }

    public Object[] getChildren(Object parent) {
        IInteractionElement node;
        if (parent == null) {
            return new Object[0];
        }
        if (parent instanceof InteractionContextRelation) {
            IInteractionRelation edge = (IInteractionRelation)parent;
            IInteractionElement source = ContextCore.getContextManager().getElement(((IInteractionRelation)parent).getSource().getHandleIdentifier());
            return this.getAllTagetsForSource(source, edge.getRelationshipHandle());
        }
        if (parent instanceof IInteractionElement) {
            node = (IInteractionElement)parent;
        } else {
            AbstractContextStructureBridge bridge = ContextCore.getStructureBridge((Object)parent);
            node = ContextCore.getContextManager().getElement(bridge.getHandleIdentifier(parent));
        }
        if (node != null) {
            return this.getAllEdgeTypes(node.getRelations());
        }
        return new Object[0];
    }

    private boolean isRootItem(Object object) {
        TreeItem[] items;
        boolean isRootItem = false;
        TreeItem[] treeItemArray = items = this.tree.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            if (object.equals(item.getData())) {
                isRootItem = true;
            }
            ++n2;
        }
        return isRootItem;
    }

    private Object[] getAllTagetsForSource(IInteractionElement source, String kind) {
        Collection edges = source.getRelations();
        ArrayList<Object> targets = new ArrayList<Object>();
        for (InteractionContextRelation edge : edges) {
            IInteractionElement target;
            AbstractContextStructureBridge bridge;
            Object object;
            if (!edge.getRelationshipHandle().equals(kind) || (object = (bridge = ContextCore.getStructureBridge((String)(target = edge.getTarget()).getContentType())).getObjectForHandle(target.getHandleIdentifier())) == null) continue;
            targets.add(object);
        }
        return targets.toArray();
    }

    private Object[] getAllEdgeTypes(Collection<InteractionContextRelation> edges) {
        HashMap<String, IInteractionRelation> map = new HashMap<String, IInteractionRelation>();
        for (IInteractionRelation iInteractionRelation : edges) {
            IInteractionRelation edgeType = (IInteractionRelation)map.get(iInteractionRelation.getRelationshipHandle());
            if (edgeType != null) continue;
            edgeType = iInteractionRelation;
            map.put(iInteractionRelation.getRelationshipHandle(), edgeType);
        }
        Object[] objectArray = new Object[map.size()];
        int index = 0;
        for (IInteractionRelation value : map.values()) {
            objectArray[index] = value;
            ++index;
        }
        return objectArray;
    }

    public boolean hasChildren(Object parent) {
        if (parent instanceof IInteractionRelation) {
            return true;
        }
        return this.isRootItem(parent);
    }
}

