/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.launchConfigurations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.LaunchConfigurationTabExtension;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationPresentationManager;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.debug.ui.ILaunchConfigurationTabGroup;

public class LaunchConfigurationTabGroupWrapper
implements ILaunchConfigurationTabGroup {
    private ILaunchConfigurationTabGroup fGroup = null;
    private String fGroupId = null;
    private List fTabs = null;
    private String fMode = null;
    private ILaunchConfiguration fConfig = null;

    public LaunchConfigurationTabGroupWrapper(ILaunchConfigurationTabGroup group, String groupId, ILaunchConfiguration config) {
        this.fGroup = group;
        this.fGroupId = groupId;
        this.fConfig = config;
    }

    public void createTabs(ILaunchConfigurationDialog dialog, String mode) {
        if (this.fGroup != null) {
            this.fGroup.createTabs(dialog, mode);
            this.fMode = mode;
        }
    }

    public void dispose() {
        this.fGroup.dispose();
        if (this.fTabs != null) {
            List<ILaunchConfigurationTab> tabs = Arrays.asList(this.fGroup.getTabs());
            ILaunchConfigurationTab tab = null;
            int i = 0;
            while (i < this.fTabs.size()) {
                tab = (ILaunchConfigurationTab)this.fTabs.get(i);
                if (!tabs.contains(tab)) {
                    tab.dispose();
                }
                ++i;
            }
            this.fTabs.clear();
        }
    }

    public ILaunchConfigurationTab[] getTabs() {
        if (this.fTabs == null) {
            try {
                this.fTabs = new ArrayList();
                LaunchConfigurationTabExtension[] ext = LaunchConfigurationPresentationManager.getDefault().getTabExtensions(this.fGroupId, this.fConfig, this.fMode);
                if (ext.length > 0) {
                    TabCollector collector = new TabCollector(Arrays.asList(this.fGroup.getTabs()), Arrays.asList(ext));
                    while (collector.hasNext()) {
                        this.fTabs.add(collector.next());
                    }
                } else {
                    ILaunchConfigurationTab[] tabs = this.fGroup.getTabs();
                    int i = 0;
                    while (i < tabs.length) {
                        this.fTabs.add(tabs[i]);
                        ++i;
                    }
                }
            }
            catch (CoreException ce) {
                DebugUIPlugin.log(ce);
            }
        }
        return this.fTabs.toArray(new ILaunchConfigurationTab[this.fTabs.size()]);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.fGroup.initializeFrom(configuration);
        if (this.fTabs != null) {
            List<ILaunchConfigurationTab> tabs = Arrays.asList(this.fGroup.getTabs());
            ILaunchConfigurationTab tab = null;
            int i = 0;
            while (i < this.fTabs.size()) {
                tab = (ILaunchConfigurationTab)this.fTabs.get(i);
                if (!tabs.contains(tab)) {
                    tab.initializeFrom(configuration);
                }
                ++i;
            }
        }
    }

    public void launched(ILaunch launch) {
        if (this.fGroup != null) {
            this.fGroup.launched(launch);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        this.fGroup.performApply(configuration);
        if (this.fTabs != null) {
            List<ILaunchConfigurationTab> tabs = Arrays.asList(this.fGroup.getTabs());
            ILaunchConfigurationTab tab = null;
            int i = 0;
            while (i < this.fTabs.size()) {
                tab = (ILaunchConfigurationTab)this.fTabs.get(i);
                if (!tabs.contains(tab)) {
                    tab.performApply(configuration);
                }
                ++i;
            }
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        this.fGroup.setDefaults(configuration);
        if (this.fTabs != null) {
            List<ILaunchConfigurationTab> tabs = Arrays.asList(this.fGroup.getTabs());
            ILaunchConfigurationTab tab = null;
            int i = 0;
            while (i < this.fTabs.size()) {
                tab = (ILaunchConfigurationTab)this.fTabs.get(i);
                if (!tabs.contains(tab)) {
                    tab.setDefaults(configuration);
                }
                ++i;
            }
        }
    }

    class TabCollector
    implements Iterator {
        private HashSet idSet = null;
        private ArrayList tabList = null;
        private ArrayList extList = null;

        public TabCollector(List tabs, List exts) {
            this.tabList = new ArrayList(tabs);
            this.extList = new ArrayList(exts);
            this.idSet = new HashSet(this.tabList.size() + this.extList.size());
        }

        private ILaunchConfigurationTab nextExtensionTab() {
            Iterator iterator = this.extList.iterator();
            while (iterator.hasNext()) {
                LaunchConfigurationTabExtension launchConfigurationTabExtension = (LaunchConfigurationTabExtension)iterator.next();
                String relativeTab = launchConfigurationTabExtension.getRelativeTabId();
                if (!this.idSet.contains(relativeTab)) continue;
                iterator.remove();
                return launchConfigurationTabExtension.getTab();
            }
            return null;
        }

        public boolean hasNext() {
            return this.extList.size() > 0 || this.tabList.size() > 0;
        }

        public Object next() {
            String id;
            ILaunchConfigurationTab nextTab = this.nextExtensionTab();
            if (nextTab == null) {
                if (this.tabList.size() > 0) {
                    nextTab = (ILaunchConfigurationTab)this.tabList.remove(0);
                } else {
                    LaunchConfigurationTabExtension launchConfigurationTabExtension = (LaunchConfigurationTabExtension)this.extList.remove(0);
                    nextTab = launchConfigurationTabExtension.getTab();
                }
            }
            if (nextTab instanceof AbstractLaunchConfigurationTab && (id = ((AbstractLaunchConfigurationTab)nextTab).getId()) != null) {
                this.idSet.add(id);
            }
            return nextTab;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

