/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.ui.actions;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.internal.ui.importexport.breakpoints.ImportExportMessages;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.XMLMemento;

public class ExportBreakpointsOperation
implements IRunnableWithProgress {
    private IBreakpoint[] fBreakpoints = null;
    private String fFileName = null;
    private StringWriter fWriter = null;

    public ExportBreakpointsOperation(IBreakpoint[] breakpoints, String fileName) {
        this.fBreakpoints = breakpoints;
        this.fFileName = fileName;
    }

    public ExportBreakpointsOperation(IBreakpoint[] breakpoints) {
        this.fBreakpoints = breakpoints;
        this.fWriter = new StringWriter();
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException {
        XMLMemento memento = XMLMemento.createWriteRoot((String)"breakpoints");
        monitor.beginTask(ImportExportMessages.ExportOperation_0, this.fBreakpoints.length);
        try {
            int i = 0;
            while (i < this.fBreakpoints.length) {
                IBreakpoint breakpoint = this.fBreakpoints[i];
                IMarker marker = breakpoint.getMarker();
                IMemento root = memento.createChild("breakpoint");
                root.putString("enabled", Boolean.toString(breakpoint.isEnabled()));
                root.putString("registered", Boolean.toString(breakpoint.isRegistered()));
                root.putString("persistant", Boolean.toString(breakpoint.isPersisted()));
                IResource resource = marker.getResource();
                IMemento child = root.createChild("resource");
                child.putString("path", resource.getFullPath().toPortableString());
                child.putInteger("type", resource.getType());
                root = root.createChild("marker");
                root.putString("type", marker.getType());
                Object val = marker.getAttribute("lineNumber");
                root.putString("lineNumber", val != null ? val.toString() : null);
                val = marker.getAttribute("charStart");
                root.putString("charStart", val != null ? val.toString() : null);
                Iterator iter = marker.getAttributes().keySet().iterator();
                while (iter.hasNext()) {
                    String iterval = iter.next().toString();
                    if (iterval.equals("lineNumber")) continue;
                    child = root.createChild("attrib");
                    child.putString("name", iterval);
                    child.putString("value", marker.getAttribute(iterval).toString());
                }
                ++i;
            }
            Writer writer = this.fWriter;
            if (writer == null) {
                writer = new OutputStreamWriter((OutputStream)new FileOutputStream(this.fFileName), "UTF-8");
            }
            memento.save(writer);
            ((Writer)writer).close();
        }
        catch (CoreException e) {
            throw new InvocationTargetException(e);
        }
        catch (IOException e) {
            throw new InvocationTargetException(e);
        }
    }

    public StringBuffer getBuffer() {
        if (this.fWriter != null) {
            return this.fWriter.getBuffer();
        }
        return null;
    }
}

