/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ui.Policy;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.synchronize.SynchronizePageConfiguration;
import org.eclipse.team.internal.ui.synchronize.SynchronizeViewWorkbenchPart;
import org.eclipse.team.internal.ui.synchronize.WorkbenchPartSynchronizePageSite;
import org.eclipse.team.internal.ui.synchronize.actions.PinParticipantAction;
import org.eclipse.team.internal.ui.synchronize.actions.RemoveSynchronizeParticipantAction;
import org.eclipse.team.internal.ui.synchronize.actions.SynchronizePageDropDownAction;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.team.ui.synchronize.ISynchronizeManager;
import org.eclipse.team.ui.synchronize.ISynchronizePage;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipantListener;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipantReference;
import org.eclipse.team.ui.synchronize.ISynchronizeView;
import org.eclipse.team.ui.synchronize.ModelSynchronizeParticipant;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.ISaveablesLifecycleListener;
import org.eclipse.ui.ISaveablesSource;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.Saveable;
import org.eclipse.ui.SaveablesLifecycleEvent;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.MessagePage;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.PageBookView;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;

public class SynchronizeView
extends PageBookView
implements ISynchronizeView,
ISynchronizeParticipantListener,
IPropertyChangeListener,
ISaveablesSource,
ISaveablePart {
    public static final int MAX_NAME_LENGTH = 100;
    private ISynchronizeParticipant activeParticipantRef = null;
    private Map fParticipantToPart = new HashMap();
    private Map fPartToParticipant = new HashMap();
    private SynchronizePageDropDownAction fPageDropDown;
    private PinParticipantAction fPinAction;
    private RemoveSynchronizeParticipantAction fRemoveCurrentAction;
    private RemoveSynchronizeParticipantAction fRemoveAllAction;
    private static final String KEY_LAST_ACTIVE_PARTICIPANT_ID = "lastactiveparticipant_id";
    private static final String KEY_LAST_ACTIVE_PARTICIPANT_SECONDARY_ID = "lastactiveparticipant_sec_id";
    private static final String KEY_SETTINGS_SECTION = "SynchronizeViewSettings";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public void propertyChange(PropertyChangeEvent event) {
        Object source = event.getSource();
        if (source instanceof ISynchronizeParticipant) {
            if (event.getProperty().equals("org.eclipse.jface.text")) {
                if (source.equals(this.getParticipant())) {
                    this.updateTitle();
                }
            } else if (event.getProperty().equals("org.eclipse.team.ui.DIRTY")) {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        SynchronizeView.this.firePropertyChange(257);
                    }
                });
            } else if (event.getProperty().equals("org.eclipse.team.ui.ACTIVE_SAVEABLE")) {
                ISaveablesLifecycleListener listener;
                Saveable oldSaveable = (Saveable)event.getOldValue();
                Saveable newSaveable = (Saveable)event.getNewValue();
                IWorkbenchWindow iWorkbenchWindow = this.getSite().getPage().getWorkbenchWindow();
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.ui.ISaveablesLifecycleListener");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((listener = (ISaveablesLifecycleListener)iWorkbenchWindow.getService((Class)clazz)) != null && oldSaveable != null) {
                    listener.handleLifecycleEvent(new SaveablesLifecycleEvent((Object)this, 3, new Saveable[]{oldSaveable}, false));
                }
                if (listener != null && newSaveable != null) {
                    listener.handleLifecycleEvent(new SaveablesLifecycleEvent((Object)this, 1, new Saveable[]{newSaveable}, false));
                }
            } else if (event.getProperty().equals("org.eclipse.team.ui.content")) {
                IWorkbenchSiteProgressService ps;
                IWorkbenchPartSite iWorkbenchPartSite = this.getSite();
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.eclipse.ui.progress.IWorkbenchSiteProgressService");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((ps = (IWorkbenchSiteProgressService)iWorkbenchPartSite.getAdapter((Class)clazz)) != null) {
                    Display.getDefault().asyncExec(new Runnable(){

                        public void run() {
                            ps.warnOfContentChange();
                        }
                    });
                }
            }
        }
        if (source instanceof ISynchronizePageConfiguration) {
            ISynchronizePageConfiguration configuration = (ISynchronizePageConfiguration)source;
            if (event.getProperty().equals("org.eclipse.team.ui.P_PAGE_DESCRIPTION")) {
                if (configuration.getParticipant().equals(this.getParticipant())) {
                    this.updateTitle();
                }
            } else if (event.getProperty().equals("org.eclipse.team.ui.P_SYNCVIEWPAGE_MODE") && configuration.getParticipant().equals(this.getParticipant())) {
                this.updateTitle();
            }
        }
    }

    public void partClosed(IWorkbenchPart part) {
        super.partClosed(part);
    }

    public ISynchronizeParticipant getParticipant() {
        return this.activeParticipantRef;
    }

    protected void showPageRec(PageBookView.PageRec pageRec) {
        super.showPageRec(pageRec);
        this.activeParticipantRef = (ISynchronizeParticipant)this.fPartToParticipant.get(pageRec.part);
        this.updateActionEnablements();
        this.updateTitle();
    }

    protected void updateTitle() {
        ISynchronizeParticipant participant = this.getParticipant();
        if (participant == null) {
            this.setContentDescription("");
        } else {
            SynchronizeViewWorkbenchPart part = (SynchronizeViewWorkbenchPart)this.fParticipantToPart.get(participant);
            ISynchronizePageConfiguration configuration = part.getConfiguration();
            String description = (String)configuration.getProperty("org.eclipse.team.ui.P_PAGE_DESCRIPTION");
            if (description == null) {
                description = part.getParticipant().getName();
            }
            this.setContentDescription(Utils.shortenText(100, description));
            this.setStatusLineMessage(description, configuration.getMode());
        }
    }

    protected void doDestroyPage(IWorkbenchPart part, PageBookView.PageRec pageRecord) {
        IPage page = pageRecord.page;
        page.dispose();
        pageRecord.dispose();
        SynchronizeViewWorkbenchPart syncPart = (SynchronizeViewWorkbenchPart)part;
        ISynchronizeParticipant participant = syncPart.getParticipant();
        this.clearCrossReferenceCache(part, participant);
    }

    private void clearCrossReferenceCache(IWorkbenchPart part, ISynchronizeParticipant participant) {
        participant.removePropertyChangeListener(this);
        if (part == null) {
            return;
        }
        ISynchronizePageConfiguration configuration = ((SynchronizeViewWorkbenchPart)part).getConfiguration();
        if (configuration != null) {
            configuration.removePropertyChangeListener(this);
        }
        this.fPartToParticipant.remove(part);
        this.fParticipantToPart.remove(participant);
    }

    protected PageBookView.PageRec doCreatePage(IWorkbenchPart dummyPart) {
        SynchronizeViewWorkbenchPart part = (SynchronizeViewWorkbenchPart)dummyPart;
        ISynchronizeParticipant participant = part.getParticipant();
        participant.addPropertyChangeListener(this);
        ISynchronizePageConfiguration configuration = participant.createPageConfiguration();
        part.setConfiguration(configuration);
        configuration.addPropertyChangeListener(this);
        IPageBookViewPage page = participant.createPage(configuration);
        if (page != null) {
            this.initPage(page);
            this.initPage(configuration, page);
            page.createControl((Composite)this.getPageBook());
            PageBookView.PageRec rec = new PageBookView.PageRec(dummyPart, (IPage)page);
            return rec;
        }
        return null;
    }

    protected void initPage(ISynchronizePageConfiguration configuration, IPageBookViewPage page) {
        ((SynchronizePageConfiguration)configuration).setSite(new WorkbenchPartSynchronizePageSite((IWorkbenchPart)this, page.getSite(), this.getDialogSettings(configuration.getParticipant())));
        if (page instanceof ISynchronizePage) {
            try {
                ((ISynchronizePage)page).init(configuration.getSite());
            }
            catch (PartInitException e) {
                TeamUIPlugin.log(4, e.getMessage(), e);
            }
        }
        page.getSite().getActionBars().setGlobalActionHandler(ActionFactory.REFRESH.getId(), (IAction)this.fPageDropDown);
        page.getSite().getActionBars().updateActionBars();
    }

    protected boolean isImportant(IWorkbenchPart part) {
        return part instanceof SynchronizeViewWorkbenchPart;
    }

    public void dispose() {
        super.dispose();
        TeamUI.getSynchronizeManager().removeSynchronizeParticipantListener(this);
        this.fPinAction.dispose();
        if (this.activeParticipantRef != null) {
            this.rememberCurrentParticipant();
        }
        this.fParticipantToPart = null;
        this.fPartToParticipant = null;
    }

    private void rememberCurrentParticipant() {
        IDialogSettings section = this.getDialogSettings();
        section.put(KEY_LAST_ACTIVE_PARTICIPANT_ID, this.activeParticipantRef.getId());
        section.put(KEY_LAST_ACTIVE_PARTICIPANT_SECONDARY_ID, this.activeParticipantRef.getSecondaryId());
    }

    protected IPage createDefaultPage(PageBook book) {
        MessagePage page = new MessagePage();
        page.createControl((Composite)this.getPageBook());
        this.initPage((IPageBookViewPage)page);
        return page;
    }

    public void participantsAdded(ISynchronizeParticipant[] participants) {
        int i = 0;
        while (i < participants.length) {
            ISynchronizeParticipant participant = participants[i];
            if (this.isAvailable() && this.select(TeamUI.getSynchronizeManager().get(participant.getId(), participant.getSecondaryId()))) {
                SynchronizeViewWorkbenchPart part = new SynchronizeViewWorkbenchPart(participant, this.getSite());
                this.fParticipantToPart.put(participant, part);
                this.fPartToParticipant.put(part, participant);
            }
            ++i;
        }
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                SynchronizeView.this.firePropertyChange(257);
            }
        });
    }

    public void participantsRemoved(final ISynchronizeParticipant[] participants) {
        if (this.isAvailable()) {
            Runnable r = new Runnable(){

                public void run() {
                    int i = 0;
                    while (i < participants.length) {
                        ISynchronizeParticipant participant = participants[i];
                        if (SynchronizeView.this.isAvailable()) {
                            ISynchronizeParticipantReference[] available;
                            SynchronizeViewWorkbenchPart part = (SynchronizeViewWorkbenchPart)SynchronizeView.this.fParticipantToPart.get(participant);
                            if (part != null) {
                                SynchronizeView.this.partClosed(part);
                                SynchronizeView.this.clearCrossReferenceCache(part, participant);
                            }
                            SynchronizeView.this.removeDialogSettings(participant);
                            if (SynchronizeView.this.getParticipant() == null && (available = TeamUI.getSynchronizeManager().getSynchronizeParticipants()).length > 0) {
                                ISynchronizeParticipant p;
                                try {
                                    p = available[available.length - 1].getParticipant();
                                }
                                catch (TeamException teamException) {
                                    return;
                                }
                                SynchronizeView.this.display(p);
                            }
                        }
                        ++i;
                    }
                    SynchronizeView.this.firePropertyChange(257);
                }
            };
            this.asyncExec(r);
        }
    }

    public SynchronizeView() {
        this.updateTitle();
    }

    protected void createActions() {
        this.fPageDropDown = new SynchronizePageDropDownAction(this);
        this.fPinAction = new PinParticipantAction();
        this.fRemoveCurrentAction = new RemoveSynchronizeParticipantAction(this, false);
        this.fRemoveAllAction = new RemoveSynchronizeParticipantAction(this, true);
        this.updateActionEnablements();
    }

    private void updateActionEnablements() {
        if (this.fPinAction != null) {
            this.fPinAction.setParticipant(this.activeParticipantRef);
        }
        if (this.fRemoveAllAction != null) {
            this.fRemoveAllAction.setEnabled(this.getParticipant() != null);
        }
        if (this.fRemoveCurrentAction != null) {
            this.fRemoveCurrentAction.setEnabled(this.getParticipant() != null);
        }
    }

    protected void configureToolBar(IActionBars bars) {
        IToolBarManager mgr = bars.getToolBarManager();
        mgr.add((IAction)this.fPageDropDown);
        mgr.add((IAction)this.fPinAction);
        IMenuManager menu = bars.getMenuManager();
        menu.add((IAction)this.fPinAction);
        menu.add((IAction)this.fRemoveCurrentAction);
        menu.add((IAction)this.fRemoveAllAction);
    }

    public void display(ISynchronizeParticipant participant) {
        SynchronizeViewWorkbenchPart part = (SynchronizeViewWorkbenchPart)this.fParticipantToPart.get(participant);
        if (part != null) {
            this.partActivated(part);
            this.fPageDropDown.update();
            this.rememberCurrentParticipant();
        }
    }

    protected IWorkbenchPart getBootstrapPart() {
        return null;
    }

    public void asyncExec(Runnable runnable) {
        if (this.isAvailable()) {
            this.getPageBook().getDisplay().asyncExec(runnable);
        }
    }

    public void createPartControl(Composite parent) {
        IWorkbenchSiteProgressService progress;
        super.createPartControl(parent);
        this.createActions();
        this.configureToolBar(this.getViewSite().getActionBars());
        this.updateForExistingParticipants();
        this.getViewSite().getActionBars().updateActionBars();
        this.updateTitle();
        IWorkbenchPartSite iWorkbenchPartSite = this.getSite();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.ui.progress.IWorkbenchSiteProgressService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((progress = (IWorkbenchSiteProgressService)iWorkbenchPartSite.getAdapter((Class)clazz)) != null) {
            progress.showBusyForFamily(ISynchronizeManager.FAMILY_SYNCHRONIZE_OPERATION);
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.team.ui.sync_view_context");
    }

    private void updateForExistingParticipants() {
        ISynchronizeManager manager = TeamUI.getSynchronizeManager();
        List<ISynchronizeParticipantReference> participants = Arrays.asList(this.getParticipants());
        boolean errorOccurred = false;
        int i = 0;
        while (i < participants.size()) {
            try {
                ISynchronizeParticipantReference ref = participants.get(i);
                this.participantsAdded(new ISynchronizeParticipant[]{ref.getParticipant()});
            }
            catch (TeamException teamException) {
                errorOccurred = true;
            }
            ++i;
        }
        if (errorOccurred) {
            participants = Arrays.asList(this.getParticipants());
        }
        try {
            if (participants.size() > 0) {
                ISynchronizeParticipantReference selectedParticipant;
                ISynchronizeParticipantReference participantToSelect = participants.get(0);
                IDialogSettings section = this.getDialogSettings();
                String selectedParticipantId = section.get(KEY_LAST_ACTIVE_PARTICIPANT_ID);
                String selectedParticipantSecId = section.get(KEY_LAST_ACTIVE_PARTICIPANT_SECONDARY_ID);
                if (selectedParticipantId != null && (selectedParticipant = manager.get(selectedParticipantId, selectedParticipantSecId)) != null) {
                    participantToSelect = selectedParticipant;
                }
                this.display(participantToSelect.getParticipant());
            }
            manager.addSynchronizeParticipantListener(this);
        }
        catch (TeamException e) {
            Utils.handle(e);
        }
    }

    private ISynchronizeParticipantReference[] getParticipants() {
        ISynchronizeManager manager = TeamUI.getSynchronizeManager();
        ArrayList<ISynchronizeParticipantReference> participants = new ArrayList<ISynchronizeParticipantReference>();
        ISynchronizeParticipantReference[] refs = manager.getSynchronizeParticipants();
        int i = 0;
        while (i < refs.length) {
            ISynchronizeParticipantReference ref = refs[i];
            if (this.select(ref)) {
                participants.add(ref);
            }
            ++i;
        }
        return participants.toArray(new ISynchronizeParticipantReference[participants.size()]);
    }

    private boolean isAvailable() {
        return this.getPageBook() != null && !this.getPageBook().isDisposed();
    }

    public IPage getPage(ISynchronizeParticipant participant) {
        IWorkbenchPart part = (IWorkbenchPart)this.fParticipantToPart.get(participant);
        if (part == null) {
            return null;
        }
        try {
            return this.getPageRec((IWorkbenchPart)part).page;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    protected boolean select(ISynchronizeParticipantReference ref) {
        return true;
    }

    private IDialogSettings getDialogSettings() {
        IDialogSettings workbenchSettings = TeamUIPlugin.getPlugin().getDialogSettings();
        IDialogSettings syncViewSettings = workbenchSettings.getSection(KEY_SETTINGS_SECTION);
        if (syncViewSettings == null) {
            syncViewSettings = workbenchSettings.addNewSection(KEY_SETTINGS_SECTION);
        }
        return syncViewSettings;
    }

    private String getSettingsKey(ISynchronizeParticipant participant) {
        String id = participant.getId();
        String secondaryId = participant.getSecondaryId();
        return secondaryId == null ? id : String.valueOf(id) + '.' + secondaryId;
    }

    private IDialogSettings getDialogSettings(ISynchronizeParticipant participant) {
        String key = this.getSettingsKey(participant);
        IDialogSettings viewsSettings = this.getDialogSettings();
        IDialogSettings settings = viewsSettings.getSection(key);
        if (settings == null) {
            settings = viewsSettings.addNewSection(key);
        }
        return settings;
    }

    private void removeDialogSettings(ISynchronizeParticipant participant) {
        String key = this.getSettingsKey(participant);
        IDialogSettings settings = this.getDialogSettings();
        if (settings.getSection(key) != null) {
            this.getDialogSettings().addSection((IDialogSettings)new DialogSettings(key));
        }
    }

    public Saveable[] getSaveables() {
        HashSet<Saveable> result = new HashSet<Saveable>();
        Iterator iter = this.fPartToParticipant.keySet().iterator();
        while (iter.hasNext()) {
            SynchronizeViewWorkbenchPart part = (SynchronizeViewWorkbenchPart)iter.next();
            Saveable saveable = this.getSaveable(part.getParticipant());
            if (saveable == null) continue;
            result.add(saveable);
        }
        return result.toArray(new Saveable[result.size()]);
    }

    private Saveable getSaveable(ISynchronizeParticipant participant) {
        if (participant instanceof ModelSynchronizeParticipant) {
            ModelSynchronizeParticipant msp = (ModelSynchronizeParticipant)participant;
            return msp.getActiveSaveable();
        }
        return null;
    }

    public Saveable[] getActiveSaveables() {
        ISynchronizeParticipant participant = this.getParticipant();
        Saveable s = this.getSaveable(participant);
        if (s != null) {
            return new Saveable[]{s};
        }
        return new Saveable[0];
    }

    public void doSave(IProgressMonitor monitor) {
        Saveable[] saveables = this.getSaveables();
        if (saveables.length == 0) {
            return;
        }
        monitor.beginTask(null, 100 * saveables.length);
        int i = 0;
        while (i < saveables.length) {
            Saveable saveable = saveables[i];
            try {
                saveable.doSave(Policy.subMonitorFor(monitor, 100));
            }
            catch (CoreException e) {
                ErrorDialog.openError((Shell)this.getSite().getShell(), null, (String)e.getMessage(), (IStatus)e.getStatus());
            }
            Policy.checkCanceled(monitor);
            ++i;
        }
        monitor.done();
        this.firePropertyChange(257);
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        Saveable[] saveables = this.getSaveables();
        int i = 0;
        while (i < saveables.length) {
            Saveable saveable = saveables[i];
            if (saveable.isDirty()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return true;
    }

    private void setStatusLineMessage(String description, int mode) {
        String syncMode = null;
        ResourceBundle bundle = Policy.getActionBundle();
        switch (mode) {
            case 1: {
                syncMode = Utils.getString("action.directionFilterIncoming.tooltip", bundle);
                break;
            }
            case 2: {
                syncMode = Utils.getString("action.directionFilterOutgoing.tooltip", bundle);
                break;
            }
            case 4: {
                syncMode = Utils.getString("action.directionFilterBoth.tooltip", bundle);
                break;
            }
            case 8: {
                syncMode = Utils.getString("action.directionFilterConflicts.tooltip", bundle);
            }
        }
        IViewSite viewSite = this.getViewSite();
        if (viewSite != null && syncMode != null) {
            viewSite.getActionBars().getStatusLineManager().setMessage(NLS.bind((String)TeamUIMessages.SynchronizeView_statusLine, (Object[])new String[]{description, syncMode}));
        }
    }
}

