/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.xalan.debugger;

import javax.xml.transform.TransformerException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xalan.templates.ElemVariable;
import org.apache.xpath.VariableStack;
import org.apache.xpath.objects.XNodeSet;
import org.apache.xpath.objects.XObject;
import org.eclipse.wst.xsl.jaxp.debug.debugger.Variable;
import org.eclipse.wst.xsl.xalan.debugger.XalanStyleFrame;

public class XalanVariable
extends Variable
implements Comparable {
    private final Log log;
    private final ElemVariable elemVariable;
    private final VariableStack varStack;
    private int stackFrame;
    static /* synthetic */ Class class$0;

    public XalanVariable(XalanStyleFrame xalanStyleFrame, VariableStack varStack, String scope, int slotNumber, ElemVariable elemVariable) {
        super(XalanVariable.getName(elemVariable, scope, xalanStyleFrame), scope, slotNumber + varStack.getStackFrame());
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.xsl.xalan.debugger.XalanVariable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.log = LogFactory.getLog((Class)clazz);
        this.elemVariable = elemVariable;
        this.varStack = varStack;
        this.stackFrame = varStack.getStackFrame();
    }

    private static String getName(ElemVariable elemVariable, String scope, XalanStyleFrame xalanStyleFrame) {
        String name = elemVariable.getName().getLocalName();
        String systemId = elemVariable.getStylesheet().getSystemId();
        if ("G".equals(scope) && systemId != null) {
            int index = systemId.lastIndexOf(47);
            name = index > 0 ? String.valueOf(name) + " (" + systemId.substring(index + 1) + ")" : String.valueOf(name) + " (" + systemId + ")";
        }
        return name;
    }

    public String getType() {
        String value = "unknown";
        try {
            XObject xobject = this.getXObject();
            if (xobject != null) {
                int xalanType = xobject.getType();
                switch (xalanType) {
                    case 600: {
                        value = "unresolved";
                        break;
                    }
                    case 4: {
                        value = "nodeset";
                        break;
                    }
                    case 1: {
                        value = "boolean";
                        break;
                    }
                    case 2: {
                        value = "number";
                        break;
                    }
                    case 0: {
                        value = "unknown";
                        break;
                    }
                    default: {
                        value = "string";
                        break;
                    }
                }
            }
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        return value;
    }

    public String getValue() {
        String value = "???";
        try {
            XObject xobject = this.getXObject();
            if (xobject != null) {
                int xalanType = xobject.getType();
                switch (xalanType) {
                    case 600: {
                        value = "";
                        break;
                    }
                    case 4: {
                        XNodeSet xns = (XNodeSet)xobject;
                        if (xns.nodelist().getLength() > 0) {
                            value = ((XNodeSet)xobject).nodelist().item(0).toString();
                            break;
                        }
                        value = "<EMPTY NODESET>";
                        break;
                    }
                    default: {
                        value = xobject.toString();
                        break;
                    }
                }
            }
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        return value;
    }

    private XObject getXObject() throws TransformerException {
        XObject xvalue = this.elemVariable.getIsTopLevel() ? this.varStack.elementAt(this.slotNumber) : this.varStack.getLocalVariable(this.elemVariable.getIndex(), this.stackFrame);
        return xvalue;
    }

    public int compareTo(Object arg0) {
        XalanVariable xvar = (XalanVariable)arg0;
        int comp = xvar.stackFrame - this.stackFrame;
        if (comp == 0) {
            comp = this.slotNumber - xvar.slotNumber;
        }
        return comp;
    }
}

