/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.reportitem.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.data.Query;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.impl.QueryImpl;
import org.eclipse.birt.chart.reportitem.i18n.Messages;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.emf.common.util.EList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class QueryUIHelper {
    private static final String BASE_SERIES = Messages.getString((String)"QueryHelper.Text.CategroySeries");
    private static final String ORTHOGONAL_SERIES = Messages.getString((String)"QueryHelper.Text.ValueSeries");
    private static final String X_SERIES = Messages.getString((String)"QueryHelper.Text.XSeries");
    private static final String Y_SERIES = Messages.getString((String)"QueryHelper.Text.YSeries");
    public static final String[] CAST_STRING_ARRAY = new String[0];

    public final SeriesQueries[] getSeriesQueryDefinitions(Chart cm) {
        if (cm instanceof ChartWithAxes) {
            return this.getSeriesQueryDefinitions((ChartWithAxes)cm);
        }
        if (cm instanceof ChartWithoutAxes) {
            return this.getSeriesQueryDefinitions((ChartWithoutAxes)cm);
        }
        return null;
    }

    final SeriesQueries[] getSeriesQueryDefinitions(ChartWithAxes cwa) {
        ArrayList<SeriesQueries> alSeriesQueries = new ArrayList<SeriesQueries>(4);
        Axis axPrimaryBase = cwa.getPrimaryBaseAxes()[0];
        EList elSD = axPrimaryBase.getSeriesDefinitions();
        if (elSD.size() != 1) {
            return alSeriesQueries.toArray(new SeriesQueries[alSeriesQueries.size()]);
        }
        SeriesDefinition sd = (SeriesDefinition)elSD.get(0);
        Series seBase = sd.getDesignTimeSeries();
        EList elBaseSeries = seBase.getDataDefinition();
        int[] bDataIndex = this.getValidationIndex(seBase);
        Query[] qua = new Query[bDataIndex.length];
        SeriesQueries sqd = new SeriesQueries(X_SERIES, qua);
        int i = 0;
        while (i < bDataIndex.length) {
            qua[i] = i < elBaseSeries.size() ? (Query)elBaseSeries.get(bDataIndex[i]) : QueryImpl.create((String)"");
            ++i;
        }
        alSeriesQueries.add(sqd);
        Axis[] axaOrthogonal = cwa.getOrthogonalAxes(axPrimaryBase, true);
        int j = 0;
        while (j < axaOrthogonal.length) {
            elSD = axaOrthogonal[j].getSeriesDefinitions();
            int k = 0;
            while (k < elSD.size()) {
                sd = (SeriesDefinition)elSD.get(k);
                Series seOrthogonal = sd.getDesignTimeSeries();
                EList elOrthogonalSeries = seOrthogonal.getDataDefinition();
                int[] oDataIndex = this.getValidationIndex(seOrthogonal);
                qua = new Query[oDataIndex.length];
                sqd = new SeriesQueries(Y_SERIES, qua);
                int i2 = 0;
                while (i2 < oDataIndex.length) {
                    qua[i2] = oDataIndex[i2] < elOrthogonalSeries.size() ? (Query)elOrthogonalSeries.get(oDataIndex[i2]) : QueryImpl.create((String)"");
                    ++i2;
                }
                alSeriesQueries.add(sqd);
                ++k;
            }
            ++j;
        }
        return alSeriesQueries.toArray(new SeriesQueries[alSeriesQueries.size()]);
    }

    final SeriesQueries[] getSeriesQueryDefinitions(ChartWithoutAxes cwoa) {
        ArrayList<SeriesQueries> alSeriesQueries = new ArrayList<SeriesQueries>(4);
        EList elSD = cwoa.getSeriesDefinitions();
        if (elSD.size() != 1) {
            return alSeriesQueries.toArray(new SeriesQueries[alSeriesQueries.size()]);
        }
        SeriesDefinition sd = (SeriesDefinition)elSD.get(0);
        Series seBase = sd.getDesignTimeSeries();
        EList elBaseSeries = seBase.getDataDefinition();
        int[] bDataIndex = this.getValidationIndex(seBase);
        Query[] qua = new Query[bDataIndex.length];
        SeriesQueries sqd = new SeriesQueries(BASE_SERIES, qua);
        int i = 0;
        while (i < bDataIndex.length) {
            qua[i] = i < elBaseSeries.size() ? (Query)elBaseSeries.get(bDataIndex[i]) : QueryImpl.create((String)"");
            ++i;
        }
        alSeriesQueries.add(sqd);
        elSD = sd.getSeriesDefinitions();
        int k = 0;
        while (k < elSD.size()) {
            sd = (SeriesDefinition)elSD.get(k);
            Series seOrthogonal = sd.getDesignTimeSeries();
            EList elOrthogonalSeries = seOrthogonal.getDataDefinition();
            int[] oDataIndex = this.getValidationIndex(seOrthogonal);
            qua = new Query[oDataIndex.length];
            sqd = new SeriesQueries(ORTHOGONAL_SERIES, qua);
            int i2 = 0;
            while (i2 < oDataIndex.length) {
                qua[i2] = oDataIndex[i2] < elOrthogonalSeries.size() ? (Query)elOrthogonalSeries.get(oDataIndex[i2]) : QueryImpl.create((String)"");
                ++i2;
            }
            alSeriesQueries.add(sqd);
            ++k;
        }
        return alSeriesQueries.toArray(new SeriesQueries[alSeriesQueries.size()]);
    }

    private int[] getValidationIndex(Series series) {
        return ChartUIUtil.getSeriesUIProvider((Series)series).validationIndex(series);
    }

    public static Map<String, Query[]> getQueryDefinitionsMap(Chart cm) {
        if (cm instanceof ChartWithAxes) {
            return QueryUIHelper.getQueryDefinitionsMap((ChartWithAxes)cm);
        }
        if (cm instanceof ChartWithoutAxes) {
            return QueryUIHelper.getQueryDefinitionsMap((ChartWithoutAxes)cm);
        }
        return Collections.EMPTY_MAP;
    }

    static Map<String, Query[]> getQueryDefinitionsMap(ChartWithAxes cwa) {
        Query[] q;
        Axis[] axaOrthogonal;
        HashMap<String, Query[]> queryMap = new HashMap<String, Query[]>();
        Axis axPrimaryBase = cwa.getPrimaryBaseAxes()[0];
        EList elSD = axPrimaryBase.getSeriesDefinitions();
        SeriesDefinition sd = (SeriesDefinition)elSD.get(0);
        Series seBase = sd.getDesignTimeSeries();
        EList elBaseSeries = seBase.getDataDefinition();
        Query categoryQuery = (Query)elBaseSeries.get(0);
        if (categoryQuery != null) {
            queryMap.put("category", new Query[]{categoryQuery});
        }
        ArrayList<Query> yOptionQueryList = new ArrayList<Query>();
        ArrayList<Query> valueQueryList = new ArrayList<Query>();
        Axis[] axisArray = axaOrthogonal = cwa.getOrthogonalAxes(axPrimaryBase, true);
        int n = axaOrthogonal.length;
        int n2 = 0;
        while (n2 < n) {
            Axis axis = axisArray[n2];
            elSD = axis.getSeriesDefinitions();
            for (SeriesDefinition sdef : elSD) {
                Query yOptionQuery = sdef.getQuery();
                if (yOptionQuery != null) {
                    yOptionQueryList.add(yOptionQuery);
                }
                Series seOrthogonal = sdef.getDesignTimeSeries();
                EList elOrthogonalSeries = seOrthogonal.getDataDefinition();
                for (Query q2 : elOrthogonalSeries) {
                    if (q2 == null) continue;
                    valueQueryList.add(q2);
                }
            }
            ++n2;
        }
        if (yOptionQueryList.size() > 0) {
            q = new Query[]{};
            queryMap.put("optional", yOptionQueryList.toArray(q));
        }
        if (valueQueryList.size() > 0) {
            q = new Query[]{};
            queryMap.put("value", valueQueryList.toArray(q));
        }
        return queryMap;
    }

    static Map<String, Query[]> getQueryDefinitionsMap(ChartWithoutAxes cwoa) {
        Query[] q;
        HashMap<String, Query[]> queryMap = new HashMap<String, Query[]>();
        EList elSD = cwoa.getSeriesDefinitions();
        SeriesDefinition sd = (SeriesDefinition)elSD.get(0);
        Series seBase = sd.getDesignTimeSeries();
        EList elBaseSeries = seBase.getDataDefinition();
        Query categoryQuery = (Query)elBaseSeries.get(0);
        if (categoryQuery != null) {
            queryMap.put("category", new Query[]{categoryQuery});
        }
        ArrayList<Query> yOptionQueryList = new ArrayList<Query>();
        ArrayList<Query> valueQueryList = new ArrayList<Query>();
        elSD = sd.getSeriesDefinitions();
        for (SeriesDefinition sdef : elSD) {
            Query yOptionQuery = sdef.getQuery();
            if (yOptionQuery != null) {
                yOptionQueryList.add(yOptionQuery);
            }
            Series seOrthogonal = sdef.getDesignTimeSeries();
            EList elOrthogonalSeries = seOrthogonal.getDataDefinition();
            for (Query q2 : elOrthogonalSeries) {
                if (q2 == null) continue;
                valueQueryList.add(q2);
            }
        }
        if (yOptionQueryList.size() > 0) {
            q = new Query[]{};
            queryMap.put("optional", yOptionQueryList.toArray(q));
        }
        if (valueQueryList.size() > 0) {
            q = new Query[]{};
            queryMap.put("value", valueQueryList.toArray(q));
        }
        return queryMap;
    }

    public static final class SeriesQueries {
        private final String sSeriesType;
        private final Query[] qua;

        SeriesQueries(String sSeriesType, Query[] qua) {
            this.sSeriesType = sSeriesType;
            this.qua = qua;
        }

        public Collection validate() {
            ArrayList<String> al = null;
            int i = 0;
            while (i < this.qua.length) {
                if (!this.qua[i].isDefined()) {
                    if (al == null) {
                        al = new ArrayList(this.qua.length);
                    }
                    al.add(Messages.getString((String)"SeriesQueries.dataDefnUndefined", (Object)this.sSeriesType));
                }
                ++i;
            }
            if (this.qua.length == 0) {
                al = new ArrayList<String>(this.qua.length);
                al.add(Messages.getString((String)"SeriesQueries.NoDataDefinitionFor", (Object)this.sSeriesType));
            }
            return al;
        }
    }
}

