/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.reportitem.ui;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.DialChart;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.data.Query;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.impl.QueryImpl;
import org.eclipse.birt.chart.model.type.BubbleSeries;
import org.eclipse.birt.chart.model.type.DifferenceSeries;
import org.eclipse.birt.chart.model.type.GanttSeries;
import org.eclipse.birt.chart.model.type.StockSeries;
import org.eclipse.birt.chart.reportitem.ChartReportItemUtil;
import org.eclipse.birt.chart.reportitem.ChartXTabUtil;
import org.eclipse.birt.chart.reportitem.ui.ReportDataServiceProvider;
import org.eclipse.birt.chart.reportitem.ui.dialogs.ChartColumnBindingDialog;
import org.eclipse.birt.chart.reportitem.ui.dialogs.ExtendedItemFilterDialog;
import org.eclipse.birt.chart.reportitem.ui.dialogs.ReportItemParametersDialog;
import org.eclipse.birt.chart.reportitem.ui.i18n.Messages;
import org.eclipse.birt.chart.reportitem.ui.views.attributes.provider.ChartCubeFilterHandleProvider;
import org.eclipse.birt.chart.reportitem.ui.views.attributes.provider.ChartFilterProviderDelegate;
import org.eclipse.birt.chart.ui.swt.ColorPalette;
import org.eclipse.birt.chart.ui.swt.ColumnBindingInfo;
import org.eclipse.birt.chart.ui.swt.CustomPreviewTable;
import org.eclipse.birt.chart.ui.swt.DataDefinitionTextManager;
import org.eclipse.birt.chart.ui.swt.DefaultChartDataSheet;
import org.eclipse.birt.chart.ui.swt.SimpleTextTransfer;
import org.eclipse.birt.chart.ui.swt.wizard.ChartAdapter;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.birt.chart.util.ChartUtil;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.ui.frameworks.taskwizard.WizardBase;
import org.eclipse.birt.report.designer.internal.ui.dialogs.ExpressionFilter;
import org.eclipse.birt.report.designer.internal.ui.views.ViewsTreeProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.AbstractFilterHandleProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.IFormProvider;
import org.eclipse.birt.report.designer.ui.actions.NewDataSetAction;
import org.eclipse.birt.report.designer.ui.cubebuilder.action.NewCubeAction;
import org.eclipse.birt.report.designer.ui.dialogs.ExpressionProvider;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabReportItemHandle;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.metadata.IClassInfo;
import org.eclipse.birt.report.model.api.olap.CubeHandle;
import org.eclipse.birt.report.model.api.olap.LevelHandle;
import org.eclipse.birt.report.model.api.olap.MeasureHandle;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardChartDataSheet
extends DefaultChartDataSheet
implements Listener {
    private final ExtendedItemHandle itemHandle;
    private final ReportDataServiceProvider dataProvider;
    private Button btnInherit = null;
    private Button btnUseData = null;
    private boolean bIsInheritSelected = true;
    private CCombo cmbDataItems = null;
    private StackLayout stackLayout = null;
    private Composite cmpStack = null;
    private Composite cmpCubeTree = null;
    private Composite cmpDataPreview = null;
    private CustomPreviewTable tablePreview = null;
    private TreeViewer cubeTreeViewer = null;
    private Button btnFilters = null;
    private Button btnParameters = null;
    private Button btnBinding = null;
    private String currentData = null;
    public static final int SELECT_NONE = 1;
    public static final int SELECT_NEXT = 2;
    public static final int SELECT_DATA_SET = 4;
    public static final int SELECT_DATA_CUBE = 8;
    public static final int SELECT_REPORT_ITEM = 16;
    public static final int SELECT_NEW_DATASET = 32;
    public static final int SELECT_NEW_DATACUBE = 64;
    private final int iSupportedDataItems;
    private List<Integer> selectDataTypes = new ArrayList<Integer>();

    public StandardChartDataSheet(ExtendedItemHandle itemHandle, ReportDataServiceProvider dataProvider, int iSupportedDataItems) {
        this.itemHandle = itemHandle;
        this.dataProvider = dataProvider;
        this.iSupportedDataItems = iSupportedDataItems;
    }

    public StandardChartDataSheet(ExtendedItemHandle itemHandle, ReportDataServiceProvider dataProvider) {
        this(itemHandle, dataProvider, 0);
    }

    public Composite createActionButtons(Composite parent) {
        Composite composite = ChartUIUtil.createCompositeWrapper((Composite)parent);
        composite.setLayoutData((Object)new GridData(776));
        this.btnFilters = new Button(composite, 0);
        this.btnFilters.setAlignment(0x1000000);
        GridData gridData = new GridData(768);
        this.btnFilters.setLayoutData((Object)gridData);
        this.btnFilters.setText(Messages.getString("StandardChartDataSheet.Label.Filters"));
        this.btnFilters.addListener(13, (Listener)this);
        this.btnParameters = new Button(composite, 0);
        this.btnParameters.setAlignment(0x1000000);
        gridData = new GridData(768);
        this.btnParameters.setLayoutData((Object)gridData);
        this.btnParameters.setText(Messages.getString("StandardChartDataSheet.Label.Parameters"));
        this.btnParameters.addListener(13, (Listener)this);
        this.btnBinding = new Button(composite, 0);
        this.btnBinding.setAlignment(0x1000000);
        gridData = new GridData(768);
        this.btnBinding.setLayoutData((Object)gridData);
        this.btnBinding.setText(Messages.getString("StandardChartDataSheet.Label.DataBinding"));
        this.btnBinding.addListener(13, (Listener)this);
        this.setEnabledForButtons();
        return composite;
    }

    private void setEnabledForButtons() {
        if (this.isCubeMode()) {
            boolean disabled = this.getDataServiceProvider().isInXTabAggrCell() || this.getDataServiceProvider().isInXTabMeasureCell();
            this.btnFilters.setEnabled(!disabled);
            this.btnBinding.setEnabled(this.getDataServiceProvider().isInvokingSupported() || this.getDataServiceProvider().isSharedBinding());
            this.btnParameters.setEnabled(false);
        } else {
            this.btnFilters.setEnabled(this.hasDataSet());
            this.btnParameters.setEnabled(this.getDataServiceProvider().getBoundDataSet() != null && this.getDataServiceProvider().isInvokingSupported());
            this.btnBinding.setEnabled(this.hasDataSet() && (this.getDataServiceProvider().isInvokingSupported() || this.getDataServiceProvider().isSharedBinding()));
        }
    }

    private boolean hasDataSet() {
        return this.getDataServiceProvider().getReportDataSet() != null || this.getDataServiceProvider().getBoundDataSet() != null;
    }

    void fireEvent(Widget widget, int eventType) {
        Event event = new Event();
        event.data = this;
        event.widget = widget;
        event.type = eventType;
        this.notifyListeners(event);
    }

    public Composite createDataDragSource(Composite parent) {
        this.cmpStack = new Composite(parent, 0);
        this.cmpStack.setLayoutData((Object)new GridData(1808));
        this.stackLayout = new StackLayout();
        this.stackLayout.marginHeight = 0;
        this.stackLayout.marginWidth = 0;
        this.cmpStack.setLayout((Layout)this.stackLayout);
        this.cmpCubeTree = ChartUIUtil.createCompositeWrapper((Composite)this.cmpStack);
        this.cmpDataPreview = ChartUIUtil.createCompositeWrapper((Composite)this.cmpStack);
        Label label = new Label(this.cmpCubeTree, 0);
        label.setText(Messages.getString("StandardChartDataSheet.Label.CubeTree"));
        label.setFont(JFaceResources.getBannerFont());
        if (!this.dataProvider.isInXTabMeasureCell() && !this.dataProvider.isInMultiView()) {
            Label description = new Label(this.cmpCubeTree, 64);
            GridData gd = new GridData(768);
            description.setLayoutData((Object)gd);
            description.setText(Messages.getString("StandardChartDataSheet.Label.DragCube"));
        }
        this.cubeTreeViewer = new TreeViewer(this.cmpCubeTree, 2820);
        this.cubeTreeViewer.getTree().setLayoutData((Object)new GridData(1808));
        ((GridData)this.cubeTreeViewer.getTree().getLayoutData()).heightHint = 120;
        ViewsTreeProvider provider = new ViewsTreeProvider();
        this.cubeTreeViewer.setLabelProvider((IBaseLabelProvider)provider);
        this.cubeTreeViewer.setContentProvider((IContentProvider)provider);
        this.cubeTreeViewer.setInput((Object)this.getCube());
        DragSource dragSource = new DragSource((Control)this.cubeTreeViewer.getTree(), 1);
        dragSource.setTransfer(new Transfer[]{SimpleTextTransfer.getInstance()});
        dragSource.addDragListener(new DragSourceListener(){
            private String text = null;

            public void dragFinished(DragSourceEvent event) {
            }

            public void dragSetData(DragSourceEvent event) {
                event.data = this.text;
            }

            public void dragStart(DragSourceEvent event) {
                this.text = StandardChartDataSheet.this.createCubeExpression();
                if (this.text == null) {
                    event.doit = false;
                }
            }
        });
        this.cubeTreeViewer.getTree().addListener(3, new Listener(){

            public void handleEvent(Event event) {
                if (event.button == 3 && event.widget instanceof Tree) {
                    Tree tree = (Tree)event.widget;
                    TreeItem treeItem = tree.getSelection()[0];
                    if (treeItem.getData() instanceof LevelHandle || treeItem.getData() instanceof MeasureHandle) {
                        tree.setMenu(StandardChartDataSheet.this.createMenuManager(treeItem.getData()).createContextMenu((Control)tree));
                    } else {
                        tree.setMenu(null);
                    }
                }
            }
        });
        label = new Label(this.cmpDataPreview, 0);
        label.setText(Messages.getString("StandardChartDataSheet.Label.DataPreview"));
        label.setFont(JFaceResources.getBannerFont());
        if (!this.dataProvider.isInXTabMeasureCell() && !this.dataProvider.isInMultiView()) {
            Label description = new Label(this.cmpDataPreview, 64);
            GridData gd = new GridData(768);
            description.setLayoutData((Object)gd);
            description.setText(Messages.getString("StandardChartDataSheet.Label.ToBindADataColumn"));
        }
        this.tablePreview = new CustomPreviewTable(this.cmpDataPreview, 66308);
        GridData gridData = new GridData(1808);
        gridData.widthHint = 400;
        gridData.heightHint = 120;
        this.tablePreview.setLayoutData((Object)gridData);
        this.tablePreview.setHeaderAlignment(16384);
        this.tablePreview.addListener(0, (Listener)this);
        this.updateDragDataSource();
        return this.cmpStack;
    }

    private void updateDragDataSource() {
        if (this.isCubeMode()) {
            this.stackLayout.topControl = this.cmpCubeTree;
            this.cubeTreeViewer.setInput((Object)this.getCube());
        } else {
            this.stackLayout.topControl = this.cmpDataPreview;
            this.refreshTablePreview();
        }
        this.cmpStack.layout();
    }

    public Composite createDataSelector(Composite parent) {
        Composite cmpDataSet = ChartUIUtil.createCompositeWrapper((Composite)parent);
        cmpDataSet.setLayoutData((Object)new GridData(768));
        Label label = new Label(cmpDataSet, 0);
        label.setText(Messages.getString("StandardChartDataSheet.Label.SelectDataSet"));
        label.setFont(JFaceResources.getBannerFont());
        Composite cmpDetail = new Composite(cmpDataSet, 0);
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.marginWidth = 10;
        gridLayout.marginHeight = 0;
        cmpDetail.setLayout((Layout)gridLayout);
        cmpDetail.setLayoutData((Object)new GridData(768));
        Composite compRadios = ChartUIUtil.createCompositeWrapper((Composite)cmpDetail);
        GridData gd = new GridData();
        gd.verticalSpan = 2;
        compRadios.setLayoutData((Object)gd);
        this.btnInherit = new Button(compRadios, 16);
        this.btnInherit.setText(Messages.getString("StandardChartDataSheet.Label.UseReportData"));
        this.btnInherit.addListener(13, (Listener)this);
        this.btnUseData = new Button(compRadios, 16);
        this.btnUseData.setText(Messages.getString("StandardChartDataSheet.Label.UseDataSet"));
        this.btnUseData.addListener(13, (Listener)this);
        new Label(cmpDetail, 0);
        new Label(cmpDetail, 0);
        this.cmbDataItems = new CCombo(cmpDetail, 2060);
        this.cmbDataItems.setLayoutData((Object)new GridData(768));
        this.cmbDataItems.addListener(13, (Listener)this);
        this.initDataSelector();
        this.updatePredefinedQueries();
        return cmpDataSet;
    }

    int invokeNewDataSet() {
        NewDataSetAction action = new NewDataSetAction();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)action, "org.eclipse.birt.chart.cshelp.NewDataSet_ID");
        action.run();
        return 0;
    }

    int invokeEditFilter() {
        ExtendedItemHandle handle = this.getItemHandle();
        handle.getModuleHandle().getCommandStack().startTrans(null);
        ExtendedItemFilterDialog page = new ExtendedItemFilterDialog(handle);
        AbstractFilterHandleProvider provider = ChartFilterProviderDelegate.createFilterProvider(handle, handle);
        if (provider instanceof ChartCubeFilterHandleProvider) {
            ((ChartCubeFilterHandleProvider)provider).setContext(this.getContext());
        }
        page.setFilterHandleProvider((IFormProvider)provider);
        int openStatus = page.open();
        if (openStatus == 0) {
            handle.getModuleHandle().getCommandStack().commit();
        } else {
            handle.getModuleHandle().getCommandStack().rollback();
        }
        return openStatus;
    }

    int invokeEditParameter() {
        ReportItemParametersDialog page = new ReportItemParametersDialog((ReportItemHandle)this.getItemHandle());
        return page.open();
    }

    int invokeDataBinding() {
        Shell shell = new Shell(Display.getDefault(), 67696);
        ExtendedItemHandle handle = this.getItemHandle();
        handle.getModuleHandle().getCommandStack().startTrans(null);
        ChartColumnBindingDialog page = new ChartColumnBindingDialog((ReportItemHandle)handle, shell, this.getContext());
        ExpressionProvider ep = new ExpressionProvider((DesignElementHandle)this.getItemHandle());
        ep.addFilter(new ExpressionFilter(){

            public boolean select(Object parentElement, Object element) {
                return !parentElement.equals(ExpressionProvider.BIRT_OBJECTS) || !(element instanceof IClassInfo) || !((IClassInfo)element).getName().equals("Total");
            }
        });
        page.setExpressionProvider(ep);
        page.setReadOnly(this.getDataServiceProvider().isSharedBinding() || this.getDataServiceProvider().isInheritanceOnly());
        int openStatus = page.open();
        if (openStatus == 0) {
            handle.getModuleHandle().getCommandStack().commit();
            this.updatePredefinedQueries();
        } else {
            handle.getModuleHandle().getCommandStack().rollback();
        }
        return openStatus;
    }

    private void initDataSelector() {
        this.cmbDataItems.setItems(this.createDataComboItems());
        this.cmbDataItems.setVisibleItemCount(this.cmbDataItems.getItemCount());
        String sItemRef = this.getDataServiceProvider().getReportItemReference();
        if (sItemRef != null) {
            this.btnUseData.setSelection(true);
            this.bIsInheritSelected = false;
            this.cmbDataItems.setText(sItemRef);
            this.currentData = sItemRef;
            return;
        }
        String sDataSet = this.getDataServiceProvider().getBoundDataSet();
        if (sDataSet != null && !this.getDataServiceProvider().isInheritanceOnly()) {
            this.btnUseData.setSelection(true);
            this.bIsInheritSelected = false;
            this.cmbDataItems.setText(sDataSet);
            this.currentData = sDataSet;
            if (sDataSet != null) {
                this.switchDataTable();
            }
            return;
        }
        String sDataCube = this.getDataServiceProvider().getDataCube();
        if (sDataCube != null && !this.getDataServiceProvider().isInheritanceOnly()) {
            this.btnUseData.setSelection(true);
            this.bIsInheritSelected = false;
            this.cmbDataItems.setText(sDataCube);
            this.currentData = sDataCube;
            return;
        }
        this.btnInherit.setSelection(true);
        this.bIsInheritSelected = true;
        if (this.getDataServiceProvider().isInheritanceOnly()) {
            this.btnUseData.setSelection(false);
            this.btnUseData.setEnabled(false);
        }
        this.cmbDataItems.select(0);
        this.currentData = null;
        this.cmbDataItems.setEnabled(false);
        this.getDataServiceProvider().setDataSet(null);
        String reportDataSet = this.getDataServiceProvider().getReportDataSet();
        if (reportDataSet != null) {
            this.switchDataTable();
        }
    }

    public void handleEvent(Event event) {
        if (event.type == 0) {
            if ((this.getDataServiceProvider().getBoundDataSet() != null || this.getDataServiceProvider().getReportDataSet() != null) && event.widget instanceof Button) {
                Button header = (Button)event.widget;
                if (header.getMenu() == null) {
                    header.setMenu(this.createMenuManager(event.data).createContextMenu((Control)this.tablePreview));
                }
                header.getMenu().setVisible(true);
            }
        } else if (event.type == 13) {
            if (event.widget instanceof MenuItem) {
                IAction action;
                MenuItem item = (MenuItem)event.widget;
                action.setChecked(!(action = (IAction)item.getData()).isChecked());
                action.run();
            } else if (event.widget == this.btnFilters) {
                if (this.invokeEditFilter() == 0) {
                    this.refreshTablePreview();
                    this.fireEvent((Widget)this.btnFilters, 1);
                }
            } else if (event.widget == this.btnParameters) {
                if (this.invokeEditParameter() == 0) {
                    this.refreshTablePreview();
                    this.fireEvent((Widget)this.btnParameters, 1);
                }
            } else if (event.widget == this.btnBinding && this.invokeDataBinding() == 0) {
                this.refreshTablePreview();
                this.fireEvent((Widget)this.btnBinding, 1);
            }
            try {
                if (event.widget == this.btnInherit) {
                    ColorPalette.getInstance().restore();
                    if (!this.btnInherit.getSelection()) {
                        return;
                    }
                    if (this.bIsInheritSelected) {
                        return;
                    }
                    this.bIsInheritSelected = true;
                    this.getDataServiceProvider().setReportItemReference(null);
                    this.getDataServiceProvider().setDataSet(null);
                    this.switchDataSet(null);
                    this.cmbDataItems.select(0);
                    this.currentData = null;
                    this.cmbDataItems.setEnabled(false);
                    this.setEnabledForButtons();
                    this.updateDragDataSource();
                    this.updatePredefinedQueries();
                } else if (event.widget == this.btnUseData) {
                    if (!this.btnUseData.getSelection()) {
                        return;
                    }
                    if (!this.bIsInheritSelected) {
                        return;
                    }
                    this.bIsInheritSelected = false;
                    this.getDataServiceProvider().setReportItemReference(null);
                    this.getDataServiceProvider().setDataSet(null);
                    this.selectDataSet();
                    this.cmbDataItems.setEnabled(true);
                    this.setEnabledForButtons();
                    this.updateDragDataSource();
                    this.updatePredefinedQueries();
                } else if (event.widget == this.cmbDataItems) {
                    ColorPalette.getInstance().restore();
                    int selectedIndex = this.cmbDataItems.getSelectionIndex();
                    Integer selectState = this.selectDataTypes.get(selectedIndex);
                    switch (selectState) {
                        case 1: {
                            this.btnInherit.setSelection(true);
                            this.btnUseData.setSelection(false);
                            this.btnInherit.notifyListeners(13, new Event());
                            break;
                        }
                        case 2: {
                            selectState = this.selectDataTypes.get(++selectedIndex);
                            this.cmbDataItems.select(selectedIndex);
                        }
                    }
                    switch (selectState) {
                        case 4: {
                            if (this.getDataServiceProvider().getReportItemReference() == null && this.getDataServiceProvider().getBoundDataSet() != null && this.getDataServiceProvider().getBoundDataSet().equals(this.cmbDataItems.getText())) {
                                return;
                            }
                            this.getDataServiceProvider().setDataSet(this.cmbDataItems.getText());
                            this.currentData = this.cmbDataItems.getText();
                            this.switchDataSet(this.cmbDataItems.getText());
                            this.setEnabledForButtons();
                            this.updateDragDataSource();
                            break;
                        }
                        case 8: {
                            this.getDataServiceProvider().setDataCube(this.cmbDataItems.getText());
                            this.currentData = this.cmbDataItems.getText();
                            this.updateDragDataSource();
                            this.setEnabledForButtons();
                            DataDefinitionTextManager.getInstance().refreshAll();
                            this.fireEvent((Widget)this.tablePreview, 1);
                            break;
                        }
                        case 16: {
                            if (this.cmbDataItems.getText().equals(this.getDataServiceProvider().getReportItemReference())) {
                                return;
                            }
                            this.getDataServiceProvider().setReportItemReference(this.cmbDataItems.getText());
                            ChartReportItemUtil.reviseChartModel((int)1, (Chart)this.getContext().getModel(), (ReportItemHandle)this.itemHandle);
                            this.currentData = this.cmbDataItems.getText();
                            DataDefinitionTextManager.getInstance().refreshAll();
                            this.fireEvent((Widget)this.tablePreview, 1);
                            this.setEnabledForButtons();
                            this.updateDragDataSource();
                            break;
                        }
                        case 32: {
                            int result = this.invokeNewDataSet();
                            if (result == 1) {
                                return;
                            }
                            this.cmbDataItems.removeAll();
                            this.cmbDataItems.setItems(this.createDataComboItems());
                            this.cmbDataItems.setVisibleItemCount(this.cmbDataItems.getItemCount());
                            if (this.currentData == null) {
                                this.cmbDataItems.select(0);
                                break;
                            }
                            this.cmbDataItems.setText(this.currentData);
                            break;
                        }
                        case 64: {
                            if (this.getDataServiceProvider().getAllDataSets().length == 0) {
                                this.invokeNewDataSet();
                            }
                            if (this.getDataServiceProvider().getAllDataSets().length != 0) {
                                new NewCubeAction().run();
                            }
                            this.cmbDataItems.removeAll();
                            this.cmbDataItems.setItems(this.createDataComboItems());
                            this.cmbDataItems.setVisibleItemCount(this.cmbDataItems.getItemCount());
                            if (this.currentData == null) {
                                this.cmbDataItems.select(0);
                                break;
                            }
                            this.cmbDataItems.setText(this.currentData);
                        }
                    }
                    this.updatePredefinedQueries();
                }
            }
            catch (ChartException e1) {
                WizardBase.showException((String)e1.getLocalizedMessage());
            }
        }
    }

    private void selectDataSet() {
        String currentDS = this.getDataServiceProvider().getBoundDataSet();
        if (currentDS == null) {
            this.cmbDataItems.select(0);
            this.currentData = null;
        } else {
            this.cmbDataItems.setText(currentDS);
            this.currentData = currentDS;
        }
    }

    private void refreshTablePreview() {
        if (this.dataProvider.getDataSetFromHandle() == null) {
            return;
        }
        this.tablePreview.clearContents();
        this.switchDataTable();
        this.tablePreview.layout();
    }

    private void switchDataSet(String datasetName) throws ChartException {
        if (this.isCubeMode()) {
            return;
        }
        try {
            this.tablePreview.clearContents();
            if (datasetName == null) {
                datasetName = this.getDataServiceProvider().getReportDataSet();
            }
            if (datasetName != null) {
                this.switchDataTable();
            } else {
                this.tablePreview.createDummyTable();
            }
            this.tablePreview.layout();
        }
        catch (Throwable t) {
            throw new ChartException("org.eclipse.birt.chart.engine", 19, t);
        }
        DataDefinitionTextManager.getInstance().refreshAll();
        this.fireEvent((Widget)this.tablePreview, 1);
    }

    private void updateTablePreview(ColumnBindingInfo[] headers, List dataList) {
        this.fireEvent((Widget)this.tablePreview, 2);
        if (this.tablePreview.isDisposed()) {
            return;
        }
        if (headers == null) {
            this.tablePreview.setEnabled(false);
            this.tablePreview.createDummyTable();
        } else {
            this.tablePreview.setEnabled(true);
            this.tablePreview.setColumns(headers);
            this.refreshTableColor();
            if (dataList != null) {
                for (String[] dataRow : dataList) {
                    int i = 0;
                    while (i < dataRow.length) {
                        this.tablePreview.addEntry(dataRow[i], i);
                        ++i;
                    }
                }
            }
        }
        this.tablePreview.layout();
    }

    private void switchDataTable() {
        if (this.isCubeMode()) {
            return;
        }
        Runnable runnable = new Runnable(){

            public void run() {
                ColumnBindingInfo[] headers = null;
                List dataList = null;
                try {
                    headers = StandardChartDataSheet.this.getDataServiceProvider().getPreviewHeadersInfo();
                    dataList = StandardChartDataSheet.this.getDataServiceProvider().getPreviewData();
                    StandardChartDataSheet.this.getDataServiceProvider().setPredefinedExpressions(headers);
                    final ColumnBindingInfo[] headerInfo = headers;
                    final List data = dataList;
                    Display.getDefault().syncExec(new Runnable(){

                        public void run() {
                            StandardChartDataSheet.this.updateTablePreview(headerInfo, data);
                        }
                    });
                }
                catch (Exception e) {
                    final ColumnBindingInfo[] headerInfo = headers;
                    final List data = dataList;
                    final String msg = e.getMessage();
                    Display.getDefault().syncExec(new Runnable(){

                        public void run() {
                            StandardChartDataSheet.this.updateTablePreview(headerInfo, data);
                            WizardBase.showException((String)msg);
                        }
                    });
                }
            }
        };
        new Thread(runnable).start();
    }

    private void refreshTableColor() {
        if (this.isCubeMode()) {
            return;
        }
        int i = 0;
        while (i < this.tablePreview.getColumnNumber()) {
            this.tablePreview.setColumnColor(i, ColorPalette.getInstance().getColor(ExpressionUtil.createJSRowExpression((String)this.tablePreview.getColumnHeading(i))));
            ++i;
        }
    }

    protected void manageColorAndQuery(Query query, String expr) {
        if (DataDefinitionTextManager.getInstance().getNumberOfSameDataDefinition(query.getDefinition()) == 0) {
            ColorPalette.getInstance().retrieveColor(query.getDefinition());
        }
        query.setDefinition(this.getActualExpression(expr));
        DataDefinitionTextManager.getInstance().updateText(query);
        this.refreshTableColor();
        DataDefinitionTextManager.getInstance().refreshAll();
    }

    private String getActualExpression(String expr) {
        ColumnBindingInfo cbi;
        int type;
        if (!this.dataProvider.checkState(16)) {
            return expr;
        }
        Object obj = this.tablePreview.getCurrentColumnHeadObject();
        if (obj instanceof ColumnBindingInfo && ((type = (cbi = (ColumnBindingInfo)obj).getColumnType()) == 1 || type == 2)) {
            return cbi.getExpression();
        }
        return expr;
    }

    ExtendedItemHandle getItemHandle() {
        return this.itemHandle;
    }

    ReportDataServiceProvider getDataServiceProvider() {
        return this.dataProvider;
    }

    protected List<Object> getActionsForTableHead(String expr) {
        ArrayList<Object> actions = new ArrayList<Object>(3);
        actions.add(this.getBaseSeriesMenu(this.getChartModel(), expr));
        actions.add(this.getOrthogonalSeriesMenu(this.getChartModel(), expr));
        actions.add(this.getGroupSeriesMenu(this.getChartModel(), expr));
        return actions;
    }

    private MenuManager createMenuManager(final Object data) {
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                String expr;
                if (data instanceof Integer) {
                    this.addMenu(manager, (Object)new HeaderShowAction(StandardChartDataSheet.this.tablePreview.getCurrentColumnHeading()));
                    String expr2 = ExpressionUtil.createJSRowExpression((String)StandardChartDataSheet.this.tablePreview.getCurrentColumnHeading());
                    List<Object> actions = StandardChartDataSheet.this.getActionsForTableHead(expr2);
                    for (Object act : actions) {
                        this.addMenu(manager, act);
                    }
                } else if (data instanceof MeasureHandle) {
                    String expr3 = StandardChartDataSheet.this.createCubeExpression();
                    if (expr3 != null) {
                        this.addMenu(manager, StandardChartDataSheet.this.getOrthogonalSeriesMenu(StandardChartDataSheet.this.getChartModel(), expr3));
                    }
                } else if (data instanceof LevelHandle && (expr = StandardChartDataSheet.this.createCubeExpression()) != null) {
                    if (((Boolean)StandardChartDataSheet.this.dataProvider.checkData("category", expr)).booleanValue()) {
                        this.addMenu(manager, StandardChartDataSheet.this.getBaseSeriesMenu(StandardChartDataSheet.this.getChartModel(), expr));
                    }
                    if (StandardChartDataSheet.this.dataProvider.checkState(64) && ((Boolean)StandardChartDataSheet.this.dataProvider.checkData("optional", expr)).booleanValue()) {
                        this.addMenu(manager, StandardChartDataSheet.this.getGroupSeriesMenu(StandardChartDataSheet.this.getChartModel(), expr));
                    }
                }
            }

            private void addMenu(IMenuManager manager, Object item) {
                if (item instanceof IAction) {
                    manager.add((IAction)item);
                } else if (item instanceof IContributionItem) {
                    manager.add((IContributionItem)item);
                }
                if (StandardChartDataSheet.this.getDataServiceProvider().isPartChart() && item instanceof IAction) {
                    ((IAction)item).setEnabled(false);
                }
            }
        });
        return menuManager;
    }

    private Object getBaseSeriesMenu(Chart chart, String expr) {
        EList sds = ChartUIUtil.getBaseSeriesDefinitions((Chart)chart);
        if (sds.size() == 1) {
            return new CategoryXAxisAction(expr);
        }
        return null;
    }

    private Object getGroupSeriesMenu(Chart chart, String expr) {
        MenuManager topManager = new MenuManager(this.getGroupSeriesTitle(this.getChartModel()));
        int axisNum = ChartUIUtil.getOrthogonalAxisNumber((Chart)chart);
        int axisIndex = 0;
        while (axisIndex < axisNum) {
            int i = 0;
            EList sds = ChartUIUtil.getOrthogonalSeriesDefinitions((Chart)chart, (int)axisIndex);
            if (i < sds.size()) {
                SeriesDefinition sd = (SeriesDefinition)sds.get(i);
                GroupYSeriesAction action = new GroupYSeriesAction(sd.getQuery(), expr);
                return action;
            }
            ++axisIndex;
        }
        return topManager;
    }

    private Object getOrthogonalSeriesMenu(Chart chart, String expr) {
        MenuManager topManager = new MenuManager(this.getOrthogonalSeriesTitle(this.getChartModel()));
        int axisNum = ChartUIUtil.getOrthogonalAxisNumber((Chart)chart);
        int axisIndex = 0;
        while (axisIndex < axisNum) {
            EList sds = ChartUIUtil.getOrthogonalSeriesDefinitions((Chart)chart, (int)axisIndex);
            int i = 0;
            while (i < sds.size()) {
                ValueYSeriesAction action;
                int j;
                MenuManager secondManager;
                Series series = ((SeriesDefinition)sds.get(i)).getDesignTimeSeries();
                EList dataDefns = series.getDataDefinition();
                if (series instanceof StockSeries) {
                    secondManager = new MenuManager(this.getSecondMenuText(axisIndex, i, series));
                    topManager.add((IContributionItem)secondManager);
                    j = 0;
                    while (j < dataDefns.size()) {
                        action = new ValueYSeriesAction((Query)dataDefns.get(j), expr);
                        action.setText(String.valueOf(ChartUIUtil.getStockTitle((int)j)) + Messages.getString("StandardChartDataSheet.Label.Component"));
                        secondManager.add((IAction)action);
                        ++j;
                    }
                } else if (series instanceof BubbleSeries) {
                    secondManager = new MenuManager(this.getSecondMenuText(axisIndex, i, series));
                    topManager.add((IContributionItem)secondManager);
                    j = 0;
                    while (j < dataDefns.size()) {
                        action = new ValueYSeriesAction((Query)dataDefns.get(j), expr);
                        action.setText(String.valueOf(ChartUIUtil.getBubbleTitle((int)j)) + Messages.getString("StandardChartDataSheet.Label.Component"));
                        secondManager.add((IAction)action);
                        ++j;
                    }
                } else if (series instanceof DifferenceSeries) {
                    secondManager = new MenuManager(this.getSecondMenuText(axisIndex, i, series));
                    topManager.add((IContributionItem)secondManager);
                    j = 0;
                    while (j < dataDefns.size()) {
                        action = new ValueYSeriesAction((Query)dataDefns.get(j), expr);
                        action.setText(String.valueOf(ChartUIUtil.getDifferenceTitle((int)j)) + Messages.getString("StandardChartDataSheet.Label.Component"));
                        secondManager.add((IAction)action);
                        ++j;
                    }
                } else if (series instanceof GanttSeries) {
                    secondManager = new MenuManager(this.getSecondMenuText(axisIndex, i, series));
                    topManager.add((IContributionItem)secondManager);
                    j = 0;
                    while (j < dataDefns.size()) {
                        action = new ValueYSeriesAction((Query)dataDefns.get(j), expr);
                        action.setText(String.valueOf(ChartUIUtil.getGanttTitle((int)j)) + Messages.getString("StandardChartDataSheet.Label.Component"));
                        secondManager.add((IAction)action);
                        ++j;
                    }
                } else {
                    ValueYSeriesAction action2 = new ValueYSeriesAction((Query)dataDefns.get(0), expr);
                    if (axisNum == 1 && sds.size() == 1) {
                        return action2;
                    }
                    action2.setText(this.getSecondMenuText(axisIndex, i, series));
                    topManager.add((IAction)action2);
                }
                ++i;
            }
            ++axisIndex;
        }
        return topManager;
    }

    private String getSecondMenuText(int axisIndex, int seriesIndex, Series series) {
        StringBuffer sb = new StringBuffer();
        if (ChartUIUtil.getOrthogonalAxisNumber((Chart)this.getChartModel()) > 1) {
            sb.append(Messages.getString("StandardChartDataSheet.Label.Axis"));
            sb.append(axisIndex + 1);
            sb.append(" - ");
        }
        sb.append(String.valueOf(Messages.getString("StandardChartDataSheet.Label.Series")) + (seriesIndex + 1) + " (" + series.getDisplayName() + ")");
        return sb.toString();
    }

    private String getBaseSeriesTitle(Chart chart) {
        if (chart instanceof ChartWithAxes) {
            return Messages.getString("StandardChartDataSheet.Label.UseAsCategoryXAxis");
        }
        return Messages.getString("StandardChartDataSheet.Label.UseAsCategorySeries");
    }

    private String getOrthogonalSeriesTitle(Chart chart) {
        if (chart instanceof ChartWithAxes) {
            return Messages.getString("StandardChartDataSheet.Label.PlotAsValueYSeries");
        }
        if (chart instanceof DialChart) {
            return Messages.getString("StandardChartDataSheet.Label.PlotAsGaugeValue");
        }
        return Messages.getString("StandardChartDataSheet.Label.PlotAsValueSeries");
    }

    private String getGroupSeriesTitle(Chart chart) {
        if (chart instanceof ChartWithAxes) {
            return Messages.getString("StandardChartDataSheet.Label.UseToGroupYSeries");
        }
        return Messages.getString("StandardChartDataSheet.Label.UseToGroupValueSeries");
    }

    private boolean isCubeMode() {
        return ChartXTabUtil.getBindingCube((DesignElementHandle)this.itemHandle) != null;
    }

    private CubeHandle getCube() {
        return ChartXTabUtil.getBindingCube((DesignElementHandle)this.itemHandle);
    }

    private String createCubeExpression() {
        if (this.cubeTreeViewer == null) {
            return null;
        }
        TreeItem[] selection = this.cubeTreeViewer.getTree().getSelection();
        String expr = null;
        if (selection.length > 0 && !this.dataProvider.isSharedBinding() && !this.dataProvider.isPartChart()) {
            TreeItem treeItem = selection[0];
            ComputedColumnHandle binding = null;
            if (treeItem.getData() instanceof LevelHandle) {
                binding = ChartXTabUtil.findBinding((ReportItemHandle)this.itemHandle, (String)ChartXTabUtil.createDimensionExpression((LevelHandle)((LevelHandle)treeItem.getData())));
            } else if (treeItem.getData() instanceof MeasureHandle) {
                binding = ChartXTabUtil.findBinding((ReportItemHandle)this.itemHandle, (String)ChartXTabUtil.createMeasureExpression((MeasureHandle)((MeasureHandle)treeItem.getData())));
            }
            if (binding != null) {
                expr = ExpressionUtil.createJSDataExpression((String)binding.getName());
            }
        }
        return expr;
    }

    private boolean isDataItemSupported(int type) {
        return this.iSupportedDataItems == 0 || (this.iSupportedDataItems & type) == type;
    }

    private String[] createDataComboItems() {
        String[] dataRefs;
        int i;
        ArrayList<String> items = new ArrayList<String>();
        this.selectDataTypes.clear();
        if (this.isDataItemSupported(1)) {
            if (DEUtil.getDataSetList((DesignElementHandle)this.itemHandle.getContainer()).size() > 0) {
                items.add(Messages.getString("ReportDataServiceProvider.Option.Inherits", ((DataSetHandle)DEUtil.getDataSetList((DesignElementHandle)this.itemHandle.getContainer()).get(0)).getName()));
            } else {
                items.add(ReportDataServiceProvider.OPTION_NONE);
            }
            this.selectDataTypes.add(new Integer(1));
        }
        if (this.isDataItemSupported(4)) {
            String[] dataSets = this.getDataServiceProvider().getAllDataSets();
            if (dataSets.length > 0) {
                if (this.isDataItemSupported(2)) {
                    items.add(Messages.getString("StandardChartDataSheet.Combo.DataSets"));
                    this.selectDataTypes.add(new Integer(2));
                }
                i = 0;
                while (i < dataSets.length) {
                    items.add(dataSets[i]);
                    this.selectDataTypes.add(new Integer(4));
                    ++i;
                }
            }
            if (this.isDataItemSupported(32)) {
                items.add(Messages.getString("StandardChartDataSheet.NewDataSet"));
                this.selectDataTypes.add(new Integer(32));
            }
        }
        if (this.isDataItemSupported(8)) {
            String[] dataCubes = this.getDataServiceProvider().getAllDataCubes();
            if (dataCubes.length > 0) {
                if (this.isDataItemSupported(2)) {
                    items.add(Messages.getString("StandardChartDataSheet.Combo.DataCubes"));
                    this.selectDataTypes.add(new Integer(2));
                }
                i = 0;
                while (i < dataCubes.length) {
                    items.add(dataCubes[i]);
                    this.selectDataTypes.add(new Integer(8));
                    ++i;
                }
            }
            if (this.isDataItemSupported(64)) {
                items.add(Messages.getString("StandardChartDataSheet.NewDataCube"));
                this.selectDataTypes.add(new Integer(64));
            }
        }
        if (this.isDataItemSupported(16) && (dataRefs = this.getDataServiceProvider().getAllReportItemReferences()).length > 0) {
            if (this.isDataItemSupported(2)) {
                items.add(Messages.getString("StandardChartDataSheet.Combo.ReportItems"));
                this.selectDataTypes.add(new Integer(2));
            }
            i = 0;
            while (i < dataRefs.length) {
                items.add(dataRefs[i]);
                this.selectDataTypes.add(new Integer(16));
                ++i;
            }
        }
        return items.toArray(new String[items.size()]);
    }

    private void updatePredefinedQueries() {
        block17: {
            if (this.dataProvider.isInXTabMeasureCell()) {
                try {
                    CrosstabReportItemHandle xtab = ChartXTabUtil.getXtabContainerCell((DesignElementHandle)this.itemHandle).getCrosstab();
                    if (this.dataProvider.isPartChart()) {
                        List levels = ChartXTabUtil.getAllLevelsBindingExpression((CrosstabReportItemHandle)xtab);
                        Object[] exprs = levels.toArray(new String[levels.size()]);
                        if (exprs.length == 2 && this.dataProvider.isInXTabAggrCell()) {
                            exprs = ((ChartWithAxes)this.getChartModel()).isTransposed() ? new String[]{exprs[1]} : new String[]{exprs[0]};
                        }
                        this.getContext().addPredefinedQuery("category", exprs);
                        break block17;
                    }
                    Iterator columnBindings = ChartXTabUtil.getAllColumnBindingsIterator((ReportItemHandle)this.itemHandle);
                    List levels = ChartXTabUtil.getAllLevelsBindingExpression((Iterator)columnBindings);
                    Object[] exprs = levels.toArray(new String[levels.size()]);
                    this.getContext().addPredefinedQuery("category", exprs);
                    this.getContext().addPredefinedQuery("optional", exprs);
                    columnBindings = ChartXTabUtil.getAllColumnBindingsIterator((ReportItemHandle)this.itemHandle);
                    List measures = ChartXTabUtil.getAllMeasuresBindingExpression((Iterator)columnBindings);
                    exprs = measures.toArray(new String[measures.size()]);
                    this.getContext().addPredefinedQuery("value", exprs);
                }
                catch (BirtException e) {
                    WizardBase.displayException((Throwable)e);
                }
            } else {
                CubeHandle cube = this.getCube();
                if (cube == null) {
                    this.getContext().addPredefinedQuery("category", null);
                    this.getContext().addPredefinedQuery("value", null);
                    this.getContext().addPredefinedQuery("optional", null);
                } else if (this.dataProvider.isInheritanceOnly() || this.dataProvider.isSharedBinding()) {
                    Object[] categoryExprs;
                    ArrayList<String> dimensionExprs = new ArrayList<String>();
                    ArrayList<String> measureExprs = new ArrayList<String>();
                    ReportItemHandle reportItemHandle = this.dataProvider.getReportItemHandle();
                    for (ComputedColumnHandle cch : reportItemHandle.getColumnBindings()) {
                        String dataExpr = ExpressionUtil.createJSDataExpression((String)cch.getName());
                        if (ChartXTabUtil.isDimensionExpresion((String)cch.getExpression())) {
                            dimensionExprs.add(dataExpr);
                            continue;
                        }
                        if (!ChartXTabUtil.isMeasureExpresion((String)cch.getExpression())) continue;
                        measureExprs.add(dataExpr);
                    }
                    Object[] yOptionalExprs = categoryExprs = dimensionExprs.toArray(new String[dimensionExprs.size()]);
                    Object[] valueExprs = measureExprs.toArray(new String[measureExprs.size()]);
                    ReportItemHandle referenceHandle = ChartReportItemUtil.getReportItemReference((ReportItemHandle)this.itemHandle);
                    if (referenceHandle instanceof ExtendedItemHandle && ChartReportItemUtil.isChartReportItemHandle((ReportItemHandle)referenceHandle)) {
                        Chart referenceCM = ChartReportItemUtil.getChartFromHandle((ExtendedItemHandle)((ExtendedItemHandle)referenceHandle));
                        categoryExprs = ChartUtil.getCategoryExpressions((Chart)referenceCM);
                        yOptionalExprs = ChartUtil.getYOptoinalExpressions((Chart)referenceCM);
                        valueExprs = ChartUtil.getValueSeriesExpressions((Chart)referenceCM);
                        Chart cm = this.getChartModel();
                        if (categoryExprs.length > 0) {
                            this.updateCategoryExpression(cm, (String)categoryExprs[0]);
                        }
                        if (yOptionalExprs.length > 0) {
                            this.updateYOptionalExpressions(cm, (String)yOptionalExprs[0]);
                        }
                    } else if (this.dataProvider.checkState(256)) {
                        categoryExprs = null;
                        yOptionalExprs = null;
                    }
                    this.getContext().addPredefinedQuery("category", categoryExprs);
                    this.getContext().addPredefinedQuery("optional", yOptionalExprs);
                    this.getContext().addPredefinedQuery("value", valueExprs);
                } else {
                    Iterator columnBindings = ChartXTabUtil.getAllColumnBindingsIterator((ReportItemHandle)this.itemHandle);
                    List levels = ChartXTabUtil.getAllLevelsBindingExpression((Iterator)columnBindings);
                    Object[] exprs = levels.toArray(new String[levels.size()]);
                    this.getContext().addPredefinedQuery("category", exprs);
                    this.getContext().addPredefinedQuery("optional", exprs);
                    columnBindings = ChartXTabUtil.getAllColumnBindingsIterator((ReportItemHandle)this.itemHandle);
                    List measures = ChartXTabUtil.getAllMeasuresBindingExpression((Iterator)columnBindings);
                    exprs = measures.toArray(new String[measures.size()]);
                    this.getContext().addPredefinedQuery("value", exprs);
                }
            }
        }
        this.fireEvent((Widget)this.btnBinding, 2);
    }

    private void updateYOptionalExpressions(Chart cm, String expr) {
        List orthSDs = ChartUtil.getAllOrthogonalSeriesDefinitions((Chart)cm);
        for (SeriesDefinition sd : orthSDs) {
            Query q = sd.getQuery();
            if (q == null) {
                sd.setQuery(QueryImpl.create((String)expr));
                continue;
            }
            if (q.getDefinition() != null && !"".equals(q.getDefinition().trim())) continue;
            q.setDefinition(expr);
        }
    }

    private void updateCategoryExpression(Chart cm, String expr) {
        EList baseSDs = ChartUtil.getBaseSeriesDefinitions((Chart)cm);
        for (SeriesDefinition sd : baseSDs) {
            EList dds = sd.getDesignTimeSeries().getDataDefinition();
            Query q = (Query)dds.get(0);
            if (q.getDefinition() != null && !"".equals(q.getDefinition().trim())) continue;
            q.setDefinition(expr);
        }
    }

    class CategoryXAxisAction
    extends Action {
        Query query;
        String expr;

        CategoryXAxisAction(String expr) {
            super(StandardChartDataSheet.this.getBaseSeriesTitle(StandardChartDataSheet.this.getChartModel()));
            this.query = (Query)((SeriesDefinition)ChartUIUtil.getBaseSeriesDefinitions((Chart)StandardChartDataSheet.this.getChartModel()).get(0)).getDesignTimeSeries().getDataDefinition().get(0);
            this.expr = expr;
            this.setEnabled(DataDefinitionTextManager.getInstance().isAcceptableExpression(this.query, expr, StandardChartDataSheet.this.dataProvider.isSharedBinding()));
        }

        public void run() {
            StandardChartDataSheet.this.manageColorAndQuery(this.query, this.expr);
        }
    }

    class GroupYSeriesAction
    extends Action {
        Query query;
        String expr;

        GroupYSeriesAction(Query query, String expr) {
            super(StandardChartDataSheet.this.getGroupSeriesTitle(StandardChartDataSheet.this.getChartModel()));
            this.query = query;
            this.expr = expr;
            this.setEnabled(DataDefinitionTextManager.getInstance().isAcceptableExpression(query, expr, StandardChartDataSheet.this.dataProvider.isSharedBinding()));
        }

        public void run() {
            ChartAdapter.beginIgnoreNotifications();
            ChartUIUtil.setAllGroupingQueryExceptFirst((Chart)StandardChartDataSheet.this.getChartModel(), (String)this.expr);
            ChartAdapter.endIgnoreNotifications();
            StandardChartDataSheet.this.manageColorAndQuery(this.query, this.expr);
        }
    }

    class HeaderShowAction
    extends Action {
        HeaderShowAction(String header) {
            super(header);
            this.setEnabled(false);
        }
    }

    class ValueYSeriesAction
    extends Action {
        Query query;
        String expr;

        ValueYSeriesAction(Query query, String expr) {
            Object obj;
            super(StandardChartDataSheet.this.getOrthogonalSeriesTitle(StandardChartDataSheet.this.getChartModel()));
            this.query = query;
            this.expr = expr;
            boolean enabled = true;
            if (StandardChartDataSheet.this.dataProvider.checkState(16) && (obj = StandardChartDataSheet.this.tablePreview.getCurrentColumnHeadObject()) instanceof ColumnBindingInfo && ((ColumnBindingInfo)obj).getColumnType() == 1) {
                enabled = false;
            }
            this.setEnabled(enabled);
        }

        public void run() {
            StandardChartDataSheet.this.manageColorAndQuery(this.query, this.expr);
        }
    }
}

