/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.reportitem.ui.actions;

import java.util.List;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.AxisType;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.data.Query;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.reportitem.ChartReportItemImpl;
import org.eclipse.birt.chart.reportitem.ChartXTabUtil;
import org.eclipse.birt.chart.reportitem.ui.ChartXTabUIUtil;
import org.eclipse.birt.chart.reportitem.ui.i18n.Messages;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.ui.frameworks.taskwizard.WizardBase;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.item.crosstab.core.de.AggregationCellHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabReportItemHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.action.Action;

public class FlipAxisAction
extends Action {
    private ExtendedItemHandle eih;

    public FlipAxisAction(ExtendedItemHandle eih) {
        super(Messages.getString("FlipAxisAction.Text.FlipAxis"), 2);
        this.eih = eih;
        this.init();
    }

    private void init() {
        Chart cm = ChartXTabUtil.getChartFromHandle((ExtendedItemHandle)this.eih);
        if (cm instanceof ChartWithAxes) {
            this.setChecked(((ChartWithAxes)cm).isTransposed());
            this.setEnabled(this.checkEnabled());
        } else {
            this.setEnabled(false);
        }
    }

    private boolean checkEnabled() {
        block4: {
            AggregationCellHandle containerCell;
            block5: {
                if (ChartXTabUtil.isAxisChart((DesignElementHandle)this.eih)) {
                    this.eih = (ExtendedItemHandle)this.eih.getElementProperty("hostChart");
                }
                if (!ChartXTabUtil.isPlotChart((DesignElementHandle)this.eih) || (containerCell = ChartXTabUtil.getXtabContainerCell((DesignElementHandle)this.eih)) == null) break block4;
                if (!DEUtil.isLinkedElement((DesignElementHandle)containerCell.getCrosstabHandle())) break block5;
                return false;
            }
            try {
                List exprs = ChartXTabUtil.getAllLevelsBindingExpression((CrosstabReportItemHandle)containerCell.getCrosstab());
                return exprs.size() == 2 && !ChartXTabUtil.isAggregationCell((AggregationCellHandle)containerCell);
            }
            catch (BirtException e) {
                WizardBase.displayException((Throwable)e);
            }
        }
        return false;
    }

    public void run() {
        try {
            AggregationCellHandle containerCell = ChartXTabUtil.getXtabContainerCell((DesignElementHandle)this.eih);
            if (containerCell != null) {
                ChartReportItemImpl reportItem = (ChartReportItemImpl)this.eih.getReportItem();
                ChartWithAxes cmOld = (ChartWithAxes)reportItem.getProperty("chart.instance");
                ChartWithAxes cmNew = (ChartWithAxes)EcoreUtil.copy((EObject)cmOld);
                List exprs = ChartXTabUtil.getAllLevelsBindingExpression((CrosstabReportItemHandle)containerCell.getCrosstab());
                Query query = (Query)((SeriesDefinition)((Axis)cmNew.getAxes().get(0)).getSeriesDefinitions().get(0)).getDesignTimeSeries().getDataDefinition().get(0);
                this.eih.getRoot().getCommandStack().startTrans(this.getText());
                if (cmNew.isTransposed()) {
                    cmNew.setTransposed(false);
                    cmNew.getBaseAxes()[0].setType(AxisType.TEXT_LITERAL);
                    query.setDefinition((String)exprs.get(0));
                    ChartXTabUIUtil.updateXTabForAxis(containerCell, this.eih, true, cmNew);
                } else {
                    cmNew.setTransposed(true);
                    cmNew.getBaseAxes()[0].setType(AxisType.TEXT_LITERAL);
                    query.setDefinition((String)exprs.get(1));
                    ChartXTabUIUtil.updateXTabForAxis(containerCell, this.eih, false, cmNew);
                }
                reportItem.executeSetModelCommand(this.eih, (Chart)cmOld, (Chart)cmNew);
            }
            this.eih.getRoot().getCommandStack().commit();
        }
        catch (BirtException e) {
            WizardBase.displayException((Throwable)e);
            this.eih.getRoot().getCommandStack().rollback();
        }
    }
}

