/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.render;

import org.eclipse.birt.chart.computation.DataPointHints;
import org.eclipse.birt.chart.computation.Methods;
import org.eclipse.birt.chart.computation.withaxes.SeriesRenderingHints;
import org.eclipse.birt.chart.datafeed.DifferenceEntry;
import org.eclipse.birt.chart.device.IPrimitiveRenderer;
import org.eclipse.birt.chart.engine.extension.i18n.Messages;
import org.eclipse.birt.chart.event.WrappedStructureSource;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.ChartDimension;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.LineAttributes;
import org.eclipse.birt.chart.model.attribute.Location;
import org.eclipse.birt.chart.model.attribute.Marker;
import org.eclipse.birt.chart.model.attribute.Position;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.attribute.impl.LocationImpl;
import org.eclipse.birt.chart.model.component.Label;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.layout.Legend;
import org.eclipse.birt.chart.model.layout.Plot;
import org.eclipse.birt.chart.model.type.DifferenceSeries;
import org.eclipse.birt.chart.model.type.LineSeries;
import org.eclipse.birt.chart.render.DifferenceRenderer;
import org.eclipse.birt.chart.render.ISeriesRenderingHints;
import org.eclipse.birt.chart.render.Line;
import org.eclipse.birt.chart.script.ScriptHandler;
import org.eclipse.birt.chart.util.ChartUtil;
import org.eclipse.birt.chart.util.FillUtil;
import org.eclipse.emf.common.util.EList;

public class Difference
extends Line {
    public void renderSeries(IPrimitiveRenderer ipr, Plot p, ISeriesRenderingHints isrh) throws ChartException {
        Label laDataPoint;
        double fX;
        double fY;
        DifferenceEntry de;
        Fill[] fills;
        int iThisSeriesIndex;
        ChartWithAxes cwa = (ChartWithAxes)this.getModel();
        if (cwa.getDimension() != ChartDimension.TWO_DIMENSIONAL_LITERAL) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.difference.dimension", new Object[]{cwa.getDimension().getName()}, Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
        }
        try {
            this.validateDataSetCount(isrh);
        }
        catch (ChartException vex) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, (Throwable)vex);
        }
        SeriesRenderingHints srh = (SeriesRenderingHints)isrh;
        DifferenceSeries ds = (DifferenceSeries)this.getSeries();
        if (!ds.isSetVisible()) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.series.visibility", new Object[]{ds}, Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
        }
        if (!ds.isVisible()) {
            return;
        }
        logger.log(1, Messages.getString("info.render.series", new Object[]{((Object)((Object)this)).getClass().getName(), new Integer(this.iSeriesIndex + 1), new Integer(this.iSeriesCount)}, this.getRunTimeContext().getULocale()));
        ScriptHandler sh = this.getRunTimeContext().getScriptHandler();
        DataPointHints[] dpha = isrh.getDataPoints();
        this.validateNullDatapoint(dpha);
        double[] faX = new double[dpha.length];
        double[][] faY = new double[2][dpha.length];
        SeriesDefinition sd = this.getSeriesDefinition();
        EList elPalette = sd.getSeriesPalette().getEntries();
        int iPaletteSize = elPalette.size();
        if (iPaletteSize == 0) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.empty.palette", new Object[]{ds}, Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
        }
        boolean isTransposed = this.isTransposed();
        boolean bPaletteByCategory = this.isPaletteByCategory();
        if (bPaletteByCategory && ds.eContainer() instanceof SeriesDefinition) {
            sd = (SeriesDefinition)ds.eContainer();
        }
        if ((iThisSeriesIndex = sd.getRunTimeSeries().indexOf(ds)) < 0) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.missing.series.for.palette.index", new Object[]{ds, sd}, Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
        }
        Marker posMarker = null;
        if (ds.getMarkers().size() > 0) {
            posMarker = (Marker)ds.getMarkers().get(iThisSeriesIndex % ds.getMarkers().size());
        }
        Marker negMarker = null;
        if (ds.getNegativeMarkers().size() > 0) {
            negMarker = (Marker)ds.getNegativeMarkers().get(iThisSeriesIndex % ds.getNegativeMarkers().size());
        }
        Fill fPaletteEntry = null;
        if (!bPaletteByCategory) {
            fPaletteEntry = FillUtil.copyOf((Fill)((Fill)elPalette.get(iThisSeriesIndex % iPaletteSize)));
        } else if (this.iSeriesIndex > 0) {
            fPaletteEntry = FillUtil.copyOf((Fill)((Fill)elPalette.get((this.iSeriesIndex - 1) % iPaletteSize)));
        }
        this.updateTranslucency(fPaletteEntry, (Series)ds);
        LineAttributes liaPos = ds.getLineAttributes();
        LineAttributes liaNeg = ds.getNegativeLineAttributes();
        if (((LineSeries)this.getSeries()).isPaletteLineColor() && (fills = DifferenceRenderer.createDifferenceFillFromPalette(fPaletteEntry, true))[0] instanceof ColorDefinition && fills[1] instanceof ColorDefinition) {
            liaPos.setColor((ColorDefinition)fills[0]);
            liaNeg.setColor((ColorDefinition)fills[1]);
        }
        int i = 0;
        while (i < dpha.length) {
            de = (DifferenceEntry)dpha[i].getOrthogonalValue();
            faX[i] = Double.NaN;
            faY[0][i] = Double.NaN;
            faY[1][i] = Double.NaN;
            if (DifferenceRenderer.isValidDifferenceEntry(de)) {
                double fUnit;
                Location lo = dpha[i].getLocation();
                double fPos = srh.getLocationOnOrthogonal((Object)new Double(de.getPositiveValue()));
                double fNeg = srh.getLocationOnOrthogonal((Object)new Double(de.getNegativeValue()));
                if (isTransposed) {
                    fUnit = dpha[i].getSize();
                    faX[i] = fY = lo.getY() + fUnit / 2.0;
                    faY[0][i] = fPos;
                    faY[1][i] = fNeg;
                } else {
                    fUnit = dpha[i].getSize();
                    faX[i] = fX = lo.getX() + fUnit / 2.0;
                    faY[0][i] = fPos;
                    faY[1][i] = fNeg;
                }
            }
            ++i;
        }
        if (isTransposed) {
            this.handleOutsideDataPoints(ipr, srh, faY[0], faX, false);
            this.handleOutsideDataPoints(ipr, srh, faY[1], faX, false);
        } else {
            this.handleOutsideDataPoints(ipr, srh, faX, faY[0], false);
            this.handleOutsideDataPoints(ipr, srh, faX, faY[1], false);
        }
        if (ds.isCurve()) {
            DifferenceRenderer.renderDifferenceCurve(this, ipr, dpha, isTransposed ? LocationImpl.create((double[])faY[0], (double[])faX) : LocationImpl.create((double[])faX, (double[])faY[0]), isTransposed ? LocationImpl.create((double[])faY[1], (double[])faX) : LocationImpl.create((double[])faX, (double[])faY[1]), liaPos, liaNeg, fPaletteEntry);
        } else {
            DifferenceRenderer.renderDifferencePolygon(this, ipr, dpha, isTransposed ? LocationImpl.create((double[])faY[0], (double[])faX) : LocationImpl.create((double[])faX, (double[])faY[0]), isTransposed ? LocationImpl.create((double[])faY[1], (double[])faX) : LocationImpl.create((double[])faX, (double[])faY[1]), liaPos, liaNeg, fPaletteEntry);
        }
        if (negMarker != null && negMarker.isSetType() || posMarker != null && posMarker.isSetType()) {
            i = 0;
            while (i < dpha.length) {
                de = (DifferenceEntry)dpha[i].getOrthogonalValue();
                if (DifferenceRenderer.isValidDifferenceEntry(de) && !dpha[i].isOutside()) {
                    fPaletteEntry = bPaletteByCategory ? FillUtil.copyOf((Fill)((Fill)elPalette.get(i % iPaletteSize))) : FillUtil.copyOf((Fill)((Fill)elPalette.get(iThisSeriesIndex % iPaletteSize)));
                    this.updateTranslucency(fPaletteEntry, (Series)ds);
                    ScriptHandler.callFunction((ScriptHandler)sh, (String)"beforeDrawDataPoint", (Object)dpha[i], (Object)fPaletteEntry, (Object)this.getRunTimeContext().getScriptContext());
                    this.getRunTimeContext().notifyStructureChange("beforeDrawDataPoint", (Object)dpha[i]);
                    if (negMarker != null && negMarker.isSetType()) {
                        Fill negFill = ChartUtil.convertFill((Fill)fPaletteEntry, (double)-1.0, null);
                        this.renderMarker(ds, ipr, negMarker, isTransposed ? LocationImpl.create((double)faY[1][i], (double)faX[i]) : LocationImpl.create((double)faX[i], (double)faY[1][i]), liaNeg, negFill, dpha[i], null, true, true);
                    }
                    if (posMarker != null && posMarker.isSetType()) {
                        Fill posFill = ChartUtil.convertFill((Fill)fPaletteEntry, (double)1.0, null);
                        this.renderMarker(ds, ipr, posMarker, isTransposed ? LocationImpl.create((double)faY[0][i], (double)faX[i]) : LocationImpl.create((double)faX[i], (double)faY[0][i]), liaPos, posFill, dpha[i], null, true, true);
                    }
                    ScriptHandler.callFunction((ScriptHandler)sh, (String)"afterDrawDataPoint", (Object)dpha[i], (Object)fPaletteEntry, (Object)this.getRunTimeContext().getScriptContext());
                    this.getRunTimeContext().notifyStructureChange("afterDrawDataPoint", (Object)dpha[i]);
                }
                ++i;
            }
        }
        if ((laDataPoint = srh.getLabelAttributes((Series)ds)).isVisible()) {
            Position posDataPoint = srh.getLabelPosition((Series)ds);
            Location loDataPoint = LocationImpl.create((double)0.0, (double)0.0);
            double dSize = posMarker == null ? 0 : posMarker.getSize();
            int i2 = 0;
            while (i2 < dpha.length) {
                DifferenceEntry de2 = (DifferenceEntry)dpha[i2].getOrthogonalValue();
                if (DifferenceRenderer.isValidDifferenceEntry(de2) && !dpha[i2].isOutside()) {
                    laDataPoint.getCaption().setValue(dpha[i2].getDisplayValue());
                    ScriptHandler.callFunction((ScriptHandler)sh, (String)"beforeDrawDataPointLabel", (Object)dpha[i2], (Object)laDataPoint, (Object)this.getRunTimeContext().getScriptContext());
                    this.getRunTimeContext().notifyStructureChange("beforeDrawDataPointLabel", (Object)laDataPoint);
                    if (laDataPoint.isVisible()) {
                        fX = faX[i2];
                        fY = faY[1][i2];
                        if (isTransposed) {
                            fX = faY[1][i2];
                            fY = faX[i2];
                        }
                        switch (posDataPoint.getValue()) {
                            case 0: {
                                loDataPoint.set(fX, fY - dSize - (double)p.getVerticalSpacing());
                                break;
                            }
                            case 1: {
                                loDataPoint.set(fX, fY + dSize + (double)p.getVerticalSpacing());
                                break;
                            }
                            case 2: {
                                loDataPoint.set(fX - dSize - (double)p.getHorizontalSpacing(), fY);
                                break;
                            }
                            case 3: {
                                loDataPoint.set(fX + dSize + (double)p.getHorizontalSpacing(), fY);
                                break;
                            }
                            default: {
                                throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.illegal.datapoint.position.line", new Object[]{posDataPoint.getName()}, Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
                            }
                        }
                        this.renderLabel(WrappedStructureSource.createSeriesDataPoint((Series)ds, (DataPointHints)dpha[i2]), 2, laDataPoint, posDataPoint, loDataPoint, null);
                    }
                    ScriptHandler.callFunction((ScriptHandler)sh, (String)"afterDrawDataPointLabel", (Object)dpha[i2], (Object)laDataPoint, (Object)this.getRunTimeContext().getScriptContext());
                    this.getRunTimeContext().notifyStructureChange("afterDrawDataPointLabel", (Object)laDataPoint);
                }
                ++i2;
            }
        }
        this.restoreClipping(ipr);
    }

    public void renderLegendGraphic(IPrimitiveRenderer ipr, Legend lg, Fill fPaletteEntry, Bounds bo) throws ChartException {
        if (bo.getWidth() == 0.0 && bo.getHeight() == 0.0) {
            return;
        }
        DifferenceSeries ds = (DifferenceSeries)this.getSeries();
        if (fPaletteEntry == null) {
            fPaletteEntry = ColorDefinitionImpl.RED();
        }
        Location[] loa1 = new Location[]{LocationImpl.create((double)(bo.getLeft() + 1.0 * this.getDeviceScale()), (double)(bo.getTop() + 2.0 * this.getDeviceScale())), LocationImpl.create((double)(bo.getLeft() + bo.getWidth() - 1.0 * this.getDeviceScale()), (double)(bo.getTop() + 2.0 * this.getDeviceScale()))};
        Location[] loa2 = new Location[]{LocationImpl.create((double)(bo.getLeft() + 1.0 * this.getDeviceScale()), (double)(bo.getTop() + bo.getHeight() - 2.0 * this.getDeviceScale())), LocationImpl.create((double)(bo.getLeft() + bo.getWidth() - 1.0 * this.getDeviceScale()), (double)(bo.getTop() + bo.getHeight() - 2.0 * this.getDeviceScale()))};
        DifferenceRenderer.renderDifferenceCurve(this, ipr, null, loa1, loa2, ds.getLineAttributes(), ds.getNegativeLineAttributes(), fPaletteEntry);
        this.dc.flush();
    }

    protected int checkEntryInRange(Object entry, Object min, Object max) {
        if (entry instanceof DifferenceEntry) {
            double vP = ((DifferenceEntry)entry).getPositiveValue();
            double vN = ((DifferenceEntry)entry).getNegativeValue();
            double dMin = Methods.asDouble((Object)min);
            double dMax = Methods.asDouble((Object)max);
            if (vP < dMin || vN < dMin) {
                return 1;
            }
            if (vP > dMax || vN > dMax) {
                return 2;
            }
            return 0;
        }
        return super.checkEntryInRange(entry, min, max);
    }
}

