/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.transform.pass;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IComputedColumn;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.transform.FilterUtil;
import org.eclipse.birt.data.engine.executor.transform.ResultSetPopulator;
import org.eclipse.birt.data.engine.impl.ComputedColumnHelper;
import org.eclipse.birt.data.engine.impl.FilterByRow;

class PassStatusController {
    public static final int DATA_SET_FILTERING = 1;
    public static final int DATA_SET_COMPUTED_COLUMN_POPULATING = 2;
    public static final int RESULT_SET_FILTERING = 3;
    public static final int RESULT_SET_TEMP_COMPUTED_COLUMN_POPULATING = 4;
    public static final int GROUP_ROW_FILTERING = 5;
    public static final int AGGR_ROW_FILTERING = 6;
    private boolean hasDataSetFilters;
    private boolean hasDataSetCC;
    private boolean hasResultSetFilters;
    private boolean hasResultSetTempCC;
    private boolean hasGroupRowFilters;
    private boolean hasAggrRowFilters;
    private boolean needMultipassProcessing;
    private boolean hasAggregationInDataSetCC;

    PassStatusController(ResultSetPopulator populator, FilterByRow filterByRow, ComputedColumnHelper computedColumnHelper) throws DataException {
        this.hasDataSetFilters = filterByRow == null ? false : filterByRow.isFilterSetExist(1);
        this.hasDataSetCC = computedColumnHelper == null ? false : computedColumnHelper.isComputedColumnExist(0);
        this.hasResultSetFilters = filterByRow == null ? false : filterByRow.isFilterSetExist(2);
        this.hasAggrRowFilters = filterByRow == null ? false : filterByRow.isFilterSetExist(6);
        this.hasResultSetTempCC = computedColumnHelper == null ? false : computedColumnHelper.isComputedColumnExist(1);
        boolean bl = this.hasGroupRowFilters = filterByRow == null ? false : filterByRow.isFilterSetExist(5);
        if (computedColumnHelper != null) {
            computedColumnHelper.setModel(0);
            this.hasAggregationInDataSetCC = PassStatusController.hasAggregationsInComputedColumns(computedColumnHelper, populator);
            computedColumnHelper.setModel(4);
        }
        this.needMultipassProcessing = this.hasAggregationInDataSetCC || FilterUtil.hasMultiPassFilters(filterByRow) || populator.getQuery().getGrouping() != null && populator.getQuery().getGrouping().length > 0 || populator.getQuery().getOrdering() != null && populator.getQuery().getOrdering().length > 0 || this.hasAggrRowFilters;
    }

    boolean needDoOperation(int operType) {
        switch (operType) {
            case 1: {
                return this.hasDataSetFilters;
            }
            case 2: {
                return this.hasDataSetCC && (this.hasAggregationInDataSetCC || !this.hasDataSetFilters);
            }
            case 3: {
                return this.hasResultSetFilters;
            }
            case 4: {
                return this.hasResultSetTempCC;
            }
            case 5: {
                return this.hasGroupRowFilters;
            }
            case 6: {
                return this.hasAggrRowFilters;
            }
        }
        return false;
    }

    boolean needMultipassProcessing() {
        return this.needMultipassProcessing;
    }

    static boolean hasAggregationsInComputedColumns(ComputedColumnHelper ccHelper, ResultSetPopulator rsp) throws DataException {
        if (ccHelper == null) {
            return false;
        }
        ArrayList<IBaseExpression> expressionList = new ArrayList<IBaseExpression>();
        List list = ccHelper.getComputedColumnList();
        int j = 0;
        while (j < list.size()) {
            expressionList.add(((IComputedColumn)list.get(j)).getExpression());
            if (((IComputedColumn)list.get(j)).getAggregateFunction() != null) {
                return true;
            }
            ++j;
        }
        return rsp.getExpressionProcessor().hasAggregateExpr(expressionList);
    }
}

